
; ********************************************************************************************************
; *                                                                                                      *
; * Update Hunter GUI & Kern version 2.1 - (W) 2012-2017 by Harald Wagner (PureBasic v5.42 LTS version)  *
; *                                                                                                      *
; ********************************************************************************************************


; Globals Init.

Global Dim profilname$(100), Dim VersionRecognizeSite$(100), Dim Zeile.i(100), Dim Spalte.i(100)
Global Dim RemovePoints.i(100), Dim DownloadLink$(100), Dim Dateiname$(100), Dim UseRegistry.i(100)
Global Dim Registry.i(100), Dim RegKey.s(100), Dim RegName.s(100), ProfileSize.i, Index.i, Dim OpenRegKey.i(5)
Global NewList RegEntrys.s(), Dim NumberErrors.i(100,2), Dim UseStringFilter.i(100), Dim IsAlreadyDownloaded.i(100)
Global Dim UseSearchString.i(100), Dim SuchString$(100), Dim FindHighestVersion.i(100), MaxMinutes.i=120
Global Dim DeactivateProfile.i(100), Dim ReplaceVariante$(3), NewList TempLines.s(), Dim AppIcon(100)


Macro DEFINE_GUID(Name, l, w1, w2, b1, b2, b3, b4, b5, b6, b7, b8)
  CompilerIf Defined(Name, #PB_Variable)
    If SizeOf(Name) = SizeOf(GUID)
      Name\Data1    = l
      Name\Data2    = w1
      Name\Data3    = w2
      Name\Data4[0] = b1
      Name\Data4[1] = b2
      Name\Data4[2] = b3
      Name\Data4[3] = b4
      Name\Data4[4] = b5
      Name\Data4[5] = b6
      Name\Data4[6] = b7
      Name\Data4[7] = b8
    EndIf
  CompilerEndIf
EndMacro

Procedure.s FindFile(Path$, Name$)

  a$=StringField(Name$,1,"<%")

  If ExamineDirectory(0, Path$, "*.*")  
    While NextDirectoryEntry(0)
      If DirectoryEntryType(0) = #PB_DirectoryEntry_File
        b$=DirectoryEntryName(0)
        If LCase(Left(b$,Len(a$)))=LCase(a$)
          c$=b$
          Break
        EndIf
      EndIf
    Wend
    FinishDirectory(0)
  EndIf

  ProcedureReturn c$

EndProcedure

Procedure.i GetInteger(String$)

x=CountString(String$, ".")
z=Val(String$)

If x>0
  z=0
  For i=1 To x+1
    a$=StringField(String$, i, ".")
    z=(z*256)+Val(a$)
  Next
EndIf

ProcedureReturn z

EndProcedure

Procedure.i DownloadFile(URL$, DestFile$)

  ; Init

  Protected Bytes.i=0, Buffer.i=4096, hInet.i, hURL.i, Mem.i, File.i, State.i
  DeleteUrlCacheEntry_(@URL$)
  hInet.i = InternetOpen_("", #INTERNET_OPEN_TYPE_DIRECT, #Null, #Null, 0)
  hURL.i = InternetOpenUrl_(hInet, URL$, #Null, 0, #INTERNET_FLAG_RELOAD, 0)

  ; Start Download

  If hInet<>0 And hURL<>0
    Mem.i = AllocateMemory(Buffer)
    If Mem<>#Null
      File.i = CreateFile(#PB_Any, DestFile$)
      If File<>#Null
        Repeat
          InternetReadFile_(hURL, Mem, Buffer, @Bytes)
          If Bytes>0 : WriteData(File, Mem, Bytes) : EndIf
        Until Bytes=0
        CloseFile(File)
        State=#True
      EndIf
      FreeMemory(Mem)
    EndIf
    InternetCloseHandle_(hURL)
    InternetCloseHandle_(hInet)
    ProcedureReturn State
  EndIf

EndProcedure

Procedure.i BalloonTip(WindowID, Gadget, Text$ , Title$, Icon, MilliSekunden=5000)

  ToolTip=CreateWindowEx_(0,"ToolTips_Class32","",#WS_POPUP | #TTS_NOPREFIX | #TTS_BALLOON,0,0,0,0,WindowID,0,GetModuleHandle_(0),0)
  SendMessage_(ToolTip,#TTM_SETTIPTEXTCOLOR,GetSysColor_(#COLOR_INFOTEXT),0)
  SendMessage_(ToolTip,#TTM_SETTIPBKCOLOR,GetSysColor_(#COLOR_INFOBK),0)
  SendMessage_(ToolTip,#TTM_SETMAXTIPWIDTH,0,600)
  Balloon.TOOLINFO\cbSize=SizeOf(TOOLINFO)
  Balloon\uFlags=#TTF_IDISHWND | #TTF_SUBCLASS
  Balloon\hWnd=GadgetID(Gadget)
  Balloon\uId=GadgetID(Gadget)
  Balloon\lpszText=@Text$
  SendMessage_(ToolTip, #TTM_ADDTOOL, 0, Balloon)
  SendMessage_(ToolTip, #TTM_SETDELAYTIME, #TTDT_AUTOPOP, MilliSekunden)
  If Title$ > ""
    SendMessage_(ToolTip, #TTM_SETTITLE, Icon, @Title$)
  EndIf

EndProcedure

Procedure.i DelBalloonTip(Gadget)
  Balloon.TOOLINFO\cbSize=SizeOf(TOOLINFO) 
  Balloon\hWnd=GadgetID(Gadget) 
  Balloon\uId=GadgetID(Gadget) 
  SendMessage_(ToolTip, #TTM_DELTOOL, 0, Balloon) 
EndProcedure 

Procedure.s CutString(string$)

If Str(Val(ReplaceString(string$,".","")))<>ReplaceString(string$,".","")
  For i=1 To Len(string$)
    If Mid(string$,i,1)<>Str(Val(Mid(string$,i,1)))
      Break
    EndIf
  Next
  string$=Mid(string$,i)
EndIf

ProcedureReturn string$

EndProcedure

Procedure.s FilterString(string$, count)

  If UseStringFilter(count)=#True
    string$=CutString(string$)
    For i=1 To Len(string$)
      a$=Mid(string$,i,1)
      x=Asc(LCase(a$))
      If Str(Val(a$))=a$ Or (a$="." And Len(b$)>0) Or (a$="_" And Len(b$)>0) Or (x>96 And x<123 And Len(b$)>0 And Right(b$,1)<>".")
        b$+a$
      ElseIf b$<>""
        Break
      EndIf
    Next
  Else
    b$=string$
  EndIf

  ProcedureReturn b$

EndProcedure

Procedure.s ReadRegKey(OpenKey.i,SubKey.s,ValueName.s)

  hKey.i=#Null
  keyvalue.s=Space(255)
  DataSize.i=255
  
  If RegOpenKeyEx_(OpenKey,SubKey,0,#KEY_READ,@hKey)
    keyvalue=""
  Else
    If RegQueryValueEx_(hKey,ValueName,0,0,@keyvalue,@DataSize)
      keyvalue=""
    Else
      keyvalue=Left(keyvalue,DataSize-1)
    EndIf
    RegCloseKey_(hKey)
  EndIf

  ProcedureReturn keyvalue

EndProcedure

Procedure.s ListSubKey(RootKey, KeyName$, pos.i, Computer$="")

  Protected Handle, SubKey$, lpcbName = 255, lpName$ = Space(lpcbName), lpftLastWriteTime.FILETIME

  If Left(KeyName$, 1) = "\"
    KeyName$ = Mid(KeyName$, 2)
  EndIf

  If Computer$
    If Not RegConnectRegistry_(Computer$, RootKey, @RootKey)
      RootKey = #Null
    EndIf
  EndIf

  If RootKey
    If RegOpenKeyEx_(RootKey, KeyName$, 0, #KEY_READ, @Handle) = #ERROR_SUCCESS
      If RegEnumKeyEx_(Handle, pos, @lpName$, @lpcbName, 0, 0, 0, @lpftLastWriteTime) = #ERROR_SUCCESS
        SubKey$ = Left(lpName$, lpcbName)
      EndIf
      RegCloseKey_(Handle)
    EndIf
    RegCloseKey_(RootKey)
  EndIf

  ProcedureReturn SubKey$

EndProcedure

Procedure.i CountRegistryEntrys(topKey.i, StartKeyName$, IsWindowOpened.i=#True)

Protected CurrentIndex.i = 0

Repeat
  If IsWindowOpened=#True
    Event=WindowEvent()
  EndIf
  tst$=ListSubKey(topKey,StartKeyName$,CurrentIndex,"")
  If tst$<>""
    CurrentIndex+1
    AddElement(RegEntrys())
    RegEntrys()=StartKeyName$+tst$
    CountRegistryEntrys(topKey,StartKeyName$+tst$+"\", IsWindowOpened)
  EndIf
Until tst$=""

ProcedureReturn ListSize(RegEntrys())

EndProcedure

Procedure.i CheckRegistryEntry(key.i, name$, entry$)

a$=ReplaceString(ReverseString(StringField(ReverseString(entry$),1,"\")),Chr(32),"")
name$=ReplaceString(name$,Chr(32),"")

If FindString(a$,name$,1,#PB_String_NoCase)
  st=#True
ElseIf FindString(name$,a$,1,#PB_String_NoCase)
  st=#True
Else
  a$=ReadRegKey(key, entry$, "DisplayName")
  If FindString(ReplaceString(a$,Chr(32),""),name$,1,#PB_String_NoCase)
    st=#True
  ElseIf FindString(name$,ReplaceString(a$,Chr(32),""),1,#PB_String_NoCase)
    st=#True
  EndIf
EndIf

ProcedureReturn st

EndProcedure

Procedure.s GetFilenameFromLink(Link$, ProfilIndex.i)

a$=Dateiname$(ProfilIndex)

If CountString(LCase(Link$),"<%version%>") = 1 ; Nur bei 1 x "<%version%>" den Dateinamen aus Link ermitteln.
  If FindString(LCase(Link$),"<%version%>")
    Repeat
      x + 1
      a$=StringField(Link$,x,"/")
    Until FindString(LCase(a$),"<%version%>")
  EndIf
EndIf

ProcedureReturn StringField(a$,1,"?")

EndProcedure

Procedure.s LoadConfig(cfg$)

  Shared Minutes.i, MaxErrors.i

  Index = 0
  ProfileSize=0
  folder$=GetHomeDirectory()+"Downloads\"
  If OpenPreferences(cfg$) <> #Null
    If PreferenceGroup("Folders")
      folder$=ReadPreferenceString("SaveFolder",folder$)
    EndIf
    If PreferenceGroup("Check")
      Minutes=ReadPreferenceLong("Intervall",5)
      MaxErrors=MaxMinutes/Minutes
    EndIf
    Repeat
      count + 1
      If PreferenceGroup("Profil_"+Str(count))
        profilname$(count)=ReadPreferenceString("Name","")
        VersionRecognizeSite$(count)=ReadPreferenceString("WebSite","")
        Zeile(count)=ReadPreferenceLong("Line",1)
        Spalte(count)=ReadPreferenceLong("Row",1)
        RemovePoints(count)=ReadPreferenceLong("RemovePoints",1)
        UseSearchString(count)=ReadPreferenceLong("UseSearchString",0)
        SuchString$(count)=ReadPreferenceString("SearchString","")
        FindHighestVersion(count)=ReadPreferenceLong("FindHighestVersion",0)
        DownloadLink$(count)=ReadPreferenceString("DownloadLink","")
        Dateiname$(count)=ReadPreferenceString("Filename","AppSetup<%Version%>.exe")
        UseRegistry(count)=ReadPreferenceLong("UseRegistry",0)
        Registry(count)=ReadPreferenceLong("Registry",0)
        RegName(count)=ReadPreferenceString("RegName","SOFTWARE/App")
        RegKey(count)=ReadPreferenceString("RegKey","DisplayVersion")
        UseStringFilter(count)=ReadPreferenceLong("UseStringFilter",0)
        DeactivateProfile(count)=ReadPreferenceLong("DeactivateProfile",#PB_Checkbox_Unchecked)
      Else
        ProfileSize=count-1
        Break
      EndIf
    ForEver
    ClosePreferences()
  EndIf

  ProcedureReturn folder$

EndProcedure

Procedure.s SaveConfig(cfg$, folder$, Minutes.i)

If CreatePreferences(cfg$) <> #Null
  PreferenceGroup("Folders")
  WritePreferenceString("SaveFolder",folder$)
  PreferenceComment("")
  PreferenceGroup("Check")
  WritePreferenceLong("Intervall",Minutes)
  For count=1 To ProfileSize
    PreferenceComment("")
    PreferenceGroup("Profil_"+Str(count))
    WritePreferenceString("Name",profilname$(count))
    WritePreferenceString("WebSite",VersionRecognizeSite$(count))
    WritePreferenceLong("Line",Zeile(count))
    WritePreferenceLong("Row",Spalte(count))
    WritePreferenceLong("RemovePoints",RemovePoints(count))
    WritePreferenceLong("UseSearchString",UseSearchString(count))
    WritePreferenceString("SearchString",SuchString$(count))
    WritePreferenceLong("FindHighestVersion",FindHighestVersion(count))
    WritePreferenceString("DownloadLink",DownloadLink$(count))
    WritePreferenceString("Filename",Dateiname$(count))
    WritePreferenceLong("UseRegistry",UseRegistry(count))
    WritePreferenceLong("Registry",Registry(count))
    WritePreferenceString("RegName",RegName(count))
    WritePreferenceString("RegKey",RegKey(count))
    WritePreferenceLong("UseStringFilter",UseStringFilter(count))
    WritePreferenceLong("DeactivateProfile", DeactivateProfile(count))
  Next
  ClosePreferences()
EndIf

EndProcedure

Procedure.s GetAndCreateConfigPath(FullPath$)

  Protected PrefsPath$

  If Right(FullPath$, 1)<>"\" : FullPath$+"\" : EndIf
  PrefsPath$ = FullPath$

  If OSVersion()=>#PB_OS_Windows_Vista
    PrefsPath$ = GetEnvironmentVariable("APPDATA") + "\" + StringField(FullPath$, CountString(FullPath$,"\"), "\") + "\"
  EndIf

  If MakeSureDirectoryPathExists_(@PrefsPath$) = #True
    ProcedureReturn PrefsPath$
  EndIf

EndProcedure

Procedure.s GetVersion(String$, Row.i)

  For i=Row To Len(String$)
    a$=Mid(String$,i,1)
    x=Asc(LCase(a$))
    If Str(Val(a$))=a$ Or (a$="." And Len(b$)>0) Or (a$="_" And Len(b$)>0) Or (x>96 And x<123 And Len(b$)>0 And Right(b$,1)<>".")
      b$+a$
    ElseIf b$<>""
      Break
    EndIf
  Next

  ProcedureReturn Trim(b$,".")

EndProcedure

Procedure.s GetVersionString()

Shared TempFolder$, count.i

If ReadFile(0,TempFolder$+"UpdateHunter.tmp")
  If UseSearchString(count)=#False
    For i=1 To Zeile(count)
      a$=ReadString(0)
    Next
    b$=GetVersion(a$,Spalte(count))
  ElseIf SuchString$(count)<>""
    While Eof(0)=0
      a$=ReadString(0)
      x=FindString(a$, SuchString$(count), 1, #PB_String_NoCase)
      If x>0
        a$=GetVersion(a$,x+Len(SuchString$(count)))
        If FindHighestVersion(count)=#True
          If GetInteger(a$) > GetInteger(b$) And FindString(a$,".")>0 ; Nur wenn "." im Versions-String ist.
            b$=a$
          EndIf
        Else
          b$=a$
          If Len(b$)>2 And FindString(b$,".")>0 ; Nur wenn "." im Versions-String ist.
            Break
          EndIf
        EndIf
      EndIf
    Wend
  EndIf
  CloseFile(0)
EndIf

ProcedureReturn b$

EndProcedure

Procedure.s FindDownloadLink(Link$)

Shared TempFolder$, count.i
old$=Link$

If ReadFile(0,TempFolder$+"UpdateHunter.tmp")
  While Eof(0)=0
    a$=ReadString(0)
    x=FindString(a$, Link$, 1, #PB_String_NoCase)
    If x>0
      Link$=StringField(a$, 2, "href=")
      Link$=StringField(Trim(Link$,#DQUOTE$), 1, #DQUOTE$)
      Link$=StringField(Link$, 1, "<")
      Link$=StringField(Link$, 1, ">")
      Link$=StringField(Link$, 1, "'")
      Break
    EndIf
  Wend
  CloseFile(0)
EndIf

If old$=Link$
  Link$=VersionRecognizeSite$(count)
ElseIf Left(Link$,1)="/"
  url$=VersionRecognizeSite$(count)
  Link$=GetURLPart(url$, #PB_URL_Protocol) + "://" + GetURLPart(url$, #PB_URL_Site) + Link$
EndIf

ProcedureReturn Link$

EndProcedure

Procedure.s AutoCompleteDownloadLink(Link$)

Shared TempFolder$

If FindString(Link$,"/")>0 Or FindString(Link$,"\")>0 Or FindString(Link$,":")>0
  If ReadFile(0,TempFolder$+"UpdateHunter.tmp")
    While Eof(0)=0
      a$=ReadString(0)
      x=FindString(a$, Link$, 1, #PB_String_NoCase)
      If x>0
        Link$=StringField(Mid(a$,x), 1, "<")
        Link$=StringField(Mid(a$,x), 1, ">")
        Link$=StringField(Link$, 1, #DQUOTE$)
        Link$=StringField(Link$, 1, "'")
        Break
      EndIf
    Wend
    CloseFile(0)
  EndIf
Else
  Link$=FindDownloadLink(Link$)
EndIf

ProcedureReturn Link$

EndProcedure

Procedure.i CheckForUpdate(TempFolder$, SaveFolder$)

Shared StartTime.i, Minutes.i, MaxErrors.i, count.i
Delay(1)

If ElapsedMilliseconds() - StartTime > 60000 * Minutes
  StartTime = ElapsedMilliseconds()
  For count=1 To ProfileSize
    If DeactivateProfile(count) = #PB_Checkbox_Unchecked
      State=ReceiveHTTPFile(VersionRecognizeSite$(count),TempFolder$+"UpdateHunter.tmp")
      If State=#Null
        State=DownloadFile(VersionRecognizeSite$(count), TempFolder$+"UpdateHunter.tmp")
      EndIf
      If State<>#Null
        NumberErrors(count,1)=0
        a$ = GetVersionString()
        If a$<>""
          st = #False
          NumberErrors(count,0)=0
          a$=ReplaceString(a$,".",ReplaceVariante$(RemovePoints(count)))
          UPDFile$ = ReplaceString(GetFilenameFromLink(DownloadLink$(count),count),"<%version%>",a$,#PB_String_NoCase)
          DLink$ = ReplaceString(DownloadLink$(count),"<%version%>",a$,#PB_String_NoCase)
          If UseRegistry(count) = #True
            v$ = FilterString(ReadRegKey(OpenRegKey(Registry(count)), RegName(count), RegKey(count)), count)
            If ReplaceString(v$,".","") <> ReplaceString(a$,".","") : st=#True : EndIf
          Else
            b$=LCase(GetExtensionPart(UPDFile$))
            If b$="php" Or b$="htm" Or b$="html" Or b$=""
              UPDFile$=ReplaceString(Dateiname$(count),"<%version%>",a$,#PB_String_NoCase)
            EndIf
            If FileSize(SaveFolder$+GetFilePart(UPDFile$))=-1 : st=#True : EndIf
          EndIf
          If st=#True
            If IsAlreadyDownloaded(count)=#False
              If MessageRequester("Update Hunter","Eine neue version von "+profilname$(count)+" ist verfgbar"+Chr(10)+"Mchten Sie diese version jetzt herunterladen?"+Chr(10)+Chr(10)+GetFilePart(UPDFile$)+Chr(10),#PB_MessageRequester_YesNo|#MB_ICONQUESTION) = #IDYES
                IsAlreadyDownloaded(count)=#True
                RunProgram(AutoCompleteDownloadLink(DLink$))
              EndIf
            EndIf
            StartTime = ElapsedMilliseconds()
          EndIf
        Else
          NumberErrors(count,0)+1
          If NumberErrors(count,0)=>MaxErrors
            NumberErrors(count,0)=0
            MessageRequester("Update Hunter", "Versions-Informationen ungltig!"+#CR$+#CR$+profilname$(count), #MB_OK|#MB_ICONWARNING)
          EndIf
        EndIf
      Else
        NumberErrors(count,1)+1
        If NumberErrors(count,1)=>MaxErrors
          NumberErrors(count,1)=0
          MessageRequester("Update Hunter", "Webseite nicht gefunden!"+#CR$+#CR$+profilname$(count), #MB_OK|#MB_ICONWARNING)
        EndIf
      EndIf
    EndIf
  Next
EndIf

EndProcedure

Procedure.s Spec_Folder(clsi_const.i)
   Path.s = Space(2048)
   SHGetSpecialFolderLocation_(0,clsi_const,@pidl.i)
   SHGetPathFromIDList_(pidl,@Path)
   CoTaskMemFree_(pidl)
   ProcedureReturn Path+"\"
EndProcedure

Procedure.i CreateShortcut(Path.s, Link.s, Argument.s = "", Description.s =  "", WorkingDir.s = "", ShowCommand.i = #SW_SHOWNORMAL, HotKey.i = #Null, IconFile.s = "|", IconIndex.i = 0)
  Protected psl.IShellLinkW, ppf.IPersistFile, result
  Protected.GUID CLSID_ShellLink, IID_IShellLink, IID_IPersistFile
 
  DEFINE_GUID(CLSID_ShellLink, $00021401, $0000,$0000, $C0, $00, $00, $00, $00, $00, $00, $46) ; {00021401-0000-0000-C000-000000000046}
  DEFINE_GUID(IID_IShellLink, $000214F9, $0000,$0000, $C0, $00, $00, $00, $00, $00, $00, $46)  ; {000214F9-0000-0000-C000-000000000046}
  DEFINE_GUID(IID_IPersistFile, $0000010B, $0000,$0000, $C0, $00, $00, $00, $00, $00, $00, $46); {0000010b-0000-0000-C000-000000000046}
 
  If IconFile = "|" : IconFile = Path : EndIf
  If WorkingDir="" : WorkingDir = GetPathPart(Path) : EndIf

  CoInitialize_(0)
  If CoCreateInstance_(@CLSID_ShellLink, 0, 1, @IID_IShellLink, @psl) =  #S_OK

    Set_ShellLink_preferences:
    psl\SetPath(Path)
    psl\SetArguments(Argument)
    psl\SetWorkingDirectory(WorkingDir)
    psl\SetDescription(Description)
    psl\SetShowCmd(ShowCommand)
    psl\SetHotkey(HotKey)
    psl\SetIconLocation(IconFile, IconIndex)
    ShellLink_SAVE:
    If psl\QueryInterface(@IID_IPersistFile, @ppf) = #S_OK
      ppf\Save(Link, #True)
      result = 1
      ppf\Release()
    EndIf
    psl\Release()
  EndIf
  CoUninitialize_()
  ProcedureReturn result
EndProcedure

Procedure.i ViewVersion()

  Shared TempFolder$, LastVersionView$, count.i
  count = Index
  st=ReceiveHTTPFile(VersionRecognizeSite$(count), TempFolder$+"UpdateHunter.tmp")
  If st=#Null
    st=DownloadFile(VersionRecognizeSite$(count), TempFolder$+"UpdateHunter.tmp")
  EndIf
  If st<>#Null
    LastVersionView$=GetVersionString()
    If LastVersionView$<>""
       LastVersionView$=ReplaceString(LastVersionView$,".",ReplaceVariante$(RemovePoints(count)))
      MessageRequester("Info", "Ermittelte Version = "+StringField(LastVersionView$, 1, "<"), #MB_OK|#MB_ICONINFORMATION)
    Else
      MessageRequester("Info", "Versions-Informationen ungltig!", #MB_OK|#MB_ICONWARNING)
    EndIf
  Else
    MessageRequester("Download Fehlgeschlagen", "Einstellung fr Webseite ungltig!", #MB_OK|#MB_ICONWARNING)
  EndIf

EndProcedure

Procedure.i DeleteProfile(pos.i)

For i=pos To ProfileSize
  profilname$(i) = profilname$(i+1)
  VersionRecognizeSite$(i) = VersionRecognizeSite$(i+1)
  DownloadLink$(i) = DownloadLink$(i+1)
  Zeile(i) = Zeile(i+1)
  Spalte(i) = Spalte(i+1)
  RemovePoints(i) = RemovePoints(i+1)
  Dateiname$(i) = Dateiname$(i+1)
  UseStringFilter(i) = UseStringFilter(i+1)
  UseRegistry(i) = UseRegistry(i+1)
  Registry(i) = Registry(i+1)
  RegName(i) = RegName(i+1)
  RegKey(i) = RegKey(i+1)
  UseSearchString(i) = UseSearchString(i+1)
  SuchString$(i) = SuchString$(i+1)
  FindHighestVersion(i) = FindHighestVersion(i+1)
  DeactivateProfile(i) = DeactivateProfile(i+1)
Next

ProfileSize-1

EndProcedure

Procedure.s Input_Requester(Title$, Text$, DefaultText$, StoredText$="")

oldwin=GetActiveWindow_()
Window_0 = OpenWindow(#PB_Any, 195, 302, 341, 150, Title$, #PB_Window_SystemMenu|#PB_Window_TitleBar|#PB_Window_ScreenCentered|#PB_Window_WindowCentered,oldwin)

If Window_0

  EnableWindow_(oldwin,#False)
  menu=CreateMenu(#PB_Any,WindowID(Window_0))

  If menu<>0
    MenuTitle("Optionen")
    MenuItem(1, "OK"+Chr(9)+"[ENTER]")
    MenuItem(2, "Abbrechen"+Chr(9)+"[ESC]")
  EndIf

  Text_0 = TextGadget(#PB_Any, 16, 17, 319, 20, Text$)
  ComboBox_1 = ComboBoxGadget(#PB_Any, 15, 50, 309, 22, #PB_ComboBox_Editable)
  Button_1 = ButtonGadget(#PB_Any, 54, 90, 111, 25, "OK")
  Button_2 = ButtonGadget(#PB_Any, 176, 90, 111, 25, "Abbrechen")
  AddKeyboardShortcut(Window_0,#PB_Shortcut_Return, 1) ; OK Button
  AddKeyboardShortcut(Window_0,#PB_Shortcut_Escape, 2) ; Cancel Button
  SetGadgetText(ComboBox_1,DefaultText$)
  SetActiveGadget(ComboBox_1)
  txt$=ReplaceString(StoredText$,"|",Chr(10))
  If Right(txt$,1)<>Chr(10):txt$+Chr(10):EndIf

  For i=1 To CountString(txt$,Chr(10))
    a$=StringField(txt$,i,Chr(10))
    AddGadgetItem(ComboBox_1,-1,a$)
  Next

  Repeat
    Event=WaitWindowEvent()
    If Event=#PB_Event_Gadget
      pb=EventGadget()
    ElseIf Event=#PB_Event_Menu
      em=EventMenu()
    Else
      pb=0
      em=0
    EndIf
    If pb=Button_1 Or em=1
      b$=GetGadgetText(ComboBox_1)
    EndIf
  Until Event=#PB_Event_CloseWindow Or pb=Button_1 Or pb=Button_2 Or em=1 Or em=2

  EnableWindow_(oldwin,#True)
  CloseWindow(Window_0)
  ProcedureReturn b$

EndIf

EndProcedure

Procedure.i AutoCompleteProfil(Spin1.i, Spin2.i, Link.i, Points.i, Name.i, Search1.i, Search2.i, Search3.i)

Shared TempFolder$, LastVersionView$

ClearList(TempLines())
v$ = FilterString(ReadRegKey(OpenRegKey(Registry(Index)), RegName(Index), RegKey(Index)), Index)
url$ = "http://" + StringField(VersionRecognizeSite$(Index), 3,"/")
v$ = Input_Requester("Profil vervollstndigen", "Bitte die aktuelle Programm-Version eingeben", v$)

If v$<>""
  v2$=ReplaceString(v$,".","")
  State=ReceiveHTTPFile(VersionRecognizeSite$(Index),TempFolder$+"UpdateHunter.tmp")
  If State=#Null
    State=DownloadFile(VersionRecognizeSite$(Index), TempFolder$+"UpdateHunter.tmp")
  EndIf
  If State<>#Null
    If ReadFile(0,TempFolder$+"UpdateHunter.tmp")
      While Eof(0)=#Null
        AddElement(TempLines())
        TempLines()=ReadString(0)
      Wend
      ; Zeile & Spalte ermitteln
      ForEach TempLines()
        s=FindString(TempLines(), v$)
        If s>0 And sz=0
          sz=1
          Zeile(Index)=ListIndex(TempLines())+1 : Spalte(Index)=s
          SetGadgetText(Spin1, Str(Zeile(Index)))
          SetGadgetText(Spin2, Str(Spalte(Index)))
          LastVersionView$=v$
        EndIf
      Next
      If sz=0
        ForEach TempLines()
          s=FindString(TempLines(), ReplaceString(v$,".",""))
          If s>0 And sz=0
            sz=1
            Zeile(Index)=ListIndex(TempLines())+1 : Spalte(Index)=s
            SetGadgetText(Spin1, Str(Zeile(Index)))
            SetGadgetText(Spin2, Str(Spalte(Index)))
            LastVersionView$=v$
          EndIf
        Next
      EndIf
      UseSearchString(Index)=#False
      SetGadgetState(Search1, UseSearchString(Index))
      DisableGadget(Search2, #True)
      DisableGadget(Search3, #True)
      DisableGadget(Spin1, #False)
      DisableGadget(Spin2, #False)
      ; DownloadLink ermitteln
      ForEach TempLines()
        s=FindString(TempLines(), "href=", 1, #PB_String_NoCase)
        If s>0
          x=0 : a$=StringField(Mid(TempLines(),s), 2, "=")
          If Left(a$,1)=#DQUOTE$
            a$=StringField(a$, 2, #DQUOTE$)
          EndIf
          a$=StringField(a$, 1, "?")
          a$=StringField(a$, 1, "<")
          a$=StringField(a$, 1, ">")
          If FindString(a$, ReplaceString(Profilname$(Index)," ",""), 1, #PB_String_NoCase)>0:x+1:EndIf
          If FindString(a$, ".exe", 1, #PB_String_NoCase)>0:x+1:EndIf
          If FindString(a$, ".zip", 1, #PB_String_NoCase)>0:x+1:EndIf
          If FindString(a$, ".rar", 1, #PB_String_NoCase)>0:x+1:EndIf
          If FindString(a$, ".7z", 1, #PB_String_NoCase)>0:x+1:EndIf
          If FindString(a$, v$, 1, #PB_String_NoCase)>0:x+1:EndIf
          If FindString(a$, v2$, 1, #PB_String_NoCase)>0:x+1:EndIf
          If x>1
            If LCase(Left(a$,7))="http://"
              DownloadLink$(Index)=a$
            Else
              If Left(Trim(a$,"."),1)<>"/" : url$+"/" : EndIf
              DownloadLink$(Index)=url$+Trim(a$,".")
            EndIf
            If FindString(DownloadLink$(Index), v$)>0
              SetGadgetState(Points, 0)
              RemovePoints(Index)=0
            ElseIf FindString(DownloadLink$(Index), ReplaceString(v$,".",""))>0
              SetGadgetState(Points, 1)
              RemovePoints(Index)=1
            ElseIf FindString(DownloadLink$(Index), ReplaceString(v$,".","_"))>0
              SetGadgetState(Points, 2)
              RemovePoints(Index)=2
            Else
              SetGadgetState(Points, 0)
              RemovePoints(Index)=0
            EndIf
            DownloadLink$(Index)=ReplaceString(DownloadLink$(Index), v$, "<%Version%>")
            DownloadLink$(Index)=ReplaceString(DownloadLink$(Index), ReplaceString(v$,".",""), "<%Version%>")
            DownloadLink$(Index)=ReplaceString(DownloadLink$(Index), ReplaceString(v$,".","_"), "<%Version%>")
            SetGadgetText(Link, DownloadLink$(Index))
            Dateiname$(Index)=GetFilenameFromLink(DownloadLink$(Index), Index)
            SetGadgetText(Name, Dateiname$(Index))
            Break
          EndIf
        EndIf
      Next
      If x<2
        SetGadgetText(Link, "<DownloadLink wurde nicht gefunden!>")
        SetGadgetText(Name, "<Dateiname wurde nicht gefunden!>")
        DownloadLink$(Index)=GetGadgetText(Link)
        Dateiname$(Index)=GetGadgetText(Name)
      EndIf
      CloseFile(0)
    EndIf
    If sz=#Null
      MessageRequester("Update Hunter", "Version aus Webseite konnte nicht ermittelt werden!"+#CR$+#CR$+Profilname$(Index), #MB_OK|#MB_ICONWARNING)
    EndIf
  Else
    MessageRequester("Update Hunter", "Webseite konnte nicht geladen werden!"+#CR$+#CR$+Profilname$(Index), #MB_OK|#MB_ICONWARNING)
  EndIf
EndIf

EndProcedure

Procedure.s ConvertFilename(File$)

For i=1 To Len(File$)
  If Asc(Mid(File$,i,1))>47 And Asc(Mid(File$,i,1))<58
    Break
  EndIf
  a$+Mid(File$,i,1)
Next

ProcedureReturn Trim(ReplaceString(a$,"version","",#PB_String_NoCase))+".exe"

EndProcedure

Procedure.i GetFileIcon(File$, CurrentIndex.i, IconType.i=#SHGFI_SMALLICON)

c$=Trim(StringField(ReadRegKey(OpenRegKey(Registry(CurrentIndex)), RegName(CurrentIndex), "DisplayIcon"), 1, ","), #DQUOTE$)

If FindString(c$, "unin", 1, #PB_String_NoCase) > #Null Or c$=""
  a$=ReadRegKey(OpenRegKey(Registry(CurrentIndex)), RegName(CurrentIndex), "InstallLocation")
  b$=ReadRegKey(OpenRegKey(Registry(CurrentIndex)), RegName(CurrentIndex), "DisplayName")
  If Right(a$,1)<>"\" : a$+"\" : EndIf
  c$=ConvertFilename(b$)
EndIf

If FileSize(a$+c$)>0
  File$=a$+c$
ElseIf FileSize(a$+ReplaceString(c$," ",""))>0
  File$=a$+ReplaceString(c$," ","")
EndIf

If FileSize(File$)>0
  If SHGetFileInfo_(File$, #FILE_ATTRIBUTE_NORMAL, @Info.SHFILEINFO, SizeOf(SHFILEINFO), #SHGFI_TYPENAME|#SHGFI_ICON|IconType|#SHGFI_USEFILEATTRIBUTES)<>0
    Icon.i=PeekI(@Info\hIcon)
  Else
    Icon.i=ImageID(3)
  EndIf
Else
  Icon.i=ImageID(3)
EndIf

ProcedureReturn Icon

EndProcedure

Procedure.s SetGUI(folder$, ConfigPath$, Version$)

  Shared OldIndex.i, CurrentOption.i, Minutes.i, MaxErrors.i, StartTime.i, LastVersionView$

  ; GUI Aufbauen.

  Window = OpenWindow(#PB_Any, 392, 191, 840, 646, "Update Hunter v"+Version$+" - (Einstellungen)", #PB_Window_SystemMenu|#PB_Window_MinimizeGadget|#PB_Window_TitleBar|#PB_Window_ScreenCentered|#PB_Window_WindowCentered)
  If Window
    Apply = ButtonGadget(#PB_Any, 562, 600, 128, 30, "bernehmen")
    Cancel = ButtonGadget(#PB_Any, 697, 600, 128, 30, "Abbrechen")
    ListView = ListViewGadget(#PB_Any, 16, 20, 175, 562)
    SetGadgetFont(ListView,FontID(0))
    AddGadgetItem(ListView,-1,"Downloads")
    AddGadgetItem(ListView,-1,"Prfungs Intervall")
    AddGadgetItem(ListView,-1,"Tool Profile")
    Panel = PanelGadget(#PB_Any, 192, 17, 634, 566)
      ; Downloads
      AddGadgetItem(Panel, -1, "Downloads")
      Frame3D_1 = FrameGadget(#PB_Any, 25, 33, 578, 83, "Speicherordner")
      SaveFolder = StringGadget(#PB_Any, 48, 66, 506, 22, folder$, #ES_CENTER|#PB_String_ReadOnly)
      SaveFolderSelect = ButtonGadget(#PB_Any, 556, 66, 31, 22, "<<")
      ; Prfungs Intervall
      AddGadgetItem(Panel, -1, "Prfungs Intervall")
      Frame3D_2 = FrameGadget(#PB_Any, 25, 33, 578, 81, "Prfungs Intervall")
      Text_1 = TextGadget(#PB_Any, 38, 69, 126, 22, "Nach updates suchen", #PB_Text_Center)
      CheckIntervall = ComboBoxGadget(#PB_Any, 182, 66, 394, 22)
      ; Tool Profile
      AddGadgetItem(Panel, -1, "Tool Profile")
      Frame3D_3 = FrameGadget(#PB_Any, 25, 33, 578, 467, "Profil Einstellungen")
      Text_2 = TextGadget(#PB_Any, 49, 73, 63, 22, "Profilname")
      ProfilName = ComboBoxGadget(#PB_Any, 117, 69, 274, 22, #PB_ComboBox_Image)
      ProfilDelete = ButtonImageGadget(#PB_Any, 395, 68, 28, 24, ImageID(2))
      BalloonTip(WindowID(Window), ProfilDelete, "Lscht das aktuell ausgewhlte Profil", "Profil Lschen", #TOOLTIP_INFO_ICON)
      ProfilAdd = ButtonGadget(#PB_Any, 445, 68, 135, 24, "Neues Profil erstellen")
      BalloonTip(WindowID(Window), ProfilAdd, "Erstellt ein neues Profil", "Profil hinzufgen", #TOOLTIP_INFO_ICON)
      Text_3 = TextGadget(#PB_Any, 33, 114, 166, 22, "Version auslesen von Webseite", #PB_Text_Right)
      ScanSite = StringGadget(#PB_Any, 210, 111, 340, 22, "http://www.ToolsWebSite.com")
      BalloonTip(WindowID(Window), ScanSite, "Tragen Sie hier die Webseite ein, aus der die Version"+Chr(13)+"des entsprechenden Programms ausgelesen werden kann.", "Webseite zur Versionsermittlung", #TOOLTIP_INFO_ICON, 10000)
      ProfilComplete = ButtonImageGadget(#PB_Any, 555, 110, 35, 24, ImageID(1))
      BalloonTip(WindowID(Window), ProfilComplete, "Versucht das aktuell ausgewhlte Profil anhand der voreingestellten Webseite"+Chr(13)+"automatisch zu vervollstndigen. (Das Eingabefeld links neben diesen Button)", "Profil Automatisch vervollstndigen", #TOOLTIP_INFO_ICON, 20000)
      Text_4 = TextGadget(#PB_Any, 33, 152, 40, 22, "Zeile", #PB_Text_Right)
      Spin_1 = SpinGadget(#PB_Any, 85, 149, 50, 20, 1, 100000, #PB_Spin_Numeric)
      Text_5 = TextGadget(#PB_Any, 142, 152, 48, 22, "Spalte", #PB_Text_Center)
      Spin_2 = SpinGadget(#PB_Any, 195, 149, 50, 20, 1, 100000, #PB_Spin_Numeric)
      BalloonTip(WindowID(Window), Spin_1, "Die Zeile in der die Versions-Nummer zu finden ist.", "Zeile der Versionsnummer", #TOOLTIP_INFO_ICON)
      BalloonTip(WindowID(Window), Spin_2, "Die Spalte ab der die Versions-Nummer beginnt.", "Spalte der Versionsnummer", #TOOLTIP_INFO_ICON)
      PointRemove = ComboBoxGadget(#PB_Any, 267, 148, 202, 20)
      BalloonTip(WindowID(Window), PointRemove, "Beispiel: Aus "+Chr(34)+"1.2.3"+Chr(34)+" wird "+Chr(34)+"1_2_3"+Chr(34)+" oder "+Chr(34)+"123"+Chr(34), "Punkte entfernen oder ersetzen", #TOOLTIP_INFO_ICON)
      ShowVersion = ButtonGadget(#PB_Any, 488, 147, 90, 22, "Anzeigen")
      UseSearch1 = CheckBoxGadget(#PB_Any, 50, 188, 120, 20, "SuchString benutzen")
      UseSearch2 = StringGadget(#PB_Any, 177, 187, 253, 22, "")
      UseSearch3 = CheckBoxGadget(#PB_Any, 440, 188, 143, 20, "Hchste Version ermitteln")
      BalloonTip(WindowID(Window), UseSearch1, "Benutzt einen Suchstring anstatt ZEILE/SPALTE."+Chr(13)+"Dieser String muss VOR der VersionsNummer in der selben Zeile der Webseite stehen."+Chr(13)+"Zum Beispiel: "+#DQUOTE$+"Download Latest Version:"+#DQUOTE$, "SuchString benutzen", #TOOLTIP_INFO_ICON, 10000)
      BalloonTip(WindowID(Window), UseSearch2, "Benutzt einen Suchstring anstatt ZEILE/SPALTE."+Chr(13)+"Dieser String muss VOR der VersionsNummer in der selben Zeile der Webseite stehen."+Chr(13)+"Zum Beispiel: "+#DQUOTE$+"Download Latest Version:"+#DQUOTE$, "SuchString benutzen", #TOOLTIP_INFO_ICON, 10000)
      BalloonTip(WindowID(Window), UseSearch3, "Hiermit wird sichergestellt, das immer die Hchste Auffindbare version ermittelt wird."+Chr(13)+"Empfehlenswert fr Webseiten mit einer Entwicklungsgeschichte.", "Hchste Version ermitteln", #TOOLTIP_INFO_ICON, 10000)
      Text_6 = TextGadget(#PB_Any, 34, 226, 87, 22, "Download Link", #PB_Text_Right)
      DownloadLink = StringGadget(#PB_Any, 132, 223, 446, 22, "http://www.ToolsWebSite.com/Downloads/AppSetup<%Version%>.exe")
      BalloonTip(WindowID(Window), DownloadLink, "Der DownloadLink zur entsprechenden Datei."+Chr(13)+"Alle enthaltenen versionsnummern mssen durch"+Chr(13)+"die Variable <%Version%> ersetzt werden.", "DownloadLink", #TOOLTIP_INFO_ICON, 10000)
      Text_11 = TextGadget(#PB_Any, 34, 261, 87, 22, "Dateiname", #PB_Text_Right)
      Datei_Name = StringGadget(#PB_Any, 132,258,344,22,"AppSetup<%Version%>.exe")
      BalloonTip(WindowID(Window), Datei_Name, "Der Name der entsprechenden Datei."+Chr(13)+"Alle enthaltenen versionsnummern mssen durch"+Chr(13)+"die Variable <%Version%> ersetzt werden.", "Dateiname", #TOOLTIP_INFO_ICON, 10000)
      Text_7 = TextGadget(#PB_Any, 32, 313, 156, 22, "Lokale Version ermitteln ber", #PB_Text_Right)
      CheckMethod = ComboBoxGadget(#PB_Any, 201, 309, 130, 22)
      Text_8 = TextGadget(#PB_Any, 57, 349, 70, 20, "Registrierung", #PB_Text_Right)
      RegistryCombo = ComboBoxGadget(#PB_Any, 137, 346, 180, 22)
      Text_9 = TextGadget(#PB_Any, 57, 379, 70, 20, "Schlssel", #PB_Text_Right)
      Schluessel = StringGadget(#PB_Any, 137, 376, 370, 20, "SOFTWARE/App")
      Text_10 = TextGadget(#PB_Any, 57, 406, 70, 20, "Name", #PB_Text_Right)
      SchluesselName = StringGadget(#PB_Any, 137, 403, 110, 20, "DisplayVersion")
      FilterUse = CheckBoxGadget(#PB_Any, 260, 404, 325, 20, "Filter aktivieren. (Um den absoluten Versions-String zu ermitteln)")
      RegEdit = ButtonGadget(#PB_Any, 263, 445, 80, 25, "Reg. Editor")
      RegTest = ButtonGadget(#PB_Any, 353, 445, 80, 25, "Testen")
      RegFind = ButtonGadget(#PB_Any, 443, 445, 80, 25, "Suchen")
      Deactivate = CheckBoxGadget(#PB_Any, 330, 510, 275, 20, "Dieses Profil wrend der Update-Prfung deaktivieren")
      AddGadgetItem(CheckMethod, -1, "Download-Ordner")
      AddGadgetItem(CheckMethod, -1, "Registry Eintrag")
      SetGadgetState(CheckMethod, 0)
      AddGadgetItem(RegistryCombo,-1,"#HKEY_LOCAL_MACHINE")
      AddGadgetItem(RegistryCombo,-1,"#HKEY_CLASSES_ROOT")
      AddGadgetItem(RegistryCombo,-1,"#HKEY_CURRENT_USER")
      AddGadgetItem(RegistryCombo,-1,"#HKEY_USERS")
      AddGadgetItem(RegistryCombo,-1,"#HKEY_CURRENT_CONFIG")
      SetGadgetState(RegistryCombo,0)
    CloseGadgetList()
    DisableGadget(ProfilName, #True)
    DisableGadget(ProfilDelete, #True)
    DisableGadget(Spin_1, #True)
    DisableGadget(Spin_2, #True)
    DisableGadget(PointRemove, #True)
    DisableGadget(ScanSite, #True)
    DisableGadget(ProfilComplete, #True)
    DisableGadget(DownloadLink, #True)
    DisableGadget(Text_11, #True)
    DisableGadget(Datei_Name, #True)
    DisableGadget(ShowVersion, #True)
    DisableGadget(Text_2, #True)
    DisableGadget(Text_3, #True)
    DisableGadget(Text_4, #True)
    DisableGadget(Text_5, #True)
    DisableGadget(Text_6, #True)
    DisableGadget(Text_8, #True)
    DisableGadget(RegistryCombo, #True)
    DisableGadget(Text_9, #True)
    DisableGadget(Schluessel, #True)
    DisableGadget(Text_10, #True)
    DisableGadget(SchluesselName, #True)
    DisableGadget(RegEdit, #True)
    DisableGadget(RegTest, #True)
    DisableGadget(RegFind, #True)
    DisableGadget(Text_7, #True)
    DisableGadget(CheckMethod, #True)
    DisableGadget(FilterUse, #True)
    DisableGadget(UseSearch1, #True)
    DisableGadget(UseSearch2, #True)
    DisableGadget(UseSearch3, #True)
  EndIf

  ; Gadget Inits.

  For i=5 To MaxMinutes Step 5
    AddGadgetItem(CheckIntervall,-1,"Alle "+Str(i)+" Minuten")
  Next
  SetGadgetState(CheckIntervall,(Minutes/5)-1)
  SetGadgetState(ListView,CurrentOption)
  SetGadgetState(Panel, CurrentOption)
  For x=1 To ProfileSize
    AppIcon(x)=GetFileIcon(folder$+FindFile(folder$,Dateiname$(x)), x)
    AddGadgetItem(ProfilName, -1, profilname$(x), AppIcon(x))
  Next
  AddGadgetItem(PointRemove, -1, "Punkte im String unverndert lassen")
  AddGadgetItem(PointRemove, -1, "Punkte aus String entfernen")
  AddGadgetItem(PointRemove, -1, "Punkte im String durch ('_') ersetzen")
  SetGadgetState(ProfilName, OldIndex-1)
  If ProfileSize>0
    Index = OldIndex
    SetGadgetText(Spin_1, Str(Zeile(Index)))
    SetGadgetText(Spin_2, Str(Spalte(Index)))
    SetGadgetState(PointRemove, RemovePoints(Index))
    SetGadgetText(ScanSite, VersionRecognizeSite$(Index))
    SetGadgetText(DownloadLink, DownloadLink$(Index))
    SetGadgetText(Datei_Name, Dateiname$(Index))
    SetGadgetState(CheckMethod, UseRegistry(Index))
    SetGadgetState(FilterUse, UseStringFilter(Index))
    SetGadgetState(UseSearch1, UseSearchString(Index))
    SetGadgetText(UseSearch2, SuchString$(Index))
    SetGadgetState(UseSearch3, FindHighestVersion(Index))
    SetGadgetState(RegistryCombo, Registry(Index))
    SetGadgetText(Schluessel, RegName(Index))
    SetGadgetText(SchluesselName, RegKey(Index))
    SetGadgetState(Deactivate, DeactivateProfile(Index))
    If UseRegistry(Index)=1
      DisableGadget(Text_8,#False)
      DisableGadget(Text_9,#False)
      DisableGadget(Text_10,#False)
      DisableGadget(RegistryCombo,#False)
      DisableGadget(Schluessel,#False)
      DisableGadget(SchluesselName,#False)
      DisableGadget(RegEdit,#False)
      DisableGadget(RegTest,#False)
      DisableGadget(RegFind,#False)
      DisableGadget(FilterUse, #False)
    EndIf
    DisableGadget(ProfilName, #False)
    DisableGadget(ProfilDelete, #False)
    If UseSearchString(Index)=#True
      DisableGadget(UseSearch2,#False)
      DisableGadget(UseSearch3,#False)
      DisableGadget(Spin_1,#True)
      DisableGadget(Spin_2,#True)
    Else
      DisableGadget(UseSearch2,#True)
      DisableGadget(UseSearch3,#True)
      DisableGadget(Spin_1,#False)
      DisableGadget(Spin_2,#False)
    EndIf
    DisableGadget(PointRemove, #False)
    DisableGadget(ScanSite, #False)
    DisableGadget(ProfilComplete, #False)
    DisableGadget(DownloadLink, #False)
    DisableGadget(Datei_Name, #False)
    DisableGadget(ShowVersion, #False)
    DisableGadget(Text_2, #False)
    DisableGadget(Text_3, #False)
    DisableGadget(Text_4, #False)
    DisableGadget(Text_5, #False)
    DisableGadget(Text_6, #False)
    DisableGadget(Text_7, #False)
    DisableGadget(Text_11, #False)
    DisableGadget(CheckMethod, #False)
    DisableGadget(UseSearch1, #False)
  EndIf

  ; Auf Events warten.

  Repeat

    EventID = WaitWindowEvent()
    If EventID = #PB_Event_CloseWindow
      OldIndex = Index
      LastVersionView$=""
      folder$ = LoadConfig(ConfigPath$+"Settings.ini")
      If ProfileSize = #Null
        folder$ = LoadConfig(GetPathPart(ProgramFilename())+"Settings.ini")
      EndIf
      StartTime = ElapsedMilliseconds()
      If OldIndex > ProfileSize
        OldIndex = 1
      EndIf
      Break
    ElseIf EventID = #PB_Event_Gadget
      Gadget = EventGadget()
    EndIf

    ; Panel oder ListView geklickt.

    If Gadget = ListView
      Gadget = 0
      CurrentOption = GetGadgetState(ListView)
      SetGadgetState(Panel, CurrentOption)
    ElseIf Gadget = Panel
      Gadget = 0
      CurrentOption = GetGadgetState(Panel)
      SetGadgetState(ListView, CurrentOption)
    EndIf

    ; Neuen Speicherordner whlen.

    If Gadget = SaveFolderSelect
      Gadget = 0
      path$=PathRequester("Speicherordner whlen",GetGadgetText(SaveFolder))
      If path$<>""
        SetGadgetText(SaveFolder,path$)
      EndIf
    EndIf

    ; bernehmen

    If Gadget = Apply
      Gadget = 0
      OldIndex = Index
      LastVersionView$=""
      Minutes = (GetGadgetState(CheckIntervall)+1)*5
      MaxErrors = MaxMinutes/Minutes
      StartTime = ElapsedMilliseconds()
      folder$ = GetGadgetText(SaveFolder)
      Zeile(Index) = Val(GetGadgetText(Spin_1))
      Spalte(Index) = Val(GetGadgetText(Spin_2))
      RemovePoints(Index) = GetGadgetState(PointRemove)
      VersionRecognizeSite$(Index) = GetGadgetText(ScanSite)
      DownloadLink$(Index) = GetGadgetText(DownloadLink)
      Dateiname$(Index) = GetGadgetText(Datei_Name)
      UseRegistry(Index) = GetGadgetState(CheckMethod)
      Registry(Index) = GetGadgetState(RegistryCombo)
      RegName(Index) = GetGadgetText(Schluessel)
      RegKey(Index) = GetGadgetText(SchluesselName)
      UseStringFilter(Index) = GetGadgetState(FilterUse)
      UseSearchString(Index) = GetGadgetState(UseSearch1)
      SuchString$(Index) = GetGadgetText(UseSearch2)
      FindHighestVersion(Index) = GetGadgetState(UseSearch3)
      DeactivateProfile(Index) = GetGadgetState(Deactivate)
      SaveConfig(ConfigPath$+"Settings.ini",GetGadgetText(SaveFolder), Minutes)
      Break
    EndIf

    ; Abbrechen

    If Gadget = Cancel
      Gadget = 0
      OldIndex = Index
      LastVersionView$=""
      folder$ = LoadConfig(ConfigPath$+"Settings.ini")
      If ProfileSize = #Null
        folder$ = LoadConfig(GetPathPart(ProgramFilename())+"Settings.ini")
      EndIf
      StartTime = ElapsedMilliseconds()
      If OldIndex > ProfileSize
        OldIndex = 1
      EndIf
      Break
    EndIf

    ; Profil automatisch vervollstndigen.

    If Gadget = ProfilComplete
      AutoCompleteProfil(Spin_1, Spin_2, DownloadLink, PointRemove, Datei_Name, UseSearch1, UseSearch2, UseSearch3)
      Gadget = 0
    EndIf

    ; Version anzeigen.

    If Gadget = ShowVersion
      Gadget = 0
      ViewVersion()
    EndIf

    ; CheckBox fr "Punkte aus VersionsString entfernen" angeklickt.

    If Gadget = PointRemove
      Gadget = 0
      RemovePoints(Index)=GetGadgetState(PointRemove)
    EndIf

    ; CheckBox fr "SuchString benutzen" angeklickt.

    If Gadget = UseSearch1
      Gadget = 0
      If GetGadgetState(UseSearch1)=1
        UseSearchString(Index)=#True
        SuchString$(Index)=GetGadgetText(UseSearch2)
        FindHighestVersion(Index)=GetGadgetState(UseSearch3)
        DisableGadget(UseSearch2,#False)
        DisableGadget(UseSearch3,#False)
        DisableGadget(Spin_1,#True)
        DisableGadget(Spin_2,#True)
      Else
        UseSearchString(Index)=#False
        Zeile(Index)=Val(GetGadgetText(Spin_1))
        Spalte(Index)=Val(GetGadgetText(Spin_2))
        DisableGadget(UseSearch2,#True)
        DisableGadget(UseSearch3,#True)
        DisableGadget(Spin_1,#False)
        DisableGadget(Spin_2,#False)
      EndIf
    EndIf

    ; Zeile gendert.

    If Gadget = Spin_1
      Gadget = 0
      Zeile(Index)=Val(GetGadgetText(Spin_1))
    EndIf

    ; Spalte gendert.

    If Gadget = Spin_2
      Gadget = 0
      Spalte(Index)=Val(GetGadgetText(Spin_2))
    EndIf

    ; ScanSeite gendert.

    If Gadget = ScanSite
      Gadget = 0
      If EventType() = #PB_EventType_Change
        VersionRecognizeSite$(Index)=GetGadgetText(ScanSite)
      EndIf
    EndIf

    ; DownloadLink gendert.

    If Gadget = DownloadLink
      Gadget = 0
      If EventType() = #PB_EventType_Change
        DownloadLink$(Index)=GetGadgetText(DownloadLink)
        If LastVersionView$<>"" And FindString(DownloadLink$(Index), LastVersionView$)<>#Null
          DownloadLink$(Index)=ReplaceString(DownloadLink$(Index), LastVersionView$, "<%Version%>")
          SetGadgetText(DownloadLink, DownloadLink$(Index))
        ElseIf LastVersionView$<>"" And FindString(DownloadLink$(Index), ReplaceString(LastVersionView$,".",""))<>#Null
          DownloadLink$(Index)=ReplaceString(DownloadLink$(Index), ReplaceString(LastVersionView$,".",""), "<%Version%>")
          SetGadgetText(DownloadLink, DownloadLink$(Index))
        ElseIf LastVersionView$<>"" And FindString(DownloadLink$(Index), ReplaceString(LastVersionView$,".","_"))<>#Null
          DownloadLink$(Index)=ReplaceString(DownloadLink$(Index), ReplaceString(LastVersionView$,".","_"), "<%Version%>")
          SetGadgetText(DownloadLink, DownloadLink$(Index))
        EndIf
        a$ = GetFilenameFromLink(DownloadLink$(Index), Index)
        If a$<>""
          Dateiname$(Index)=a$
          SetGadgetText(Datei_Name,a$)
        EndIf
      EndIf
    EndIf

    ; Dateiname gendert.

    If Gadget = Datei_Name
      Gadget = 0
      If EventType() = #PB_EventType_Change
        Dateiname$(Index)=GetGadgetText(Datei_Name)
        If LastVersionView$<>"" And FindString(Dateiname$(Index), LastVersionView$)<>#Null
          Dateiname$(Index)=ReplaceString(Dateiname$(Index), LastVersionView$, "<%Version%>")
          SetGadgetText(Datei_Name, Dateiname$(Index))
        ElseIf LastVersionView$<>"" And FindString(Dateiname$(Index), ReplaceString(LastVersionView$,".",""))<>#Null
          Dateiname$(Index)=ReplaceString(Dateiname$(Index), ReplaceString(LastVersionView$,".",""), "<%Version%>")
          SetGadgetText(Datei_Name, Dateiname$(Index))
        ElseIf LastVersionView$<>"" And FindString(Dateiname$(Index), ReplaceString(LastVersionView$,".","_"))<>#Null
          Dateiname$(Index)=ReplaceString(Dateiname$(Index), ReplaceString(LastVersionView$,".","_"), "<%Version%>")
          SetGadgetText(Datei_Name, Dateiname$(Index))
        EndIf
      EndIf
    EndIf

    ; Registrierungs-Editor aufrufen.

    If Gadget = RegEdit
      Gadget = 0
      RunProgram("regedit")
    EndIf

    ; Registry Testen.

    If Gadget = RegTest
      Gadget = 0
      a$ = FilterString(ReadRegKey(OpenRegKey(Registry(Index)), RegName(Index), RegKey(Index)), Index)
      If a$<>""
        MessageRequester("Registry Wert",a$+"          ",#MB_OK|#MB_ICONINFORMATION)
      Else
        MessageRequester("Registry Wert","Wert konnte nicht ermittelt werden!",#MB_OK|#MB_ICONWARNING)
      EndIf
    EndIf

    ; Registrierungs-Eintrag finden.

    If Gadget = RegFind
      Gadget = 0
      ClearList(RegEntrys())
      path$ = PathRequester("Installations Ordner whlen","")
      If path$<>""
        win=OpenWindow(#PB_Any, 245, 160, 301, 86, "Registry Durchsuchen",#PB_Window_TitleBar|#PB_Window_ScreenCentered,WindowID(Window))
        DisableWindow(Window,#True)
        txtgad=TextGadget(#PB_Any, 31, 10, 237, 22, GetGadgetText(RegistryCombo), #PB_Text_Center)
        progress=ProgressBarGadget(#PB_Any, 31, 37, 237, 25, 0, 31)
        name$=GetFilePart(Left(path$,Len(path$)-1))
        key.i=OpenRegKey(Registry(Index))
        CountRegistryEntrys(key, "SOFTWARE\Microsoft\Windows\")
        CountRegistryEntrys(key, "SOFTWARE\Wow6432Node\Microsoft\Windows\")
        anzahl=ListSize(RegEntrys())
        st=#False
        SetGadgetAttribute(progress,#PB_ProgressBar_Maximum,anzahl)
        ForEach RegEntrys()
          SetGadgetState(progress,ListIndex(RegEntrys()))
          Event=WindowEvent()
          If CheckRegistryEntry(key, name$, RegEntrys()) = #True
            If ReadRegKey(key, RegEntrys(), "DisplayVersion") <> ""
              st=#True : v$="DisplayVersion"
            ElseIf ReadRegKey(key, RegEntrys(), "Version") <> ""
              st=#True : v$="Version"
            ElseIf ReadRegKey(key, RegEntrys(), "DisplayName") <> ""
              st=#True : v$="DisplayName"
            EndIf
          EndIf
          If st=#True
            If MessageRequester("UpdateHunter", "Soll der Eintrag bernommen werden ?"+Chr(10)+Chr(10)+RegEntrys(),#MB_YESNO|#MB_ICONQUESTION) = #IDYES
              SetGadgetText(Schluessel, RegEntrys())
              SetGadgetText(SchluesselName, v$)
              RegName(Index)=GetGadgetText(Schluessel)
              RegKey(Index)=GetGadgetText(SchluesselName)
              Break
            Else
              st=#False
            EndIf
          EndIf
        Next
        If st=#False
          MessageRequester("UpdateHunter","Durchsuchung der Registry abgeschlossen!",#MB_OK|#MB_ICONINFORMATION)
        EndIf
        DisableWindow(Window,#False)
        CloseWindow(win)
      EndIf
    EndIf

    ; Profil hinzufgen

    If Gadget = ProfilAdd
      Gadget = 0
      name$ = Input_Requester("Neues Profil erstellen","Bitte Profilnamen eingeben","")
      If name$ <> ""
        LastVersionView$=""
        AddGadgetItem(ProfilName, -1, name$, ImageID(3))
        If ProfileSize>0
          Zeile(Index) = Val(GetGadgetText(Spin_1))
          Spalte(Index) = Val(GetGadgetText(Spin_2))
          RemovePoints(Index) = GetGadgetState(PointRemove)
          VersionRecognizeSite$(Index) = GetGadgetText(ScanSite)
          DownloadLink$(Index) = GetGadgetText(DownloadLink)
          Dateiname$(Index) = GetGadgetText(Datei_Name)
          UseRegistry(Index) = GetGadgetState(CheckMethod)
          Registry(Index) = GetGadgetState(RegistryCombo)
          RegName(Index) = GetGadgetText(Schluessel)
          RegKey(Index) = GetGadgetText(SchluesselName)
          UseStringFilter(Index) = GetGadgetState(FilterUse)
          UseSearchString(Index) = GetGadgetState(UseSearch1)
          SuchString$(Index) = GetGadgetText(UseSearch2)
          FindHighestVersion(Index) = GetGadgetState(UseSearch3)
          DeactivateProfile(Index) = GetGadgetState(Deactivate)
        EndIf
        ProfileSize + 1 : Index = ProfileSize
        Profilname$(Index) = name$
        VersionRecognizeSite$(Index) = "http://www.ToolsWebSite.com"
        Zeile(Index) = 1
        Spalte(Index) = 1
        RemovePoints(Index) = 1
        DownloadLink$(Index) = "http://www.ToolsWebSite.com/Downloads/AppSetup<%Version%>.exe"
        Dateiname$(Index) = "AppSetup<%Version%>.exe"
        UseRegistry(Index) = #False
        Registry(Index) = 0
        RegName(Index) = "SOFTWARE/App"
        RegKey(Index) = "DisplayVersion"
        UseStringFilter(Index) = 0
        UseSearchString(Index) = 0
        SuchString$(Index) = ""
        FindHighestVersion(Index) = 0
        DeactivateProfile(Index) = #PB_Checkbox_Unchecked
        ClearList(RegEntrys())
        CountRegistryEntrys(#HKEY_LOCAL_MACHINE, "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\")
        CountRegistryEntrys(#HKEY_LOCAL_MACHINE, "SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\")
        ForEach RegEntrys()
          If CheckRegistryEntry(#HKEY_LOCAL_MACHINE, Profilname$(Index), RegEntrys()) = #True
            If ReadRegKey(#HKEY_LOCAL_MACHINE, RegEntrys(), "DisplayVersion") <> ""
              RegKey(Index)="DisplayVersion"
              RegName(Index)=RegEntrys()
              UseRegistry(Index)=1
              EnableRegGadgets=#True
            ElseIf ReadRegKey(#HKEY_LOCAL_MACHINE, RegEntrys(), "Version") <> ""
              RegKey(Index)="Version"
              RegName(Index)=RegEntrys()
              UseRegistry(Index)=1
              EnableRegGadgets=#True
            ElseIf ReadRegKey(#HKEY_LOCAL_MACHINE, RegEntrys(), "DisplayName") <> ""
              RegKey(Index)="DisplayName"
              RegName(Index)=RegEntrys()
              UseRegistry(Index)=1
              EnableRegGadgets=#True
            EndIf
          EndIf
        Next
        SetGadgetState(ProfilName, CountGadgetItems(ProfilName)-1)
        SetGadgetText(Spin_1, "1")
        SetGadgetText(Spin_2, "1")
        SetGadgetState(PointRemove, #True)
        SetGadgetText(ScanSite, "http://www.ToolsWebSite.com")
        SetGadgetText(DownloadLink, "http://www.ToolsWebSite.com/Downloads/AppSetup<%Version%>.exe")
        SetGadgetText(Datei_Name, "AppSetup<%Version%>.exe")
        SetGadgetState(CheckMethod, UseRegistry(Index))
        SetGadgetState(RegistryCombo,0)
        SetGadgetText(Schluessel, RegName(Index))
        SetGadgetText(SchluesselName,RegKey(Index))
        SetGadgetState(FilterUse, UseStringFilter(Index))
        SetGadgetState(UseSearch1,0)
        SetGadgetText(UseSearch2,"")
        SetGadgetState(UseSearch3,0)
        SetGadgetState(Deactivate, DeactivateProfile(Index))
        DisableGadget(UseSearch2,#True)
        DisableGadget(UseSearch3,#True)
        DisableGadget(Text_8,#True)
        DisableGadget(Text_9,#True)
        DisableGadget(Text_10,#True)
        DisableGadget(RegistryCombo,#True)
        DisableGadget(Schluessel,#True)
        DisableGadget(SchluesselName,#True)
        DisableGadget(FilterUse,#True)
        DisableGadget(RegEdit,#True)
        DisableGadget(RegTest,#True)
        DisableGadget(RegFind,#True)
        DisableGadget(ProfilName, #False)
        DisableGadget(ProfilDelete, #False)
        DisableGadget(Spin_1, #False)
        DisableGadget(Spin_2, #False)
        DisableGadget(PointRemove, #False)
        DisableGadget(UseSearch1, #False)
        DisableGadget(ScanSite, #False)
        DisableGadget(ProfilComplete, #False)
        DisableGadget(DownloadLink, #False)
        DisableGadget(Datei_Name, #False)
        DisableGadget(ShowVersion, #False)
        DisableGadget(CheckMethod, #False)
        DisableGadget(Text_2, #False)
        DisableGadget(Text_3, #False)
        DisableGadget(Text_4, #False)
        DisableGadget(Text_5, #False)
        DisableGadget(Text_6, #False)
        DisableGadget(Text_7, #False)
        DisableGadget(Text_11, #False)
        If EnableRegGadgets=#True
          EnableRegGadgets=#False
          DisableGadget(Text_8,#False)
          DisableGadget(Text_9,#False)
          DisableGadget(Text_10,#False)
          DisableGadget(RegistryCombo,#False)
          DisableGadget(Schluessel,#False)
          DisableGadget(SchluesselName,#False)
          DisableGadget(FilterUse,#False)
          DisableGadget(RegEdit,#False)
          DisableGadget(RegTest,#False)
          DisableGadget(RegFind,#False)
        EndIf
      EndIf
    EndIf

    ; Registry Eintrge im StringGadget gendert oder CheckBox fr StringFilter geklickt.

    If Gadget = Schluessel Or Gadget = SchluesselName Or Gadget = FilterUse
      Gadget = 0
      UseStringFilter(Index) = GetGadgetState(FilterUse)
      If EventType() = #PB_EventType_Change
        RegName(Index) = GetGadgetText(Schluessel)
        RegKey(Index) = GetGadgetText(SchluesselName)
      EndIf
    EndIf

    ; SuchString gendert.

    If Gadget = UseSearch2
      Gadget = 0
      If EventType() = #PB_EventType_Change
        SuchString$(Index) = GetGadgetText(UseSearch2)
      EndIf
    EndIf

    ; FindHighestVersion CheckBox angeklickt.

    If Gadget = UseSearch3
      Gadget = 0
      FindHighestVersion(Index) = GetGadgetState(UseSearch3)
    EndIf

    ; Deactivate Profile angeklickt.

    If Gadget = Deactivate
      Gadget = 0
      DeactivateProfile(Index) = GetGadgetState(Deactivate)
    EndIf

    ; Download-Ordner oder Registry-Eintrag in ComboBox gewhlt.

    If Gadget = CheckMethod
      Gadget = 0
      If EventType() = #PB_EventType_Change
        UseRegistry(Index) = GetGadgetState(CheckMethod)
        If UseRegistry(Index)=1
          Registry(Index) = GetGadgetState(RegistryCombo)
          RegName(Index) = GetGadgetText(Schluessel)
          RegKey(Index) = GetGadgetText(SchluesselName)
          UseStringFilter(Index) = GetGadgetState(FilterUse)
          DisableGadget(Text_8,#False)
          DisableGadget(Text_9,#False)
          DisableGadget(Text_10,#False)
          DisableGadget(RegistryCombo,#False)
          DisableGadget(Schluessel,#False)
          DisableGadget(SchluesselName,#False)
          DisableGadget(FilterUse,#False)
          DisableGadget(RegEdit,#False)
          DisableGadget(RegTest,#False)
          DisableGadget(RegFind,#False)
        Else
          DisableGadget(Text_8,#True)
          DisableGadget(Text_9,#True)
          DisableGadget(Text_10,#True)
          DisableGadget(RegistryCombo,#True)
          DisableGadget(Schluessel,#True)
          DisableGadget(SchluesselName,#True)
          DisableGadget(FilterUse,#True)
          DisableGadget(RegEdit,#True)
          DisableGadget(RegTest,#True)
          DisableGadget(RegFind,#True)
        EndIf
      EndIf
    EndIf

    ; Registry Category gendert.

    If Gadget = RegistryCombo
      Gadget = 0
      If EventType() = #PB_EventType_Change
        Registry(Index) = GetGadgetState(RegistryCombo)
      EndIf
    EndIf

    ; Profil in ComboBox gendert.

    If Gadget = ProfilName
      Gadget = 0
      If EventType() = #PB_EventType_Change
        LastVersionView$=""
        Zeile(Index) = Val(GetGadgetText(Spin_1))
        Spalte(Index) = Val(GetGadgetText(Spin_2))
        RemovePoints(Index) = GetGadgetState(PointRemove)
        VersionRecognizeSite$(Index) = GetGadgetText(ScanSite)
        DownloadLink$(Index) = GetGadgetText(DownloadLink)
        Dateiname$(Index) = GetGadgetText(Datei_Name)
        UseRegistry(Index) = GetGadgetState(CheckMethod)
        Registry(Index) = GetGadgetState(RegistryCombo)
        RegName(Index) = GetGadgetText(Schluessel)
        RegKey(Index) = GetGadgetText(SchluesselName)
        UseStringFilter(Index) = GetGadgetState(FilterUse)
        UseSearchString(Index) = GetGadgetState(UseSearch1)
        SuchString$(Index) = GetGadgetText(UseSearch2)
        FindHighestVersion(Index) = GetGadgetState(UseSearch3)
        DeactivateProfile(Index) = GetGadgetState(Deactivate)
        Index = GetGadgetState(ProfilName) + 1
        SetGadgetText(Spin_1, Str(Zeile(Index)))
        SetGadgetText(Spin_2, Str(Spalte(Index)))
        SetGadgetState(PointRemove, RemovePoints(Index))
        SetGadgetText(ScanSite, VersionRecognizeSite$(Index))
        SetGadgetText(DownloadLink, DownloadLink$(Index))
        SetGadgetText(Datei_Name, Dateiname$(Index))
        SetGadgetState(CheckMethod, UseRegistry(Index))
        SetGadgetState(RegistryCombo, Registry(Index))
        SetGadgetText(Schluessel, RegName(Index))
        SetGadgetText(SchluesselName, RegKey(Index))
        SetGadgetState(FilterUse, UseStringFilter(Index))
        SetGadgetState(UseSearch1, UseSearchString(Index))
        SetGadgetText(UseSearch2, SuchString$(Index))
        SetGadgetState(UseSearch3, FindHighestVersion(Index))
        SetGadgetState(Deactivate, DeactivateProfile(Index))
        If UseSearchString(Index)=#True
          DisableGadget(UseSearch2,#False)
          DisableGadget(UseSearch3,#False)
          DisableGadget(Spin_1,#True)
          DisableGadget(Spin_2,#True)
        Else
          DisableGadget(UseSearch2,#True)
          DisableGadget(UseSearch3,#True)
          DisableGadget(Spin_1,#False)
          DisableGadget(Spin_2,#False)
        EndIf
        If UseRegistry(Index)=1
          DisableGadget(Text_8,#False)
          DisableGadget(Text_9,#False)
          DisableGadget(Text_10,#False)
          DisableGadget(RegistryCombo,#False)
          DisableGadget(Schluessel,#False)
          DisableGadget(SchluesselName,#False)
          DisableGadget(FilterUse,#False)
          DisableGadget(RegEdit,#False)
          DisableGadget(RegTest,#False)
          DisableGadget(RegFind,#False)
        Else
          DisableGadget(Text_8,#True)
          DisableGadget(Text_9,#True)
          DisableGadget(Text_10,#True)
          DisableGadget(RegistryCombo,#True)
          DisableGadget(Schluessel,#True)
          DisableGadget(SchluesselName,#True)
          DisableGadget(FilterUse,#True)
          DisableGadget(RegEdit,#True)
          DisableGadget(RegTest,#True)
          DisableGadget(RegFind,#True)
        EndIf
      EndIf
    EndIf

    ; Profil Lschen.

    If Gadget = ProfilDelete
      Gadget = 0
      st = MessageRequester("Profil Lschen", "Mchten Sie das ausgewhlte Profil wirklich lschen ?"+Chr(10)+Chr(10)+GetGadgetText(ProfilName), #MB_YESNO|#MB_ICONQUESTION)
      If st = #IDYES
        LastVersionView$=""
        DeleteProfile(Index)
        Index = 1
        RemoveGadgetItem(ProfilName, GetGadgetState(ProfilName))
        SetGadgetState(ProfilName, Index-1)
        SetGadgetText(Spin_1, Str(Zeile(Index)))
        SetGadgetText(Spin_2, Str(Spalte(Index)))
        SetGadgetState(PointRemove, RemovePoints(Index))
        SetGadgetText(ScanSite, VersionRecognizeSite$(Index))
        SetGadgetText(DownloadLink, DownloadLink$(Index))
        SetGadgetText(Datei_Name, Dateiname$(Index))
        SetGadgetState(CheckMethod, UseRegistry(Index))
        SetGadgetState(RegistryCombo, Registry(Index))
        SetGadgetText(Schluessel, RegName(Index))
        SetGadgetText(SchluesselName, RegKey(Index))
        SetGadgetState(FilterUse, UseStringFilter(Index))
        SetGadgetState(UseSearch1, UseSearchString(Index))
        SetGadgetText(UseSearch2, SuchString$(Index))
        SetGadgetState(UseSearch3, FindHighestVersion(Index))
        SetGadgetState(Deactivate, DeactivateProfile(Index))
        If UseSearchString(Index)=#True
          DisableGadget(UseSearch2,#False)
          DisableGadget(UseSearch3,#False)
          DisableGadget(Spin_1,#True)
          DisableGadget(Spin_2,#True)
        Else
          DisableGadget(UseSearch2,#True)
          DisableGadget(UseSearch3,#True)
          DisableGadget(Spin_1,#False)
          DisableGadget(Spin_2,#False)
        EndIf
        If UseRegistry(Index)=1
          DisableGadget(Text_8,#False)
          DisableGadget(Text_9,#False)
          DisableGadget(Text_10,#False)
          DisableGadget(RegistryCombo,#False)
          DisableGadget(Schluessel,#False)
          DisableGadget(SchluesselName,#False)
          DisableGadget(RegEdit,#False)
          DisableGadget(RegTest,#False)
          DisableGadget(RegFind,#False)
          DisableGadget(FilterUse, #False)
        EndIf
        If ProfileSize < 1
          DisableGadget(ProfilName, #True)
          DisableGadget(ProfilDelete, #True)
          DisableGadget(Spin_1, #True)
          DisableGadget(Spin_2, #True)
          DisableGadget(PointRemove, #True)
          DisableGadget(ScanSite, #True)
          DisableGadget(ProfilComplete, #True)
          DisableGadget(DownloadLink, #True)
          DisableGadget(Datei_Name, #True)
          DisableGadget(ShowVersion, #True)
          DisableGadget(Text_2, #True)
          DisableGadget(Text_3, #True)
          DisableGadget(Text_4, #True)
          DisableGadget(Text_5, #True)
          DisableGadget(Text_6, #True)
          DisableGadget(Text_7,#True)
          DisableGadget(Text_8,#True)
          DisableGadget(Text_9,#True)
          DisableGadget(Text_10,#True)
          DisableGadget(Text_11,#True)
          DisableGadget(CheckMethod,#True)
          DisableGadget(RegistryCombo,#True)
          DisableGadget(Schluessel,#True)
          DisableGadget(SchluesselName,#True)
          DisableGadget(FilterUse,#True)
          DisableGadget(RegEdit,#True)
          DisableGadget(RegTest,#True)
          DisableGadget(RegFind,#True)
          DisableGadget(UseSearch1,#True)
          DisableGadget(UseSearch2,#True)
          DisableGadget(UseSearch3,#True)
        EndIf
      EndIf
    EndIf
  ForEver

  For i=1 To ProfileSize
    If AppIcon(i)<>ImageID(3)
      DestroyIcon_(AppIcon(i))
    EndIf
  Next

  ClearList(RegEntrys())
  CloseWindow(Window)
  ProcedureReturn folder$

EndProcedure

Procedure.i UpdateProfiles()

  ClearList(RegEntrys())
  CountRegistryEntrys(#HKEY_LOCAL_MACHINE, "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\", #False)
  CountRegistryEntrys(#HKEY_LOCAL_MACHINE, "SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\", #False)

  For i=1 To ProfileSize
    If UseRegistry(i)=#True
      If FilterString(ReadRegKey(OpenRegKey(Registry(i)), RegName(i), RegKey(i)), i) = ""
        ForEach RegEntrys()
          If CheckRegistryEntry(#HKEY_LOCAL_MACHINE, Profilname$(i), RegEntrys()) = #True
            If ReadRegKey(#HKEY_LOCAL_MACHINE, RegEntrys(), "DisplayVersion") <> ""
              Registry(i)=0
              RegName(i)=RegEntrys()
              RegKey(i)="DisplayVersion"
              UseStringFilter(i)=0
              txt$+profilname$(i)+#CR$
            ElseIf ReadRegKey(#HKEY_LOCAL_MACHINE, RegEntrys(), "Version") <> ""
              Registry(i)=0
              RegName(i)=RegEntrys()
              RegKey(i)="Version"
              UseStringFilter(i)=0
              txt$+profilname$(i)+#CR$
            ElseIf ReadRegKey(#HKEY_LOCAL_MACHINE, RegEntrys(), "DisplayName") <> ""
              Registry(i)=0
              RegName(i)=RegEntrys()
              RegKey(i)="DisplayName"
              UseStringFilter(i)=1
              txt$+profilname$(i)+#CR$
            EndIf
          EndIf
        Next
      EndIf
    EndIf
  Next

  If txt$<>""
    ProcedureReturn MessageRequester("UpdateHunter","Folgende Registry-Eintrge knnen nicht mehr gelesen werden,"+#CR$+"mchten Sie ihre Profil-Einstellungen jetzt Automatisch Korrigieren ?"+#CR$+#CR$+txt$+#CR$, #MB_YESNO|#MB_ICONQUESTION)
  EndIf

EndProcedure


; AppRunning Check

Mutex.i = CreateMutex_(0,0, "Update Hunter")
If GetLastError_() = #ERROR_ALREADY_EXISTS
  ReleaseMutex_(Mutex)
  CloseHandle_(Mutex)
  End
EndIf

; VarInit

OldIndex.i = 1 : Minutes.i = 5 : Version$="2.1" : Year$="2012-2017"
TempFolder$ = GetTemporaryDirectory()
ConfigPath$ = GetAndCreateConfigPath(GetPathPart(ProgramFilename())+"UpdateHunter\")
SaveFolder$ = LoadConfig(ConfigPath$+"Settings.ini")
AutostartFolder$ = Spec_Folder(#CSIDL_STARTUP)
StartTime.i = ElapsedMilliseconds()
If ProfileSize = #Null
  SaveFolder$ = LoadConfig(GetPathPart(ProgramFilename())+"Settings.ini")
EndIf
OpenRegKey(0) = #HKEY_LOCAL_MACHINE
OpenRegKey(1) = #HKEY_CLASSES_ROOT
OpenRegKey(2) = #HKEY_CURRENT_USER
OpenRegKey(3) = #HKEY_USERS
OpenRegKey(4) = #HKEY_CURRENT_CONFIG
ReplaceVariante$(0) = "."
ReplaceVariante$(1) = ""
ReplaceVariante$(2) = "_"
st = UpdateProfiles()
If st = #IDYES
  SaveConfig(ConfigPath$+"Settings.ini", SaveFolder$, Minutes)
ElseIf st = #IDNO
  SaveFolder$ = LoadConfig(ConfigPath$+"Settings.ini")
EndIf
If #PB_Compiler_Processor = #PB_Processor_x86
  Version$+" (x86)"
ElseIf #PB_Compiler_Processor = #PB_Processor_x64
  Version$+" (x64)"
EndIf

; SetGUI

If OpenWindow(0, 100, 150, 300, 100, "Update Hunter", #PB_Window_SystemMenu|#PB_Window_Invisible)
  LoadFont(0,"Microsoft Sans Serif",12,#PB_Font_Bold|#PB_Font_HighQuality)
  If CreatePopupImageMenu(0,#PB_Menu_ModernLook)
    MenuItem(1, "Autostart")
    MenuBar()
    MenuItem(2, "Einstellungen")
    MenuBar()
    MenuItem(3, "ber")
    MenuBar()
    MenuItem(4, "Beenden")
  EndIf
  If FileSize(AutostartFolder$+"UpdateHunter.lnk") > 0
    SetMenuItemState(0, 1, #True)
  EndIf
Else
  CloseHandle_(Mutex)
  End
EndIf

; SysTry Init

CatchImage(0,?Check_Start)
CatchImage(1,?OK_Icon_Start)
CatchImage(2,?ProfilDelete_Start)
CatchImage(3,?ExeIcon_Start)
AddSysTrayIcon(1, WindowID(0), ImageID(0))
SysTrayIconToolTip(1, "Update Hunter v"+Version$)
InitNetwork()

; Events

Repeat

  CheckForUpdate(TempFolder$, SaveFolder$)

  Event = WindowEvent()
  ; SysTray Men oder Einstellungen aufrufen.
  If Event = #PB_Event_SysTray
    If EventType() = #PB_EventType_RightClick
      DisplayPopupMenu(0, WindowID(0))
    EndIf
    If EventType() = #PB_EventType_LeftDoubleClick
      SaveFolder$ = SetGUI(SaveFolder$, ConfigPath$, Version$)
    EndIf
  EndIf
  If Event = #PB_Event_Menu
    ; Autostart Aktivieren / Deaktivieren.
    If EventMenu() = 1
      SetMenuItemState(0,1,GetMenuItemState(0,1)!1)
      If GetMenuItemState(0,1) = #Null
        DeleteFile(AutostartFolder$+"UpdateHunter.lnk")
      Else
        file$=GetPathPart(ProgramFilename())+"UpdateHunter.exe"
        CreateShortcut(file$,AutostartFolder$+"UpdateHunter.lnk","","UpdateHunter",GetPathPart(file$),#SW_SHOWNORMAL,0,file$,1)
      EndIf
    EndIf
    ; Einstellungen aufrufen.
    If EventMenu() = 2
      SaveFolder$ = SetGUI(SaveFolder$, ConfigPath$, Version$)
    EndIf
    ; ber About.
    If EventMenu() = 3
      MessageRequester("Update Hunter", "GUI & Core version "+Version$+Chr(10)+Chr(10)+"Written in "+Year$+" by Harald Wagner", #MB_OK|#MB_ICONINFORMATION)
    EndIf
  EndIf
  ; Programm beenden.
  If Event = #PB_Event_Menu
    If EventMenu() = 4
      Break
    EndIf
  EndIf

ForEver

CloseHandle_(Mutex)
FreeFont(0)
End

; TryIcon

DataSection
Check_Start:
Data.l $00010000,$10100001,$00010000,$03680018,$00160000,$00280000,$00100000,$00200000,$00010000,$00000018,$03400000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$C8650000,$00C86500,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$80000000,$FF9000FF,$00FF9000,$0000C865,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$90000000,$FFBF70FF,$00FFB870,$6500FF90,$000000C8,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$FF900000,$70FFB870,$9000FFB8,$C86500FF,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$70FF9000,$B870FFB8,$FF9000FF,$00C86500,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B870FF90,$FFB870FF,$00FF9000,$2DFF0000,$9270FF7F,$FF808CFF
Data.l $00009271,$00000000,$00000000,$00000000,$00000000,$00000000,$90000000,$EFD8BFFF,$FF6E42FF,$D8FF5352,$CCE7FFAF,$FFCCE7FF
Data.l $B2FFCCE7,$7178FFAE,$00000000,$00000000,$00000000,$00000000,$00000000,$9E80FF00,$FF7F8DFF,$E7FFBDDB,$CCE7FFCC,$FFCCE7FF
Data.l $E6FFCDE8,$CEF3FFDD,$004354FF,$00000000,$00000000,$00000000,$00000000,$8261FF00,$FFA0D6FF,$E4FF91C7,$CCE7FFBE,$FFCDE8FF
Data.l $FFC7DDE6,$B6FFC7B6,$0090C8FF,$00000000,$00000000,$00000000,$00000000,$818CFF00,$FFAECDFF,$E4FF82AD,$CDE8FFBD,$FFCDE8FF
Data.l $FFC7DDE6,$DCE6FFB6,$FFB0ECFF,$00007262,$00000000,$00000000,$00000000,$9093FF00,$FF9FC1FF,$D6FF7296,$CCE7FFA0,$FFCDE8FF
Data.l $E6FFDCE6,$CDE8FFDC,$FFCCE6FF,$00008D70,$00000000,$00000000,$00000000,$818CFF00,$FFAECFFF,$ACFF7296,$BDDBFF90,$FFCDE8FF
Data.l $E8FFCDE8,$CDE8FFCD,$FFB0ECFF,$00009270,$00000000,$00000000,$00000000,$9270FF00,$FFBDDBFF,$BAFFBDD0,$90BAFF91,$FFA0D6FF
Data.l $E5FFBEE4,$CCE7FFBE,$0090CBFF,$00000000,$00000000,$00000000,$00000000,$00000000,$C79093FF,$E4FFB6FF,$90ACFFDC,$FF7296FF
Data.l $CDFF90BA,$BDE4FFAE,$005352FF,$00000000,$00000000,$00000000,$00000000,$00000000,$FF000000,$F0FF9F81,$AED9FFBF,$FFAECDFF
Data.l $C6FFAECF,$7178FFA0,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$8DFF0000,$7178FF62,$FF818CFF
Data.l $0000818C,$00000000,$00000000,$FF9F0000,$FF0F0000,$FF070000,$FF830000,$FFC10000,$0FE10000,$03F00000,$01F80000,$01F80000
Data.l $00F80000,$00F80000,$00F80000,$01F80000,$01FC0000,$03FE0000,$0FFF0000
Data.b $00,$00
Check_End:
EndDataSection

; Hckchen Icon

DataSection
OK_Icon_Start:
Data.l $00010000,$10100002,$00010000,$03680018,$00260000,$10100000,$00010000,$04680020,$038E0000,$00280000
Data.l $00100000,$00200000,$00010000,$00000018,$FF400000,$0000FFFF,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$B9000000,$3DB9003D,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$E7163DB9,$31C60423,$003DB900,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$0A3DB900,$E71639C9,$23E71623,$0031C604,$00003DB9
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$273DB900,$EB1E3EEF,$30EB1E30
Data.l $0023E716,$00003DB9,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$3DB90000,$3041CA0D
Data.l $D7164CF3,$3DB9003E,$0C30EB1E,$B9002ED3,$0000003D,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $3DB90000,$305AF738,$B9004CF3,$3DB9003D,$1E3EEF27,$B90030EB,$0000003D,$00000000,$00000000,$00000000
Data.l $00000000,$B9000000,$4ED41A3D,$1F68FC41,$B9004DDC,$0000003D,$273DB900,$D5113EEF,$3DB90036,$00000000
Data.l $00000000,$00000000,$00000000,$B9000000,$73FF483D,$0073FF48,$00003DB9,$00000000,$133DB900,$EF2743D1
Data.l $3DB9003E,$00000000,$00000000,$00000000,$00000000,$00000000,$3DB90000,$005BE028,$00003DB9,$00000000
Data.l $00000000,$F3303DB9,$3ED7164C,$003DB900,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$DC1F3DB9,$4CF3304D,$003DB900,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$B9000000,$5AF7383D,$0045DA1B,$00003DB9,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B9000000,$55DF243D,$005AF738
Data.l $00003DB9,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $3DB90000,$2468FC41,$B90055DF,$0000003D,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$3DB90000,$415BE028,$B90068FC,$0000003D,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$483DB900,$E02873FF,$3DB9005B,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B9003DB9,$0000003D
Data.l $00000000,$FFF30000,$FFE10000,$FFC00000,$FFC00000,$7F800000,$7F800000,$3F040000,$3F0C0000,$1F8E0000
Data.l $1FFE0000,$0FFF0000,$0FFF0000,$87FF0000,$87FF0000,$C3FF0000,$E7FF0000,$00280000,$00100000,$00200000
Data.l $00010000,$00000020,$00400000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$B9000F00,$B900BF3D,$0000BF3D,$00001900,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B9000F00,$E716BF3D,$C604FF23,$B900FF31
Data.l $0000CB3D,$00001900,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$B9000000,$C90ABF3D,$E716FF39,$E716FF23,$C604FF23,$B900FF31,$0000983D,$00001900,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B9001100,$EF27C93D,$EB1EFF3E
Data.l $EB1EFF30,$E716FF30,$B900FF23,$0000C13D,$00002500,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$B9000800,$CA0DC43D,$F330EE41,$D716FF4C,$B900FF3E,$EB1EFF3D,$D30CFF30,$B900FF2E
Data.l $0000923D,$00001900,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B9001F00,$F738E53D
Data.l $F330FF5A,$B900FF4C,$B900EA3D,$EF27AF3D,$EB1EFF3E,$B900FF30,$0000CE3D,$00002500,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$B9000000,$D41ABF3D,$FC41FF4E,$DC1FFF68,$B900FF4D,$00009D3D,$B9001900
Data.l $EF27D93D,$D511FF3E,$B900FF36,$0000923D,$00001900,$00000000,$00000000,$00000000,$00000000,$B9000000
Data.l $FF48BF3D,$FF48FF73,$B900FF73,$0000BF3D,$00001700,$B9000000,$D113B33D,$EF27FF43,$B900FF3E,$0000CE3D
Data.l $00002500,$00000000,$00000000,$00000000,$00000000,$00000000,$B9000800,$E028BF3D,$B900FF5B,$00008A3D
Data.l $00000900,$00000000,$B9001100,$F330DB3D,$D716FF4C,$B900FF3E,$0000923D,$00001900,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$B9000900,$0000553D,$00000000,$00000000,$00000000,$B9000000,$DC1FB33D
Data.l $F330FF4D,$B900FF4C,$0000CE3D,$00002500,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$B9001100,$F738DB3D,$DA1BFF5A,$B900FF45,$0000923D
Data.l $00001900,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$B9000000,$DF24A53D,$F738FF55,$B900FF5A,$0000CE3D,$00002500,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B9001300,$FC41D53D
Data.l $DF24FF68,$B900FF55,$0000923D,$00001900,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$B9000000,$E028A53D,$FC41FF5B,$B900FF68,$0000CE3D,$00002500
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$B9000000,$FF48BF3D,$E028FF73,$B900FF5B,$00007F3D,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B9000000,$B900D83D
Data.l $0000DB3D,$00000000,$00000000,$FFE10000,$FFC00000,$7FC00000,$7F800000,$3F000000,$3F000000,$1F000000
Data.l $1F040000,$0F040000,$0F9E0000,$07FE0000,$07FF0000,$03FF0000,$83FF0000,$C3FF0000,$E7FF0000
Data.b $00,$00
OK_Icon_End:
EndDataSection

; Kreuz Icon

DataSection
ProfilDelete_Start:
Data.l $00010000,$10100001,$00010000,$03680018,$00160000,$00280000,$00100000,$00200000,$00010000,$00000018
Data.l $03400000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$6E6E6E6E
Data.l $00006E6E,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $EA5F7900,$3FDF0029,$6565A628,$00000065,$00000000,$00000000,$00000000,$00000000,$50620000,$D8072EB2
Data.l $00000000,$00000000,$EA5F7900,$30DF0029,$4E53DB0A,$6565656A,$00000000,$00000000,$00000000,$46000000
Data.l $0029C329,$B6465ADF,$00000000,$00000000,$00000000,$29EA5F79,$1C3DDF00,$5F5F5FD2,$00000000,$00000000
Data.l $00000000,$2ECD183A,$465AD807,$000000B6,$00000000,$00000000,$00000000,$7A000000,$0029EB60,$C33852DF
Data.l $00646464,$00000000,$CD183A00,$5AD8072E,$0000B646,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $607A0000,$DF0029EB,$53C33751,$12335E50,$D7062CC7,$00B6465A,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$EA5F7900,$2CDF0029,$052BD706,$8C626AD6,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$29D9082F,$2B47DF00,$8C626AC4,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$CD183A00,$5AD8072E,$0F36B646
Data.l $D63D59E0,$008C626A,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$183A0000,$DF0029CD
Data.l $00B6465A,$00000000,$E21F4300,$6ADD284A,$00008C62,$00000000,$00000000,$00000000,$00000000,$39000000
Data.l $0029CC17,$B6465ADF,$00000000,$00000000,$00000000,$35E7405F,$626ADF0E,$0000008C,$00000000,$00000000
Data.l $00000000,$29CC1739,$465ADF00,$000000B6,$00000000,$00000000,$00000000,$5F000000,$0029E740,$000000DF
Data.l $00000000,$00000000,$E01D4100,$46DF0029,$0000C329,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$E1103600,$00E12C4D,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$FFFF0000,$FFCF0000,$F3870000
Data.l $E3830000,$C7C30000,$8FE10000,$1FF00000,$3FF80000,$3FFC0000,$1FF80000,$8FF10000,$C7E30000,$E7C70000
Data.l $FF8F0000,$FF9F0000,$FFFF0000
Data.b $00,$00
ProfilDelete_End:
EndDataSection

; ExeIcon

DataSection
ExeIcon_Start:
Data.l $00010000,$10100001,$00010000,$03680018,$00160000,$00280000,$00100000,$00200000,$00010000,$00000018
Data.l $03400000,$0B130000,$0B130000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$A2E10000,$63A2E163,$E163A2E1
Data.l $A2E163A2,$63A2E163,$E163A2E1,$A2E163A2,$63A2E163,$E163A2E1,$A2E163A2,$63A2E163,$E163A2E1,$91DC63A2
Data.l $E8F1FA46,$FADEECFA,$E4FAD8E9,$CBE3FACE,$FAC1DEFA,$D7FABADB,$ACD4FAB3,$FAA4CFFA,$CDFA9ECE,$92CDFA92
Data.l $DC93CCFA,$95DD2D85,$FFFFFF4D,$FFFDFEFF,$F7FFF3F9,$EFF7FFEF,$FFDDEEFF,$E0FFC0E0,$C0E0FFC0,$FFC0E0FF
Data.l $D7FFB5DB,$A0D7FFA0,$DDA8D5FF,$95DD3387,$FFFFFF4D,$FFFFFFFF,$FAFFFFFF,$F6FAFFF6,$F8EEF6FD,$F3FFE0EF
Data.l $C3E1FFE6,$FFC0E0FF,$DBFFBFDF,$ADD8FFB5,$DDAED7FF,$95DD3489,$FFFFFF4D,$FFFFFFFF,$FEFFFFFF,$F3F9FFFD
Data.l $FFE9F4F9,$F7FFEFF7,$CEE5FAEF,$FFC3E1FF,$E0FFC0E0,$B3D9FFC0,$DDB0D8FF,$95DD3589,$FFFFFF4D,$FFFFFFFF
Data.l $FFFFFFFF,$FDFEFFFF,$FFF3F8F7,$F6FFF6FA,$DBECFCEE,$FFD2E9FF,$E0FFC2E1,$BCDEFFC0,$DDBBDDFF,$95DD398B
Data.l $FFFFFF4D,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF,$FFF7FBFF,$F8FFF8FB,$E3F1FFF1,$FFD9ECFF,$E1FFCEE7,$C0E0FFC2
Data.l $DDC0E0FF,$95DD3A8B,$FFFFFF4D,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF,$EEF6FFFF,$FFE9F4FF
Data.l $E9FFE3F1,$C3E1FFD2,$DDCAE5FF,$95DD3D8D,$FFFFFF4D,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF
Data.l $F2F9FFFF,$FFEFF7FF,$F6FFEEF6,$D9ECFFEE,$DDD3E9FF,$95DD408E,$FFFFFF4D,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF
Data.l $FFFFFFFF,$FFFFFFFF,$FDFEFFFF,$FFF8FBFF,$F7FFF6FA,$E2F0FFEF,$DDDFEFFF,$8EDB4390,$D2E8F940,$F9D2E8F9
Data.l $E8F9D2E8,$D2E8F9D2,$F9D2E8F9,$E8F9D2E8,$D2E8F9D2,$F9CCE5F9,$DFF9C7E3,$B8DBF9C0,$DBB8DBF9,$6ED3388A
Data.l $007FDF00,$DF007FDF,$7FDF007F,$007FDF00,$DF007FDF,$7FDF007F,$007FDF00,$DFC1D7EC,$D7EC007F,$007FDFC1
Data.l $D3C1D7EC,$83D1006E,$016CD13B,$D2006CD2,$6CD2006C,$006CD200,$D2006CD2,$6CD2006C,$006CD200,$D2006CD2
Data.l $6CD2006C,$006CD200,$D1006CD2,$D7EC096E,$6BA4DEC1,$E163A2E1,$A2E163A2,$63A2E163,$E163A2E1,$A2E163A2
Data.l $63A2E163,$E163A2E1,$A2E163A2,$63A2E163,$E863A2E1,$0000A7CB,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$FFFF0000,$000081FE,$000081FF
Data.l $00000000,$00000046,$00000003,$00000000,$00000400,$00000002,$0000012B,$00000400,$00000004,$00000138
Data.l $0000013C,$00000400,$FFFF0002
Data.b $00,$03
ExeIcon_End:
EndDataSection

; IDE Options = PureBasic 5.42 LTS (Windows - x64)
; Folding = AAAAAg
; EnableXP
; EnableUser
; UseIcon = Icon\Zoom.ico
; Executable = ..\Temp\UpdateHunter.exe