
; ******************************************************************************************
; * PureTheme-Launcher V1.6 - (w) 2009-2017 by Harald Wagner (PureBasic v5.42 LTS version) *
; ******************************************************************************************


; Inits

Global AppDir$=GetPathPart(ProgramFilename()), CurrentThemeFile$, ThemeFile$, WallPaper$, BackPics$
Global StepWide.i, LastChangeDay.i, CurrentThemeNumber.i, WindowHandle.i, PlayStartSound.i

; Proceduren

Procedure.i ThemeChange()

CurrentDay.i=Val(FormatDate("%dd",Date()))

If CurrentDay=>LastChangeDay+StepWide
  Update=#True
ElseIf CurrentDay<LastChangeDay
  If CurrentDay+31=>LastChangeDay+StepWide
    Update=#True
  EndIf
EndIf

ProcedureReturn Update

EndProcedure

Procedure.s ConvertEnvString(string$)

Repeat
  count=FindString(string$,"%",1)
  If count>0
    len=FindString(string$,"%",count+1) - count-1
    If len>0
      a$=Mid(string$,count+1,len)
      If a$<>""
        b$=GetEnvironmentVariable(a$)
      EndIf
      string$=ReplaceString(string$,"%"+a$+"%",b$,1)
      b$=""
    Else
      Break
    EndIf
  EndIf
Until count=0

ProcedureReturn Trim(string$)

EndProcedure

Procedure.s FixConfigPath()

If OSVersion()=>#PB_OS_Windows_Vista
  PreferencePath.s = GetEnvironmentVariable("APPDATA") + "\PureTheme\"
  MakeSureDirectoryPathExists_(@PreferencePath)
  AppDir$=PreferencePath
EndIf

EndProcedure

Procedure.s GetWallpaperFileName(index.i)
  If CountString(BackPics$,"*")=>index And index>0
    ProcedureReturn StringField(BackPics$, index, "*")
  EndIf
EndProcedure

Procedure.i GetWallpaperIndex()
  x=CountString(BackPics$, "*")
  y=Val(StringField(BackPics$, x+1, "*"))
  If x=>y
    ProcedureReturn y
  EndIf
EndProcedure

Procedure.i LoadConfig()

If OpenPreferences(AppDir$+"PureTheme.ini")
  If PreferenceGroup("WindowsStartUp")
    PlayStartSound=ReadPreferenceLong("PlayStartSound",0)
  EndIf
  If PreferenceGroup("Rotation")
    StepWide=ReadPreferenceLong("StepWide",0)
  EndIf
  If PreferenceGroup("LastChange")
    LastChangeDay=ReadPreferenceLong("Day",1)
    CurrentThemeNumber=ReadPreferenceLong("CurrentThemeNumber",0)
  EndIf
  If PreferenceGroup("Themes")
    CurrentThemeFile$=ReadPreferenceString("Entry"+Str(CurrentThemeNumber),"")
    ThemeFile$=ReadPreferenceString("Entry"+Str(CurrentThemeNumber+1),"")
    If ThemeFile$=""
      CurrentThemeNumber=-1
      ThemeFile$=ReadPreferenceString("Entry"+Str(CurrentThemeNumber+1),"")
    EndIf
  EndIf
  If PreferenceGroup("Wallpapers")
    BackPics$=ReadPreferenceString("Entry"+Str(CurrentThemeNumber+1),"")
  EndIf
  ClosePreferences()
EndIf

EndProcedure

Procedure.i SaveConfig()

If BackPics$<>""
  index=GetWallpaperIndex()+1
  WallPaper$=GetWallpaperFileName(index)
  If WallPaper$="" : index=0 : EndIf
  For i=1 To CountString(BackPics$, "*")
    b$+StringField(BackPics$,i,"*")+"*"
  Next
  BackPics$=b$+Str(index)
EndIf

If OpenPreferences(AppDir$+"PureTheme.ini")
  If PreferenceGroup("LastChange")
    WritePreferenceLong("Day",Val(FormatDate("%dd",Date())))
    WritePreferenceLong("CurrentThemeNumber",CurrentThemeNumber+1)
  EndIf
  If BackPics$<>""
    If PreferenceGroup("Wallpapers")
      WritePreferenceString("Entry"+Str(CurrentThemeNumber+1),BackPics$)  
    EndIf
  EndIf
  ClosePreferences()
EndIf

EndProcedure

Procedure.i EnumWindowsCallBack(hwnd.i, ProgramID.i)

  Title$ = Space(1024)
  ProcessID.i = 0
  st = #True
  GetWindowText_(hwnd, Title$, Len(Title$))
  GetWindowThreadProcessId_(hwnd, @ProcessID)

  If Title$<>""
    If OSVersion()=>#PB_OS_Windows_7
      If Trim(LCase(Title$))="anpassung" Or Trim(LCase(Title$))="einstellungen"
        WindowHandle = hwnd
        st = #False
      EndIf
    ElseIf IsWindowVisible_(hwnd)
      If ProcessID = ProgramID
        WindowHandle = hwnd
        st = #False
      EndIf
    EndIf
  EndIf

  ProcedureReturn st

EndProcedure

Procedure.i UseWindowsTheme(ThemeFile$)

Run$=ConvertEnvString("%SystemRoot%\System32\rundll32.exe")
Param$=ConvertEnvString("%SystemRoot%\System32\shell32.dll,Control_RunDLL %SystemRoot%\System32\desk.cpl desk,@Themes /Action:OpenTheme /file:"+#DOUBLEQUOTE$+ThemeFile$+#DOUBLEQUOTE$)
If OSVersion()>#PB_OS_Windows_7
  st=RunProgram(ThemeFile$, "", "", #PB_Program_Open)
Else
  st=RunProgram(Run$, Param$, "", #PB_Program_Open)
EndIf
ProgramID.i=ProgramID(st)

Repeat
  Delay(100)
  x = EnumWindows_(@EnumWindowsCallBack(), ProgramID)
Until x = #Null

CloseProgram(st)
ShowWindow_(WindowHandle, #False)
Delay(2000)

If OSVersion()=>#PB_OS_Windows_7
  SendMessage_(WindowHandle, #WM_CLOSE, 0, 0)
Else
  SendMessage_(WindowHandle, #WM_IME_KEYDOWN, 13, 0)
EndIf

Delay(1000)

If WallPaper$<>""
  Delay(3000)
  SystemParametersInfo_(#SPI_SETDESKWALLPAPER, 0, @WallPaper$, #SPIF_UPDATEINIFILE|#SPIF_SENDWININICHANGE)
EndIf

EndProcedure

Procedure MP3_Load(Nb,file.s) 
  i=mciSendString_("OPEN "+Chr(34)+file+Chr(34)+" Type MPEGVIDEO ALIAS MP3_"+Str(Nb),0,0,0) 
  If i=0 
    ProcedureReturn #True
  Else 
    ProcedureReturn #False 
  EndIf 
EndProcedure 

Procedure MP3_Play(Nb) 

  i=mciSendString_("play MP3_"+Str(Nb),0,0,0) 
  ProcedureReturn i 

EndProcedure 

Procedure MP3_GetLength(Nb) 

  a$=Space(#MAX_PATH) 
  i=mciSendString_("status MP3_"+Str(Nb)+" length",@a$,#MAX_PATH,0) 

  ProcedureReturn Val(a$)+1200

EndProcedure 

Procedure MP3_Free(Nb) 

  i=mciSendString_("close MP3_"+Str(Nb),0,0,0) 
  ProcedureReturn i 

EndProcedure 

Procedure.s FixEnvString(string$)

Repeat
  count=FindString(string$,"%",1)
  If count>0
    len=FindString(string$,"%",count+1) - count-1
    If len>0
      a$=Mid(string$,count+1,len)
      If a$<>""
        b$=GetEnvironmentVariable(a$)
      EndIf
      string$=ReplaceString(string$,"%"+a$+"%",b$,1)
      b$=""
    Else
      Break
    EndIf
  EndIf
Until count=0

ProcedureReturn Trim(string$)

EndProcedure

Procedure.i PlayStartSound(wave$)

If wave$<>""
  If MP3_Load(0,FixEnvString(wave$))
    MP3_Play(0)
    Delay((MP3_GetLength(0)/1000)*1000)
    MP3_Free(0)
  EndIf
EndIf

EndProcedure

Procedure.s GetStartSound()

  If OpenPreferences(CurrentThemeFile$)
    If PreferenceGroup("AppEvents\Schemes\Apps\.Default\SystemStart\.Current")
      a$=ReadPreferenceString("DefaultValue","")
    EndIf
    If a$=""
      If PreferenceGroup("AppEvents\Schemes\Apps\.Default\WindowsLogon")
        a$=ReadPreferenceString("DefaultValue","")
      EndIf
    EndIf
    ClosePreferences()
  EndIf

  ProcedureReturn a$

EndProcedure

; Windows-OS version berprfen.

If OSVersion() < #PB_OS_Windows_XP
  MessageRequester("Info", "Windows XP oder hher wird bentigt!", #MB_OK|#MB_ICONINFORMATION)
  End
EndIf

; Prozess ausfhren.

FixConfigPath()
LoadConfig()

If OSVersion() > #PB_OS_Windows_7
  If PlayStartSound = #True
    StartSound$=GetStartSound()
    PlayStartSound(StartSound$)
  EndIf
EndIf

If ThemeChange() = #True ; Theme wechseln.
  SaveConfig()
  UseWindowsTheme(ThemeFile$)
EndIf

End

; IDE Options = PureBasic 5.42 LTS (Windows - x64)
; Folding = AAw
; EnableXP
; UseIcon = Icons\Tool1.ico
; Executable = ..\Temp\PureTheme_Launch.exe