
; *************************************************************************************
; * PureTheme-GUI V1.6 - (w) 2009-2017 by Harald Wagner (PureBasic v5.42 LTS version) *
; *************************************************************************************


; Inits

Global Version$="1.6", AppDir$=GetPathPart(ProgramFilename()), Dim Wallpaper$(1000)
Global StepWide.i, LastChangeDay.i, CurrentThemeNumber.i, WindowHandle.i, PlayStartSound.i
UseJPEGImageDecoder() : UseJPEG2000ImageDecoder() : FirstStart.i=#True

; Macros & Proceduren

Macro DEFINE_GUID(Name, l, w1, w2, b1, b2, b3, b4, b5, b6, b7, b8)
  CompilerIf Defined(Name, #PB_Variable)
    If SizeOf(Name) = SizeOf(GUID)
      Name\Data1    = l
      Name\Data2    = w1
      Name\Data3    = w2
      Name\Data4[0] = b1
      Name\Data4[1] = b2
      Name\Data4[2] = b3
      Name\Data4[3] = b4
      Name\Data4[4] = b5
      Name\Data4[5] = b6
      Name\Data4[6] = b7
      Name\Data4[7] = b8
    EndIf
  CompilerEndIf
EndMacro

Procedure.i PI_CreateMirrorImage(Image.i, Width.i, Height.i, Depth.i, Color1.i, Color2.i)

img.i=CreateImage(Image, Width, Height, Depth)
If Image=#PB_Any : Image=img : EndIf

If IsImage(Image)
  If StartDrawing(ImageOutput(Image))
    If Red(Color2)>Red(Color1)
      Pixels=Red(Color2)-Red(Color1)
      add1.f=Pixels/Height
    Else
      Pixels=Red(Color1)-Red(Color2)
      add1.f=-(Pixels/Height)
    EndIf
    If Green(Color2)>Green(Color1)
      Pixels=Green(Color2)-Green(Color1)
      add2.f=Pixels/Height
    Else
      Pixels=Green(Color1)-Green(Color2)
      add2.f=-(Pixels/Height)
    EndIf
    If Blue(Color2)>Blue(Color1)
      Pixels=Blue(Color2)-Blue(Color1)
      add3.f=Pixels/Height
    Else
      Pixels=Blue(Color1)-Blue(Color2)
      add3.f=-(Pixels/Height)
    EndIf
    r.f=Red(Color1):g.f=Green(Color1):b.f=Blue(Color1)
    For y=0 To Height-1
      Box(0,y,Width,1,RGB(r,g,b))
      r+add1 : g+add2 : b+add3
    Next
    StopDrawing()
    ProcedureReturn img
  EndIf
EndIf

EndProcedure

Procedure.s ConvertEnvString(string$)

Repeat
  count=FindString(string$,"%",1)
  If count>0
    len=FindString(string$,"%",count+1) - count-1
    If len>0
      a$=Mid(string$,count+1,len)
      If a$<>""
        b$=GetEnvironmentVariable(a$)
      EndIf
      string$=ReplaceString(string$,"%"+a$+"%",b$,1)
      b$=""
    Else
      Break
    EndIf
  EndIf
Until count=0

ProcedureReturn Trim(string$)

EndProcedure

Procedure.s GetWallpaperName(ThemeFile$)

If LCase(GetExtensionPart(ThemeFile$))="theme"
  If OpenPreferences(ThemeFile$)
    If PreferenceGroup("Control Panel\Desktop")
      a$=ReadPreferenceString("Wallpaper","")
      If a$<>""
        b$=ConvertEnvString(a$)
      EndIf
    EndIf
    ClosePreferences()
  EndIf
EndIf

If b$<>""
  ProcedureReturn b$
EndIf

EndProcedure

Procedure.i SetWallpaperPreview(ThemeFile$, Param.i=#Null)

  If IsImage(0)<>#Null : FreeImage(0) : EndIf
  If LoadImage(0,GetWallpaperName(ThemeFile$))<>#Null
    ResizeImage(0,135,100)
  ElseIf PI_CreateMirrorImage(0,135,100,32,$FF0000,$0000FF)<>#Null
    If StartDrawing(ImageOutput(0))
      DrawingMode(#PB_2DDrawing_Transparent)
      If Param=#Null
        DrawText(30,45,"Ohne Bild",$FFFFFF)
      Else
        DrawText(30,45,"ThemePack",$FFFFFF)
      EndIf
      StopDrawing()
    EndIf
  EndIf
  If IsImage(0)<>#Null : SetGadgetAttribute(10,#PB_Button_Image,ImageID(0)) : EndIf

EndProcedure

Procedure.i SetGUI()
  If OpenWindow(0, 478, 252, 676, 550, "PureTheme v"+Version$+" - (C) 2009-2017 by Harald Wagner", #PB_Window_SystemMenu|#PB_Window_MinimizeGadget|#PB_Window_TitleBar|#PB_Window_ScreenCentered|#PB_Window_WindowCentered)
    If CreateStatusBar(0,WindowID(0))
      AddStatusBarField(50)
      AddStatusBarField(623)
      StatusBarText(0,0,"Style",#PB_StatusBar_Center|#PB_StatusBar_Raised)
    EndIf
    ButtonGadget(1, 535, 38, 124, 36, "Hinzufgen")
    ButtonGadget(2, 535, 78, 124, 36, "Entfernen")
    CheckBoxGadget(11, 23, 455, 245, 22, "Anmeldesound unter Windows 8 wiedergeben")
    TextGadget(3, 18, 492, 114, 22, "Wechsel der Themes", #PB_Text_Right)
    ComboBoxGadget(5, 151, 489, 133, 22)
    TextGadget(4, 300, 492, 71, 26, "durchfhren")
    ButtonGadget(6, 411, 484, 120, 30, "bernehmen")
    ButtonGadget(7, 543, 484, 120, 30, "Deaktivieren")
    GadgetToolTip(6,"bernimmt das ausgewhlte Theme und startet die Rotation")
    GadgetToolTip(7,"Stoppt die Rotation und entfernt die Verknpfung aus dem Autostart-Ordner")
    ButtonImageGadget(10,530,140,135,100,0) ; ImageGadget fr Wallpaper Previews
    GadgetToolTip(10,"Klicken Sie hier um weitere Wallpapers zum gewhlten Theme hinzuzufgen")
    ContainerGadget(8, 17, 16, 502, 428, #PB_Container_Raised)
      ListIconGadget(9, 15, 15, 466, 392, "Verfgbare Windows-Themes", 100, #PB_ListIcon_AlwaysShowSelection|#PB_ListIcon_FullRowSelect|#PB_ListIcon_GridLines|#PB_ListIcon_MultiSelect)
      SendMessage_(GadgetID(9), #LVM_SETCOLUMNWIDTH, 0, #LVSCW_AUTOSIZE_USEHEADER)
    CloseGadgetList()
    AddGadgetItem(5,-1,"Nach jedem Neustart")
    AddGadgetItem(5,-1,"Jeden Tag")
    AddGadgetItem(5,-1,"Alle zwei Tage")
    AddGadgetItem(5,-1,"Alle drei Tage")
    AddGadgetItem(5,-1,"Alle vier Tage")
    AddGadgetItem(5,-1,"Alle fnf Tage")
    AddGadgetItem(5,-1,"Alle sechs Tage")
    AddGadgetItem(5,-1,"Alle sieben Tage")
    SetGadgetState(5,0)
    SetWallpaperPreview("")
    DisableGadget(2,#True)
    DisableGadget(3,#True)
    DisableGadget(4,#True)
    DisableGadget(5,#True)
    DisableGadget(6,#True)
    DisableGadget(10,#True)
    DisableGadget(11,#True)
    If OSVersion()>#PB_OS_Windows_7
      SetGadgetState(11,#PB_Checkbox_Checked)
    EndIf
  EndIf
EndProcedure

Procedure.i LoadConfig()

If OpenPreferences(AppDir$+"PureTheme.ini")
  If PreferenceGroup("WindowsStartUp")
    PlayStartSound=ReadPreferenceLong("PlayStartSound",0)
    SetGadgetState(11,PlayStartSound)
  EndIf
  If PreferenceGroup("Rotation")
    StepWide=ReadPreferenceLong("StepWide",0)
    SetGadgetState(5,StepWide)
  EndIf
  If PreferenceGroup("LastChange")
    LastChangeDay=ReadPreferenceLong("Day",1)
    CurrentThemeNumber=ReadPreferenceLong("CurrentThemeNumber",0)
  EndIf
  If PreferenceGroup("Themes")
    Repeat
      a$=ReadPreferenceString("Entry"+Str(count),"")
      If a$<>""
        count+1
        AddGadgetItem(9,-1,a$)
      Else
        Break
      EndIf
    ForEver
  EndIf
  If PreferenceGroup("Wallpapers")
    For i=0 To CountGadgetItems(9)-1
      a$=ReadPreferenceString("Entry"+Str(i),"")
      If a$<>""
        Wallpaper$(i)=a$
      EndIf
    Next
  EndIf
  ClosePreferences()
EndIf

EndProcedure

Procedure.i SaveConfig()

If CreatePreferences(AppDir$+"PureTheme.ini")
  PreferenceComment("PureTheme configuration file - please do not change this lines!")
  PreferenceComment("")
  PreferenceGroup("WindowsStartUp")
  PreferenceComment("")
  WritePreferenceLong("PlayStartSound",GetGadgetState(11))
  PreferenceComment("")
  PreferenceGroup("Rotation")
  PreferenceComment("")
  WritePreferenceLong("StepWide",GetGadgetState(5))
  PreferenceComment("")
  PreferenceGroup("LastChange")
  PreferenceComment("")
  WritePreferenceLong("Day",Val(FormatDate("%dd",Date())))
  WritePreferenceLong("CurrentThemeNumber",CurrentThemeNumber)
  PreferenceComment("")
  PreferenceGroup("Themes")
  PreferenceComment("")
  For i=0 To CountGadgetItems(9)-1
    WritePreferenceString("Entry"+Str(i),GetGadgetItemText(9,i))
  Next
  PreferenceComment("")
  PreferenceGroup("Wallpapers")
  PreferenceComment("")
  For i=0 To CountGadgetItems(9)-1
    If Wallpaper$(i)<>""
      WritePreferenceString("Entry"+Str(i),Wallpaper$(i))
    EndIf
  Next
  ClosePreferences()
EndIf

EndProcedure

Procedure.s FixConfigPath()

If OSVersion()=>#PB_OS_Windows_Vista
  PreferencePath.s = GetEnvironmentVariable("APPDATA") + "\PureTheme\"
  MakeSureDirectoryPathExists_(@PreferencePath)
  AppDir$=PreferencePath
EndIf

EndProcedure

Procedure.i EnumWindowsCallBack(hwnd.i, ProgramID.i)

  Title$ = Space(1024)
  ProcessID.i = 0
  st = #True
  GetWindowText_(hwnd, Title$, Len(Title$))
  GetWindowThreadProcessId_(hwnd, @ProcessID)

  If Title$<>""
    If OSVersion()=>#PB_OS_Windows_7
      If LCase(Trim(Title$))="anpassung" Or LCase(Trim(Title$))="einstellungen"
        WindowHandle = hwnd
        st = #False
      EndIf
    ElseIf IsWindowVisible_(hwnd)
      If ProcessID = ProgramID
        WindowHandle = hwnd
        st = #False
      EndIf
    EndIf
  EndIf
 
  ProcedureReturn st

EndProcedure

Procedure.i UseWindowsTheme(ThemeFile$)

Run$=ConvertEnvString("%SystemRoot%\System32\rundll32.exe")
Param$=ConvertEnvString("%SystemRoot%\System32\shell32.dll,Control_RunDLL %SystemRoot%\System32\desk.cpl desk,@Themes /Action:OpenTheme /file:"+#DOUBLEQUOTE$+ThemeFile$+#DOUBLEQUOTE$)
If OSVersion()>#PB_OS_Windows_7
  st=RunProgram(ThemeFile$, "", "", #PB_Program_Open)
Else
  st=RunProgram(Run$, Param$, "", #PB_Program_Open)
EndIf
ProgramID.i=ProgramID(st)

Repeat
  Delay(100)
  x = EnumWindows_(@EnumWindowsCallBack(), ProgramID)
Until x = #Null

CloseProgram(st)
ShowWindow_(WindowHandle, #False)
Delay(2000)

If OSVersion()=>#PB_OS_Windows_7
  SendMessage_(WindowHandle, #WM_CLOSE, 0, 0)
Else
  SendMessage_(WindowHandle, #WM_IME_KEYDOWN, 13, 0)
EndIf

EndProcedure

Procedure.i CreateShortcut(Path.s, Link.s, Argument.s = "", Description.s =  "", WorkingDir.s = "", ShowCommand.i = #SW_SHOWNORMAL, HotKey.i = #Null, IconFile.s = "|", IconIndex.i = 0)
  Protected psl.IShellLinkW, ppf.IPersistFile, result
  Protected.GUID CLSID_ShellLink, IID_IShellLink, IID_IPersistFile
 
  DEFINE_GUID(CLSID_ShellLink, $00021401, $0000,$0000, $C0, $00, $00, $00, $00, $00, $00, $46) ; {00021401-0000-0000-C000-000000000046}
  DEFINE_GUID(IID_IShellLink, $000214F9, $0000,$0000, $C0, $00, $00, $00, $00, $00, $00, $46)  ; {000214F9-0000-0000-C000-000000000046}
  DEFINE_GUID(IID_IPersistFile, $0000010B, $0000,$0000, $C0, $00, $00, $00, $00, $00, $00, $46); {0000010b-0000-0000-C000-000000000046}
 
  If IconFile = "|" : IconFile = Path : EndIf
  If WorkingDir="" : WorkingDir = GetPathPart(Path) : EndIf

  CoInitialize_(0)
  If CoCreateInstance_(@CLSID_ShellLink, 0, 1, @IID_IShellLink, @psl) =  #S_OK

    Set_ShellLink_preferences:
    psl\SetPath(Path)
    psl\SetArguments(Argument)
    psl\SetWorkingDirectory(WorkingDir)
    psl\SetDescription(Description)
    psl\SetShowCmd(ShowCommand)
    psl\SetHotkey(HotKey)
    psl\SetIconLocation(IconFile, IconIndex)
    ShellLink_SAVE:
    If psl\QueryInterface(@IID_IPersistFile, @ppf) = #S_OK
      ppf\Save(Link, #True)
      result = 1
      ppf\Release()
    EndIf
    psl\Release()
  EndIf
  CoUninitialize_()
  ProcedureReturn result
EndProcedure

Procedure.s Spec_Folder(clsi_const.i)
   Path.s = Space(2048)
   SHGetSpecialFolderLocation_(0,clsi_const,@pidl.i)
   SHGetPathFromIDList_(pidl,@Path)
   CoTaskMemFree_(pidl)
   ProcedureReturn Path+"\"
EndProcedure

Procedure.s GetStyleName()

file$=GetGadgetItemText(9,GetGadgetState(9))
a$="<Unbekannt>"

If LCase(GetExtensionPart(file$))="theme"
  If OpenPreferences(file$)
    If PreferenceGroup("VisualStyles")
      a$=ReadPreferenceString("Path","<Unbekannt>")
      If a$<>"<Unbekannt>"
        b$=GetFilePart(a$)
        a$=Mid(b$,1,Len(b$)-Len(GetExtensionPart(b$))-1)
      EndIf
    EndIf
    ClosePreferences()
  EndIf
EndIf

ProcedureReturn a$

EndProcedure

Procedure.i DeleteArrayElement(index.i)

For i=index+1 To 1000
  Wallpaper$(i-1)=Wallpaper$(i)
Next

EndProcedure

Procedure.i CallWallpaperPrefs(ThemeFile$, index.i)

; Startwerte ermitteln.

DefaultPic$=ConvertEnvString(GetWallpaperName(ThemeFile$))
If DefaultPic$=""
  DefaultPic$="<Kein Bild>!"
EndIf
DefaultPath$=GetPathPart(DefaultPic$)
If Wallpaper$(index)<>""
  DefaultPath$=GetPathPart(StringField(Wallpaper$(index),1,"*"))
EndIf
If DefaultPath$=""
  DefaultPath$=ConvertEnvString(GetEnvironmentVariable("ProgramFiles"))
  If Right(DefaultPath$,1)<>"\" : DefaultPath$+"\" : EndIf
EndIf

; GUI aufbauen.

Window = OpenWindow(#PB_Any, 518, 360, 410, 392, "Wallpapers", #PB_Window_SystemMenu|#PB_Window_TitleBar|#PB_Window_ScreenCentered|#PB_Window_WindowCentered,WindowID(0))
If Window
  DisableWindow(0,#True)
  Container = ContainerGadget(#PB_Any, 11, 12, 389, 370, #PB_Container_Raised)
    ComboBox = ComboBoxGadget(#PB_Any, 12, 11, 359, 20)
    AddGadgetItem(ComboBox,-1,DefaultPath$)
    AddGadgetItem(ComboBox,-1,"<Verzeichniss wechseln>")
    SetGadgetState(ComboBox,0)
    ListIcon = ListIconGadget(#PB_Any, 12, 40, 359, 282, "Name", 300, #PB_ListIcon_AlwaysShowSelection|#PB_ListIcon_CheckBoxes|#PB_ListIcon_FullRowSelect|#PB_ListIcon_GridLines)
    AddGadgetColumn(ListIcon, 1, "Typ", 50)
    name$=GetFilePart(DefaultPic$)
    ext$=GetExtensionPart(DefaultPic$)
    def$=Mid(name$,1,Len(name$)-Len(ext$)-1) + "  (Standard)"+Chr(10)+UCase(ext$)
    AddGadgetItem(ListIcon,-1,def$)
    SetGadgetItemState(ListIcon,0,#PB_ListIcon_Checked) ; Default Wallpaper Anhacken.
    SetGadgetItemColor(ListIcon,0,#PB_Gadget_FrontColor,RGB(128,128,128))
    CheckBox = CheckBoxGadget(#PB_Any, 12, 328, 148, 22, "Alle Auswhlen/Abwhlen")
    Button_1 = ButtonGadget(#PB_Any, 167, 332, 100, 24, "OK")
    Button_2 = ButtonGadget(#PB_Any, 272, 332, 100, 24, "Abbrechen")
  CloseGadgetList()
EndIf

; Bilder auflisten.

If ExamineDirectory(0,DefaultPath$,"")
  While NextDirectoryEntry(0)
    If DirectoryEntryType(0) = #PB_DirectoryEntry_File
      name$=DirectoryEntryName(0)
      ext$=UCase(GetExtensionPart(name$))
      If ext$="BMP" Or ext$="JPG" Or ext$="JPEG"
        If LCase(DefaultPath$+name$)<>LCase(DefaultPic$) ; DefaultPic$ nicht nochmal (2x) anzeigen.
          ext$=GetExtensionPart(name$)
          a$=Mid(name$,1,Len(name$)-Len(ext$)-1)
          AddGadgetItem(ListIcon,-1,a$+Chr(10)+UCase(ext$))
        EndIf
      EndIf
    EndIf
  Wend
  FinishDirectory(0)
EndIf

; Bereits gewhlten Bilder wieder anhacken.

For i=0 To CountGadgetItems(ListIcon)-1
  a$=GetGadgetItemText(ListIcon,i,0)+"."+GetGadgetItemText(ListIcon,i,1)
  If FindString(LCase(Wallpaper$(index)),LCase(DefaultPath$+a$),1)<>#Null
    SetGadgetItemState(ListIcon,i,#PB_ListIcon_Checked) ; Bilddatei Anhacken.
  EndIf
Next

; Auf Events warten.

Repeat

  EventID=WaitWindowEvent()
  If EventID=#PB_Event_Gadget
    pb=EventGadget()
  Else
    pb=#Null
  EndIf

  ; ComboBox (Path wechseln)

  If pb=ComboBox
    If EventType()=#PB_EventType_Change
      If GetGadgetState(ComboBox)=1
        a$=PathRequester("Verzeichniss wechseln",DefaultPath$)
        If a$<>""
          DefaultPath$=a$
          ClearGadgetItems(ListIcon)
          AddGadgetItem(ListIcon,-1,def$)
          SetGadgetItemState(ListIcon,0,#PB_ListIcon_Checked) ; Default Wallpaper Anhacken.
          SetGadgetItemColor(ListIcon,0,#PB_Gadget_FrontColor,RGB(128,128,128))
          If ExamineDirectory(0,DefaultPath$,"")
            While NextDirectoryEntry(0)
              If DirectoryEntryType(0) = #PB_DirectoryEntry_File
                name$=DirectoryEntryName(0)
                ext$=UCase(GetExtensionPart(name$))
                If ext$="BMP" Or ext$="JPG" Or ext$="JPEG"
                  If LCase(DefaultPath$+name$)<>LCase(DefaultPic$) ; DefaultPic$ nicht nochmal (2x) anzeigen.
                    ext$=GetExtensionPart(name$)
                    a$=Mid(name$,1,Len(name$)-Len(ext$)-1)
                    AddGadgetItem(ListIcon,-1,a$+Chr(10)+UCase(ext$))
                  EndIf
                EndIf
              EndIf
            Wend
            FinishDirectory(0)
          EndIf
        EndIf
        SetGadgetItemText(ComboBox,0,DefaultPath$)
        SetGadgetState(ComboBox,0)
      EndIf
    EndIf
  EndIf

  ; DefaultPicture auf Angehackt erzwingen.

  If pb=ListIcon
    If Not GetGadgetItemState(ListIcon,0) & #PB_ListIcon_Checked
      SetGadgetItemState(ListIcon,0,#PB_ListIcon_Checked)
      MessageBeep_(#MB_OK)
    EndIf
    If GetGadgetState(ListIcon)=0
      SetGadgetState(ListIcon,-1)
      MessageBeep_(#MB_OK)
    EndIf
  EndIf

  ; CheckBox (Alle An/Abwhlen)

  If pb=CheckBox
    For i=1 To CountGadgetItems(ListIcon)-1
      If GetGadgetState(CheckBox)=#True
        SetGadgetItemState(ListIcon,i,#PB_ListIcon_Checked)
      Else
        SetGadgetItemState(ListIcon,i,#Null)
      EndIf
    Next
  EndIf

  ; Einstellungen bernehmen.

  If pb=Button_1
    Wallpaper$(index)=""
    For i=1 To CountGadgetItems(ListIcon)-1
      If GetGadgetItemState(ListIcon,i) & #PB_ListIcon_Checked
        Wallpaper$(index)+DefaultPath$+GetGadgetItemText(ListIcon,i,0)+"."+GetGadgetItemText(ListIcon,i,1)+"*"
      EndIf
    Next
    If Wallpaper$(index)<>""
      Wallpaper$(index)+"0"
    EndIf
  EndIf

Until EventID=#PB_Event_CloseWindow Or pb=Button_1 Or pb=Button_2

DisableWindow(0,#False)
CloseWindow(Window)
SetActiveGadget(9)

If pb=Button_1
  ProcedureReturn #True
EndIf

EndProcedure


; Windows-OS version berprfen.

If OSVersion() < #PB_OS_Windows_XP
  MessageRequester("Info", "Windows XP oder hher wird bentigt!", #MB_OK|#MB_ICONINFORMATION)
  End
EndIf

; GUI aufbauen & Config Laden.

FixConfigPath()
SetGUI()
LoadConfig()
SetGadgetState(9,CurrentThemeNumber)
SetActiveGadget(9)
AutostartFolder$=Spec_Folder(#CSIDL_STARTUP)
If Right(AutostartFolder$,1)<>"\" : AutostartFolder$+"\" : EndIf
If FileSize(AutostartFolder$+"PureTheme_Launch.lnk")<0 ; "Disable"-Gadget ggf. Deaktivieren.
  DisableGadget(7,#True)
EndIf

Repeat

  ; Auf Events warten.

  EventID=WaitWindowEvent()
  If EventID=#PB_Event_Gadget
    Gadget=EventGadget()
  Else
    Gadget=#Null
  EndIf

  ; ListIcon angeklickt?

  If Gadget=9 Or EntryRemoved=#True Or FirstStart=#True
    FirstStart=#False
    EntryRemoved=#False
    If GetGadgetState(9)=-1
      DisableGadget(2,#True)
      DisableGadget(3,#True)
      DisableGadget(4,#True)
      DisableGadget(5,#True)
      DisableGadget(6,#True)
      DisableGadget(10,#True)
      DisableGadget(11,#True)
      StatusBarText(0,1,"",#PB_StatusBar_Raised)
      SetWallpaperPreview("")
    Else
      If LCase(GetExtensionPart(GetGadgetItemText(9,GetGadgetState(9))))<>"theme"
        st=1
        DisableGadget(10,#True)
      Else
        st=0
        DisableGadget(10,#False)
      EndIf
      DisableGadget(2,#False)
      DisableGadget(3,#False)
      DisableGadget(4,#False)
      DisableGadget(5,#False)
      DisableGadget(6,#False)
      If OSVersion()>#PB_OS_Windows_7
        DisableGadget(11,#False)
      EndIf
      StatusBarText(0,1,GetStyleName(),#PB_StatusBar_Raised)
      SetWallpaperPreview(ConvertEnvString(GetGadgetItemText(9,GetGadgetState(9))),st)
      If EventType()=#PB_EventType_LeftDoubleClick
        Gadget=6 ; Event fr "bernehmen" nach DoppelClick ausfhren.
      EndIf
    EndIf
  EndIf

  ; ThemeFiles hinzufgen.

  If Gadget=1
    st=GetGadgetState(9)
    If st<0 : st=CountGadgetItems(9)-1 : EndIf
    def$=GetPathPart(GetGadgetItemText(9,st))
    file$=OpenFileRequester("Theme(s) whlen",def$,"All Supported Themes|*.theme;*.deskthemepack;*.themepack|Themes (*.theme)|*.theme|Win7-ThemePacks (*.themepack)|*.themepack|Win8-ThemePacks (*.deskthemepack)|*.deskthemepack",0,#PB_Requester_MultiSelection)
    While file$
      If FileSize(file$)>0
        def$=file$
        AddGadgetItem(9,-1,file$)
        SettingsChange=#True
      EndIf
      file$=NextSelectedFileName()
    Wend
    SetActiveGadget(9)
  EndIf

  ; ThemeFiles aus Liste entfernen.

  If Gadget=2
    If GetGadgetState(9)=>0
      If MessageRequester("Frage", "Mchten Sie die gewhlten Themes wirklich aus der Liste entfernen ?", #MB_YESNO|#MB_ICONQUESTION) = #IDYES
        For i=CountGadgetItems(9)-1 To 0 Step -1
          If GetGadgetItemState(9,i) & #PB_ListIcon_Selected
            RemoveGadgetItem(9,i)
            DeleteArrayElement(i)
            EntryRemoved=#True
            SettingsChange=#True
          EndIf
        Next
      EndIf
      SetActiveGadget(9)
    EndIf
  EndIf

  ; ComboBox gendert ?

  If Gadget=5
    If EventType()=#PB_EventType_Change
      If GetGadgetState(5)<>StepWide
        SettingsChange=#True
      EndIf
      SetActiveGadget(9)
    EndIf
  EndIf

  ; Themes Einstellung bernehmen und GUI beenden.

  If Gadget=6
    CurrentThemeNumber=GetGadgetState(9)
    SaveConfig()
    UseWindowsTheme(GetGadgetItemText(9,CurrentThemeNumber))
    file$=GetPathPart(ProgramFilename())+"PureTheme_Launch.exe"
    CreateShortcut(file$,AutostartFolder$+"PureTheme_Launch.lnk","","PureTheme-Launcher",GetPathPart(file$),#SW_SHOWNORMAL,0,file$,1)
    CloseWindow(0)
    Delay(500)
    Break
  EndIf

  ; Themes Rotation stoppen.

  If Gadget=7
    If MessageRequester("Frage", "Mchten Sie die Rotation wirklich stoppen ?", #MB_YESNO|#MB_ICONQUESTION) = #IDYES
      DeleteFile(AutostartFolder$+"PureTheme_Launch.lnk")
      DisableGadget(7,#True)
    EndIf
    SetActiveGadget(9)
  EndIf

  ; Weitere Wallpapers hinzufgen.

  If Gadget=10
    index.i=GetGadgetState(9)
    If CallWallpaperPrefs(GetGadgetItemText(9,index), index) = #True
      SettingsChange=#True
    EndIf
  EndIf

  ; AnmeldeSound aktiviert oder deaktiviert.

  If Gadget=11
    SettingsChange=#True
    SetActiveGadget(9)
  EndIf

  ; Settings gendert ?

  If EventID=#PB_Event_CloseWindow
    If SettingsChange=#True
      If MessageRequester("Programm beenden", "Mchten Sie wirklich alle nderungen verwerfen ?", #MB_YESNO|#MB_ICONQUESTION) = #IDYES
        Break
      EndIf
      SetActiveGadget(9)
    Else
      Break
    EndIf
  EndIf

ForEver

If IsImage(0)<>#Null
  FreeImage(0)
EndIf

; IDE Options = PureBasic 5.42 LTS (Windows - x64)
; Folding = AAw
; EnableXP
; UseIcon = Icons\Tool1.ico
; Executable = ..\Temp\PureTheme_GUI.exe