
; *******************************************************
; * PureStarter V1.6 - (w) 2012 - 2022 by Harald Wagner *
; *******************************************************


; AppRunning Check

Mutex = CreateMutex_(0,0, "Pure Starter")
If GetLastError_() = #ERROR_ALREADY_EXISTS
  ReleaseMutex_(Mutex)
  CloseHandle_(Mutex)
  End
EndIf

; VarInit

AutoCloseApp=#True
Global CustomAdd, CustomDel
Global Dim Tag.i(32), LastSkin.i, WinVers$, NewList Custom$(), NewList Symbol.i()
Tag(01)=0 : Tag(06)=0 : Tag(11)=0 : Tag(16)=0 : Tag(21)=0 : Tag(26)=0
Tag(02)=1 : Tag(07)=1 : Tag(12)=1 : Tag(17)=1 : Tag(22)=1 : Tag(27)=1
Tag(03)=2 : Tag(08)=2 : Tag(13)=2 : Tag(18)=2 : Tag(23)=2 : Tag(28)=2
Tag(04)=3 : Tag(09)=3 : Tag(14)=3 : Tag(19)=3 : Tag(24)=3 : Tag(29)=3
Tag(05)=4 : Tag(10)=4 : Tag(15)=4 : Tag(20)=4 : Tag(25)=4 : Tag(30)=4 : Tag(31)=0
Dim Shutdown(3) : Shutdown(0)=#EWX_LOGOFF : Shutdown(1)=#EWX_REBOOT : Shutdown(2)=#EWX_SHUTDOWN : Shutdown(3)=#EWX_POWEROFF
Global LogoffDefault=2, MenuFarbe=0, SortMode=1, StartMode=1, MenuMode=0, RenameFolders=1, ShutdownSkin=0, MenuSound=1, UseOrigIcon=0
Global Dim MenuColor.i(12,4), NewList StartMenuFolders.s(), NewList Entrys.s(), NewList Icons.i()
AddElement(StartMenuFolders())
StartMenuFolders()=GetHomeDirectory()+"AppData\Roaming\Microsoft\Windows\Start Menu\"
AddElement(StartMenuFolders())
StartMenuFolders()=Left(GetHomeDirectory(),3)+"ProgramData\Microsoft\Windows\Start Menu\"

; Benutzerfarben definieren

MenuColor(1,0)=$C0C0C0 : MenuColor(1,1)=$A7A7A7 : MenuColor(1,2)=$E0E0E0 : MenuColor(1,3)=$A0A0A0 : MenuColor(1,4)=$000000
MenuColor(2,0)=$7F7F7F : MenuColor(2,1)=$5F5F5F : MenuColor(2,2)=$9F9F9F : MenuColor(2,3)=$BFBFBF : MenuColor(2,4)=$000000
MenuColor(3,0)=$FFB062 : MenuColor(3,1)=$DF9042 : MenuColor(3,2)=$FFD082 : MenuColor(3,3)=$EEA052 : MenuColor(3,4)=$000000
MenuColor(4,0)=$CA0000 : MenuColor(4,1)=$AA0000 : MenuColor(4,2)=$EF4806 : MenuColor(4,3)=$900000 : MenuColor(4,4)=$FFFFFF
MenuColor(5,0)=$AEFF5E : MenuColor(5,1)=$8EDF3E : MenuColor(5,2)=$CEFF7E : MenuColor(5,3)=$00B000 : MenuColor(5,4)=$000000
MenuColor(6,0)=$60BF00 : MenuColor(6,1)=$409F00 : MenuColor(6,2)=$80DF20 : MenuColor(6,3)=$A0FF40 : MenuColor(6,4)=$000000
MenuColor(7,0)=$4A4AFF : MenuColor(7,1)=$2A2ADF : MenuColor(7,2)=$6A6AFF : MenuColor(7,3)=$8A8AFF : MenuColor(7,4)=$FFFFFF
MenuColor(8,0)=$0000A6 : MenuColor(8,1)=$000086 : MenuColor(8,2)=$4040E6 : MenuColor(8,3)=$6060FF : MenuColor(8,4)=$FFFFFF
MenuColor(9,0)=$7B7B1E : MenuColor(9,1)=$5B5B00 : MenuColor(9,2)=$9B9B3E : MenuColor(9,3)=$BBBB5E : MenuColor(9,4)=$000000
MenuColor(10,0)=$3C7BFF : MenuColor(10,1)=$1C5BDF : MenuColor(10,2)=$5C9BFF : MenuColor(10,3)=$7CBBFF : MenuColor(10,4)=$000000
MenuColor(11,0)=$B700B7 : MenuColor(11,1)=$970097 : MenuColor(11,2)=$F740F7 : MenuColor(11,3)=$970097 : MenuColor(11,4)=$FFFFFF

; Images Init

UseJPEGImageDecoder()
UsePNGImageDecoder()
CatchImage(0, ?BackIcon_Start)
CatchImage(1, ?OK_Icon_Start)
CatchImage(2, ?WindowsLogo_Start)
CatchImage(3, ?File_Start3)
CatchImage(4, ?MonitorIcon)
CatchImage(5, ?ShutdownWinLogo)
CatchImage(6, ?StandByXP)
CatchImage(7, ?ShutdownXP)
CatchImage(8, ?RestartXP)
CatchImage(9, ?WinLogoXP)
CatchImage(10, ?AbmeldenXP)
CatchImage(11, ?RunterfahrenXP)
CatchImage(12, ?Arrow_Win7)
CatchImage(13, ?Abmelden16)
CatchImage(14, ?Restart16)
CatchImage(15, ?Shutdown16)
CatchImage(16, ?Energy16)
CatchImage(17, ?Information16)
CatchImage(18, ?Folder_Start2)
CatchImage(19, ?Refresh_Start)
CatchImage(20, ?File_Start4)
CatchImage(21, ?Tool)
CatchImage(22, ?Tool2)
CatchImage(23, ?Info)
CatchImage(24, ?VistaFolder)
CatchImage(25, ?WinUpdate)
CatchImage(26, ?Computer)
CatchImage(27, ?HardDisk)
CatchImage(28, ?Network)
CatchImage(29, ?Printer)
CatchImage(30, ?MenuSettings)
CatchImage(31, ?DeviceManager)
CatchImage(32, ?Deinstall)
CatchImage(33, ?Plus)
CatchImage(34, ?Minus)


; Structures

Structure MySHFILEINFO 
  hIcon.i
  iIcon.l
  dwAttributes.l
  szDisplayName.b[#MAX_PATH] 
  szTypeName.b[80] 
EndStructure 

; Procedures

Procedure.s ReadRegKey(OpenKey.i,SubKey.s,ValueName.s,Type.i=1)

  hKey.i=0
  DataSize.i=255
  keyvalue$=""
  mem=AllocateMemory(1024)

  If mem
    If RegOpenKeyEx_(OpenKey,SubKey,0,#KEY_READ,@hKey)
      keyvalue$="Error"
    Else
      If RegQueryValueEx_(hKey,ValueName,0,0,mem,@DataSize)
        keyvalue$="Error"
      Else
        If Type=0
          keyvalue$=Str(PeekI(mem))
        ElseIf Type=1
          keyvalue$=PeekS(mem)
        EndIf
      EndIf
      RegCloseKey_(hKey)
    EndIf
    FreeMemory(mem)
  EndIf

  ProcedureReturn keyvalue$

EndProcedure

Procedure.i ReadRegKey2(OpenKey.i,SubKey.s,ValueName.s)

  hKey.i=#Null
  keyvalue.s=Space(255)
  DataSize.i=255
  
  If RegOpenKeyEx_(OpenKey,SubKey,0,#KEY_READ,@hKey)
    keyvalue=""
  Else
    st=#True
    If RegQueryValueEx_(hKey,ValueName,0,0,@keyvalue,@DataSize)
      keyvalue=""
    Else
      keyvalue=Left(keyvalue,DataSize-1)
    EndIf
    RegCloseKey_(hKey)
  EndIf

  ProcedureReturn st

EndProcedure

Procedure.i GetRestartText()

  Shared RestartText$, RestartText2$, RestartText3$

  x=ReadRegKey2(#HKEY_LOCAL_MACHINE,"SOFTWARE\Microsoft\Windows\CurrentVersion\WindowsUpdate\Auto Update\RebootRequired","")
  If x=#True
    RestartText$="Aktualisieren und neu starten"
    RestartText2$="Starten Sie den Computer neu um"+#CRLF$+"Wichtige Updates abzuschliessen"
    RestartText3$="Update & neu starten"
    CopyImage(19,8)
  Else
    RestartText2$=""
    RestartText$="Neu Starten"
    RestartText3$="Neu Starten"
  EndIf

EndProcedure

Procedure.s GetWindowsVersion()

  a$=ReadRegKey(#HKEY_LOCAL_MACHINE,"SOFTWARE\Microsoft\Windows NT\CurrentVersion","ProductName")
  If a$="" Or a$="Error"
    a$="Windows"
  EndIf
  If OSVersion()=#PB_OS_Windows_11
    If FindString(a$," 10 ")
      b$=ReplaceString(a$," 10 ", " 11 ")
      a$=b$
    EndIf
  EndIf
  ProcedureReturn a$

EndProcedure

Procedure.s FixText(window, fnt, gad, text$)

drx.f=DesktopResolutionX()

If StartDrawing(WindowOutput(window))
  DrawingFont(FontID(fnt))
  x=TextWidth(text$)
  z=((GadgetWidth(gad)*drx)-x)/2
  Repeat
    a+TextWidth(" ")
    y+1
  Until a=>z-12 ; 12 Pixel weniger wegen Scroll Slider rechts.
  StopDrawing()
EndIf

ProcedureReturn Space(y)+text$

EndProcedure

Procedure.i DisableXPTheme(Gadget.i, Force.i=#False)

  Protected DLL.i, Null.w 

  If OSVersion()>#PB_OS_Windows_Vista Or Force=#True
    DLL = OpenLibrary(#PB_Any, "uxtheme.dll") 
    If DLL<>0
      CallFunction(DLL, "SetWindowTheme", GadgetID(Gadget), @Null.w, @Null.w) 
      CloseLibrary(DLL) 
      ProcedureReturn #True 
    EndIf
  EndIf

EndProcedure 

Procedure.s FindShortcutsPath(File$)

  ; *.LNK Datei Laden!

  If ReadFile(0,File$)
    l=Lof(0) : mem=AllocateMemory(l+4)
    If mem : ReadData(0,mem,l) : EndIf
    CloseFile(0)
  EndIf

  ; *.LNK Datei Durchsuchen!

  If mem
    For i=0 To l-4
      If PeekW(mem+i)=$5C3A
        p$=PeekS(mem+i-1,-1,#PB_Ascii)
        If Len(p$)>3
          st=FileSize(p$)
          If st=>0 Or st=-2
            If Right(p$,1)<>Slash$ : p$+Slash$ : EndIf
            Break
          EndIf
        EndIf
        p$=""
      EndIf
    Next
    FreeMemory(mem)
  EndIf

  ProcedureReturn p$

EndProcedure

Procedure.i SelectGadgetText(Gadget.i, pos.i, length.i)
   SendMessage_(GadgetID(Gadget), #EM_SETSEL, pos-1, pos+length-1)
EndProcedure

Procedure.s TranslateFolder(File$)

If RenameFolders=#True
  Size=Len(StringField(File$,CountString(File$,"\")+1,"\"))
  If LCase(File$)="programme"
    File$="Programs"
  ElseIf LCase(StringField(File$,CountString(File$,"\")+1,"\"))="zubehr"
    File$=Left(File$,Len(file$)-Size)+"Accessories"
  ElseIf LCase(StringField(File$,CountString(File$,"\")+1,"\"))="wartung"
    File$=Left(File$,Len(file$)-Size)+"Maintenance"
  ElseIf LCase(StringField(File$,CountString(File$,"\")+1,"\"))="autostart"
    File$=Left(File$,Len(file$)-Size)+"Startup"
  ElseIf LCase(StringField(File$,CountString(File$,"\")+1,"\"))="verwaltung"
    File$=Left(File$,Len(file$)-Size)+"Administrative Tools"
  ElseIf LCase(StringField(File$,CountString(File$,"\")+1,"\"))="erleichterte bedienung"
    File$=Left(File$,Len(file$)-Size)+"Accessibility"
  ElseIf LCase(StringField(File$,CountString(File$,"\")+1,"\"))="systemprogramme"
    File$=Left(File$,Len(file$)-Size)+"System Tools"
  ElseIf LCase(File$)="programs"
    File$="Programme"
  ElseIf LCase(File$)="accessories"
    File$="Zubehr"
  ElseIf LCase(File$)="maintenance"
    File$="Wartung"
  ElseIf LCase(File$)="startup"
    File$="Autostart"
  ElseIf LCase(File$)="administrative tools"
    File$="Verwaltung"
  ElseIf LCase(File$)="accessibility"
    File$="Erleichterte Bedienung"
  ElseIf LCase(File$)="system tools"
    File$="Systemprogramme"
  EndIf
EndIf

ProcedureReturn File$

EndProcedure

Procedure ShowFileProperties(File.s)
  Protected SEI.SHELLEXECUTEINFO
 
  With SEI
    \cbSize = SizeOf(SHELLEXECUTEINFO)
    \fMask = #SEE_MASK_NOCLOSEPROCESS | #SEE_MASK_INVOKEIDLIST | #SEE_MASK_FLAG_NO_UI
    \lpVerb = @"properties"
    \lpFile = @File
  EndWith
 
  ProcedureReturn ShellExecuteEx_(@SEI)
EndProcedure

Procedure EnableShutDown()
  Privileges.TOKEN_PRIVILEGES
  OpenProcessToken_(GetCurrentProcess_(), 40, @hToken)
  Privileges\PrivilegeCount           = 1
  Privileges\Privileges[0]\Attributes = #SE_PRIVILEGE_ENABLED
  LookupPrivilegeValue_(0, "SeShutdownPrivilege", @Privileges\Privileges[0]\Luid)
  AdjustTokenPrivileges_(hToken, 0, @Privileges, 0, 0, 0)
  CloseHandle_(hToken)
EndProcedure

Procedure SetShutdown(Flags.i)
  EnableShutDown()
  ExitWindowsEx_(Flags, 0)
EndProcedure

Procedure.i CreateMirrorImage(Image, Width, Height, Color1, Color2)

img=CreateImage(Image, Width, Height)
If Image=#PB_Any : Image=img : EndIf

If IsImage(Image)
  If StartDrawing(ImageOutput(Image))
    If Red(Color2)>Red(Color1)
      Pixels=Red(Color2)-Red(Color1)
      add1.f=Pixels/Height
    Else
      Pixels=Red(Color1)-Red(Color2)
      add1.f=-(Pixels/Height)
    EndIf
    If Green(Color2)>Green(Color1)
      Pixels=Green(Color2)-Green(Color1)
      add2.f=Pixels/Height
    Else
      Pixels=Green(Color1)-Green(Color2)
      add2.f=-(Pixels/Height)
    EndIf
    If Blue(Color2)>Blue(Color1)
      Pixels=Blue(Color2)-Blue(Color1)
      add3.f=Pixels/Height
    Else
      Pixels=Blue(Color1)-Blue(Color2)
      add3.f=-(Pixels/Height)
    EndIf
    r.f=Red(Color1):g.f=Green(Color1):b.f=Blue(Color1)
    For y=0 To Height-1
      Box(0,y,Width,1,RGB(r,g,b))
      r+add1 : g+add2 : b+add3
    Next
    StopDrawing()
    ProcedureReturn img
  EndIf
EndIf

EndProcedure

Procedure.i SetShutdownGadgets()

  Shared fnt2, drx.f, dry.f, RestartText$, RestartText2$, RestartText3$
  GetRestartText()

  If ShutdownSkin=0
    ComboBoxGadget(6, 465, 565, 192, 28)
    SetGadgetFont(6, FontID(fnt2))
    AddGadgetItem(6,-1,"Abmelden")
    AddGadgetItem(6,-1,RestartText3$)
    AddGadgetItem(6,-1,"Herunterfahren")
    AddGadgetItem(6,-1,"Energie sparen")
    AddGadgetItem(6,-1,"<Windows beenden>")
    SetGadgetState(6,4)
  ElseIf ShutdownSkin=1
    If drx>1.0 Or dry>1.0
      ResizeImage(11, ImageWidth(11)*drx, ImageHeight(11)*dry)
    EndIf
    ButtonImageGadget(6, 493, 560, 136, 33, ImageID(11))
    GadgetToolTip(6, "Windows abmelden. (Weitere Optionen anzeigen)")
  ElseIf ShutdownSkin=2
    If drx>1.0 Or dry>1.0
      ResizeImage(11, ImageWidth(11)*drx, ImageHeight(11)*dry)
    EndIf
    ButtonImageGadget(6, 493, 560, 136, 33, ImageID(11))
    GadgetToolTip(6, "Windows abmelden. (Weitere Optionen anzeigen)")
  ElseIf ShutdownSkin=3
    If drx>1.0 Or dry>1.0
      ResizeImage(10, ImageWidth(10)*drx, ImageHeight(10)*dry)
      ResizeImage(11, ImageWidth(11)*drx, ImageHeight(11)*dry)
    EndIf
    ButtonImageGadget(13, 493, 532, 136, 33, ImageID(10))
    ButtonImageGadget(6, 493, 567, 136, 33, ImageID(11))
    GadgetToolTip(13, "Benutzer wechseln")
    GadgetToolTip(6, "Windows abmelden. (Weitere Optionen anzeigen)")
  ElseIf ShutdownSkin=4
    ButtonGadget(15, 474, 560, 143, 30, "Herunterfahren")
    ButtonImageGadget(16, 617, 560, 30, 30, ImageID(12))
    SetGadgetFont(15, FontID(fnt2))
    GadgetToolTip(15, "Computer ausschalten")
    If CreatePopupImageMenu(1,#PB_Menu_ModernLook)
      MenuItem(10, "Abmelden",ImageID(13))
      MenuItem(11, RestartText$,ImageID(14))
      MenuBar()
      MenuItem(12, "Herunterfahren",ImageID(15))
      MenuBar()
      MenuItem(13, "Energie sparen",ImageID(16))
    EndIf
  EndIf

EndProcedure

Procedure IsTaskBarIconsCenterAligned()

  ;Return value: -1 (error), 0 (left), 1 (center)
  Protected Value, Result = -1
  Protected Type = #REG_DWORD, Size = 4
  
  If OSVersion() => #PB_OS_Windows_11
    If SHRegGetUSValue_("Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced", "TaskbarAl", @Type, @Value, @Size, 0, 0, 0) = #ERROR_SUCCESS
      Result = Value
    EndIf
  EndIf

  ProcedureReturn Result

EndProcedure

Procedure.i CreateGUI()

  Shared fnt, fnt2, fnt3, MirrorImg, drx.f, dry.f, MenuMode

  ExamineDesktops()
  WinWidth.f = 730
  WinHeight.f = 676
  width.f=DesktopWidth(0)
  height.f=DesktopHeight(0)
  drx.f=DesktopResolutionX()
  dry.f=DesktopResolutionY()

  If dry=1.0
    height-(676*dry)
    WinPosY=(height)-(75*dry)
  ElseIf dry=1.25
    height-(656*dry)
    WinPosY=(height)-(118*dry)
  ElseIf dry=1.50
    height-(646*dry)
    WinPosY=(height)-(97*dry)
  ElseIf dry=1.75
    height-(595*dry)
    WinPosY=(height)-(60*dry)
  EndIf

  If MenuMode=0
    x=IsTaskBarIconsCenterAligned()
    If x=0
      WinPosX.f=0
    ElseIf x=1
      WinPosX.f = 0
      WinPosX.f = (width)/(2*drx)
      WinPosX.f - (WinWidth/2)
    EndIf
  ElseIf MenuMode=1
    WinPosX.f = 0
  ElseIf MenuMode=2
    WinPosX.f = 0
    WinPosX.f = (width)/(2*drx)
    WinPosX.f - (WinWidth/2)
  EndIf

  a$=GetWindowsVersion() : WinVers$=a$
  fnt=LoadFont(#PB_Any, "Microsoft Sans Serif", 14, #PB_Font_Bold|#PB_Font_HighQuality)
  fnt2=LoadFont(#PB_Any, "Calibri", 14, #PB_Font_HighQuality)
  fnt3=LoadFont(#PB_Any, "Tahoma", 18, #PB_Font_Bold|#PB_Font_HighQuality)
  fnt4=LoadFont(#PB_Any, "Tahoma", 18, #PB_Font_Bold|#PB_Font_HighQuality|#PB_Font_Italic)
  fnt5=LoadFont(#PB_Any, "Calibri", 14, #PB_Font_Bold|#PB_Font_HighQuality)
  MirrorImg=CreateMirrorImage(#PB_Any, 32 * drx, 656 * dry, RGB(0,230,0), RGB(0,0,255))
  If StartDrawing(ImageOutput(MirrorImg))
    DrawingFont(FontID(fnt3))
    DrawRotatedText(0, 520 * dry, "Microsoft "+a$, 90, RGB(0,0,0))
    DrawRotatedText(0, 523 * dry, "Microsoft "+a$, 90, RGB(255,255,255))
    StopDrawing()
  EndIf
  If OpenWindow(0, WinPosX, WinPosY, WinWidth, WinHeight, "Start", #PB_Window_TitleBar | #PB_Window_SystemMenu | #PB_Window_Tool)
    ; Popup Menu
    If CreatePopupImageMenu(0,#PB_Menu_ModernLook)
      MenuItem(1, "Zielpfad zur Datei ffnen",ImageID(18))
      MenuItem(2, "Eigenschaften",ImageID(17))
    EndIf
    ImageGadget(14,0,10,30,556,ImageID(MirrorImg))
    ContainerGadget(0, 41, 10, 680, 656, #PB_Container_Raised)
      ListIconGadget(1, 20, 13, 425, 593, "Verknpfungen", 402, #PB_ListIcon_AlwaysShowSelection|#PB_ListIcon_FullRowSelect|#PB_ListIcon_GridLines)
      flag = SendMessage_(GadgetID(1), #LVM_GETEXTENDEDLISTVIEWSTYLE, 0, 0)
      SendMessage_(GadgetID(1), #LVM_SETEXTENDEDLISTVIEWSTYLE, 0, flag | #LVS_EX_ONECLICKACTIVATE | #LVS_EX_UNDERLINEHOT)
      If drx>1.0 Or dry>1.0
        ResizeImage(2, ImageWidth(2)*drx, ImageHeight(2)*dry)
      EndIf
      ImageGadget(7, 537, 20, 128, 97, ImageID(9))
      TextGadget(25, 465, ImageHeight(9)+35, 185, 75, a$, #PB_Text_Center)
      SetGadgetColor(25, #PB_Gadget_FrontColor, #Blue)
      HyperLinkGadget(2, 511, 167, 100, 25, "Dieser PC", #Blue)
      HyperLinkGadget(3, 477, 193, 170, 25, "Systemsteuerung", #Blue)
      HyperLinkGadget(4, 486, 219, 157, 25, "Eigene Dateien", #Blue)
      HyperLinkGadget(8, 481, 245, 163, 25, "Gerte Manager", #Blue)
      HyperLinkGadget(21, 477, 271, 171, 25, "Gerte & Drucker", #Blue)
      HyperLinkGadget(22, 507, 297, 113, 25, "Netzwerke", #Blue)
      HyperLinkGadget(23, 474, 323, 178, 25, "App Deinstallieren", #Blue)
      HyperLinkGadget(24, 480, 349, 166, 25, "Windows Update", #Blue)
      HyperLinkGadget(27, 452, 375, 215, 25, "Datentrgerverwaltung", #Blue)
      HyperLinkGadget(28, 478, 401, 170, 25, "PC-Einstellungen", #Blue)
      HyperLinkGadget(9, 493, 427, 148, 25, "Einstellungen", #Blue)
      HyperLinkGadget(26, 500, 453, 125, 25, "SystemInfos", #Blue)
      ButtonGadget(29, 460, 490, 200, 35, "<Benutzerdefiniert>")
      If CreatePopupImageMenu(2,#PB_Menu_ModernLook)
        Index=1000
        ResetList(Symbol())
        ForEach Custom$()
          NextElement(Symbol())
          Index+1
          MenuItem(Index, StringField(Custom$(), 1, "*"), Symbol())
        Next
        If ListSize(Custom$())>0
          MenuBar()
        EndIf
        Index+1 : CustomAdd=Index
        MenuItem(Index, "<Hinzufgen>",ImageID(33))
        Index+1 : CustomDel=Index
        MenuItem(Index, "<Entfernen>",ImageID(34))
      EndIf
      TextGadget(10,18,617,85,22,"Ausfhren")
      StringGadget(11,105,615,465,26,"<Bitte Dateinamen eingeben!>",#ES_NOHIDESEL)
      ButtonGadget(12,571,614,33,28,">>")
      SetShutdownGadgets()
      SetActiveGadget(1)
      AddKeyboardShortcut(0,#PB_Shortcut_Return,111)
    CloseGadgetList()
    ; Gadget Fonts
    SetGadgetFont(1, FontID(fnt2))
    SetGadgetFont(2, FontID(fnt))
    SetGadgetFont(3, FontID(fnt))
    SetGadgetFont(4, FontID(fnt))
    SetGadgetFont(8, FontID(fnt))
    SetGadgetFont(9, FontID(fnt))
    SetGadgetFont(21, FontID(fnt))
    SetGadgetFont(22, FontID(fnt))
    SetGadgetFont(23, FontID(fnt))
    SetGadgetFont(24, FontID(fnt))
    SetGadgetFont(10, FontID(fnt2))
    SetGadgetFont(11, FontID(fnt2))
    SetGadgetFont(12, FontID(fnt2))
    SetGadgetFont(25, FontID(fnt4))
    SetGadgetFont(26, FontID(fnt))
    SetGadgetFont(27, FontID(fnt))
    SetGadgetFont(28, FontID(fnt))
    SetGadgetFont(29, FontID(fnt5))
    SetGadgetColor(1, #PB_Gadget_LineColor, $cccccc)
    If MenuFarbe>0
      ; Gadget Colors
      SetGadgetColor(0, #PB_Gadget_FrontColor, 0)
      SetGadgetColor(0, #PB_Gadget_BackColor, MenuColor(MenuFarbe,0))
      SetGadgetColor(1, #PB_Gadget_LineColor, MenuColor(MenuFarbe,3))
      SetGadgetColor(1, #PB_Gadget_FrontColor, MenuColor(MenuFarbe,4))
      SetGadgetColor(1, #PB_Gadget_BackColor, MenuColor(MenuFarbe,2))
      SetGadgetColor(2, #PB_Gadget_FrontColor, 0)
      SetGadgetColor(2, #PB_Gadget_BackColor, MenuColor(MenuFarbe,0))
      SetGadgetColor(3, #PB_Gadget_FrontColor, 0)
      SetGadgetColor(3, #PB_Gadget_BackColor, MenuColor(MenuFarbe,0))
      SetGadgetColor(4, #PB_Gadget_FrontColor, 0)
      SetGadgetColor(4, #PB_Gadget_BackColor, MenuColor(MenuFarbe,0))
      SetGadgetColor(8, #PB_Gadget_FrontColor, 0)
      SetGadgetColor(8, #PB_Gadget_BackColor, MenuColor(MenuFarbe,0))
      SetGadgetColor(9, #PB_Gadget_FrontColor, 0)
      SetGadgetColor(9, #PB_Gadget_BackColor, MenuColor(MenuFarbe,0))
      SetGadgetColor(21, #PB_Gadget_FrontColor, 0)
      SetGadgetColor(21, #PB_Gadget_BackColor, MenuColor(MenuFarbe,0))
      SetGadgetColor(22, #PB_Gadget_FrontColor, 0)
      SetGadgetColor(22, #PB_Gadget_BackColor, MenuColor(MenuFarbe,0))
      SetGadgetColor(23, #PB_Gadget_FrontColor, 0)
      SetGadgetColor(23, #PB_Gadget_BackColor, MenuColor(MenuFarbe,0))
      SetGadgetColor(24, #PB_Gadget_FrontColor, 0)
      SetGadgetColor(24, #PB_Gadget_BackColor, MenuColor(MenuFarbe,0))
      SetGadgetColor(10, #PB_Gadget_FrontColor, 0)
      SetGadgetColor(10, #PB_Gadget_BackColor, MenuColor(MenuFarbe,0))
      SetGadgetColor(11, #PB_Gadget_FrontColor, MenuColor(MenuFarbe,4))
      SetGadgetColor(11, #PB_Gadget_BackColor, MenuColor(MenuFarbe,2))
      SetGadgetColor(25, #PB_Gadget_FrontColor, #Blue)
      SetGadgetColor(25, #PB_Gadget_BackColor, MenuColor(MenuFarbe,0))
      SetGadgetColor(26, #PB_Gadget_FrontColor, 0)
      SetGadgetColor(26, #PB_Gadget_BackColor, MenuColor(MenuFarbe,0))
      SetGadgetColor(27, #PB_Gadget_FrontColor, 0)
      SetGadgetColor(27, #PB_Gadget_BackColor, MenuColor(MenuFarbe,0))
      SetGadgetColor(28, #PB_Gadget_FrontColor, 0)
      SetGadgetColor(28, #PB_Gadget_BackColor, MenuColor(MenuFarbe,0))
      ; Window Backcolor
      SetWindowColor(0, MenuColor(MenuFarbe,1))
    EndIf
  EndIf

EndProcedure

Procedure.s GetAndCreateConfigPath(FullPath$)

  Protected PrefsPath$

  If Right(FullPath$, 1)<>"\" : FullPath$+"\" : EndIf
  a$ = "<ERROR>"

  If OSVersion()=>#PB_OS_Windows_Vista
    PrefsPath$ = GetEnvironmentVariable("APPDATA") + "\" + StringField(FullPath$, CountString(FullPath$,"\"), "\") + "\"
  EndIf

  If FileSize(PrefsPath$)=-2
    a$=PrefsPath$
  ElseIf CreateDirectory(PrefsPath$)
    a$=PrefsPath$
  EndIf

  ProcedureReturn a$

EndProcedure

Procedure.s FixEnvString(string$)

Repeat
  count=FindString(string$,"%",1)
  If count>0
    len=FindString(string$,"%",count+1) - count-1
    If len>0
      a$=Mid(string$,count+1,len)
      If a$<>""
        b$=GetEnvironmentVariable(a$)
      EndIf
      string$=ReplaceString(string$,"%"+a$+"%",b$,#PB_String_NoCase)
      b$=""
    Else
      Break
    EndIf
  EndIf
Until count=0

ProcedureReturn Trim(string$)

EndProcedure

Procedure.s FindShortcutsFile(File$)

If LCase(GetExtensionPart(File$))="lnk"
  ; *.LNK Datei Laden!
  If ReadFile(0,File$)
    l=Lof(0) : mem=AllocateMemory(l+4)
    If mem : ReadData(0,mem,l) : EndIf
    CloseFile(0)
  EndIf
  ; *.LNK Datei Durchsuchen!
  If mem
    For i=0 To l-4
      If PeekW(mem+i)=$5C3A
        p$=PeekS(mem+i-1,-1,#PB_UTF8)
        If Len(p$)>3
          If FileSize(p$)=>0
            Break
          EndIf
        EndIf
        p$=""
      EndIf
    Next
    If p$=""
      For i=0 To l-4
        If PeekB(mem+i)=$25
          p$=FixEnvString(PeekS(mem+i))
          If Len(p$)>3
            If FileSize(p$)=>0
              Break
            EndIf
          EndIf
          p$=""
        EndIf
      Next
    EndIf
    If p$="":p$=File$:EndIf
    FreeMemory(mem)
  EndIf
Else
  p$=File$
EndIf

ProcedureReturn p$

EndProcedure

Procedure.i GetFileIcon_Simple(File$,IconType.i=#SHGFI_SMALLICON)

If FileSize(File$)=>0
  Icon=ImageID(CopyImage(3,#PB_Any))
ElseIf FileSize(File$)=-2
  Icon=ImageID(CopyImage(18,#PB_Any))
EndIf

ProcedureReturn Icon

EndProcedure

Procedure.i GetFileIcon(File$,IconType.i=#SHGFI_SMALLICON)

If UseOrigIcon=#True
  If FileSize(File$)=>0
    a$=FindShortcutsFile(File$)
    If SHGetFileInfo_(a$, #FILE_ATTRIBUTE_NORMAL, @Info.MySHFILEINFO, SizeOf(MySHFILEINFO), #SHGFI_TYPENAME|#SHGFI_ICON|IconType|#SHGFI_USEFILEATTRIBUTES)<>#Null
      Icon.i=Info\hIcon
    EndIf
  ElseIf FileSize(File$)=-2
    If SHGetFileInfo_(File$, #FILE_ATTRIBUTE_NORMAL, @Info.MySHFILEINFO, SizeOf(MySHFILEINFO), #SHGFI_TYPENAME|#SHGFI_ICON|IconType)<>#Null
      Icon.i=Info\hIcon
    EndIf
  EndIf
Else
  Icon=GetFileIcon_Simple(File$)
EndIf

ProcedureReturn Icon

EndProcedure

Procedure.s GetShortcuts(Directory$)

  ForEach StartMenuFolders()
    If ExamineDirectory(0, StartMenuFolders()+Directory$, "")
      While NextDirectoryEntry(0)
        name$=DirectoryEntryName(0)
        ext$=LCase(GetExtensionPart(name$))
        If Left(name$,1)<>"." And LCase(GetExtensionPart(name$))<>"ini"
          If DirectoryEntryType(0) = #PB_DirectoryEntry_File
            If ext$="lnk" Or ext$="url" Or ext$="html" Or ext$="htm"
              count=0
              ForEach Entrys() ; Doppelten Eintrag verhindern.
                If LCase(StringField(Entrys(),1,Chr(34)))=LCase(StringField(Str(SortMode!1)+name$,1,Chr(34)))
                  count+1
                EndIf
              Next
              If count=0
                AddElement(Entrys()) : AddElement(Icons())
                Entrys()=Str(SortMode!1)+name$
                Icons()=GetFileIcon(StartMenuFolders()+Directory$+name$)
                Entrys()+Chr(34)+Str(Icons())
              EndIf
            EndIf
          ElseIf DirectoryEntryType(0) = #PB_DirectoryEntry_Directory
            If LCase(name$)<>"programme"
              name$=TranslateFolder(name$)
              count=0
              ForEach Entrys() ; Doppelten Eintrag verhindern.
                If LCase(StringField(Entrys(),1,Chr(34)))=LCase(StringField(Str(SortMode!0)+name$,1,Chr(34)))
                  count+1
                EndIf
              Next
              If count=0
                AddElement(Entrys()) : AddElement(Icons())
                Entrys()=Str(SortMode!0)+name$
                Icons()=GetFileIcon(StartMenuFolders()+Directory$+DirectoryEntryName(0))
                Entrys()+Chr(34)+Str(Icons())
              EndIf
            EndIf
          EndIf
        EndIf
      Wend
      FinishDirectory(0)
    EndIf
  Next

  SortList(Entrys(),#PB_Sort_Ascending | #PB_Sort_NoCase)
  ProcedureReturn Directory$

EndProcedure

Procedure.i SetEntrysInLister(Directory$)

  ForEach Icons()
    DestroyIcon_(Icons())
  Next
  ClearList(Entrys())
  ClearList(Icons())
  GetShortcuts(Directory$)
  ClearGadgetItems(1)
  AddGadgetItem(1,-1,"..",ImageID(0))

  ForEach Entrys()
    b$=Entrys()
    a$=StringField(Mid(b$,2),1,Chr(34))
    len=Len(GetExtensionPart(a$))
    If len>0
      a$=Left(a$,Len(a$)-len-1)
    EndIf
    AddGadgetItem(1,-1,a$,Val(StringField(Entrys(),2,Chr(34))))
  Next

EndProcedure

Procedure.s GetParentDirectory(dir$)

  If Len(dir$)>3
    If Right(dir$,1)="\"
      dir$=Left(dir$,Len(dir$)-1)
    EndIf
    dir$=GetPathPart(dir$)
  EndIf

  ProcedureReturn dir$

EndProcedure

Procedure.i LoadConfig(Config$)

If OpenPreferences(Config$)
  If PreferenceGroup("MenuSettings")
    StartMode=ReadPreferenceLong("StartMode",0)
    MenuMode=ReadPreferenceLong("MenuMode",0)
    SortMode=ReadPreferenceLong("SortMode",0)
    RenameFolders=ReadPreferenceLong("RenameFolders",#False)
    MenuFarbe=ReadPreferenceLong("MenuColor",0)
    ShutdownSkin=ReadPreferenceLong("ShutdownSkin",0)
    MenuSound=ReadPreferenceLong("PlayMenuPopupSound",1)
    LogoffDefault=ReadPreferenceLong("LogoffDefault",1)
    UseOrigIcon=ReadPreferenceLong("UseOriginalIcon",0)
    LastSkin=Shutdownskin
    If Shutdownskin=5
      CurrentDay.i=Val(FormatDate("%dd",Date()))
      Shutdownskin=Tag(CurrentDay)
    EndIf
    ClearList(StartMenuFolders())
    Repeat
      folder$=ReadPreferenceString("StartMenuFolder"+Str(count),"")
      count+1
      If folder$<>""
        AddElement(StartMenuFolders())
        StartMenuFolders()=folder$
      EndIf
    Until folder$=""
  EndIf
  ClosePreferences()
EndIf

EndProcedure

Procedure.i SaveConfig(Config$)

If CreatePreferences(Config$)
  PreferenceComment("PureStarter ConfigurationsFile")
  PreferenceComment("")
  PreferenceGroup("MenuSettings")
  PreferenceComment("")
  WritePreferenceLong("StartMode",StartMode)
  WritePreferenceLong("MenuMode",MenuMode)
  WritePreferenceLong("SortMode",SortMode)
  WritePreferenceLong("RenameFolders",RenameFolders)
  WritePreferenceLong("MenuColor",MenuFarbe)
  WritePreferenceLong("ShutdownSkin",ShutdownSkin)
  WritePreferenceLong("PlayMenuPopupSound",MenuSound)
  WritePreferenceLong("LogoffDefault",LogoffDefault)
  WritePreferenceLong("UseOriginalIcon",UseOrigIcon)
  PreferenceComment("")
  ForEach StartMenuFolders()
    WritePreferenceString("StartMenuFolder"+Str(count),StartMenuFolders())
    count+1
  Next
  ClosePreferences()
EndIf

EndProcedure

Procedure.i GetDirectoryEntrys(Source$)

  Protected Num.i
  Num=0
  If Right(Source$,1)<>"\":Source$+"\":EndIf
  Dir.i=ExamineDirectory(#PB_Any,Source$,"") 
  If Dir<>#Null
    While NextDirectoryEntry(Dir) 
      If DirectoryEntryType(Dir) = #PB_DirectoryEntry_Directory
        name$=DirectoryEntryName(Dir)
        If Left(name$,1)<>"."
          If Right(name$,1)<>"\":name$+"\":EndIf
          If StringField(Source$+name$, CountString(Source$+name$,"\"), "\")="Start Menu"
            AddGadgetItem(1,-1,Source$+name$)
          EndIf
          Num + GetDirectoryEntrys(Source$+name$)
        EndIf
      EndIf
    Wend 
    FinishDirectory(Dir) 
  EndIf 

  ProcedureReturn Num 

EndProcedure 

Procedure.i OpenPrefs(ConfigPath$)

  If OpenWindow(0, 454, 295, 546, 506, "StartMen Einstellungen", #PB_Window_SystemMenu|#PB_Window_TitleBar|#PB_Window_ScreenCentered|#PB_Window_MinimizeGadget|#PB_Window_Tool)
    FrameGadget(0, 10, 15, 525, 160, "Verzeichnisse (StartMen)")
    ListIconGadget(1, 30, 40, 405, 119, "Ordner", 100, #PB_ListIcon_AlwaysShowSelection|#PB_ListIcon_GridLines|#PB_ListIcon_FullRowSelect)
    SetGadgetColor(1, #PB_Gadget_LineColor, $cccccc)
    SendMessage_(GadgetID(1), #LVM_SETCOLUMNWIDTH, 0, #LVSCW_AUTOSIZE_USEHEADER)
    ButtonGadget(2, 440, 39, 90, 25, "Scannen")
    ButtonGadget(3, 440, 69, 90, 25, "Entfernen")
    ButtonGadget(21, 440, 99, 90, 60, "Standard wieder herstellen", #PB_Button_MultiLine)
    FrameGadget(4, 10, 180, 525, 290, "Diverse Einstellungen")
    CheckBoxGadget(5, 30, 210, 320, 20, "Beim start sofort in den Ordner "+#DQUOTE$+"Programme\"+#DQUOTE$+" wechseln.")
    CheckBoxGadget(6, 30, 235, 400, 20, "Sortierung umkehren. (Verknpfungen zuerst, danach Ordner darstellen)")
    CheckBoxGadget(7, 30, 260, 465, 20, "Die Ordner STARTUP, ACCESSORIES u.s.w. umbenennen. (Deutsche bezeichnungen)")
    CheckBoxGadget(14, 30, 285, 495, 20, "MenPopup-Sound beim Hochstarten der App abspielen (vom Windows-SoundSchema)")
    CheckBoxGadget(20, 30, 310, 380, 20, "Original Icons Im Lister und bei Suchen anzeigen. (ggf. langsamer)")
    TextGadget(17, 30, 351, 160, 20, "Beim beenden von Windows")
    ComboBoxGadget(18, 193, 347, 154, 22)
    TextGadget(19, 357, 351, 160, 20, "als Voreinstellung benutzen")
    TextGadget(8, 30, 380, 68, 20, "MenFarbe")
    ComboBoxGadget(9, 106, 376, 240, 22)
    TextGadget(12, 30, 409, 102, 20, "Abmeldungs-Skin")
    ComboBoxGadget(13, 135, 405, 211, 22)
    TextGadget(15, 30, 439, 130, 20, "Startmen-Ausrichtung")
    ComboBoxGadget(16, 170, 437, 240, 22)
    ButtonGadget(10, 355, 475, 85, 25, "OK")
    ButtonGadget(11, 450, 475, 85, 25, "Abbrechen")

    AddGadgetItem(16,-1,"Automatisch (TaskBar Voreinstellung)")
    AddGadgetItem(16,-1,"Linksbndig")
    AddGadgetItem(16,-1,"Zentriert")
    AddGadgetItem(18,-1,"Abmelden")

    AddGadgetItem(18,-1,"Neu Starten")
    AddGadgetItem(18,-1,"Herunterfahren")
    AddGadgetItem(18,-1,"Energie sparen")

    AddGadgetItem(13,-1,"<StandardSkin benutzen>")
    AddGadgetItem(13,-1,"Windows 98-Stil (Skin) benutzen")
    AddGadgetItem(13,-1,"Windows 2000-Stil (Skin) benutzen")
    AddGadgetItem(13,-1,"Windows XP-Stil (Skin) benutzen")
    AddGadgetItem(13,-1,"Windows 7-Stil (Skin) benutzen")
    AddGadgetItem(13,-1,"<Stil-Skin Tglich wechseln>")

    AddGadgetItem(9,-1,"<Windows Standardfarben benutzen>")
    AddGadgetItem(9,-1,"Hellgrauer Men-Stil benutzen")
    AddGadgetItem(9,-1,"Dunkelgrauer Men-Stil benutzen")
    AddGadgetItem(9,-1,"Hellblauer Men-Stil benutzen")
    AddGadgetItem(9,-1,"Dunkelblauer Men-Stil benutzen")
    AddGadgetItem(9,-1,"Hellgrner Men-Stil benutzen")
    AddGadgetItem(9,-1,"Dunkelgrner Men-Stil benutzen")
    AddGadgetItem(9,-1,"Hellroter Men-Stil benutzen")
    AddGadgetItem(9,-1,"Dunkelroter Men-Stil benutzen")
    AddGadgetItem(9,-1,"Trkiser Men-Stil benutzen")
    AddGadgetItem(9,-1,"Oranger Men-Stil benutzen")
    AddGadgetItem(9,-1,"Violeter Men-Stil benutzen")

    SetGadgetState(5,StartMode)
    SetGadgetState(6,SortMode)
    SetGadgetState(7,RenameFolders)
    SetGadgetState(9,MenuFarbe)
    SetGadgetState(13,LastSkin)
    SetGadgetState(14,MenuSound)
    SetGadgetState(18,LogoffDefault)
    SetGadgetState(20,UseOrigIcon)
    SetGadgetState(16,MenuMode)
    DisableGadget(21,#True)
    ForEach StartMenuFolders()
      AddGadgetItem(1,-1,StartMenuFolders())
    Next
  EndIf

Repeat

  EventID=WaitWindowEvent()

  If EventID=#PB_Event_Gadget
    ; bernehmen
    If EventGadget()=10
      StartMode=GetGadgetState(5)
      MenuMode=GetGadgetState(16)
      SortMode=GetGadgetState(6)
      RenameFolders=GetGadgetState(7)
      MenuFarbe=GetGadgetState(9)
      ShutdownSkin=GetGadgetState(13)
      MenuSound=GetGadgetState(14)
      LogoffDefault=GetGadgetState(18)
      UseOrigIcon=GetGadgetState(20)
      ClearList(StartMenuFolders())
      For i=0 To CountGadgetItems(1) - 1
        AddElement(StartMenuFolders())
        StartMenuFolders()=GetGadgetItemText(1,i)
      Next
      SaveConfig(ConfigPath$+"Settings.ini")
      Break
    EndIf
    ; Abbrechen
    If EventGadget()=11
      Break
    EndIf
    ; Scannen bzw. Standard wieder herstellen
    If EventGadget()=2
      DisableGadget(2,#True)
      DisableGadget(21,#False)
      ClearGadgetItems(1)
      GetDirectoryEntrys(GetParentDirectory(GetHomeDirectory()))
      GetDirectoryEntrys(Left(GetHomeDirectory(),3)+"ProgramData\")
    ElseIf EventGadget()=21
      DisableGadget(2,#False)
      DisableGadget(21,#True)
      ClearGadgetItems(1)
      ClearList(StartMenuFolders())
      AddElement(StartMenuFolders())
      StartMenuFolders()=GetHomeDirectory()+"AppData\Roaming\Microsoft\Windows\Start Menu\"
      AddElement(StartMenuFolders())
      StartMenuFolders()=Left(GetHomeDirectory(),3)+"ProgramData\Microsoft\Windows\Start Menu\"
      ForEach StartMenuFolders()
        AddGadgetItem(1, -1, StartMenuFolders())
      Next
    EndIf
    ; Entfernen
    If EventGadget()=3
      st=GetGadgetState(1)
      If st=>0
        RemoveGadgetItem(1,st)
      EndIf
    EndIf
  EndIf

Until EventID=#PB_Event_CloseWindow

EndProcedure

Procedure MP3_Load(Nb,file.s) 
  i=mciSendString_("OPEN "+Chr(34)+file+Chr(34)+" Type MPEGVIDEO ALIAS MP3_"+Str(Nb),0,0,0) 
  If i=0 
    ProcedureReturn #True
  Else 
    ProcedureReturn #False 
  EndIf 
EndProcedure 

Procedure MP3_Play(Nb) 

  i=mciSendString_("play MP3_"+Str(Nb),0,0,0) 
  ProcedureReturn i 

EndProcedure 

Procedure MP3_GetLength(Nb) 

  a$=Space(#MAX_PATH) 
  i=mciSendString_("status MP3_"+Str(Nb)+" length",@a$,#MAX_PATH,0) 

  ProcedureReturn Val(a$)+1200

EndProcedure 

Procedure MP3_Free(Nb) 

  i=mciSendString_("close MP3_"+Str(Nb),0,0,0) 
  ProcedureReturn i 

EndProcedure 

Procedure.i PlayThemeSound(wave$, Pause.i=#True)

If wave$<>""
  MP3_Free(0)
  If MP3_Load(0,FixEnvString(wave$))
    MP3_Play(0)
    If Pause=#True
      Delay((MP3_GetLength(0)/1000)*1000)
    EndIf
  EndIf
EndIf

EndProcedure

Procedure.s GetShortcutsFilename(File$)

ForEach StartMenuFolders()
  st=FileSize(StartMenuFolders()+File$)
  If st=>0 Or st=-2
    a$=StartMenuFolders()+File$
    File$=a$
    Break
  EndIf
Next

ProcedureReturn File$

EndProcedure

Procedure.s SetRecommendedEntrys(Pattern$)

If Pattern$<>""

  ClearGadgetItems(1)
  ForEach Icons()
    DestroyIcon_(Icons())
  Next
  ClearList(Icons())
  ClearList(Entrys())

  Source$=FixEnvString("%SystemRoot%")
  If Right(Source$,1)<>"\":Source$+"\":EndIf
  Source$+"System32\"
  Dir.i=ExamineDirectory(#PB_Any,Source$,"*.exe")
  If Dir<>#Null
    While NextDirectoryEntry(Dir)
      If DirectoryEntryType(Dir) = #PB_DirectoryEntry_File
        name$=DirectoryEntryName(Dir)
        If LCase(Left(name$,Len(Pattern$)))=LCase(Pattern$)
          If UseOrigIcon=#False
            AddGadgetItem(1,-1,name$,ImageID(20))
          ElseIf UseOrigIcon=#True
            AddElement(Icons())
            Icons()=GetFileIcon(Source$+name$)
            AddGadgetItem(1,-1,name$,Icons())
          EndIf
        EndIf
      EndIf
    Wend
    FinishDirectory(Dir)
  EndIf

EndIf

EndProcedure

Procedure.i SetImageBrightness(Image.i, Percent.f)

If IsImage(Image)<>0
  wert=2.54999995231628 * Percent
  Width=ImageWidth(Image)
  Height=ImageHeight(Image)
  If StartDrawing(ImageOutput(Image))
    For y=0 To Height-1
      For x=0 To Width-1
        p=Point(x,y)
        Red=Red(p) + wert
        Green=Green(p) + wert
        Blue=Blue(p) + wert
        If Red>255:Red=255:EndIf
        If Red<0:Red=0:EndIf
        If Green>255:Green=255:EndIf
        If Green<0:Green=0:EndIf
        If Blue>255:Blue=255:EndIf
        If Blue<0:Blue=0:EndIf
        Plot(x,y,RGB(Red,Green,Blue))
      Next
    Next
    StopDrawing()
    ProcedureReturn #True
  EndIf
EndIf

EndProcedure

Procedure.i HoverGadget(Window.i, Gadget.i, ContGad.i=-1)

Shared drx.f, dry.f

x=WindowMouseX(Window)
y=WindowMouseY(Window)

If ContGad<>-1
  x-(GadgetX(ContGad) * drx)-3
  y-(GadgetY(ContGad) * dry)-3
EndIf

If x>(GadgetX(Gadget) * drx) And x<(GadgetX(Gadget) * drx)+GadgetWidth(Gadget) * drx
  If y>(GadgetY(Gadget) * dry) And y<(GadgetY(Gadget) * dry)+GadgetHeight(Gadget) * dry
    State=#True
  EndIf
EndIf

ProcedureReturn State

EndProcedure

Procedure.i ShutdownPrefs_98()

Shared RestartText$

Protected EventID.i, Null.i, State.i=-1

If OpenWindow(0, 757, 329, 322, 181, "Windows beenden", #PB_Window_TitleBar|#PB_Window_ScreenCentered|#PB_Window_SystemMenu|#PB_Window_Tool)
  Gadget1=TextGadget(#PB_Any, 65, 20, 240, 20 ,"Whlen Sie eine der folgenden Optionen:")
  Gadget2=OptionGadget(#PB_Any, 65, 48, 135, 20, "Benutzer abmelden")
  Gadget3=OptionGadget(#PB_Any, 65, 68, 180, 20, RestartText$)
  Gadget4=OptionGadget(#PB_Any, 65, 88, 135, 20, "Herunterfahren")
  Gadget5=OptionGadget(#PB_Any, 65, 108, 135, 20, "Energie sparen")
  Gadget6=ButtonGadget(#PB_Any, 85, 147, 70, 25, "OK")
  Gadget7=ButtonGadget(#PB_Any, 160, 147, 70, 25, "Abbrechen")
  Gadget8=ButtonGadget(#PB_Any, 235, 147, 70, 25, "Hilfe")
  Gadget9=ImageGadget(#PB_Any, 15, 25, 32, 32, ImageID(4))
  DisableGadget(Gadget8,#True)
  If LogoffDefault=0
    SetGadgetState(Gadget2, 1)
  ElseIf LogoffDefault=1
    SetGadgetState(Gadget3, 1)
  ElseIf LogoffDefault=2
    SetGadgetState(Gadget4, 1)
  ElseIf LogoffDefault=3
    SetGadgetState(Gadget5, 1)
  EndIf
  SetWindowTheme_(GadgetID(Gadget2), @Null, @Null)
  SetWindowTheme_(GadgetID(Gadget3), @Null, @Null)
  SetWindowTheme_(GadgetID(Gadget4), @Null, @Null)
  SetWindowTheme_(GadgetID(Gadget5), @Null, @Null)
EndIf

Repeat
  EventID = WaitWindowEvent()
  If EventID=#PB_Event_Gadget
    If EventGadget()=Gadget6
      If GetGadgetState(Gadget2)=#True : State=0 : EndIf
      If GetGadgetState(Gadget3)=#True : State=1 : EndIf
      If GetGadgetState(Gadget4)=#True : State=2 : EndIf
      If GetGadgetState(Gadget5)=#True : State=3 : EndIf
      HideWindow(0,#True)
      Break
    ElseIf EventGadget()=Gadget7
      Break
    EndIf
  EndIf
Until EventID = #PB_Event_CloseWindow

ProcedureReturn State

EndProcedure

Procedure.i ShutdownPrefs_2000()

Shared drx.f, dry.f, RestartText$
Protected EventID.i, Null.i, State.i=-1, len.i, st.i, Name$

Dim Text$(3)
Text$(0)="Beendet die Sitzung. Der Computer wird nicht in den Energiesparmodus geschaltet."
Text$(1)="Beendet die Sitzung und startet Windows neu."
Text$(2)="Beendet die Sitzung und fhrt Windows herunter."
Text$(3)="Der Computer wird in den Energiesparmodus geschaltet."
Name$=Space(512) : len=Len(Name$) : st=GetUserName_(@Name$,@len)

If drx>1.0 Or dry>1.0
  ResizeImage(5, ImageWidth(5)*drx, ImageHeight(5)*dry)
EndIf

If OpenWindow(0, 620, 327, 420, 247, "Windows herunterfahren", #PB_Window_ScreenCentered|#PB_Window_SystemMenu|#PB_Window_TitleBar|#PB_Window_Tool)
  Gadget1=ImageGadget(#PB_Any, 0, 0, 416, 81, ImageID(5))
  Gadget2=ImageGadget(#PB_Any, 20, 90, 36, 36, ImageID(4))
  Gadget3=TextGadget(#PB_Any, 70, 90, 260, 20, "Whlen Sie eine der folgenden Optionen:")
  Gadget4=ComboBoxGadget(#PB_Any, 69, 115, 270, 22)
  Gadget5=TextGadget(#PB_Any, 70, 145, 260, 40, "")
  Gadget6=ButtonGadget(#PB_Any, 146, 210, 85, 25, "OK")
  Gadget7=ButtonGadget(#PB_Any, 237, 210, 85, 25, "Abbrechen")
  Gadget8=ButtonGadget(#PB_Any, 327, 210, 85, 25, "Hilfe")
  AddGadgetItem(Gadget4,-1,Chr(34)+Name$+Chr(34)+" abmelden")
  AddGadgetItem(Gadget4,-1,RestartText$)
  AddGadgetItem(Gadget4,-1,"Herunterfahren")
  AddGadgetItem(Gadget4,-1,"Energie sparen")
  SetGadgetState(Gadget4,LogoffDefault)
  SetGadgetText(Gadget5,Text$(GetGadgetState(Gadget4)))
  DisableGadget(Gadget8,#True)
  SetWindowColor(0, $CBC7C3)
  SetGadgetColor(Gadget3,#PB_Gadget_BackColor,$CBC7C3)
  SetGadgetColor(Gadget5,#PB_Gadget_BackColor,$CBC7C3)
  SetWindowTheme_(GadgetID(Gadget4), @Null, @Null)
EndIf

Repeat

  EventID=WaitWindowEvent()
  If EventID=#PB_Event_Gadget
    Gadget=EventGadget()
  Else
    Gadget=#Null
  EndIf

  If Gadget=Gadget4
    If EventType()=#PB_EventType_Change
      SetGadgetText(Gadget5,Text$(GetGadgetState(Gadget4)))
    EndIf
  ElseIf Gadget=Gadget6
    State=GetGadgetState(Gadget4)
    HideWindow(0,#True)
    Break
  ElseIf Gadget=Gadget7
    Break
  EndIf

Until EventID=#PB_Event_CloseWindow

ProcedureReturn State

EndProcedure

Procedure.i ShutdownPrefs_XP()

Shared drx.f, dry.f, RestartText$, RestartText2$
Protected EventID.i, State.i=-1, Gadget.i, fnt1.i, fnt2.i, img.i
Dim Hover(7)

If OpenWindow(0, 450, 200, 460, 260, "PureStarter", #PB_Window_SystemMenu|#PB_Window_ScreenCentered|#PB_Window_Tool)
  fnt1=LoadFont(#PB_Any,"Arial",12,#PB_Font_Bold)
  fnt2=LoadFont(#PB_Any,"Verdana",20,#PB_Font_Bold)
  fnt3=LoadFont(#PB_Any,"Verdana",12,#PB_Font_Underline)
  SetGadgetFont(#PB_Default, FontID(fnt1))
  img=CreateImage(#PB_Any,460*drx,67*dry)
  If CopyImage(6,50)<>#Null
    SetImageBrightness(50,20)
  EndIf
  If CopyImage(7,51)<>#Null
    SetImageBrightness(51,20)
  EndIf
  If CopyImage(8,52)<>#Null
    SetImageBrightness(52,20)
  EndIf
  If img<>#Null
    If StartDrawing(ImageOutput(img))
      DrawingFont(FontID(fnt2))
      FillArea(0,0,RGB(0,51,153),RGB(0,51,153))
      If drx>1.0 Or dry>1.0
        ResizeImage(6, ImageWidth(6)*drx, ImageHeight(6)*dry)
        ResizeImage(7, ImageWidth(7)*drx, ImageHeight(7)*dry)
        ResizeImage(8, ImageWidth(8)*drx, ImageHeight(8)*dry)
        ResizeImage(9, ImageWidth(9)*drx, ImageHeight(9)*dry)
        ResizeImage(50, ImageWidth(50)*drx, ImageHeight(50)*dry)
        ResizeImage(51, ImageWidth(51)*drx, ImageHeight(51)*dry)
        ResizeImage(52, ImageWidth(52)*drx, ImageHeight(52)*dry)
      EndIf
      DrawAlphaImage(ImageID(9),400*drx,12*dry)
      DrawText(20,17,"Computer ausschalten",RGB(255,255,255),RGB(0,51,153))
      StopDrawing()
    EndIf
  EndIf
  SetWindowColor(0,RGB(123,156,235))
  ImageGadget(1,0,0,460,67,ImageID(img))
  TextGadget(2,40,150,135,27,"Energie sparen")
  TextGadget(3,183,150,115,27,"Ausschalten")
  TextGadget(4,315,150,115,27,"Neu Starten")
  ImageGadget(5,80,95,45,45,ImageID(6))
  ImageGadget(6,210,95,45,45,ImageID(7))
  ImageGadget(7,340,95,45,45,ImageID(8))
  ContainerGadget(8,0,193,460,67)
  ButtonGadget(9, 330, 25, 110, 25, "Abbrechen")
  TextGadget(10,10,15,310,46,RestartText2$)
  SetGadgetFont(10, FontID(fnt3))
  SetGadgetColor(10,#PB_Gadget_FrontColor,$ffffff)
  SetGadgetColor(10,#PB_Gadget_BackColor,RGB(0,51,153))
  SetGadgetColor(2,#PB_Gadget_BackColor,RGB(123,156,235))
  SetGadgetColor(2,#PB_Gadget_FrontColor,RGB(255,255,255))
  SetGadgetColor(3,#PB_Gadget_BackColor,RGB(123,156,235))
  SetGadgetColor(3,#PB_Gadget_FrontColor,RGB(255,255,255))
  SetGadgetColor(4,#PB_Gadget_BackColor,RGB(123,156,235))
  SetGadgetColor(4,#PB_Gadget_FrontColor,RGB(255,255,255))
  SetGadgetColor(8,#PB_Gadget_BackColor,RGB(0,51,153))
EndIf

Repeat

  For i=5 To 7
    If HoverGadget(0,i)=#True And Hover(i)=0
      SetGadgetColor(i-3,#PB_Gadget_FrontColor,RGB(0,0,200))
      SetGadgetState(i,ImageID(i+45))
      Hover(i)=1
    ElseIf HoverGadget(0,i)=#False And Hover(i)=1
      SetGadgetColor(i-3,#PB_Gadget_FrontColor,RGB(255,255,255))
      SetGadgetState(i,ImageID(i+1))
      Hover(i)=0
    EndIf
  Next

  EventID=WindowEvent()
  If EventID=#PB_Event_Gadget
    Gadget=EventGadget()
  Else
    Gadget=#Null
  EndIf

  If Gadget=5
    State=3
  ElseIf Gadget=6
    State=2
  ElseIf Gadget=7
    State=1
  EndIf

  If Gadget>1 : Break : EndIf

Until EventID=#PB_Event_CloseWindow

HideWindow(0,#True)
FreeImage(50)
FreeImage(51)
FreeImage(52)
FreeImage(img)
FreeFont(fnt1)
FreeFont(fnt2)

ProcedureReturn State

EndProcedure

Procedure.i RunShutdown(State.i)

  Shared Shutdown()

  If State=>0 And State<4
    If OSVersion()>#PB_OS_Windows_7
      If Shutdown(State)=#EWX_LOGOFF
        ExitSound$=ReadRegKey(#HKEY_CURRENT_USER,"AppEvents\Schemes\Apps\.Default\WindowsLogoff\.Current","")
      Else
        ExitSound$=ReadRegKey(#HKEY_CURRENT_USER,"AppEvents\Schemes\Apps\.Default\SystemExit\.Current","")
      EndIf
      PlayThemeSound(ExitSound$)
    EndIf
    SetShutdown(Shutdown(State))
  EndIf

EndProcedure

Procedure.s GetComputerName()
  a$=ComputerName()
  ProcedureReturn a$
EndProcedure

Procedure.s GetProcessorName()
  a$=CPUName()
  ProcedureReturn a$
EndProcedure

Procedure.s GetProcessorSpeed()
  a$=ReadRegKey(#HKEY_LOCAL_MACHINE,"HARDWARE\DESCRIPTION\System\CentralProcessor\0","~MHz",0)
  If a$=""
    a$="<Unbekannt>"
  EndIf
  ProcedureReturn a$
EndProcedure

Procedure.s CountProcessorCores()
  x=CountCPUs()
  ProcedureReturn Str(x)
EndProcedure

Procedure.s GetProcessorArchitecture()
  a$=GetEnvironmentVariable("PROCESSOR_ARCHITECTURE")
  If a$=""
    a$=ReadRegKey(#HKEY_LOCAL_MACHINE,"SYSTEM\CurrentControlSet\Control\Session Manager\Environment","PROCESSOR_ARCHITECTURE")
  EndIf
  If a$=""
    a$="<Unbekannt>"
  EndIf
  ProcedureReturn a$
EndProcedure

Procedure.s GetProcessorIdentifier()
  a$=GetEnvironmentVariable("PROCESSOR_IDENTIFIER")
  If a$=""
    a$=ReadRegKey(#HKEY_LOCAL_MACHINE,"SYSTEM\CurrentControlSet\Control\Session Manager\Environment","PROCESSOR_IDENTIFIER")
  EndIf
  If a$=""
    a$="<Unbekannt>"
  EndIf
  ProcedureReturn a$
EndProcedure

Procedure.s GetProcessorLevel()
  a$=GetEnvironmentVariable("PROCESSOR_LEVEL")
  If a$=""
    a$=ReadRegKey(#HKEY_LOCAL_MACHINE,"SYSTEM\CurrentControlSet\Control\Session Manager\Environment","PROCESSOR_LEVEL")
  EndIf
  If a$=""
    a$="<Unbekannt>"
  EndIf
  ProcedureReturn a$
EndProcedure

Procedure.s GetProcessorRevision()
  a$=GetEnvironmentVariable("PROCESSOR_REVISION")
  If a$=""
    a$=ReadRegKey(#HKEY_LOCAL_MACHINE,"SYSTEM\CurrentControlSet\Control\Session Manager\Environment","PROCESSOR_REVISION")
  EndIf
  If a$=""
    a$="<Unbekannt>"
  EndIf
  ProcedureReturn a$
EndProcedure

Procedure.s GetGraphicCardName()

  Protected device.DISPLAY_DEVICE
  Protected settings.DEVMODE
  device\cb = SizeOf(DISPLAY_DEVICE)
  settings\dmSize = SizeOf(DEVMODE)
  EnumDisplayDevices_(#Null,#Null,device,#Null)
  a$=PeekS(@device\DeviceString)
  If a$=""
    a$=ReadRegKey(#HKEY_LOCAL_MACHINE,"SYSTEM\CurrentControlSet\Control\Class\{4d36e968-e325-11ce-bfc1-08002be10318}\0000","DriverDesc")
    If a$=""
      a$="<Unbekannt>"
    EndIf
  EndIf

  ProcedureReturn a$

EndProcedure

Procedure.i GetGraphicCardMemory()

  x = Val(ReadRegKey(#HKEY_LOCAL_MACHINE,"SYSTEM\CurrentControlSet\Control\Class\{4d36e968-e325-11ce-bfc1-08002be10318}\0000","HardwareInformation.qwMemorySize",0))/1024/1024
  If x = 0
    x = Val(ReadRegKey(#HKEY_LOCAL_MACHINE,"SYSTEM\CurrentControlSet\Control\Class\{4d36e968-e325-11ce-bfc1-08002be10318}\0001","HardwareInformation.qwMemorySize",0))/1024/1024
  EndIf

  ProcedureReturn x

EndProcedure

Procedure.i GetTotalInstalledMemory()
  Protected Info.MEMORYSTATUS
  Info\dwLength = SizeOf(MEMORYSTATUS)
  GlobalMemoryStatus_(@Info)
  ProcedureReturn Info\dwTotalPhys
EndProcedure

Procedure.i GetTotalFreeMemory()
  Protected Info.MEMORYSTATUS
  Info\dwLength = SizeOf(MEMORYSTATUS)
  GlobalMemoryStatus_(@Info)
  ProcedureReturn Info\dwAvailPhys
EndProcedure

Procedure.i GetTotalUsedMemory()
  Protected Info.MEMORYSTATUS
  Info\dwLength = SizeOf(MEMORYSTATUS)
  GlobalMemoryStatus_(@Info)
  ProcedureReturn Info\dwTotalPhys-Info\dwAvailPhys
EndProcedure

Procedure.i Show_SystemInformations()

  a$=GetComputerName()
  Window_0 = OpenWindow(0, 420, 134, 640, 551, "Systeminformationen fr "+a$, #PB_Window_SystemMenu|#PB_Window_TitleBar|#PB_Window_ScreenCentered)
  If Window_0
    fnt=LoadFont(#PB_Any,"verdana",10,#PB_Font_HighQuality)
    fnt2=LoadFont(#PB_Any,"consolas",12,#PB_Font_HighQuality)
    SetGadgetFont(#PB_Default,FontID(fnt))
    Button_1 = ButtonGadget(#PB_Any, 503, 508, 116, 30, "Schlieen")
    Container_0 = ContainerGadget(#PB_Any, 21, 19, 598, 477, #PB_Container_Raised)
      Text_12 = TextGadget(#PB_Any, 21, 20, 551, 25, "CPU Eigenschaften",#PB_Text_Center)
      SetGadgetFont(Text_12,FontID(fnt2))
      Text_1 = TextGadget(#PB_Any, 36, 46, 522, 25, "", #PB_Text_Border|#PB_Text_Center)
      Text_2 = TextGadget(#PB_Any, 36, 73, 522, 25, "", #PB_Text_Border|#PB_Text_Center)
      Text_3 = TextGadget(#PB_Any, 36, 100, 522, 25, "", #PB_Text_Border|#PB_Text_Center)
      Text_4 = TextGadget(#PB_Any, 36, 127, 522, 25, "", #PB_Text_Border|#PB_Text_Center)
      Text_5 = TextGadget(#PB_Any, 36, 154, 522, 25, "", #PB_Text_Border|#PB_Text_Center)
      Text_6 = TextGadget(#PB_Any, 36, 181, 522, 25, "", #PB_Text_Border|#PB_Text_Center)
      Text_7 = TextGadget(#PB_Any, 36, 208, 522, 25, "", #PB_Text_Border|#PB_Text_Center)
      Text_13 = TextGadget(#PB_Any, 21, 247, 551, 25, "GPU Eigenschaften",#PB_Text_Center)
      SetGadgetFont(Text_13,FontID(fnt2))
      Text_8 = TextGadget(#PB_Any, 36, 273, 517, 25, "", #PB_Text_Border|#PB_Text_Center)
      Text_15 = TextGadget(#PB_Any, 36, 300, 517, 25, "", #PB_Text_Border|#PB_Text_Center)
      Text_14 = TextGadget(#PB_Any, 21, 341, 551, 25, "Arbeitsspeicher (Physikalisch)",#PB_Text_Center)
      SetGadgetFont(Text_14,FontID(fnt2))
      Text_9 = TextGadget(#PB_Any, 36, 367, 522, 25, "", #PB_Text_Border|#PB_Text_Center)
      Text_10 = TextGadget(#PB_Any, 36, 394, 522, 25, "", #PB_Text_Border|#PB_Text_Center)
      Text_11 = TextGadget(#PB_Any, 36, 421, 522, 25, "", #PB_Text_Border|#PB_Text_Center)
      SetGadgetColor(Text_1, #PB_Gadget_BackColor, $cccccc)
      SetGadgetColor(Text_2, #PB_Gadget_BackColor, $cccccc)
      SetGadgetColor(Text_3, #PB_Gadget_BackColor, $cccccc)
      SetGadgetColor(Text_4, #PB_Gadget_BackColor, $cccccc)
      SetGadgetColor(Text_5, #PB_Gadget_BackColor, $cccccc)
      SetGadgetColor(Text_6, #PB_Gadget_BackColor, $cccccc)
      SetGadgetColor(Text_7, #PB_Gadget_BackColor, $cccccc)
      SetGadgetColor(Text_8, #PB_Gadget_BackColor, $cccccc)
      SetGadgetColor(Text_9, #PB_Gadget_BackColor, $cccccc)
      SetGadgetColor(Text_10, #PB_Gadget_BackColor, $cccccc)
      SetGadgetColor(Text_11, #PB_Gadget_BackColor, $cccccc)
      SetGadgetColor(Text_15, #PB_Gadget_BackColor, $cccccc)
      SetGadgetText(Text_1, GetProcessorName())
      SetGadgetText(Text_2, GetProcessorSpeed()+" Mhz")
      SetGadgetText(Text_3, CountProcessorCores()+" Cores")
      SetGadgetText(Text_4, "Architecture: "+GetProcessorArchitecture())
      SetGadgetText(Text_5, "Revision: "+GetProcessorRevision())
      SetGadgetText(Text_6, "Identifier: "+GetProcessorIdentifier())
      SetGadgetText(Text_7, "Level: "+GetProcessorLevel())
      SetGadgetText(Text_8, GetGraphicCardName())
      SetGadgetText(Text_15, Str(GetGraphicCardMemory())+" MB Video-Memory")
      x=GetTotalInstalledMemory()/1024/1024/1024
      If (x/2)*2<>x : x+1 : EndIf
      SetGadgetText(Text_9, "Gesamtspeicher: "+Str(x)+" GB")
      x=GetTotalFreeMemory()/1024/1024/1024
      SetGadgetText(Text_10, "Freier Speicher: "+Str(x)+" GB")
      x=GetTotalUsedMemory()/1024/1024/1024
      SetGadgetText(Text_11, "Belegter Speicher: "+Str(x)+" GB")
    CloseGadgetList()
  EndIf

  Repeat

    Event=WaitWindowEvent()
    If Event=#PB_Event_Gadget
      gad=EventGadget()
    Else
      gad=0
    EndIf
    If gad=Button_1
      Break
    EndIf

  Until Event=#PB_Event_CloseWindow

EndProcedure

Procedure.s MultiInputRequester(WindowID)

  Win = OpenWindow(#PB_Any, 450, 200, 530, 316, "Executable hinzufgen", #PB_Window_TitleBar|#PB_Window_SystemMenu|#PB_Window_ScreenCentered|#PB_Window_WindowCentered, WindowID(WindowID))
  If Win
    DisableWindow(WindowID, #True)
    Button_1 = ButtonGadget(#PB_Any, 160, 265, 204, 36, "Hinzufgen")
    Container_0 = ContainerGadget(#PB_Any, 18, 18, 495, 230, #PB_Container_Raised)
      Text_1 = TextGadget(#PB_Any, 18, 15, 449, 24, "Name/Bezeichnung", #PB_Text_Center)
      String_1 = StringGadget(#PB_Any, 18, 45, 449, 24, "", #ES_CENTER)
      Text_2 = TextGadget(#PB_Any, 18, 80, 449, 24, "Dateiname", #PB_Text_Center)
      String_2 = StringGadget(#PB_Any, 18, 110, 426, 24, "", #ES_CENTER|#PB_String_ReadOnly)
      Text_3 = TextGadget(#PB_Any, 18, 145, 449, 24, "Parameter", #PB_Text_Center)
      String_3 = StringGadget(#PB_Any, 18, 175, 449, 24, "", #ES_CENTER)
      Button_2 = ButtonGadget(#PB_Any, 445, 110, 22, 24, "<<")
      SetGadgetColor(String_2, #PB_Gadget_BackColor, #White)
    CloseGadgetList()
    Repeat
      Event=WaitWindowEvent()
      If Event=#PB_Event_Gadget
        gad=EventGadget()
      Else
        gad=0
      EndIf
      If gad=Button_1
        a$=ReplaceString(GetGadgetText(String_1), "*", "")+"*"
        b$=ReplaceString(GetGadgetText(String_2), "*", "")+"*"
        c$=ReplaceString(GetGadgetText(String_3), "*", "")+"*"
        If Len(a$)>1 And Len(b$)>1
          d$=a$+b$+c$
        EndIf
        Break
      EndIf
      If gad=Button_2
        f$=OpenFileRequester("Datei hinzufgen", GetGadgetText(String_2), "Executables (*.exe)|*.exe|Alle Dateien (*.*)|*.*", 0)
        If f$<>""
          SetGadgetText(String_2, f$)
          If GetGadgetText(String_1)=""
            SetGadgetText(String_1, GetFilePart(f$, #PB_FileSystem_NoExtension))
          EndIf
        EndIf
      EndIf
    Until Event=#PB_Event_CloseWindow
  EndIf
  If Win
    DisableWindow(WindowID, #False)
    CloseWindow(Win)
  EndIf

  ProcedureReturn d$

EndProcedure

Procedure.i RemoveCustomEntry(WindowID)

  Win = OpenWindow(#PB_Any, 458, 201, 432, 287, "Benutzerdefinierten Men-Eintrag entfernen", #PB_Window_TitleBar|#PB_Window_SystemMenu|#PB_Window_ScreenCentered|#PB_Window_WindowCentered, WindowID(WindowID))
  If Win
    DisableWindow(WindowID, #True)
    ListIcon_1 = ListIconGadget(#PB_Any, 18, 20, 292, 250, "Eintrag", 285, #PB_ListIcon_AlwaysShowSelection|#PB_ListIcon_GridLines|#PB_ListIcon_FullRowSelect)
    Button_1 = ButtonGadget(#PB_Any, 318, 40, 105, 30, "Entfernen")
    Button_2 = ButtonGadget(#PB_Any, 318, 75, 105, 30, "Schlieen")
    ResetList(Symbol())
    ForEach Custom$()
      NextElement(Symbol())
      AddGadgetItem(ListIcon_1, -1, StringField(Custom$(), 1, "*"), Symbol())
    Next
  EndIf

  Repeat
    Event=WaitWindowEvent()
    If Event=#PB_Event_Gadget
      gad=EventGadget()
    Else
      gad=0
    EndIf
    If gad=Button_1
      st=GetGadgetState(ListIcon_1)
      If st=>0
        SelectElement(Custom$(), st)
        SelectElement(Symbol(), st)
        DeleteElement(Custom$())
        DeleteElement(Symbol())
        RemoveGadgetItem(ListIcon_1, st)
        State=#True
      EndIf
    ElseIf gad=Button_2
      Break
    EndIf
  Until Event=#PB_Event_CloseWindow

  If Win
    DisableWindow(WindowID, #False)
    CloseWindow(Win)
  EndIf

  ProcedureReturn State

EndProcedure

Procedure.i LoadCustomList(CustomList$)

ClearList(Custom$())
If OpenPreferences(CustomList$)
  If PreferenceGroup("List")
    Repeat
      a$=ReadPreferenceString(Str(Index), "")
      If a$<>""
        AddElement(Custom$())
        Custom$()=a$
        AddElement(Symbol())
        Symbol()=GetFileIcon(StringField(a$, 2, "*"))
      EndIf
      Index+1
    Until a$=""
  EndIf
  ClosePreferences()
EndIf

EndProcedure

Procedure.i SaveCustomList(CustomList$)

If CreatePreferences(CustomList$)
  PreferenceGroup("List")
  ForEach Custom$()
    WritePreferenceString(Str(Index), Custom$())
    Index+1
  Next
  ClosePreferences()
EndIf

EndProcedure


; Main

ConfigPath$ = GetAndCreateConfigPath(GetPathPart(ProgramFilename())+"PureStarter\")
LoadConfig(ConfigPath$+"Settings.ini")
LoadCustomList(ConfigPath$+"CustomList.lst")
If StartMode=1 : CurrentPath$="Programs\" : EndIf

; GUI Init

If MenuSound=#True
  MenuPopupSound$=ReadRegKey(#HKEY_CURRENT_USER,"AppEvents\Schemes\Apps\.Default\MenuPopup\.Current","")
  PlayThemeSound(MenuPopupSound$, #False)
EndIf
CreateGUI()
SetEntrysInLister(CurrentPath$)

; Wait for Events

Repeat

  EventID = WaitWindowEvent()
  If AutoCloseApp=#True
    If GetActiveWindow()<>0:Break:EndIf
  EndIf

  If ShutdownSkin=4
    If HoverGadget(0,16,0)=#True And HoverState=#False
      HoverState=#True
      AddWindowTimer(0,2703,600)
    ElseIf HoverGadget(0,16,0)=#False And HoverState=#True
      HoverState=#False
      RemoveWindowTimer(0,2703)
    EndIf
    If EventID = #PB_Event_Timer
      If EventTimer() = 2703
        RemoveWindowTimer(0,2703)
        DisplayPopupMenu(1,WindowID(0))
      EndIf
    EndIf
  EndIf

  ; Hover ber Men-Eintrge

  If HoverGadget(0,28,0)=#True
    If LastImage<>21
      LastImage=21
      SetGadgetState(7, ImageID(21))
      SetGadgetText(25, "PC Settings")
    EndIf
  ElseIf HoverGadget(0,3,0)=#True
    If LastImage<>22
      LastImage=22
      SetGadgetState(7, ImageID(22))
      SetGadgetText(25, "System Steuerung")
    EndIf
  ElseIf HoverGadget(0,26,0)=#True
    If LastImage<>23
      LastImage=23
      SetGadgetState(7, ImageID(23))
      SetGadgetText(25, "SystemInfos")
    EndIf
  ElseIf HoverGadget(0,4,0)=#True
    If LastImage<>24
      LastImage=24
      SetGadgetState(7, ImageID(24))
      SetGadgetText(25, "Eigene Dateien")
    EndIf
  ElseIf HoverGadget(0,24,0)=#True
    If LastImage<>25
      LastImage=25
      SetGadgetState(7, ImageID(25))
      SetGadgetText(25, "Windows Update")
    EndIf
  ElseIf HoverGadget(0,2,0)=#True
    If LastImage<>26
      LastImage=26
      SetGadgetState(7, ImageID(26))
      SetGadgetText(25, "Dieser PC")
    EndIf
  ElseIf HoverGadget(0,27,0)=#True
    If LastImage<>27
      LastImage=27
      SetGadgetState(7, ImageID(27))
      SetGadgetText(25, "Partition Manager")
    EndIf
  ElseIf HoverGadget(0,22,0)=#True
    If LastImage<>28
      LastImage=28
      SetGadgetState(7, ImageID(28))
      SetGadgetText(25, "Netzwerke")
    EndIf
  ElseIf HoverGadget(0,21,0)=#True
    If LastImage<>29
      LastImage=29
      SetGadgetState(7, ImageID(29))
      SetGadgetText(25, "Gerte und Drucker")
    EndIf
  ElseIf HoverGadget(0,9,0)=#True
    If LastImage<>30
      LastImage=30
      SetGadgetState(7, ImageID(30))
      SetGadgetText(25, "Einstellungen")
    EndIf
  ElseIf HoverGadget(0,8,0)=#True
    If LastImage<>31
      LastImage=31
      SetGadgetState(7, ImageID(31))
      SetGadgetText(25, "Gerte Manager")
    EndIf
  ElseIf HoverGadget(0,23,0)=#True
    If LastImage<>32
      LastImage=32
      SetGadgetState(7, ImageID(32))
      SetGadgetText(25, "App Deinstallieren")
    EndIf
  ElseIf LastImage<>9
    LastImage=9
    SetGadgetState(7, ImageID(9))
    SetGadgetText(25, WinVers$)
  EndIf

  If EventID = #PB_Event_Menu
    If EventMenu() = 1
      a$=GetGadgetText(11)
      If a$<>"<Bitte Dateinamen eingeben!>" And a$<>""
        File$=FixEnvString("%SystemRoot%")
        If Right(File$,1)<>"\" : File$+"\" : EndIf
        File$+"SysWOW64\"+GetGadgetItemText(1,GetGadgetState(1))
      Else
        SelectElement(Entrys(),GetGadgetState(1)-1)
        a$=CurrentPath$+StringField(Mid(Entrys(),2), 1, Chr(34))
        File$=GetHomeDirectory()+"AppData\Roaming\Microsoft\Windows\Start Menu\"+a$
        If FileSize(File$)=-1
          File$=Left(GetHomeDirectory(),3)+"ProgramData\Microsoft\Windows\Start Menu\"+a$
        EndIf
      EndIf
      AutoCloseApp=#False
      a$=FindShortcutsPath(File$)
      If a$=""
        a$=GetEnvironmentVariable("programfiles")+"\"+GetFilePart(File$)+"\"
        If FileSize(a$)=-1
          a$=GetEnvironmentVariable("programfiles(x86)")+"\"+GetFilePart(File$)+"\"
        EndIf
      EndIf
      If a$<>""
        st=FileSize(a$)
        If st<>-1
          File$=a$
        EndIf
      EndIf
      If FileSize(File$)<>-1
        RunProgram(GetPathPart(File$))
      EndIf
    ElseIf EventMenu() = 2
      a$=GetGadgetText(11)
      If a$<>"<Bitte Dateinamen eingeben!>" And a$<>""
        File$=FixEnvString("%SystemRoot%")
        If Right(File$,1)<>"\" : File$+"\" : EndIf
        File$+"SysWOW64\"+GetGadgetItemText(1,GetGadgetState(1))
      Else
        SelectElement(Entrys(),GetGadgetState(1)-1)
        File$=CurrentPath$+StringField(Mid(Entrys(),2), 1, Chr(34))
      EndIf
      AutoCloseApp=#False
      ShowFileProperties(GetShortcutsFilename(TranslateFolder(File$)))
    ElseIf EventMenu() = 10
      HideWindow(0,#True)
      RunShutdown(0)
      Break
    ElseIf EventMenu() = 11
      HideWindow(0,#True)
      RunShutdown(1)
      Break
    ElseIf EventMenu() = 12
      HideWindow(0,#True)
      RunShutdown(2)
      Break
    ElseIf EventMenu() = 13
      HideWindow(0,#True)
      RunShutdown(3)
      Break
    ElseIf EventMenu() = 111
      a$=GetGadgetText(11)
      If a$<>"<Bitte Dateinamen eingeben!>" And a$<>""
        If GetActiveGadget()=11
          run$=StringField(a$,1," ")
          param$=Mid(a$,Len(run$)+1)
          RunProgram(run$,param$,"")
          Break
        EndIf
      EndIf
    ElseIf EventMenu() = CustomAdd ; Custom-Eintrag Hinzufgen
      a$=MultiInputRequester(0)
      If a$<>""
        AddElement(Custom$())
        Custom$()=a$
        AddElement(Symbol())
        Symbol()=GetFileIcon(StringField(Custom$(), 2, "*"))
        FreeMenu(2)
        If CreatePopupImageMenu(2,#PB_Menu_ModernLook)
          Index=1000
          ResetList(Symbol())
          ForEach Custom$()
            NextElement(Symbol())
            Index+1
            MenuItem(Index, StringField(Custom$(), 1, "*"), Symbol())
          Next
          If ListSize(Custom$())>0
            MenuBar()
          EndIf
          Index+1 : CustomAdd=Index
          MenuItem(Index, "<Hinzufgen>",ImageID(33))
          Index+1 : CustomDel=Index
          MenuItem(Index, "<Entfernen>",ImageID(34))
        EndIf
        SaveCustomList(ConfigPath$+"CustomList.lst")
      EndIf
    ElseIf EventMenu() = CustomDel ; Custom-Eintrag Entfernen
      st=RemoveCustomEntry(0)
      If st=#True
        FreeMenu(2)
        If CreatePopupImageMenu(2,#PB_Menu_ModernLook)
          Index=1000
          ResetList(Symbol())
          ForEach Custom$()
            NextElement(Symbol())
            Index+1
            MenuItem(Index, StringField(Custom$(), 1, "*"), Symbol())
          Next
          If ListSize(Custom$())>0
            MenuBar()
          EndIf
          Index+1 : CustomAdd=Index
          MenuItem(Index, "<Hinzufgen>",ImageID(33))
          Index+1 : CustomDel=Index
          MenuItem(Index, "<Entfernen>",ImageID(34))
        EndIf
        SaveCustomList(ConfigPath$+"CustomList.lst")
      EndIf
    ElseIf EventMenu() > 1000 ; Custom-Eintrag Ausfhren
      st=EventMenu() - 1001
      SelectElement(Custom$(), st)
      a$=StringField(Custom$(), 2, "*")
      b$=StringField(Custom$(), 3, "*")
      c$=GetPathPart(a$)
      RunProgram(a$, b$, c$)
      Break
    EndIf
  ElseIf EventID = #PB_Event_Gadget
    ; Vorschlge fr Dateien in Lister anzeigen. (CommandLine)
    If EventGadget() = 11
      If EventType()=#PB_EventType_Change
        If GetGadgetText(11)<>""
          SetRecommendedEntrys(GetGadgetText(11))
        Else
          SetEntrysInLister(CurrentPath$)
        EndIf
      EndIf
    EndIf
    ;  Verknpfung suchen/ausfhren.
    If EventGadget() <> 11
      If GetGadgetText(11)=""
        SetGadgetText(11,"<Bitte Dateinamen eingeben!>")
        SetActiveGadget(1)
      EndIf
      st=GetGadgetState(1)
      If st=>0
        If GetGadgetText(1)<>".."
          If EventType()=#PB_EventType_LeftClick
            a$=GetGadgetText(11)
            ; Vorgeschlagenen Dateinamen anklicken. (Nach CommandLine eingabe)
            If a$<>"<Bitte Dateinamen eingeben!>" And a$<>""
              a$=GetGadgetItemText(1,st)
              RunProgram(a$)
              Break
            EndIf
            ; Normale Startmen-Verknpfung Starten.
            SelectElement(Entrys(),st-1)
            If Left(Entrys(),1)=Str(SortMode!0)
              CurrentPath$=TranslateFolder(CurrentPath$+StringField(Mid(Entrys(),2), 1, Chr(34)))+"\"
              SetEntrysInLister(CurrentPath$)
            ElseIf Left(Entrys(),1)=Str(SortMode!1)
              File$=CurrentPath$+StringField(Mid(Entrys(),2), 1, Chr(34))
              ForEach Icons() : DestroyIcon_(Icons()) : Next
              ClearList(Icons()) : ClearList(Entrys())
              RunProgram(GetShortcutsFilename(File$))
              Break
            EndIf
          ElseIf EventType()=#PB_EventType_RightClick
            DisplayPopupMenu(0,WindowID(0))
          EndIf
        Else
         CurrentPath$=GetParentDirectory(CurrentPath$)
         SetEntrysInLister(CurrentPath$)
        EndIf
      EndIf
    EndIf
    ;  Arbeitsplatz ffnen.
    If EventGadget() = 2
      RunProgram("explorer.exe","/e,","")
      Break
    EndIf
    ;  Systemsteuerung ffnen.
    If EventGadget() = 3
      RunProgram("control.exe")
      Break
    EndIf
    ;  Eigene Dateien ffnen.
    If EventGadget() = 4
      RunProgram(GetHomeDirectory())
      Break
    EndIf
    ;  Gerte-Manager ffnen.
    If EventGadget() = 8
      RunProgram("control.exe","hdwwiz.cpl","")
      Break
    EndIf
    ;  Gerte und Drucker ffnen.
    If EventGadget() = 21
      RunProgram("control.exe","printers","")
      Break
    EndIf
    ;  Netzwerkverbindungen ffnen.
    If EventGadget() = 22
      RunProgram("control.exe","netconnections","")
      Break
    EndIf
    ;  Programme & Features ffnen. (Deinstallieren)
    If EventGadget() = 23
      RunProgram("control.exe","/name Microsoft.ProgramsAndFeatures","") ; appwiz.cpl
      Break
    EndIf
    ;  Windows-Update ffnen.
    If EventGadget() = 24
      RunProgram("control.exe","/name Microsoft.WindowsUpdate","")
      Break
    EndIf
    ;  Abmelden (Bei Aktiven XP-Skin nur)
    If EventGadget() = 13
      If MessageRequester("Abmelden","Mchten Sie sich jetzt abmelden ?",#MB_YESNO|#MB_ICONQUESTION)=#IDYES
        HideWindow(0,#True)
        RunShutdown(0)
      EndIf
      Break
    EndIf
    ;  Shutdown.
    If EventGadget() = 6
      If ShutdownSkin=0
        If EventType()=#PB_EventType_Change
          HideWindow(0,#True)
          st=GetGadgetState(6)
        EndIf
      ElseIf ShutdownSkin=1
        CloseWindow(0)
        GetRestartText()
        st=ShutdownPrefs_98()
      ElseIf ShutdownSkin=2
        CloseWindow(0)
        GetRestartText()
        st=ShutdownPrefs_2000()
      ElseIf ShutdownSkin=3
        CloseWindow(0)
        GetRestartText()
        st=ShutdownPrefs_XP()
      EndIf
      RunShutdown(st)
      Break
    ElseIf EventGadget() = 15
      HideWindow(0,#True)
      RunShutdown(2)
      Break
    ElseIf EventGadget() = 16
      RemoveWindowTimer(0,2703)
      DisplayPopupMenu(1,WindowID(0))
    EndIf
    ;  Preferences.
    If EventGadget() = 9
      CloseWindow(0)
      OpenPrefs(ConfigPath$)
      Break
    EndIf
    ;  SysInfos.
    If EventGadget() = 26
      CloseWindow(0)
      Show_SystemInformations()
      Break
    EndIf
    ;  Partition-Manager ffnen.
    If EventGadget() = 27
      RunProgram("diskmgmt.msc")
      Break
    EndIf
    ;  PC-Einstellungen ffnen.
    If EventGadget() = 28
      RunProgram("ms-settings:")
      Break
    EndIf
    ;  CommandLine StringGadget.
    If EventGadget() = 11
      If GetGadgetText(11)="<Bitte Dateinamen eingeben!>"
        SetGadgetText(11,"")
      EndIf
    EndIf
    ;  CommandLine Besttigen.
    If EventGadget() = 12
      a$=GetGadgetText(11)
      If a$<>"<Bitte Dateinamen eingeben!>" And a$<>""
        run$=StringField(a$,1," ")
        param$=Mid(a$,Len(run$)+1)
        RunProgram(run$,param$,"")
        Break
      EndIf
    EndIf
    ;  Benutzerdefinierter Men-Eintrag.
    If EventGadget() = 29
      DisplayPopupMenu(2, WindowID(0))
    EndIf

  EndIf

Until EventID=#PB_Event_CloseWindow

MP3_Free(0)
FreeImage(#PB_All)
FreeFont(#PB_All)
If UseOrigIcon=#True
  ForEach Icons()
    DestroyIcon_(Icons())
  Next
EndIf
FreeList(Icons())
FreeList(Entrys())
CloseWindow(0)
End

DataSection
ShutdownWinLogo:
Data.l $E0FFD8FF,$464A1000,$01004649,$01000001,$00000100,$4300DBFF,$02020300,$03020203,$04030303,$05040303
Data.l $04050508,$070A0504,$0C080607,$0B0C0C0A,$0D0B0B0A,$0D10120E,$0B0E110E,$1016100B,$15141311,$0F0C1515
Data.l $14161817,$15141218,$00DBFF14,$04030143,$05040504,$09050509,$0D0B0D14,$14141414,$14141414,$14141414
Data.l $14141414,$14141414,$14141414,$14141414,$14141414,$14141414,$14141414,$14141414,$14141414,$C0FF1414
Data.l $00081100,$03A4014D,$02002201,$11030111,$00C4FF01,$0100001F,$01010105,$00010101,$00000000,$01000000
Data.l $05040302,$09080706,$C4FF0B0A,$0010B500,$03030102,$05030402,$00040405,$017D0100,$04000302,$21120511
Data.l $13064131,$22076151,$81321471,$2308A191,$15C1B142,$24F0D152,$82726233,$17160A09,$251A1918,$29282726
Data.l $3635342A,$3A393837,$46454443,$4A494847,$56555453,$5A595857,$66656463,$6A696867,$76757473,$7A797877
Data.l $86858483,$8A898887,$95949392,$99989796,$A4A3A29A,$A8A7A6A5,$B3B2AAA9,$B7B6B5B4,$C2BAB9B8,$C6C5C4C3
Data.l $CAC9C8C7,$D5D4D3D2,$D9D8D7D6,$E3E2E1DA,$E7E6E5E4,$F1EAE9E8,$F5F4F3F2,$F9F8F7F6,$00C4FFFA,$0300011F
Data.l $01010101,$01010101,$00000001,$01000000,$05040302,$09080706,$C4FF0B0A,$0011B500,$04020102,$07040304
Data.l $00040405,$00770201,$11030201,$31210504,$51411206,$13716107,$08813222,$A1914214,$2309C1B1,$15F05233
Data.l $0AD17262,$E1342416,$1817F125,$27261A19,$352A2928,$39383736,$4544433A,$49484746,$5554534A,$59585756
Data.l $6564635A,$69686766,$7574736A,$79787776,$8483827A,$88878685,$93928A89,$97969594,$A29A9998,$A6A5A4A3
Data.l $AAA9A8A7,$B5B4B3B2,$B9B8B7B6,$C4C3C2BA,$C8C7C6C5,$D3D2CAC9,$D7D6D5D4,$E2DAD9D8,$E6E5E4E3,$EAE9E8E7
Data.l $F5F4F3F2,$F9F8F7F6,$00DAFFFA,$0001030C,$11031102,$FD003F00,$2A8AA24B,$8AA22800,$8AA22800,$B8A22800
Data.l $5C7C06AF,$3D637CD0,$8F1B8BAD,$69D76B0F,$1EFEF634,$F56CD5D7,$94E36D49,$AB056EC6,$12E59937,$C1811832
Data.l $80E2C119,$D7CC5A3B,$78A7497C,$1AEDDB6A,$A1D9C795,$666C77C6,$41D000FF,$D7CC3AAD,$78A7377C,$FAECDB96
Data.l $61DABF95,$65EF36C6,$48D000FF,$4E7BEAAC,$CDADEC47,$D21AFBD2,$DAEB7CF6,$B7AD97DF,$DA7FF63C,$AC85E193
Data.l $892F43F2,$6B87C8B6,$8E2ED82F,$A8FAFD0F,$AAE100FF,$00FF16BE,$00FFD1D0,$FEAFFB94,$FB4F5235,$BA30FC2D
Data.l $F0A5499E,$EE1CE9CE,$D07DFB66,$BF00FFC9,$1E9FE7B5,$044F677F,$4EE15F78,$77F8A9B3,$C47A3640,$99206A2F
Data.l $2A25AE6E,$7F24E61A,$E520A495,$8C238719,$114BBEE6,$D2C33F5B,$ADEC679D,$BDDBDF14,$F679BF96,$3D1C5A18
Data.l $090AAD89,$2D4D4ED6,$A7772D79,$83F77BDC,$78A463FC,$D6B740F7,$B7BF2BF4,$E90C9769,$C753FE1C,$6F94A3B8
Data.l $8661C095,$A91D3952,$F48B0FFA,$A9CD142F,$5AEBA243,$9936AF76,$A3EF6C72,$768EBBB0,$980C9CB4,$C74E0AA5
Data.l $60AB8C00,$64BED2F3,$5DFC8CFD,$5EEA58AD,$A596F02A,$D1485B76,$CA92B3E3,$F245A2D1,$92A6E15A,$9B01BB53
Data.l $C4FC2071,$C82BB6E3,$4D1F0FF4,$8F7836FB,$B238BEC5,$E365DFB7,$D25D63BD,$24493512,$6A71DB3F,$30932512
Data.l $45A296CF,$8E935091,$CBA1AF21,$60C73271,$AC64E2E9,$5AF5B5E4,$C163C73F,$CB3130CE,$9130F531,$D76CD495
Data.l $7DE395A4,$F97AB616,$F141749F,$5AB7C13F,$3E74BA94,$D4A6D02D,$6C1ABD22,$50EA9196,$4676A9B4,$D940B945
Data.l $C2CE9112,$74B56337,$E0A7F9D5,$E0674D1B,$F4EF8C4F,$A5591E5D,$348ECFD4,$FB14EDEF,$355CA8CD,$BE22C98B
Data.l $8C9FF733,$51AFA02F,$CDE35BF8,$7FF05B63,$A9777C82,$A3D55C7C,$4E8987F1,$E1A316A5,$4DFB853B,$31693CAB
Data.l $443034FB,$1D9A2CAA,$F4D77C8A,$5764F7F9,$3EC863A5,$0EBEA2DB,$325E1CF0,$9EE0EB96,$8CDFE293,$5F6B297E
Data.l $EA23BA88,$F6A3B6DA,$3CCF68A1,$F6D6EA16,$0B289236,$6767BD6D,$29C98C90,$E43004B7,$133F3456,$C2F8257E
Data.l $76C3376D,$C4973C5E,$E299467A,$366911DF,$71EBF0B6,$F1577BF8,$76A48D35,$BD620946,$D64E8A68,$C9F13CCF
Data.l $B6F3E2B1,$64C110AB,$A11FB020,$AFE28555,$C067F81E,$25FE64A9,$E19316F1,$5B98BDE4,$7DABB6DA,$94B8B015
Data.l $E6C711E3,$23C7DC30,$7CCD9381,$E2BFF06F,$EF1EDF9C,$6AA22FFC,$4BFC149F,$410D7FE1,$D6EF59E1,$585B5DEC
Data.l $E4955A6A,$B736B737,$09774B12,$16609968,$AB8470E8,$07BF0389,$2A7C676D,$C7E36B4D,$EB123E88,$2EF127FE
Data.l $C6FD2DBD,$41DBAF9F,$D8375AA8,$ED36D4C5,$C7DD7014,$4C234C19,$022A6698,$140072B6,$A0BC0F58,$15EA8AB8
Data.l $68121996,$D878959B,$15A19F32,$FBBD7C25,$D2367C1C,$F8107E2F,$221E563F,$DD2BB5D5,$45E2EA2E,$49404D86
Data.l $1D89B31D,$7CA0221A,$9E4A8EA0,$D2505F73,$298AA200,$14455100,$14455100,$14455100,$14455100,$14455100
Data.l $14455100,$14455100,$14455100,$14455100,$14455100,$955F5100,$ED55F05F,$FFC5E766,$2BFC1B00,$E6EEE9A2
Data.l $9268052F,$8D518BF8,$BC91D5BF,$7020633C,$3E282358,$BF7FBEA6,$E35D3CD7,$00FF8D6F,$AC7FBC10,$F852D669
Data.l $C342C4CB,$6FACD24D,$B6BAE32D,$68519BB7,$AEAE56C4,$A72D37A6,$3C38A779,$10187092,$EA7EC02A,$5E9B5FD1
Data.l $3CADFD01,$D016DE64,$F1636BFC,$1BFEC11B,$D69DD5F0,$097FB6A0,$5D50D366,$C0A6813E,$4ABC804C,$237845D2
Data.l $B2439588,$7EE5C121,$1BFEE64A,$B47FD4FE,$78ABBB2E,$DFF14617,$C0173DC5,$BC8A5F7A,$CF8A2737,$EDD06588
Data.l $185BFB7C,$B009B8E4,$4B52F93A,$AED8882A,$2B4423CE,$ACDC17F3,$154DEA07,$1FE25BF9,$ACE367DB,$3D7C0DBF
Data.l $C200FFAE,$5B5BA555,$D754FA69,$18DEFC9A,$A2DA543A,$CE564EAB,$9D4B5BEA,$2392CBC3,$2988151B,$A0531ECB
Data.l $FB53FCE8,$D54C7C6B,$6B185F74,$0DC4675A,$3EF7C33B,$D2B0B810,$FD3B3C6C,$F8DD1287,$5655F6A2,$F7199266
Data.l $BB6F0449,$C3464600,$8B2288D5,$455FFA01,$E6F8277E,$135FC7EB,$8BF821FE,$3DDED7C4,$B5D6B6B8,$DEE913EF
Data.l $6BBFB60D,$743B8634,$A289F62B,$12810349,$6062E8C2,$3104F83E,$C27E8DF9,$FAC10778,$BA6184B7,$B7C4574D
Data.l $9279231E,$0B3403DC,$C4F1C40A,$1451C8B1,$77E58A90,$490A18EC,$AC0316C5,$00298AA2,$00144551,$00144551
Data.l $01144551,$A94BE299,$C92BF46C,$D4BDB220,$6DB12925,$9D45E6F4,$42B910B7,$CE08AAEC,$013092EC,$07AF78EA
Data.l $2BE195F8,$A8431D1F,$6A5F5BDA,$2C6FC792,$5E6B333A,$7F5BB909,$18E96910,$9A77C4CD,$974F8E84,$80A22496
Data.l $D724E778,$D3527CAA,$3D3BF52C,$2B4E5D3A,$2AEDB488,$51DBD567,$684BFE8A,$0F8566AD,$9D486594,$C925745E
Data.l $B753B9F2,$5FDB19E6,$F8497C32,$267CAEB7,$C7FBDE86,$D5209EF6,$3728AB74,$D248FCD8,$7B0B962C,$BC9CDBAB
Data.l $A4A34550,$8570A485,$ED94CCD3,$A39E3C06,$62686238,$5E7A1514,$D7EE3E9D,$F4E467EB,$EC32F5DC,$589E0B5E
Data.l $D6F3526C,$5AF64AFE,$3E9AD3A5,$E7B1A769,$1FC5B71A,$56C10BDA,$1B785FB1,$FC863FE2,$CF5DA775,$6B509C2D
Data.l $5BD890B6,$E7D05669,$244D4BFD,$C1CB5D33,$1C5721DD,$EBE13576,$0F0500FF,$21BEA6FD,$8537A526,$04353CEF
Data.l $B2A57316,$6C6D9F3E,$3B3FB8E1,$86E4AC79,$30064E0A,$AF5DED48,$52FB1DED,$C1EF7678,$3E76949A,$EFF5D32E
Data.l $A6E85912,$7DF508C2,$ABB5483E,$F7BE995B,$CF3EFB9A,$61585210,$C6832D66,$84EFE56B,$4FF038BE,$5906BFC3
Data.l $166B5FD8,$F99C9A16,$1258B8B9,$EEBB2B66,$2A0F12A3,$F43DFE07,$66C69EAF,$1236FC18,$F54A2355,$954B9239
Data.l $4DDA36BF,$7D6AD1E9,$64925DB6,$96DEEC78,$6879E219,$4E4AB938,$96DF5671,$758C522A,$6E9C367A,$F67AE4AF
Data.l $0500FF8B,$74AEFD06,$A3471A7F,$E28F06C9,$BE6D45AD,$D2A674DA,$41687562,$C8C09C20,$D9E841DD,$F89ABEE2
Data.l $0500FF19,$C7C7F02E,$D7F0C39B,$27815EE2,$DE1B7FC3,$02B4154F,$DC58B3E4,$584624CC,$091E7089,$C115F018
Data.l $92BF8F53,$FBB9FC14,$2F9AEA25,$7C21BE8A,$3A54F141,$74792F9C,$2C6CD361,$DF4CE19E,$8E3C5C66,$BC14EA23
Data.l $73C7416A,$E5F0A657,$F86FC6AF,$CDC3D728,$D99FC000,$DF8E14FE,$5867D551,$6E10EE83,$4726DBBC,$8BA1C52A
Data.l $472E2307,$C1E63819,$58B1D5E6,$69E297B7,$7AF282AF,$F4263BAB,$D54B357D,$561CF333,$FA3C9D36,$9B000FB6
Data.l $593E09A5,$7AD27637,$E5EF953D,$B4B4CF6D,$7C075F87,$6BA7F87F,$8723DA08,$395E1846,$F52721FB,$0CEFF46A
Data.l $9072893E,$A795B65B,$E1156FC9,$B62612D4,$C574A942,$3106CE98,$4BCC12E6,$E7B1ECFD,$44EDF29A,$D07EABC1
Data.l $532E17BF,$478756E6,$B375FB78,$FF55F9EF,$126B0D00,$636CDCDA,$0F722BF3,$72D1AF39,$993A355C,$94B6B87F
Data.l $A6F400FF,$3256F171,$DEE70CAD,$F7A3D37B,$F95C28FB,$F70AFECF,$1F8D6BE0,$C46FF040,$73C90CBF,$D68BDDA4
Data.l $D367D4B6,$9FFBEC5B,$469E626E,$39480B42,$0E24C740,$FBF98A33,$E33509FE,$00FFB4F8,$2F5DB6DA,$CF6F4858
Data.l $9BCB348A,$02752E39,$79E07D24,$92B30598,$5D9F76E5,$5FE857C4,$81E057ED,$57F69FF1,$9287D7F1,$157F7B03
Data.l $8CB1BF99,$C3DFDF3E,$E3F7A9F3,$FC267E75,$FFFCF10E,$303E0B00,$96C53B78,$23DD7CFB,$0EEB8254,$C61552D8
Data.l $5C317D72,$CDE9A095,$2A149DC5,$91D4B42A,$16FCA7F6,$FFEBC737,$C1530B00,$94F40D7F,$F041C38A,$29B790D6
Data.l $B87C6465,$28569223,$15AEE5A9,$2E402476,$07420207,$00FF9906,$9EF18904,$896FE29D,$5DF8275E,$2F5B2BE3
Data.l $537FF811,$D351D7D2,$3572FDB4,$AB1B82BB,$0C0B1B59,$2D550652,$48ECD41D,$F91AEE03,$A3EEE3EF,$5FD6FEA9
Data.l $CF8A5FB6,$DB5B6286,$6B58739D,$26433C3D,$8028DEF8,$FD536489,$E3EFB1D2,$00FFB9D6,$48E2DBD8,$51FB47F8
Data.l $3CF135FC,$6D6FC192,$6B45AC6F,$05CB3D75,$807B2B8E,$2776E66D,$76E6D8A6,$A0132BFC,$0AFE07FA,$0D0AF1E5
Data.l $D389F65F,$A8A40FFC,$1B3CD1B2,$156541A4,$DA12B685,$355F6439,$2ABF688C,$20341EE1,$3B30CF7F,$FF689B57
Data.l $C69FB300,$422B9DBB,$77BCADD4,$2D8BE9A4,$DBDA5384,$B6393EEA,$8AB5BAB0,$98115654,$2E5E9D65,$1D48E536
Data.l $B3977105,$3FD67E5D,$24B2CCB5,$5AF13F17,$85B9A078,$5B907C1B,$02583ECB,$CFE2484F,$7FD2B5E0,$13EC42C1
Data.l $3CADFD4A,$CC19636D,$0245B256,$A8B1BA7F,$1F81CA1F,$34B0DFA8,$9DFD151E,$3FCD67BF,$89A7F14B,$F8A215FC
Data.l $B9BC53A3,$8FBAB9BC,$AF91B15D,$DA153E94,$76899064,$334ECEF4,$1DE92B8E,$C3C7E34B,$33C3236D,$C7EF8AF8
Data.l $418719FE,$4D264F82,$18F0EA44,$47644C16,$910B3EBC,$D22747D1,$8BEF9FBF,$3E42F25F,$B6D77F0B,$A500FFA9
Data.l $D95FBB42,$F13EF66F,$E067EDA7,$A44F193F,$4BDBA278,$19257CD2,$D30B0B9E,$52F7A423,$41A16021,$339661C4
Data.l $03233999,$33AC34E5,$B7E1F7F6,$B3F027ED,$DAA206E3,$7D3C837F,$5283F8A0,$16EC5F0A,$4A6EA897,$2422AC8E
Data.l $901C0339,$DE1A3F30,$67F18BF8,$B4087FC1,$1A2FF5A8,$F049A7F8,$ACA494BD,$69976A32,$19C39C07,$B91CC358
Data.l $26281C19,$037F9ABF,$F856CF78,$1B1DE377,$DB1DDAC4,$55FAEAD8,$D77677D4,$D1519E11,$E3A80F83,$2B8ED091
Data.l $3EA8FDB9,$B4BF6A3B,$00FFC677,$51DBF813,$D29EB9BB,$D2E2E9EA,$FC4FEEAD,$1123D879,$25A80A6F,$C1720A57
Data.l $DCCE2E78,$03962496,$F3F683F5,$1B7CA2FD,$3CF637F1,$F0A156F1,$1AB6C7D3,$DD95D5CD,$4DB49D99,$EA161743
Data.l $AA4BDBCE,$0E0EE890,$7D700632,$FEF7F32B,$0FF1EF09,$EDCF5AC5,$D3EAF07F,$B136F150,$E3256B7D,$FEE68287
Data.l $96871159,$06B154DD,$FBC9F8A6,$053FEA02,$0BEF643F,$F1BF5FFC,$6BA9995F,$7C2E6A4D,$1645B63E,$6923EE08
Data.l $E5B71910,$C30D4299,$3C783266,$ECA7F864,$1F62F1DB,$7417DF81,$11491C8F,$494797B8,$2E80B7A6,$6C8CC97C
Data.l $58B60FA8,$310DEC13,$8F3FD11F,$2FF82BFE,$778C55E1,$5EF1329E,$797BE18D,$AD3EE573,$9BBF1D7D,$9003A18E
Data.l $D70CFB58,$DABFE021,$C4CFE0D3,$372D523D,$1300FFC3,$6AA8337C,$2B8E3933,$1CC7A831,$C240B6D2,$F3589023
Data.l $6ECF01C6,$6D15F895,$00FF8D37,$3A8FAF6B,$ABA7B67D,$BEC5531D,$D912D42A,$111F6F6E,$81C263A1,$454751D1
Data.l $7FEA951E,$21ECA7B6,$3FC77EAE,$4B5E8EF0,$59FC28E2,$A2FBEAA2,$C88AD0FE,$142E18DA,$C850C464,$0CC9C8F9
Data.l $404E3B0F,$3FC32AE3,$00FFF573,$F005BE8B,$992EA9A6,$C3D7F8AD,$10A53EBA,$FE9D250D,$201304AB,$DC51823C
Data.l $56DC9E11,$5FE3819E,$48AB780F,$35D1559B,$D25833ED,$6F4966E1,$9E232FAC,$C1322A04,$20A8189D,$154F4E10
Data.l $C778CEFC,$F1BD16E2,$E2637401,$5B35F91B,$74C9269D,$82BB6BDB,$23B36F5A,$B91B4733,$606FC2E5,$2185E4A4
Data.l $2F54B573,$B100FFD6,$272FEDD7,$FBD83FC3,$7BF08FF6,$7DB9004D,$32FD3B3E,$BBB290DC,$5D58B25D,$D8C93938
Data.l $01C06EAD,$C0A2C9C1,$FF68CA7E,$1F3E1A00,$B5548B78,$1DAF74D3,$D4536BF8,$BDA5986E,$6FB19E9D,$0936D32C
Data.l $2CB922C2,$1DC00970,$28BEAB01,$FFE099F8,$435E0400,$153FE269,$D4059AE8,$41B1F9D1,$DB306AAA,$6E9C893C
Data.l $8C047655,$CD5F91F1,$1E5FC1CF,$E2C3F0C9,$583C84E7,$346EC993,$A90B52AD,$BC6588A4,$03CDE3A0,$E38785EA
Data.l $00FF455F,$26BE47C1,$3FD07EDF,$9BF68DB5,$7F75C5A1,$A65BA46F,$B067659B,$E6A90C97,$167AB44D,$0F58D4DC
Data.l $E37BCDDA,$0BDFC35F,$5ECF7A78,$E1753CD6,$BD4533CD,$85BAF642,$7004ABD6,$CC38285C,$C80F5F6E,$E79ACBC7
Data.l $56FB37BC,$7EF119FC,$A39B16A9,$95F052FC,$0231A1FE,$88F5682B,$D0139204,$8F05962A,$E7AFC9B0,$4F5EFB4B
Data.l $4C83F813,$D7EA145F,$2A1FCAA2,$E7D9E7CD,$9CB2AD3D,$40328E6D,$40384101,$5FEBEB40,$F6BF7842,$E21DF873
Data.l $F0C3F408,$D285F6B7,$659ABA27,$C7CFEE8A,$4A3A1756,$BC3FA7C0,$4845F913,$E0B832CE,$45EDEE1C,$93F5FD80
Data.l $FE86B452,$A12E191B,$A591D94B,$02A4D98A,$E6C64547,$1B48CE55,$91E94886,$64C456EB,$BEE67880,$3E85FD50
Data.l $E193F803,$2AEDC3CF,$DBF8186F,$A112BFC3,$E109E2D3,$9E42677D,$B6B4854B,$2234EB70,$8B2690E0,$7EF9ECEE
Data.l $DA74985F,$C048D607,$90E23B80,$A88FF20D,$A23ECAA3,$809DA2A5,$A23ECA8B,$4A6FCB93,$042C8A9A,$527A5B3E
Data.l $54D447F9,$206051B4,$92D62B64,$D67355AC,$D59C0393,$4B781C3E,$BEBDBF5C,$A22FBCD4,$D0B717EA,$CDD5B5AD
Data.l $B20C9FD6,$2BA7445C,$4BCA8C1C,$39853C28,$F02DD400,$AB2FC1A7,$1FBC510D,$2EA636A0,$A717BDA2,$FBCE834C
Data.l $4D114344,$A0776EBF,$03395BE1,$D1D415A1,$BF7D1C40,$DA00CFC1,$A1DE5A6A,$37FC8107,$1CB9FE0D,$51B76A91
Data.l $2EEB16E9,$C81C92A0,$CA4CB8B3,$9343F218,$BB26F59E,$BEC08FF0,$8DB4D128,$5FF05923,$276DB587,$6DBA0A48
Data.l $0495F685,$010559D0,$211B4354,$4015F058,$1E0006DA,$4851D695,$F85C330E,$C4F3F02B,$A7A6ADFA,$C30FF8AC
Data.l $68A5B63A,$5FDE5B10,$4DF3F668,$086D5C08,$30AE84EC,$2AC68331,$3C0CDFEC,$D8E2711B,$842F533C,$4F7C39B4
Data.l $D621A16E,$DE844D9F,$0560A0C6,$00F0AE98,$4DD700E3,$29393045,$127811BE,$CFFE4DE7,$1D5EC197,$6DEDC396
Data.l $D257F67F,$A57D31A0,$0ADBF4BE,$DF3DCC63,$D6B53E19,$0A2045D1,$0A80A228,$0A80A228,$0A80A228,$E261AC28
Data.l $0FF1369B,$F6F13EF6,$E776DBAD,$FF7BF59F,$A7449500,$DA995B18,$9C421AFA,$7B557EA7,$D73CF26B,$3E3CBEC6
Data.l $D08CF11B,$78D216EB,$BC55FB4A,$75D04883,$D5E4588B,$4C20D425,$2B3C334B,$41D18A19,$46BE4192,$F4580A39
Data.l $EDEB3850,$48B50952,$752D28B5,$EFEF057D,$B5D4BE24,$B65F0D2F,$45D16EA1,$E8EA22BB,$C88DB07C,$3818C7E0
Data.l $AF3807CE,$12DDB5A1,$1EDAC4C7,$76EAA3A1,$6AA679EB,$5D5AF216,$6521B95B,$A1ABD489,$482A38C7,$0FE56BFC
Data.l $7DB07F89,$1FF53BDC,$D53B5E84,$C7A90D7C,$FA69D912,$D019D744,$0072BBF4,$44B5E091,$46DB9CCF,$2CEE985D
Data.l $7B4DB2E5,$58CA2CB8,$99476957,$BE9DBD6D,$A45B9AE6,$D6DA49D3,$3B069ED5,$582F8E2C,$FBDE95CB,$E9BE5F5D
Data.l $2D6EF6A6,$E87BAF36,$6D7F828F,$6ADEA043,$E6F01ADE,$1A149E80,$E42F8887,$B4D4B9BE,$A56D15CD,$11EC0B99
Data.l $895B23C9,$E5F38318,$FFAB78BD,$9FB41100,$E12B780F,$7FA8B7DE,$CF30E962,$ABE5636D,$79588425,$025E8542
Data.l $40BDE560,$3CD32BFC,$0400FF47,$BCA1FDD0,$4D0EF157,$781F7F76,$A2AC696A,$773D3B5B,$7F619E52,$136DAA22
Data.l $7932A42A,$F3E4677C,$8C6BFC38,$13FCBFF1,$5DA6F62B,$00FFAD29,$EFF02CE1,$4116ED8B,$AA43D932,$36CA19C8
Data.l $8527DCE4,$0507A817,$C0A0AF88,$174CB867,$3EAA2AD7,$696855FD,$DB59451B,$A4DDF7A6,$C367CE7C,$D47FDCB8
Data.l $DD7F7BE9,$B39E77D2,$7DD39DBC,$4DB2B276,$863F3BF5,$C327B17F,$77F66B8D,$89D78DF0,$5F34D9B4,$FB370D13
Data.l $69117F4A,$736F4DD7,$57657211,$230E2527,$E394F729,$3FAEA107,$E1CB09FE,$2FE1F1CB,$351B3F8D,$FBDB8B7B
Data.l $055AD68D,$E770A7B6,$EE96C97D,$E44B6E09,$6A0BB09C,$CFF9C979,$C687BC3E,$E3ABDA0F,$87CFC327,$61F82A9E
Data.l $52C073F1,$D45D7B78,$B1B0E6F4,$FBB622D5,$0464343A,$8A160097,$874A2855,$87BE8084,$073FD8B7,$C2A714FE
Data.l $1626F86F,$C5F06A9B,$96B6FE15,$C4DBFD5A,$CDB51241,$C7C4BBF5,$0281FC1D,$F96BF79F,$F3CB21B7,$990DBFCC
Data.l $366ACED6,$B9E0E4E4,$4A4D92B9,$95EE954F,$2FBA5CDA,$EAF66377,$CC89074F,$47E87430,$B37653AC,$0FCDAD7A
Data.l $7EDCDA84,$F187F820,$48725117,$022C0D9A,$19969FDC,$6157FA17,$DC509C25,$4444C8F9,$790D3DF6,$48EEEC07
Data.l $8F5D7CD6,$FC65E7F9,$BE61AFA5,$A68FA485,$EC57D471,$5539197C,$935468C9,$FADF5CD6,$C40F3E53,$109FC648
Data.l $A415A757,$F8DF4E63,$E155272E,$C4D062BD,$AF4C77D6,$9563880C,$8651F018,$13D44F19,$B47F855F,$E19B8027
Data.l $1ADFC68F,$45A26478,$28A78E1D,$55392285,$C0F88E89,$AF2823FA,$96E3E8D8,$B2B061DE,$FCC3F08C,$327EC92B
Data.l $19DEC17E,$7CBCA4FD,$F8A8597C,$AFD0518F,$DE8AB564,$8DE12C58,$FD9942D6,$48CE2DE1,$2B707A20,$6D70CCDE
Data.l $9F7A3AA5,$36E69331,$115D956E,$12FC87F3,$F8C2E103,$B99CF6B7,$C8C215F1,$A4337C2D,$05AB5C5C,$01B33CCA
Data.l $C79E106E,$FDC3AE6C,$F6A7F9CA,$7E62F8A2,$DFD0FE0D,$B61C7C10,$D3B4619F,$94C57975,$B46DB71B,$B96DF376
Data.l $8C97FBEF,$2DFB35FE,$CAFE1EFB,$95EC279A,$0D92F8A7,$D7BD5A1B,$DE965E1F,$89BD6749,$8358A311,$636FA380
Data.l $827E12E6,$47DA4FB9,$E0BF09FE,$E27BDADF,$EF8ED7BD,$78A94D7C,$B4BD5173,$2CA80B82,$6791E32D,$25D83592
Data.l $41C9B925,$81FDE31A,$24A3035E,$57B93EB5,$F1B97683,$FB11FC77,$AFF151E1,$E2772DED,$2D638BAB,$D7F4848F
Data.l $8F0F659D,$C76CEA2E,$41C11D17,$CA2BE43F,$A3E000FF,$78F200FF,$FF1000FF,$7FEDEB00,$B05F11F4,$ECD7B13F
Data.l $D9BFE179,$FEFAC30F,$B76AA39F,$B3D6F53A,$EA129774,$72AC9017,$A402D588,$01825358,$F9F5C0DE,$1779A5CF
Data.l $25F8DFC7,$3E7E855F,$BCD758FC,$EB78A875,$B5AED258,$69AF4469,$A413696D,$2CC01878,$A3076B72,$EA3BDDD4
Data.l $5A7C547E,$119200FF,$BDFE5BF0,$2AFD4FB5,$FCAFF715,$49FEA311,$FACFC627,$00FF6DEB,$A5D7F3A4,$09FE9FF8
Data.l $133FE113,$3EC237F8,$06E29B1D,$87BF0DB3,$298EB962,$F312CA92,$0989D279,$630C9C6C,$FEB5571C,$4EB1BFC9
Data.l $7827FB8D,$2E3AC667,$ED5BE293,$34121F7A,$B697246D,$51401BE9,$79DA381D,$14FEFCCE,$F1F933AE,$40E12E55
Data.l $B40227C9,$BDE151BC,$26BEC143,$5A0DB4D5,$E9AA6B03,$DD587357,$734C4EC0,$7F1DE544,$0A3F5206,$FE8F67FD
Data.l $B8E09508,$97F8B0F6,$071719AF,$1987603F,$D7FA67FA,$BFD47EB4,$87CF4CF0,$88CFB4DF,$A929C557,$C547F8DF
Data.l $5E7124D2,$B328566A,$42117C45,$23169606,$06A00AE7,$F03E5E56,$F9C0306E,$FDC8F60F,$7C1DBEB5,$BC87FD72
Data.l $279DE117,$79E30F56,$5093B227,$D7DD92D1,$2E0C6DEC,$2AB6E5B2,$69C3DC15,$0C9CA35E,$82B7E757,$78A917FC
Data.l $2B6D59F7,$A84F8C48,$1CCF1279,$4690C119,$7D0F98A5,$BFC29FA0,$FF31FC5D,$F85E0400,$6BF8A379,$3CD5B35D
Data.l $5A6BAB5D,$0D4BFCCD,$C9D6A4A6,$4562580A,$6310E962,$B952C8B9,$3F062066,$F8A76B2E,$0400FF0B,$C0B7F0A3
Data.l $1F3E8B5F,$8E87DDF1,$EB568D75,$96CA9847,$AC903677,$70A51272,$681D3948,$F66BF203,$A693F856,$A1FD207C
Data.l $EDE209FC,$235DCC6F,$9AE3D44A,$EE4DA2F1,$400CE7B1,$AF19C9C8,$ADE0BFB5,$C35FB51F,$145E8CDF,$BC834FF0
Data.l $3F1BE20D,$E1BDBD14,$34AF2ED6,$000C2FE7,$9691C8C4,$E49D37C6,$B72B0795,$BE22010C,$BFA1FD92,$0C9F92E0
Data.l $867832FE,$193EC4F3,$1D3EAFD4,$34B257EB,$026329B7,$E748D8DC,$B2DCE292,$42F22494,$3DFBAF3A,$23FCCBEB
Data.l $3F0400FF,$A986EDF0,$F826BE1C,$5AEBA9A7,$6D2DB07A,$D8F168A6,$F3B8C3C8,$FF80691E,$0169BE00,$97EC77F1
Data.l $DFEA2EFB,$FC17FE1D,$D3E0D670,$4F34E87C,$EED3160D,$EA90164A,$2B573C09,$99F82314,$329AB7E2,$67344F47
Data.l $8DF90AEF,$04309459,$0304C380,$E5F457D4,$FFE0A3F0,$093E8500,$C2CF2278,$A0D10C7E,$5C3B34D1,$962C86B0
Data.l $4937CE95,$B9B39C23,$2731CBC0,$01800E00,$FF993EF1,$F8670400,$FAF8A47D,$F810C4D3,$3A7D55C7,$F44B55DB
Data.l $8DB566D1,$C1AC30E1,$3B31B3C5,$0B1BED8A,$4CEDEF75,$DB9FCF0F,$FF74F673,$D6798600,$9B5A1C3E,$35EEEC48
Data.l $5CD8086F,$FDB8A5DF,$F244BDD8,$59EEC1A7,$00FFB990,$F85FBA7E,$8700FF26,$06E3D32C,$C443F1B7,$AFFE7D1A
Data.l $D33EFCA0,$87B9571F,$D335434E,$6524DF4A,$9600FF23,$19C91B98,$AD7ECDE9,$B13FD87E,$5FFB8116,$B616FE69
Data.l $BFEB75D5,$F380360E,$82B0A518,$90551A39,$BBDBDA20,$531F990D,$AF647F57,$9FC3D3D8,$F5835FB2,$D44C0BED
Data.l $35483CAE,$EA3E9FAB,$8DB751E7,$9ECDAE58,$B872145E,$93730EEA,$DF931F40,$94FDE313,$5BFC3CBE,$7F1DE12F
Data.l $0900FFC5,$E4995617,$34D7BFB9,$98B42EB8,$543927E5,$D5D8FC49,$90243989,$2FAF003D,$67BFA0FD,$AEE0071D
Data.l $68A86199,$0F7C189F,$B91B26F1,$F8B29FFC,$BACDF76E,$92886184,$55E5C648,$D97270F9,$D6838104,$347E51BF
Data.l $20C100FF,$4BFC14FE,$AFB5AED7,$AF7AEA0D,$9C2E6F80,$8AAD2DC9,$E296C525,$F8C44A72,$7DA0CF64,$9D5780BE
Data.l $08FE7F78,$7B9BE181,$E26F7DD4,$DAA8AF8E,$6C680909,$1CADA834,$EF5078A6,$671CA024,$A080BF9D,$00FF380F
Data.l $A7F82782,$6FE2C3C4,$93387C8F,$9B83BF5C,$42F31746,$DE31B450,$4424F1AC,$8D664437,$7063E0E6,$63B0734E
Data.l $0035F2F5,$F38ADC03,$00FF804F,$BF81A7B3,$7F07EF66,$5DE039C2,$49DB741D,$73754B1C,$6E6E992B,$E51B03E4
Data.l $AEC7F290,$9C8CC200,$9A5E9301,$A0070AA3,$45D102A4,$A228C014,$A228008A,$4242008A,$D6036A8E,$300C65A7
Data.l $2418166A,$8A12B054,$4501A428,$45015014,$45015014,$45015014,$45015014,$45015014,$5F015014,$9B785B27
Data.l $31B73F51,$7DCB4DD2,$3C6EED83,$EC8F71AC,$9ACFDF82,$3FBEC6FA,$063EA0FD,$F14FEFF8,$257E89D7,$9C667678
Data.l $6BEDF6B4,$ED34A26D,$43D10DAA,$1315C56C,$0D5BCEB7,$511F37F7,$AA9F315F,$D41A95CA,$38C9E760,$95BDA5C9
Data.l $E86BFDEF,$3C0D877D,$A157AB3C,$D23E6A5E,$B65C8C9B,$7F4993E6,$D8A75E57,$57E75714,$4FC787F6,$97F8F6F9
Data.l $EF7E00FF,$E2A5A6AA,$35DA8C6F,$93509FB8,$058C1DE2,$4D6E0982,$F4586AEC,$78066219,$F88E573C,$8377A5B1
Data.l $F27FF8A9,$2EF8B027,$A58D574B,$4CFEAFF7,$BFA220FD,$DFC44F33,$EB64A089,$D403345E,$F17F5DDD,$5AF8CF54
Data.l $E8BF125F,$FC3FE339,$00FFB90B,$F53FABE2,$0BF43FC6,$89FCC33F,$BF5300FF,$FE973AEA,$33F9BF04,$AFE21BF4
Data.l $7C0B6FC2,$EF5DF06A,$A45FBC85,$1769ABC1,$A04AEE43,$48DA2FBC,$AFA38CD8,$F28A1C66,$E12BDA8F,$9FE099FE
Data.l $B93E7E81,$57E55ED3,$674B9B53,$D14D92B7,$5B5DE543,$C73582C6,$5C0502CA,$A52FC273,$2A7E9E7C,$9D07497C
Data.l $EB43C67B,$00FF7379,$576D55C5,$F13DBEC6,$862D9F1E,$BDE279A5,$A652C652,$6EA95B4B,$B0CA8926,$10B3CA65
Data.l $F408CA70,$CBD51E20,$89A5E28B,$B0A0D4C3,$6B514EB3,$63D754A7,$D1C201BB,$62E962C2,$D4A48D25,$97B99D24
Data.l $3BE77F47,$4E7BD9AF,$07F1D0FE,$09C9418C,$67E0891D,$2BFC9BA8,$B2F0E7E8,$130B10CD,$AF650712,$F666BF9C
Data.l $B1FEF0BF,$ACAE99E2,$EA92AC2E,$699F303B,$B7DFA385,$D733CECE,$2BEAED19,$C4270DE9,$AD5D29AD,$D3D7D093
Data.l $536BD6F0,$C3D09507,$EF29FCB8,$9F6DF574,$1AB5F19D,$00FF9C18,$4D325211,$9A550D35,$E9569CD2,$F099F8B5
Data.l $72410E78,$F490E05D,$C27FC8C7,$C2335DBA,$C6EEDFA6,$56FA9CD1,$ACAA9BDE,$AD19C9EB,$F551BB44,$BD79B0AF
Data.l $F8658B4A,$2F4B1F9F,$94584FA3,$DA64D2E1,$F6360236,$C366EB3D,$B871914C,$E28C7136,$D7E16C9D,$1860B6D6
Data.l $42853DDA,$636B4AC5,$890885D2,$64186504,$1545B31A,$523B7793,$154551B0,$3F960A23,$962A2AB8,$A029B82F
Data.l $5514451F,$14455100,$14455100,$14455100,$14455100,$14455100,$14455100,$14455100,$14455100,$F70D5400
Data.l $BC5F3A8D,$96CA943E,$52144501,$288AA200,$288AA200,$288AA200,$288AA200,$9CBFA200,$966FBDFA,$C30E675B
Data.l $CF01A27C,$521F8120,$BCE82B39,$FA9A0363,$CEFCE448,$FFF0D3DE,$B47C8200,$7F55CEB3,$00FFF867,$2AA23FC0
Data.l $81E9F92B,$BC6A9644,$86FA1C77,$C63D9E61,$92F37D7D,$2D71B666,$06E3D9CF,$90994237,$8F98E5E0,$A903189B
Data.l $E61EDF07,$ED1559B7,$FEC3CFFB,$86F8CE09,$DED6FDD7,$E80FF07F,$00FC8A42,$DD1650B7,$A4496C50,$8119F078
Data.l $E40C4301,$470AC911,$F7AF8C41,$1B456845,$7793DFA7,$24C0005E,$27C993E0,$8073ECAE,$5B033B0E,$BF7987C7
Data.l $FFE1EFE5,$97E50400,$00FF7214,$9BFC9FCB,$DFFB01FE,$8D00FF5C,$E36315BC,$DD341DCD,$60885B42,$D6709659
Data.l $94DBAACC,$23F03E10,$F8D59E1C,$F0394569,$191767C4,$DD7FBA55,$658200FF,$5C52292E,$F8A7A1B2,$B21FE0BF
Data.l $BECDF09F,$9F00FF19,$FFFE5BED,$00FF4500,$FD27EAC6,$CB2A3C99,$B0BAEDB7,$9F4513F7,$8E5F17FD,$C3A1A715
Data.l $9471EF1C,$25289257,$E4468998,$AE245464,$EF9F2038,$AE760406,$1676F009,$FFBA7211,$FB7FC000,$B4672962
Data.l $6141CD6A,$FFDEBFD6,$BB7E8000,$C277D99F,$57FBD68D,$45D7BF3D,$AAC600FF,$9F667F78,$B78D410C,$AC47B6DA
Data.l $BAF17FD1,$7DF0B3FC,$AFA53ACC,$76B41D99,$2078DEE6,$D3408494,$65224A99,$2BAA5091,$F3818FC6,$886CBB93
Data.l $3EF658CC,$B0BA671F,$DBCA7892,$855EB08D,$EF06BB51,$F67E95CE,$C3ED5146,$CA3F361E,$C2352202,$85CF735C
Data.l $BBDBB4B0,$7F7A795A,$A7EDCC7B,$14A9D19A,$E76B41E3,$7EE4E5EB,$01FC5B95,$CAB1F5F0,$F5796A5E,$00FFC732
Data.l $BF8556C4,$D71ADDC1,$FE5F5DEE,$00FF2732,$3A9C5F11,$70345171,$1C0960AC,$6089612C,$F7F295AD,$4D65EE64
Data.l $8941FCA9,$C2BCE54D,$4D831ED2,$139F6756,$E2CA124E,$C3BC1948,$06975DBE,$AA0AA32E,$DBED3B58,$ED2A1880
Data.l $1C1EC90B,$65BED9C3,$F0DFB6A3,$00FF4D7D,$72AB29B5,$AF55DFD0,$A21FDDF5,$B000FE76,$17B7FBB6,$FFEBEA67
Data.l $D4D5C400,$0FAAB5F0,$AB9FB3F5,$CFAFF00F,$4BD39D68,$D28E64FB,$618C0529,$30CE11D8,$7FA67F0E,$4C796A9D
Data.l $0BF32992,$DF62C86D,$30703BC4,$C739CE01,$3CB62B4E,$F3F20B35,$00FFE5DB,$7AFBCB04,$69948A9A,$00FFFC68
Data.l $437F1FE0,$DD07C3A2,$3F123F79,$42A4AEC2,$8F93603C,$ADF7FC5A,$EED92A0D,$11631230,$1568BB7B,$E58E7286
Data.l $4730C8CA,$9F81B42B,$6B9D9EEF,$82B1C367,$3FFCB5BF,$873884E0,$FC51D999,$7D1FE07F,$DA055FD1,$6F7BF6CD
Data.l $16E5E3B4,$4A1C71CF,$3B8F1148,$38794069,$E3390CC8,$18623E92,$A00D695E,$6A3E66BB,$5347975B,$6953DC85
Data.l $416160CA,$6C0806DC,$19831E05,$6FA7893C,$C17FF869,$269F233A,$3FFEE9AE,$A8B90FF0,$226F8AAF,$9525285B
Data.l $DF529AC7,$059667ED,$92CCC6B9,$7ACEC978,$9A9AE7FB,$AC763657,$361993D1,$C988ECC2,$009C8203,$6724CF73
Data.l $9C0A30A6,$23FBC30A,$3FFC546B,$DB3F9DE0,$E39FDE1B,$FB0000FF,$3C488042,$1797C757,$F5659A6C,$521E67E8
Data.l $AF60444E,$4150091B,$23C1FE2B,$39C7FB39,$6F6616E3,$308E562B,$C890F75B,$FCF2DD48,$EB71808C,$FCC8C3FB
Data.l $FE32C673,$F8CF7FCB,$FE36C17F,$F8C95FD4,$F5B1D3F7,$A97D9AE7,$2BE8D37C,$7F2A9AE4,$F8BF7FB3,$FE34C17F
Data.l $E3E7FED1,$FA0000FF,$823ECDDB,$0AFA348F,$3F8A26F9,$F8BF7FB3,$ED0FC17F,$3F7EEE1F,$BCAD0FF0,$F328E8D3
Data.l $90AFA04F,$69832B75,$B94EDEA6,$202F14DD,$A4F08CDB,$6E4790F1,$240DFDE0,$BCB900FF,$D51DCD86,$FB70095A
Data.l $1AD346B2,$4902F383,$EB93BAF9,$598AE79C,$FFFC6A63,$12FC8700,$B793661E,$00FFE327,$00FFFA00,$97823ECD
Data.l $6BFDF6CD,$E7BB2BE3,$5663994B,$3471F671,$D87CE4A4,$9D0E5C8D,$E40CCCBC,$8C63C871,$8E44B954,$023638F6
Data.l $B7AEDD5E,$9C767292,$729E6CED,$498E913A,$23ADC83D,$FFBCB794,$26F80F00,$DAD2CD32,$03FC8F1F,$DB378FED
Data.l $F6CDA3F5,$0BE26BFD,$8556F4EF,$D0342B14,$C9EECA35,$7665E045,$9CA39EE7,$1C39C783,$0B1FF90C,$445E6E2C
Data.l $4BAC70DB,$BFC4C400,$E20F0431,$2438F604,$0766B0E4,$4AAEE468,$FFF0D3FE,$2C618200,$D3D995F3,$1FE07FFC
Data.l $DFBEF977,$B76F1EAD,$C1055FEB,$90B7346B,$3D129FA9,$8A79AAD5,$114BC308,$0006C028,$03ED7C79,$AC387D1D
Data.l $48913B24,$AE740418,$DF1CE488,$FFF0F7F2,$CF738200,$E57F5C88,$00FFE3D7,$3210FD00,$CC93C29E,$F0FC5A6F
Data.l $CAC64B95,$673C69A7,$10FA9D9E,$D59E677A,$693FE75A,$99CD2086,$88256D43,$F40CB409,$3FF739C1,$7DF844E1
Data.l $F86B5FC7,$3814C17F,$654F9B8B,$C000FFF8,$1FF7453F,$1DD0F953,$D5FC7A87,$2E698EBC,$895BB425,$A3774016
Data.l $71BF6DEF,$C0006B9B,$301CE395,$7305FD3E,$B62C72B7,$3E3F57B7,$8936B9C4,$8DE23E1B,$657574F6,$F2553E62
Data.l $1D9431E5,$BE2B4870,$244BF840,$6DEABDE4,$0400FFE5,$3DEF19DE,$9FBFA59A,$34F503FC,$2F8D7D4A,$F2AB7D9A
Data.l $B5C5D67E,$441B467D,$26AF8175,$8A218610,$D1DB7621,$3C1F5B59,$02292BBC,$C594955F,$E9F1D06E,$B7F8F62F
Data.l $7DB74555,$B2784360,$3E4FB99C,$19570119,$81BBDF0A,$58C49894,$229607F3,$59796455,$ABBA9232,$B95F79F8
Data.l $B3B33B4F,$DBF9F8A7,$491AFBB1,$FC8A2627,$DBFE9E3A,$65D4B85D,$281BC28A,$68E785A2,$07F238D2,$15220B9C
Data.l $F89D0B45,$142A8604,$73C57100,$68C7824D,$27C07321,$8FEB0A24,$BD36730F,$F05FDEAE,$4D9C0A4E,$D9CB18C9
Data.l $AEFD3B5D,$7A3F76DA,$4AC1AFA8,$6FF54F2B,$00FF9EFE,$4CF0BFE4,$FAAFD63F,$9300FF73,$7A3FC07F,$36C1AFE8
Data.l $62809505,$2F038284,$5433EE51,$586B63AE,$5055A177,$B88BAAC8,$47C1822A,$F281B101,$D30DDF71,$1CBEC471
Data.l $F0D7BEB6,$5C8200FF,$4F9BA778,$9300FF63,$7E3FC07F,$EAE7AF68,$288F10F2,$6193041C,$0B65771D,$E39C27E7
Data.l $5BF23C70,$0E846A3D,$C2555E97,$9DE04029,$CE8673AC,$D8016437,$092B867F,$DEAE3C64,$00FFF0D7,$88C77482
Data.l $B23797F9,$1FE07FFC,$FC15A5D0,$3C36DEF0,$DE8005D6,$324EE191,$F6E4644C,$C7180723,$521507E2,$92BA14F4
Data.l $99184B32,$C341CFA3,$F6B0831E,$C912D6FA,$E7E57FB9,$0400FFE1,$37EF19DE,$7FFCBBFC,$4DD11FE0,$D1E7FC15
Data.l $6400FF59,$FFF07F7F,$FD6B8200,$4E00FFB5,$F81F00FF
Data.b $07,$FF,$D9
EndDataSection

DataSection
MonitorIcon:
Data.l $00010000,$20200001,$00000004,$02E80000,$00160000,$00280000,$00200000,$00400000,$00010000,$00000004
Data.l $02000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00004300,$80004F80,$80004F00,$00804C80
Data.l $00802D00,$80805780,$C0C04500,$808042C0,$00002E80,$FF0044FF,$FF004500,$00FF00FF,$00FF0000,$FFFF00FF
Data.l $FFFF0000,$000000FF,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$88070000,$00000000,$00000000,$00000000,$88770700,$00000088,$00000000,$00000000,$88777707
Data.l $00008888,$00000000,$07000000,$88777777,$00888888,$00000000,$77070000,$777F7777,$88888888,$00000000
Data.l $77770700,$88F77F77,$88888877,$00000000,$77777707,$0070F77F,$88887788,$8F000000,$7F772772,$880770F7
Data.l $88778800,$8F000000,$F77FA77A,$88770770,$77880888,$8F000000,$70F77F77,$88877707,$88880888,$8F000000
Data.l $0770F77F,$88478877,$00880088,$8F000000,$770770F7,$88474488,$00000888,$87000000,$88770770,$8847CC44
Data.l $00800888,$08000000,$44887707,$8847CCCC,$00880888,$08000000,$CC448878,$8847CCCC,$80880888,$08000000
Data.l $ECCC04F7,$8847CCEC,$80880888,$08000000,$ECCC0CF7,$8847CCCC,$80880888,$08000000,$BEEC0CF7,$8847CCCC
Data.l $80880888,$08000000,$FCCE0CF7,$8847CCEC,$80880888,$08000000,$ECEC0CF7,$8847C4CE,$80880888,$08000000
Data.l $ECCC0CF7,$888748C4,$80880888,$08000000,$C4CC0CF7,$88778748,$80880888,$08000000,$48C40CF7,$77F77F87
Data.l $80880888,$08000000,$874804F7,$7777F77F,$80880777,$08000000,$7F8708F7,$777777F7,$80777788,$08000000
Data.l $F77F77F7,$88777777,$00887777,$08000000,$77F7FFFF,$77887777,$00008877,$00000000,$77777788,$88888877
Data.l $00000088,$00000000,$77778800,$00000088,$00000000,$00000000,$88880000,$00000000,$00000000,$FFFF0000
Data.l $FFFFFFFF,$FEFFFF8F,$F8FFFF03,$E0FFFF00,$80FF3F00,$00FE0F00,$00F80700,$00E00700,$00C00700,$00C00700
Data.l $00C00700,$00C00700,$00C00F00,$00C03F00,$00E03F00,$00E01F00,$00E00F00,$00E00F00,$00E00F00,$00E00F00
Data.l $00E00F00,$00E00F00,$00E00F00,$00E00F00,$00E00F00,$00E00F00,$00E01F00,$00E03F00,$00F0FF00,$03FCFF03
Data.l $0FFFFFFF
Data.b $FF,$FF
EndDataSection

DataSection
BackIcon_Start:
Data.l $00010000,$10100001,$00010000,$03680018,$00160000,$00280000,$00100000,$00200000,$00010000,$00000018,$03400000,$0B230000
Data.l $0B230000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$4F6F4F00,$4F4F784F,$874F4F87,$4F784F4F,$004F6F4F
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$4F000000,$7F4F4F7F,$50A04F4F,$4F50B84F,$B84F50B8,$50B84F50,$4F50A74F
Data.l $804F4F80,$0000004F,$00000000,$00000000,$00000000,$4F50804F,$BF4F5090,$50C04F50,$4F50BF4F,$B84F50B8,$50BF4F50,$4F50C04F
Data.l $974F50C0,$4F704F4F,$00000000,$00000000,$50804F00,$505F974F,$C04F5FC0,$50B84F5F,$4F50B84F,$B84F50B8,$50B84F50,$4F50B84F
Data.l $C04F50BF,$4F974F50,$004F804F,$00000000,$50804F00,$5070C75F,$C0506FC0,$50B84F5F,$F080D780,$F7E0F0F8,$60C05FE0,$4F50B84F
Data.l $B84F50B8,$50C04F50,$004F804F,$884F0000,$60A7504F,$507FC85F,$BF4F6FC0,$80D07F5F,$FFF0FFF0,$E0AFFFFF,$5FBF4FAF,$4F50B84F
Data.l $B84F50B8,$50C04F50,$4F50A04F,$884F4F78,$7FBF5F4F,$5F80C85F,$D07F70C0,$F0F8F080,$9FFFFFFF,$B84FA0DF,$50B84F50,$4F50B84F
Data.l $B84F50B8,$50BF4F50,$4F50B74F,$974F4F78,$80C86050,$9F80C85F,$F8F0B0DF,$FFFFFFF0,$CFFFFFF0,$EFCFD0F0,$CFEFC0CF,$C0CFEFC0
Data.l $EFCFCFEF,$50BF4FCF,$4F50B84F,$9F504F80,$90D0705F,$CF8FCF6F,$FFFFDFF0,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF
Data.l $FFFFFFFF,$50BF4FFF,$4F50B84F,$A04F4F87,$A0D78050,$6F9FD77F,$E8BF8FCF,$FFFFFFCF,$AFFFFFFF,$D070BFE7,$8FD77F8F,$7F8FD07F
Data.l $D07F8FD0,$5FC04F80,$4F50B84F,$A04F4F7F,$90D08050,$60BFE7AF,$C85F80C8,$CFE7B080,$EFFFFFFF,$D780F0F8,$70C05F9F,$5070C050
Data.l $C0506FC0,$5FC04F60,$4F50AF4F,$00004F7F,$70BF6000,$90D0EFC0,$C75FAFDF,$80C85F80,$FFC0E7AF,$FFF0FFFF,$80CF6FF0,$5070C05F
Data.l $C0506FC0,$5FC75060,$0050974F,$00000000,$70BF6000,$D09FD780,$DF90E0F7,$80C860AF,$B080C85F,$EFC0CFE7,$80C85FD0,$5F70C75F
Data.l $C85070C0,$5FB8506F,$0050974F,$00000000,$00000000,$9060B85F,$F8E0AFDF,$CFE8BFEF,$70A0D780,$CF6F90D0,$90CF708F,$608FD06F
Data.l $BF5F80D0,$50904F70,$00000000,$00000000,$00000000,$80000000,$D08090D0,$CFE8BF90,$BFE0F0CF,$E8B0D0EF,$BFE7A0CF,$5FA0D780
Data.l $B85F70B8,$00000070,$00000000,$00000000,$00000000,$00000000,$00000000,$70C05F00,$7F80C870,$CF7F90D0,$80C06F90,$006FAF5F
Data.l $00000000,$00000000,$00000000,$1FF80000,$07E081FF,$03C081FE,$01800000,$0180FFF8,$00000000,$00000190,$00000000,$00000000
Data.l $00005320,$00002073,$01806972,$01800000,$03C0A000,$07E08200,$1FF881FF
Data.b $51,$02
BackIcon_End:
EndDataSection

DataSection
OK_Icon_Start:
Data.l $00010000,$10100002,$00010000,$03680018,$00260000,$10100000,$00010000,$04680020,$038E0000,$00280000,$00100000,$00200000
Data.l $00010000,$00000018,$FF400000,$0000FFFF,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B9000000,$3DB9003D
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$E7163DB9,$31C60423
Data.l $003DB900,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$0A3DB900,$E71639C9,$23E71623
Data.l $0031C604,$00003DB9,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$273DB900,$EB1E3EEF,$30EB1E30
Data.l $0023E716,$00003DB9,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$3DB90000,$3041CA0D,$D7164CF3,$3DB9003E
Data.l $0C30EB1E,$B9002ED3,$0000003D,$00000000,$00000000,$00000000,$00000000,$00000000,$3DB90000,$305AF738,$B9004CF3,$3DB9003D
Data.l $1E3EEF27,$B90030EB,$0000003D,$00000000,$00000000,$00000000,$00000000,$B9000000,$4ED41A3D,$1F68FC41,$B9004DDC,$0000003D
Data.l $273DB900,$D5113EEF,$3DB90036,$00000000,$00000000,$00000000,$00000000,$B9000000,$73FF483D,$0073FF48,$00003DB9,$00000000
Data.l $133DB900,$EF2743D1,$3DB9003E,$00000000,$00000000,$00000000,$00000000,$00000000,$3DB90000,$005BE028,$00003DB9,$00000000
Data.l $00000000,$F3303DB9,$3ED7164C,$003DB900,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$DC1F3DB9,$4CF3304D,$003DB900,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$B9000000,$5AF7383D,$0045DA1B,$00003DB9,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$B9000000,$55DF243D,$005AF738,$00003DB9,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$3DB90000,$2468FC41,$B90055DF,$0000003D,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$3DB90000,$415BE028,$B90068FC,$0000003D,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$483DB900,$E02873FF,$3DB9005B,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$B9003DB9,$0000003D,$00000000,$FFF30000,$FFE10000,$FFC00000,$FFC00000,$7F800000
Data.l $7F800000,$3F040000,$3F0C0000,$1F8E0000,$1FFE0000,$0FFF0000,$0FFF0000,$87FF0000,$87FF0000,$C3FF0000,$E7FF0000,$00280000
Data.l $00100000,$00200000,$00010000,$00000020,$00400000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$B9000F00,$B900BF3D,$0000BF3D,$00001900,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$B9000F00,$E716BF3D,$C604FF23,$B900FF31,$0000CB3D,$00001900,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B9000000,$C90ABF3D,$E716FF39,$E716FF23,$C604FF23
Data.l $B900FF31,$0000983D,$00001900,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B9001100
Data.l $EF27C93D,$EB1EFF3E,$EB1EFF30,$E716FF30,$B900FF23,$0000C13D,$00002500,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$B9000800,$CA0DC43D,$F330EE41,$D716FF4C,$B900FF3E,$EB1EFF3D,$D30CFF30,$B900FF2E,$0000923D,$00001900
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B9001F00,$F738E53D,$F330FF5A,$B900FF4C,$B900EA3D,$EF27AF3D
Data.l $EB1EFF3E,$B900FF30,$0000CE3D,$00002500,$00000000,$00000000,$00000000,$00000000,$00000000,$B9000000,$D41ABF3D,$FC41FF4E
Data.l $DC1FFF68,$B900FF4D,$00009D3D,$B9001900,$EF27D93D,$D511FF3E,$B900FF36,$0000923D,$00001900,$00000000,$00000000,$00000000
Data.l $00000000,$B9000000,$FF48BF3D,$FF48FF73,$B900FF73,$0000BF3D,$00001700,$B9000000,$D113B33D,$EF27FF43,$B900FF3E,$0000CE3D
Data.l $00002500,$00000000,$00000000,$00000000,$00000000,$00000000,$B9000800,$E028BF3D,$B900FF5B,$00008A3D,$00000900,$00000000
Data.l $B9001100,$F330DB3D,$D716FF4C,$B900FF3E,$0000923D,$00001900,$00000000,$00000000,$00000000,$00000000,$00000000,$B9000900
Data.l $0000553D,$00000000,$00000000,$00000000,$B9000000,$DC1FB33D,$F330FF4D,$B900FF4C,$0000CE3D,$00002500,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B9001100,$F738DB3D,$DA1BFF5A
Data.l $B900FF45,$0000923D,$00001900,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$B9000000,$DF24A53D,$F738FF55,$B900FF5A,$0000CE3D,$00002500,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B9001300,$FC41D53D,$DF24FF68,$B900FF55,$0000923D,$00001900
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B9000000,$E028A53D
Data.l $FC41FF5B,$B900FF68,$0000CE3D,$00002500,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$B9000000,$FF48BF3D,$E028FF73,$B900FF5B,$00007F3D,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B9000000,$B900D83D,$0000DB3D,$00000000
Data.l $00000000,$FFE10000,$FFC00000,$7FC00000,$7F800000,$3F000000,$3F000000,$1F000000,$1F040000,$0F040000,$0F9E0000,$07FE0000
Data.l $07FF0000,$03FF0000,$83FF0000,$C3FF0000,$E7FF0000
Data.b $00,$00
OK_Icon_End:
EndDataSection

DataSection
WindowsLogo_Start:
Data.l $474E5089,$0A1A0A0D,$0D000000,$52444849,$80000000,$80000000,$00000608,$613EC300,$000000CB,$474B6206,$00FF0044,$A0FF00FF
Data.l $0093A7BD,$70090000,$00735948,$00130B00,$01130B00,$189C9A00,$07000000,$454D4974,$0F01D607,$B835360E,$00281481,$49002000
Data.l $78544144,$797DEDDA,$D6551478,$556F7BFE,$3A6E9EF5,$21215909,$316C2409,$22C21109,$444D904B,$71190540,$54540441,$71D065C0
Data.l $46665C57,$371C6DC7,$14664050,$16501815,$88936559,$D65D916C,$64090900,$2F493A4F,$1FDFDCB5,$095DD555,$1BF44671,$F67EF9BF
Data.l $D27A9E79,$5D537D5D,$F7DCE75D,$B73DE7BC,$85B081BA,$0B616C2D,$16C2D85B,$2D85B0B6,$5B0B616C,$B616C2D8,$6C2D85B0,$D85B0B61
Data.l $B0B616C2,$616C2D85,$C2D85B0B,$85B0B616,$0B616C2D,$16C2D85B,$2D85B0B6,$8DB7FF6C,$CFC12F84,$21C2E933,$FEFE499E,$8404EFB2
Data.l $8AA023F2,$20A21017,$A480323A,$114C171E,$01C347C9,$C991FFF0,$E4CDC74D,$60F1BEFC,$9520E38D,$A3DA9124,$2BCE631C,$E200D4D0
Data.l $9A9A07A9,$8A112680,$5580828F,$67B6B62B,$6BF63389,$F5C0F3A5,$D61315C2,$FFE00387,$3909C39E,$A8C08DF5,$95F13C75,$F62A4D3D
Data.l $A3104246,$13009161,$E032FC05,$3F468095,$1A03E4D0,$26FA809A,$E00086B0,$0A88A113,$F1808914,$AE5D1136,$43D9A5AA,$988EA1DE
Data.l $83CEB917,$FC0070C5,$8D80085F,$75A5CD2F,$7750D325,$8073B00A,$5E160283,$E0094C7D,$51468093,$17A37E75,$068178F0,$1F83581F
Data.l $44504808,$A0C03906,$7E2864F8,$EB803006,$C7C3DA37,$CFA1C7B9,$B8F95B6D,$86FFFEEE,$5D87C9CF,$CEF9A97D,$4F891BED,$3B029D1F
Data.l $EABCEC03,$0E004A70,$00C65FEA,$030A0199,$64DB4564,$0000536D,$64C0C48A,$80658EA6,$AD205012,$C04467FD,$509D76D5,$4E956CA9
Data.l $53E4CC17,$07081EFB,$6DA37FC0,$72952F78,$0147050A,$8957A89E,$2A238012,$E39A4A66,$15F3A325,$14014930,$FF50F1DD,$F6D3002A
Data.l $3A419931,$8F811177,$56281C3E,$F0076F7A,$8FEDFFFB,$6EDEC34A,$85985665,$0A01C1BB,$3510800F,$F0023808,$7452E5DA,$BD66D004
Data.l $C0C16B28,$D64C0000,$9818C40E,$180006AC,$60614DD4,$A0E702A2,$5400296B,$92928E78,$0E1A02DA,$1312FF80,$415F778B,$C0938A2A
Data.l $014A5013,$8957A881,$C296AED3,$0A4B6754,$26EAC920,$A928802B,$7058C008,$4C0183C6,$4197F681,$C8981911,$8AE94810,$07F4D8DA
Data.l $A0CF1E3D,$8F9DCAB2,$F2BD391E,$1F13EED8,$EA052EDF,$F014E19C,$D1CA6CBF,$1073FB6F,$3AA0E09D,$FB3A879F,$81A2A239,$0615FB9E
Data.l $97F80628,$CD0B0819,$07D67D74,$60615FE1,$321F4692,$89BC007A,$ABE49C71,$EFBB1CF1,$EDFDD1F0,$47E4E9A8,$CEC56F1E,$EE4BC523
Data.l $FC7EDAEE,$383718FF,$552CBE5A,$B2EFE46C,$D2AB0928,$137E7AD3,$077F800E,$DFEADE89,$4A000411,$08D38DD5,$FCD54F20,$2F5068AF
Data.l $24BF661B,$29820307,$0A7DE54C,$202D24C0,$B5936D14,$07D39014,$FB198B56,$A92EDE8A,$E76D286D,$6A4033F3,$1B0FE140,$8DB7477B
Data.l $C8E1B1DD,$8A74571F,$875AFBED,$3F8581A8,$785433E7,$AC9CC68E,$0FD038DC,$AAC2F4FF,$8F2B5DB5,$F946C636,$1007B73B,$A37F800E
Data.l $15D1C5EE,$21504C7F,$5F60869F,$CD06020F,$54091AF9,$6BFF3514,$40309004,$AFD9B491,$00078D30,$1130318C,$29029260,$7272113A
Data.l $17980057,$ED3F68E1,$20EFB9F4,$526F002B,$86DA8CAB,$54A3470A,$FD596B7D,$4EDBB191,$B2EA5ABE,$C12F7DB4,$DB6973D5,$FFC52E88
Data.l $9A6BDCEA,$7A3B6E8A,$673C7971,$2828CF32,$2BD99BFB,$657ADB7B,$8159641F,$A92082AF,$0A70E773,$7001B7F8,$DE176360,$78E549EF
Data.l $08026602,$9E4011AF,$2D3FCA18,$100A2BFF,$40088290,$F2482564,$3004A8A0,$D02A0A58,$4E4000AA,$322E02EB,$79B36612,$D1454375
Data.l $09069ED3,$0A501284,$28404210,$5F830801,$AC9C706E,$CC17482D,$9E63B5F4,$2A6EAF75,$2176127A,$FF5257DA,$01003BCD,$E8ED1001
Data.l $6D42C7DA,$E703EA7D,$59F4BDB1,$31063322,$851468A0,$8A0C6641,$B924C18F,$7FF999C0,$3DD5D5D4,$35BD294F,$25222222,$C1AD001C
Data.l $A2EEE53F,$85980362,$2A1A5082,$FCB1A8FF,$24BF72D3,$C92F38A9,$D06BD41A,$037DE7AF,$073E0BF9,$5F457C81,$80264C98,$DE3CFB28
Data.l $46C6DCB2,$B6894206,$94028401,$4E539F53,$01190C0D,$813FE952,$2B29C09A,$A61E9BC7,$14238294,$3459D24D,$03185001,$AAFED303
Data.l $D40B75CF,$4488EE02,$B9EFB524,$16B6B6A6,$9DF58B16,$3AD01570,$A2B85BFC,$4088EDDD,$4E7EE79A,$AB400043,$F04859F9,$C01E5511
Data.l $97FEAD64,$82003058,$4A815F79,$C50644FE,$25DC876C,$55360007,$AE0C1434,$808F3DAA,$E83C3AA8,$1D56AA74,$24D05421,$7ACEA25B
Data.l $51A2C5A2,$E0F455C2,$82775043,$FF8105AC,$6C5C4102,$1549640A,$FB76ECA8,$B40070B1,$5DBFFEC6,$7FD1091A,$10F84A95,$008EBC72
Data.l $4FE50B4A,$B58F4294,$FDCC6B8B,$98CFFD7A,$06240696,$24012639,$9E7803BE,$7F5550DF,$93536864,$D0F99C1C,$0022AD9C,$31F53840
Data.l $23E72121,$496898F8,$7EE75000,$8C019933,$00A02869,$D88AC6AC,$79F11558,$162D905E,$0070C2F3,$BBED66B4,$CB1A403D,$F8060E01
Data.l $280D2847,$923D8908,$B369CF56,$8DB3689F,$F41FAA69,$8123A094,$290072AC,$B3043FA7,$7C208209,$1B2814DB,$9CD7A9E2,$C27CCDAC
Data.l $44F1CD11,$F342422B,$24F59D5C,$341A0684,$131A66B0,$0139AE83,$C320D480,$CB81B7C2,$0005AF15,$F9E78DB7,$B40070FA,$5FF7DC62
Data.l $AA8E11C6,$43409EE5,$43473FB5,$00C0AFF0,$88021AFF,$0A34212A,$08197A3F,$126414AD,$94850803,$D2940FDD,$BA4A12E3,$E2CB1A7B
Data.l $12ECBD1A,$01710FF8,$AA7F8412,$0A1279CF,$5818DD02,$71ABC670,$800EA1A8,$B88A05C0,$AA5014B8,$C9933D52,$04AC27B4,$703188FE
Data.l $068780B7,$C7F29AFB,$A7F94351,$D15B33A8,$FA0D4015,$48A7E9B5,$F6A7B96A,$AFF00C02,$6AC50071,$04CF4D07,$4F3BF3CF,$4DAAF85C
Data.l $10437D6D,$A75509F2,$240CE538,$BDF21890,$0A3A0916,$B0104350,$ACD9B550,$A6800108,$ED89048B,$97046A3A,$CFF9E782,$8AD001C3
Data.l $BDBE8AF9,$D3175483,$1279F3A0,$422800D2,$F45D3FDD,$17ACDA61,$A2009525,$8A37F339,$20857A3F,$6A0DEF76,$FA528332,$C67B2485
Data.l $AD65EA78,$0AB043EC,$21041E68,$3F920FF0,$A23FD1A2,$DF059F3B,$AFF0698A,$32FC57EF,$9882D7A8,$FC1A69B6,$8E3827F3,$800E1E3F
Data.l $F590C4D6,$1E53C76F,$09809460,$EBF6685C,$FAD83024,$513FD4D5,$030052D6,$E2831451,$9F650CC7,$6AC81556,$03B94810,$31AD2940
Data.l $AF2EBD99,$4F4AF2AF,$7BE6A283,$2E020D4E,$060B58F8,$403FD884,$A401545A,$03D7ACD9,$C407C8C1,$E8988A4A,$45BCF024,$36DD800F
Data.l $1C3EB59B,$C599AD00,$85441D36,$CA0C427D,$C508EE9F,$09060080,$C1816998,$D6BFFA82,$0035D409,$8264394D,$07999200,$775CD9B3
Data.l $6D696CA4,$95396D65,$AFBD50E5,$6FD9C16F,$77548020,$FC0D907C,$B18FF28B,$BBE7F960,$2AA49040,$4084208E,$AD758410,$F9BF1F6A
Data.l $F6CCFFFA,$6B2AA801,$E101130B,$E7F87369,$A7FBA848,$A68AFFD7,$7FBD6A02,$A163E4B5,$FE28D012,$4A500468,$136B04CB,$A5B94A0D
Data.l $6D6E058C,$A0C178F0,$E3349B3B,$0C292A02,$4180FFD5,$FD81800B,$96BFCA1B,$0A899FEC,$588A7AA4,$8E39FE0D,$A10416AB,$B7052C20
Data.l $7DAFFF56,$3E67863F,$78C0280B,$00D4120A,$804C4028,$364C076C,$330300B0,$22C8A005,$B50649A8,$57D48156,$60E59502,$FF9680DE
Data.l $F4182199,$3A900FF2,$093500F7,$0E42C58A,$BBDAFE88,$81B20D3D,$C0486BFD,$E809A421,$F5E893B3,$0C0296BE,$9A18C141,$193A7EA9
Data.l $54831854,$C4B2E04F,$A36D6AC3,$BB21C007,$1C327EDD,$7118AD00,$DE20CF45,$AD4E3032,$C813C1C3,$4CB1065E,$8646B781,$66BC0844
Data.l $0488E02B,$13106EEC,$8355340F,$4560ABF9,$22F6CC25,$D01EDD98,$E7C846A6,$0FD9346A,$082FF6C1,$3E657281,$B293262C,$AEDE64BF
Data.l $1133FACA,$04403F7E,$0CF92F34,$6FF8758F,$5A8DF799,$E9FE5E80,$82974A19,$04AC4001,$813BE252,$FCBD04E3,$FE51F82B,$BE765BF3
Data.l $1A40E4BF,$6772F35D,$5320E366,$8F357F06,$F076CA86,$DC8776C5,$D8B83BB9,$6F8E1044,$AC862E51,$06343189,$6399C002,$E00AA7A0
Data.l $A986EDB6,$D3C402E6,$8A0D6095,$1DB1C50A,$70248480,$6ECEB71C,$BEAFBA8E,$018503DE,$89DB3E82,$37C007A1,$F0A0FF87,$41004A13
Data.l $5F8CEBE7,$8D7FE609,$810CC80B,$1EB88A2A,$C02FF2C1,$7086FCF3,$FF96B400,$49307F2B,$29A99716,$9DC786E0,$0596920D,$841A26D2
Data.l $2185E090,$38E38084,$CB214A50,$965941F2,$17FFF54B,$62775304,$5DCA2532,$6464A1B2,$06E6B2A2,$C0B78708,$D30F5F61,$1EF0D3D9
Data.l $DA9486AA,$0DA2240D,$AD61264C,$B67CB2B7,$20B523C7,$6800A17E,$5049F79E,$DFE5D003,$15B86B96,$73A00563,$56601F01,$C572E122
Data.l $62AE0DEA,$75F9D3A7,$315A0038,$474DF67B,$B73C7FCF,$E4723087,$3F289CDD,$4D260BAA,$70A88112,$7E04CBF0,$280A6805,$786405F0
Data.l $C7A4527C,$898B512B,$C02CCB83,$D48EC662,$A4495B58,$CF27FE4D,$051B13F3,$4EDA0C53,$395B571C,$CBDD9610,$0D7D7760,$10C1AF5F
Data.l $40DE1E04,$BA8A8AD5,$36356F13,$509F2CA9,$B4A7EF55,$A8506695,$3F9037FA,$E6B3FC03,$2BA29FE5,$5AE40081,$3B572886,$0D0ECD98
Data.l $FF4385FE,$CDFE04B2,$6E03408B,$C599362E,$5E0DB571,$9F0178D4,$0BB4E042,$808A38E0,$2A2FC322,$40404BF0,$890C6066,$EB12471C
Data.l $EBCA22BD,$4A8BF0FC,$AB475DB7,$A7E16911,$5BFC2CD9,$5B8AF4D7,$2F73B2EC,$EBD6AD7A,$A633517D,$D71CF757,$21A2B896,$7AC1DC70
Data.l $DAA4F8F9,$24900BFA,$BA6AB780,$A7FFDEBF,$B54006AA,$00223080,$D064C625,$0C53FCBC,$4FCF5FF9,$09048BBE,$C1829DC9,$56993263
Data.l $15A00387,$B4F9B45B,$7DADBED0,$156396D6,$92B203C3,$6D047026,$0E5C02EC,$FF4D3813,$64D67637,$5685817D,$820BAA05,$197E0218
Data.l $11FCAAE7,$F8F8AF01,$C79EB3F9,$F31C1393,$CF2D63E2,$9C8CC9F4,$1F1C3A23,$5E363637,$D6C2082B,$8323F2AA,$1A421B1A,$B5F6107F
Data.l $7E975FBA,$F43ED98D,$03F8B9BC,$74C400A3,$3D2B52A1,$6E886DEB,$FF675EDB,$35CB977E,$AD001C2F,$3CDDA458,$0BDEE57D,$389844AF
Data.l $D80423B8,$3C0826CD,$30A9CF05,$504A4A2C,$35145158,$197F8C00,$987E2B42,$149640A2,$E0F39C94,$69BAF1CC,$23AD6DB1,$BFDE00C5
Data.l $DFFB4066,$B90D3C79,$274D4D4D,$81B71CA9,$98B05CFA,$0638503C,$18FE6C1A,$D6093F67,$BFCBCDFD,$D2AFF2E6,$A834054C,$1C0A0DCF
Data.l $D870B6E6,$E51CEADB,$4155BFDC,$6FCE8B7F,$0B246C6C,$16BF9F36,$1409300C,$3CF1CD26,$54702147,$7219FB5B,$7635A2B6,$B52D4564
Data.l $CB20C664,$61B26BDA,$9F241853,$6B47538C,$F31DCF13,$C168B73C,$1111E3AE,$2000CF8E,$D6B9ABE0,$78981D5B,$43EF64A6,$4921725E
Data.l $D680FDE2,$0CBAA602,$8FE2EADC,$E6BFCB4B,$010AA02A,$F10C935C,$84BB4502,$4C4D1034,$0D2C94A0,$B62B4007,$F1156F61,$0261E578
Data.l $04F0204F,$73C0471C,$3EA70204,$78EE9856,$3A0BF84D,$D02A6A1F,$0DEABE5A,$49240AA0,$40322281,$41996406,$9F441916,$9DE9CE5F
Data.l $7E00025C,$2947196F,$39EBCDAD,$B4A74171,$9CCE9321,$745493DD,$B87C237E,$4121C108,$CDE1C4BA,$45A47FBB,$64D14FF7,$9060125F
Data.l $552864AB,$8DD78A04,$90BDB10E,$2F47DA9E,$D9B360FF,$40070BBF,$E714962B,$F1FD7AB8,$78DB442A,$C4C294F0,$051CF051,$947011C7
Data.l $4AAD9D04,$0F6CDAAC,$60235F3A,$A0D022DA,$1418CBEC,$AA2C8149,$C33D21A9,$F0C427CE,$3636368F,$BC54ACDE,$201896F2,$B6F60857
Data.l $EE6262E3,$0F36691A,$BB5243FC,$95CEFBDC,$B85FCF7C,$A10117B8,$C0367008,$732194E2,$3D498004,$AB551017,$C88779D7,$E0926810
Data.l $0D6025AB,$0DDF9802,$DA324477,$B88EEBB6,$8DEA4ED8,$4C999A2C,$ED800F26,$C56800E1,$BEAA9F76,$0811C4D6,$A820853C,$29E05F33
Data.l $10829E04,$167ECEA2,$F9DD7F82,$834CC7C1,$2C81517C,$E4198FE9,$805F7A80,$7464322C,$EBD7808D,$2AE7621D,$BF3C6D6F,$13CA86E5
Data.l $9C95CBA2,$0725D870,$6D2D3916,$8E44B51F,$F5B5635D,$7DA92C7B,$4F7AB74E,$FAFADB79,$385F5452,$065C8085,$E1904D05,$E4D44C87
Data.l $8414C8AE,$24494159,$2418969C,$8F616238,$11C3868D,$9A179E07,$2F3C0769,$B71C7134,$EBE8E38C,$3AADBB76,$58AD001C,$2F194053
Data.l $40820470,$FE1553C1,$6BC04A79,$F9CF4833,$B4501446,$66D6402A,$5E3BA2BC,$9A88A052,$07F835E3,$ABADD053,$9FCF3C03,$272C55F7
Data.l $8BAF06FE,$CE1A0229,$86E4D897,$C7B1EECF,$D12DF3BA,$D51EBEDF,$B5F96FE1,$3629B5B5,$BBBA7D9B,$FB7E424D,$94AE3D76,$D92400C4
Data.l $9A96590F,$4CE39639,$CB5338E0,$D8CC064E,$A0149E0F,$5704C2A9,$981FDDEA,$B75E6D2C,$7E47AD5A,$CDF8B5EA,$7389C005,$DEDE5DF5
Data.l $0AB0E454,$1A0BDC2A,$9ABCF3FC,$1F867402,$C8727C24,$FB9E8AF1,$14083D65,$9ED4582D,$0C101ABF,$B816F1F1,$28A098DB,$16227DEC
Data.l $5068135F,$E5030840,$0480E418,$0CF9D56F,$5EF257D9,$7381E1E3,$AFF78DCC,$D5EAFD82,$45F9238A,$8E2DDC9F,$8D29CE70,$630A8D8D
Data.l $0E94A6C8,$00191456,$084601E3,$7291C051,$E0F7D2F0,$B1B077D8,$02ECA08D,$F1451F24,$89B43CB1,$EAD2B01D,$72E4721E,$2E6FC7AE
Data.l $B91CB600,$39818038,$13073CCD,$9CD66047,$9C14702F,$AB35FE56,$3020B400,$D68A01EA,$00AB55EA,$A2CA0095,$CE800C12,$CC983619
Data.l $793B731C,$28B8B1B9,$8024D033,$154A0650,$10818E50,$48012806,$8863678D,$7C9DC3FC,$F27717E3,$843878B6,$BB50402B,$13C4C1CE
Data.l $0013EEA0,$01A80277,$058DE533,$7C88ED63,$018A5002,$4CA00652,$93400723,$77160E27,$EAB14406,$FAFAFA9B,$F420821E,$6FAD5AB3
Data.l $B5A00385,$53A11FEE,$3FCB5128,$9CA0A781,$D32A028E,$21983A0E,$3AFA0018,$040F497B,$4D36D149,$6418500B,$457F8549,$CF3FF351
Data.l $FCA97EF3,$5F657B1F,$11228A7D,$C202BCF0,$818E1031,$27080A72,$060D4403,$3E401442,$004A820D,$5C41C391,$401301C3,$0F17001D
Data.l $B0445CA2,$80644CBF,$A0725579,$35F542A9,$BBBB3091,$FFEE6FC1,$19E3CFB1,$FED9B361,$C7AF53FE,$C8416A6F,$DB4F62A9,$914DE513
Data.l $F3B66D66,$BC802554,$FDEA85B6,$2EA00E90,$81950FFD,$4FF6B68A,$54F404AF,$E5FADFA0,$4848208A,$4C1040B0,$27EAC0C7,$007CEBF8
Data.l $20650803,$0954A004,$32729E3A,$A8409508,$26EED5AC,$0EBA8200,$AD080881,$9B5A274D,$1F300039,$14002D00,$34059140,$58A0B8D4
Data.l $E28A2053,$40514508,$1C3CFD08,$D7D8AD00,$56742E87,$09D34B18,$E15789A0,$7F94379F,$DD0FEE7A,$AA84A207,$33FD8D02,$21D002AD
Data.l $9A6A899F,$920A0290,$74E15BDA,$F89B300A,$33CFB28D,$DAF2F449,$42060FA2,$68153515,$9271C008,$8154181A,$DB4512BA,$41AD0088
Data.l $362A6EA0,$CF9CD001,$F7ECE0C4,$B3F06D7B,$048EF024,$B69E309D,$C31B2C58,$B58AD001,$F41E5871,$FF0A8ACB,$A9002E9C,$12109024
Data.l $E504B26A,$1FBB455F,$8077A994,$7EB2082B,$6400AF59,$FFAB5906,$ADD0C299,$CF3C13BB,$FB1EF143,$DEFFAC50,$D538FA2E,$528194E1
Data.l $DA29C206,$8090D7CC,$5644204A,$2D043E67,$10508410,$014ADFA8,$26803F30,$6095FE0D,$46D43400,$0248ECC2,$3FD5D4E1,$C6B5AB56
Data.l $C2FB3162,$FC297001,$D7140F9B,$1D385A47,$480175FA,$5F3BAC7D,$0A3AFB67,$F5204DE8,$FC90CFE6,$8015EB2B,$AAC8A0C4,$5131682A
Data.l $43B34874,$0B0A8410,$A0477B39,$214C1AAE,$54A5BDEA,$3284FFCD,$280AF1CD,$92708127,$C23215D6,$C2D08F3F,$34ADA244,$A0414315
Data.l $04630005,$A0D195B5,$B7425D91,$EF3A118D,$6FCBAE72,$3BBE0026,$C0C09951,$011CF206,$B59853C7,$FDA4CFB2,$F4FA466D,$F7969FEE
Data.l $542EB699,$6B267F87,$F45B5FEC,$106ACB29,$88F14544,$E783318D,$35FCAFF9,$BD11AF87,$99EB36BC,$E68A0016,$271C0578,$2A9004AB
Data.l $10D38420,$004214C0,$00CFF0E8,$F0040648,$B281DB07,$2F934264,$9D36E606,$CF91C6F4,$08ADB366,$162B4007,$AD3CC6D7,$C4C12BD6
Data.l $75789853,$4ABC0A56,$2FF24306,$86BD5AD3,$FF63404A,$BE99530A,$4885002A,$902B2C9F,$E82A6A03,$8E01C5D2,$796590A3,$1850DC9E
Data.l $A0F0F7EF,$51FE569C,$2029F89D,$02880654,$28941950,$9A0BDC1A,$F2C305C3,$4C3DCD20,$F33FF354,$BA80556A,$0171EBDB,$25A83C42
Data.l $B1600006,$C58B6458,$001C317C,$D93FC297,$CE26AC7A,$1F6AABCC,$FAD6894F,$66414B55,$0506F59C,$5D425650,$DF6DD0BF,$42E8205A
Data.l $4313A490,$3BBA5D05,$3F820821,$151B1E82,$5688A868,$FCD6AA24,$47F22114,$32A01434,$94012728,$4C3FF285,$F9A33100,$0A8A496D
Data.l $6802F0FF,$7681D350,$457557EF,$3A6DCC0C,$2801A86A,$E5FAF28A,$44DF9B5E,$A92E1C00,$6E262DE3,$04094F32,$387F1341,$8CFF2C1A
Data.l $054D5FB9,$110D240A,$EFB4C624,$5FA0D084,$25145062,$474016B8,$438D9B05,$281B6487,$6A04DFA5,$1E02520A,$94FD0829,$095E5032
Data.l $754A01A6,$F85597F8,$AA002BD7,$039D3F13,$79FE50C0,$800FF043,$5D4F0A31,$AEA88434,$6B125400,$87579932,$4B15A003,$384FB58D
Data.l $9985EB5F,$A71F0957,$14F47E35,$FF60B720,$EC13E0BA,$F48D33F9,$480121C9,$A8B202E7,$BA464022,$4CDABC0D,$F8695CFA,$C0D0233E
Data.l $416F8EA9,$419508FC,$93841938,$39ACA940,$012A14DA,$D5012861,$D2B4BC9B,$31100BCF,$D023FAB8,$392280E4,$EBA447C1,$3CF03FDD
Data.l $AF72EC77,$09426FCD,$42E7B95C,$F3F99062,$751FC5CD,$82F7A936,$0A0A0458,$3038C206,$1CBF5E00,$4D00135C,$50E597EF,$BFC3AFFD
Data.l $CF74322C,$8A528274,$B24D7308,$8BAAA9A7,$99C1E3E4,$57CEAD64,$04904079,$B0079D52,$E75FECE6,$4637FA01,$1FBFF304,$17EA4D20
Data.l $BFF96A53,$701A3AB6,$C17083A4,$AB52E06E,$0E175AD5,$62CC5680,$3EF166E5,$58D78E02,$49A5003F,$7AD9F146,$51F99554,$5F08D153
Data.l $31288240,$B20E0458,$0307E0CC,$C2210191,$8504730C,$204665C9,$2547FAB8,$A2A89281,$9D01C701,$38E01DD2,$6AA078EE,$D63624AD
Data.l $60B8409B,$3F0AA7F9,$1B54193A,$55938443,$FBAC179E,$7810020D,$3513FCAD,$14026804,$08CBFC83,$60A2AAEA,$0C1CEF8F,$BFE79E14
Data.l $095E79E2,$3B0B4007,$DFAEA17F,$B8CF6B6B,$6D05021D,$A4FE7090,$007D6207,$DE90473C,$5DEE86D1,$1819882C,$5053A701,$9837EFEF
Data.l $5454332C,$EC5C51F8,$1BC70FC3,$4193ABE0,$ED100422,$FCF5807B,$09BDA1DF,$8E00BB76,$0D28D6E3,$75FD72BB,$C7EB5B4C,$C3A00882
Data.l $1024E53F,$4952812A,$40D9B873,$AFDCF502,$CAD200AF,$1004D63F,$A5FE105F,$46DE0580,$6CEE5C27,$79E0F9DD,$B9CFD77E,$01D5FF3E
Data.l $E6F379B0,$F36D0038,$FE0FF3F3,$50FC63DC,$CB4298DA,$B5F52C9A,$1CD15C22,$689D33B2,$8E0A3EDF,$B8D9A108,$0007CE96,$8B88238E
Data.l $CE2E20B3,$74AF2B82,$802ABAA1,$F0EAFB7D,$F07F51FD,$64593E1E,$09CDDAE8,$5BB0279E,$7F5E0D02,$C7C96F43,$4A3E4B05,$57F6B059
Data.l $F4014083,$89F3BABF,$E5CD71BE,$F969265F,$034549BF,$D4377E6D,$1DAC40BB,$7E870540,$162C7BAA,$0A2FD16B,$BE6F9B80,$61617879
Data.l $0D86DFE1,$AFF6B61B,$0CEBFD7F,$F1F8FF7D,$D9ED0FE3,$5154E7B3,$5B98D151,$BD65B96E,$62FFEFDF,$6FA5D2E9,$FF9DA7FF,$4F0FC3F0
Data.l $DA6D369C,$B2B2B25F,$8F47A36C,$AFAFAE4E,$CB65B61F,$7B972596,$E997449C,$C77A6B8B,$671F12BC,$E55AB38E,$BB8B48DB,$23D9D46B
Data.l $5BE53180,$82F7D8C6,$A6DF6820,$08600021,$24900204,$5A28A209,$939D1212,$D05ADBA3,$6D802F2B,$B7B0AADB,$A76C8241,$011CEF48
Data.l $589AE38E,$A2B39EE3,$914A2AA7,$0E417829,$ED5A3F89,$A7F8744F,$0CE7F846,$4BF18FE2,$01006589,$AE69FC4D,$A36A7AEC,$40D2B820
Data.l $242C1988,$A2FE36FF,$2B2B2800,$55555473,$65B2DC75,$85854DCB,$C9CFBF85,$DA6FF1C9,$B1EEE9B4,$F376C763,$00223C78,$F7DBEDF4
Data.l $8F14516B,$14BA5D2F,$77CFE7F3,$23C8F23E,$5DAED742,$5F17C5F1,$DCF73C34,$E9D38A73,$D5D5D674,$43A1D0E1,$3E4F93F2,$3FE7F8D9
Data.l $75B9D9FF,$F7BC56EB,$A4F27BDE,$8B6A9349,$A79B4E8A,$B1D7BF4F,$DC26D369,$E24DD374,$5C7F1FC7,$66B3000F,$582DB2CD,$999AC0B0
Data.l $43A18999,$B85CD687,$7DB2C170,$7BEBF6FB,$507DEEF7,$F65B9451,$B6D3D9EC,$E9E4A4A4,$7F47A3D1,$C8E4723D,$EBEBEA3B,$48484D1F
Data.l $5BD6E6B8,$EFFBDD6F,$B4E7603E,$E7CF8F68,$A1A1A27B,$C9A9A9A1,$4D9B31EB,$F6E38E01,$99B74A52,$4D55E64C,$1DC78D4D,$264C070E
Data.l $BCF3C893,$F1C763F4,$1444FCF9,$AD59F703,$C99314B6,$378DFD7B,$676467DA,$9D16C6D7,$8242426D,$6DC71C15,$F5366B97,$01FBD40C
Data.l $7FBAD262,$2350077A,$8FF75A82,$D3369272,$60055A4D,$4311FEEC,$3753E7F9,$277E85E2,$68092288,$7B036BA8,$A8301CC7,$21093F8B
Data.l $13B9FD7F,$180A59AD,$F6106834,$B317DBED,$1BD2E974,$70B27C01,$876B82E1,$A58E1F0F,$C5D5D54B,$996CB65B,$F8F9F3EC,$56B75BAD
Data.l $3BCEF3BC,$131313AB,$C78F1E2D,$9F27C9F5,$EE7738AC,$28A27BDC,$ADADA86E,$E2626245,$FF3FCFDE,$3399D77C,$9C977E67,$FCFFEC9C
Data.l $0BEDCFF3,$F4182C16,$668B47D1,$4DD5D5D6,$3C4C4C4A,$A1D0E87A,$BBAEEBA8,$6E6E4C6E,$4B25C9EE,$8A896C96,$AFA88A8A,$B95A8FAF
Data.l $131FE572,$4E9A1212,$E431389C,$548BC5E2,$64BB9451,$29471E59,$E6733B4D,$D5D5D7CC,$8FC719D5,$3F1F371F,$C00B3C7E,$21F29FDE
Data.l $2D965965,$8754CB16,$C5B36223,$73F73E62,$62C5942E,$731A9A66,$9F11C004,$B74AFFCF,$D3FBD66E,$8BF7BCD2,$366298A2,$9621FBF1
Data.l $1CFC958D,$BCA06128,$35E7FBD6,$280A2004,$80694295,$8FF2A1F0,$C1BFA170,$B2A49FEE,$3A69347F,$5E881680,$7B4A023B,$DAF1ECD8
Data.l $EAA575F2,$F2F3F9FC,$DAE773B9,$F9555557,$2A727272,$200EB67E,$F5FA0208,$63B457EB,$0B1B8EC7,$77630B0B,$E573DEEF,$832391C8
Data.l $BABAA5B9,$D5D5D51A,$AFABEAF8,$70B85E66,$93E4F841,$7BDCC64F,$7ECFBDEF,$5DC7F1FC,$F1ABABAB,$A1DF77DD,$2FFEFF7F,$6633198C
Data.l $BBDDEEF6,$DCEE77A7,$5FD7F279,$21157D7F,$92C97AA4,$592D0F25,$B0DBA4B2,$2F76C361,$C7A0B058,$16A351A8,$8DE378DF,$678F1EF9
Data.l $F264C985,$BF3F9FCE,$DDF77DD7,$6D6D64F7,$DC770BED,$C4AAC771,$B7D5C4C4,$96EB7ADE,$97E2E2E2,$874B4B4A,$FC78A289,$590381C0
Data.l $BF3DBB76,$9FFEFF7F,$6FD7EBF7,$90FD4FED,$715DBB76,$FD1F1C38,$48FFE75C,$EEDC0440,$EDD9AF36,$BB769EF6,$9366EFE3,$13E319F2
Data.l $300AB02D,$FC90A439,$7D7F33AB,$06968801,$274FA482,$77D9A482,$D74EABD2,$F7635FE5,$3E0DCEAF,$88440922,$96940000,$5E2D4696
Data.l $C2CD78BC,$7E770B85,$D3A7E9FA,$9410B17F,$A7389898,$E472B2B2,$674BA5D2,$29D4EA74,$E5F9E79E,$5FACC72D,$51511EBF,$75BB7B51
Data.l $EACDF6EB,$CA5FABD5,$051ACACA,$69696900,$F5E51450,$95269349,$BB8CB2C8,$5CFBBEEF,$A9C24242,$95A8A8A8,$49454545,$3B0D86C3
Data.l $9F27C9F0,$763B1CF4,$83C1E16C,$6CDB8707,$FBFDE2B6,$020727F7,$F3F34F81,$984E2FF3,$F2C3E130,$E7F3F2F2,$FEBF9FCF,$D6784EC7
Data.l $4EDF59AC,$C2653299,$4B93C9E4,$AA881BFF,$8AACE9D3,$DDBC8A8A,$C7D988E6,$B3C9AE99,$37F35CC7,$620896C9,$122DE067,$7DB6A728
Data.l $AA60E5D5,$E9DEA400,$9FA08423,$DEBFD918,$340093FD,$C1FC5F42,$758D0E64,$B8F26831,$16EC88E1,$E5CB9D74,$9191985A,$48499301
Data.l $124A4A48,$7400717E,$BD7DDEEF,$56E6EDDB,$DB3D5EAF,$4DFE74E9,$FBCD2263,$A0DA6DEA,$2F96B6B6,$7D4D3A2A,$D97D9F3E,$552365B2
Data.l $62C1CCD6,$3A3A20B1,$A124921A,$5CCCACAC,$D2885858,$9B7352D2,$9BB86D36,$FF69BA6E,$533399CC,$A5E97A5F,$4F9F3EC5,$FA7D3E99
Data.l $088888E8,$5DAED77F,$FEC000FB,$51DBFBFD,$A9A9ED4A,$194BFEA9,$D4D5C739,$5757FCD4,$871D112D,$F1EC885F,$D76B52F0,$36FECB3F
Data.l $B623C077,$5004C887,$25E5025E,$00C80D2D,$7FA85BE5,$07FBA1BC,$7E2A0095,$BF0FC930,$E2AA8CC7,$D63D9C54,$57A5A513,$064D7443
Data.l $0001E6DA,$E4FEA108,$4B7F0EE4,$188D4B4B,$44586C36,$9FDDEEF7,$6065C5FF,$79424242,$92C24242,$4DB6DB6D,$7949494C,$9694C003
Data.l $73737263,$B8DC6FD7,$AFEBF161,$20B4F1BF,$74BBC308,$780122E9,$A3FD7F4E,$BC0A3E8F,$9EEBFAFE,$BF828282,$FBBDDEEF,$DADADACD
Data.l $8F47A369,$ACD67B7E,$65660F59,$484D4D65,$E9CF7F88,$1312DA74,$DC71C113,$F7FBFD9C,$2BCAFBBF,$97F07F2F,$43A5FCBF,$B28E4E4E
Data.l $B78EC763,$8FD42C01,$0D9D9D97,$3FBA9249,$B743D0F4,$AAB55AAF,$51A8D47C,$835BFEAB,$6F3264C0,$7FAFAFAD,$CC37F09A,$8FCDB7F2
Data.l $42ECD6F1,$584EED43,$6CC28E9B,$55C3832E,$28015E05,$0677A9C7,$004A0033,$6590098C,$E1914C11,$5BC0F06F,$A9B787EF,$4F72FC3D
Data.l $483A7B50,$22986F7C,$C86840D2,$C9B36665,$F6DBB76F,$0DF392FE,$DF6FAD1E,$A2A317BE,$4747D6A2,$A351B147,$3A742D46,$2713759D
Data.l $D8032C4E,$C6633189,$8BE2F9B4,$6FB7D02F,$81026FDF,$9E27E9C0,$5A556278,$0FBCDA5A,$4FB0FC3F,$654A4A4A,$F4D45454,$18848484
Data.l $67D65145,$43886464,$BB3D0E87,$DBF2F97C,$7C5E2F16,$67B3D9EF,$68341BAF,$BFEE1FD0,$B105FEFF,$D8FFB1B1,$23E371B8,$63050505
Data.l $B7D3D3D2,$FBFD9ECC,$EDBB6E37,$6633FDF6,$E4F8C8CC,$6657C593,$A3CA6666,$791A8D46,$48F73DCF,$38CC6633,$674BA5D8,$F33C002B
Data.l $1B7533CC,$63786C36,$132D96CB,$B4EA753A,$7C5DBFE6,$2F9D3A72,$4FBEBD79,$4F7F3C3D,$92743CC0,$46283D14,$D7C195F2,$CADA8450
Data.l $0A588013,$C2815681,$3FAB260B,$0A28A14E,$E0C13844,$0B6E6704,$8D0748E2,$12D9824A,$239B4A07,$5FADF6BB,$E5B36625,$AE7A5FFD
Data.l $FC0DDFE1,$4D4D5B0F,$2B2C924D,$9A5965D3,$ADFBF7E5,$AA87B7EA,$41260F10,$3BED1451,$35182801,$B6935083,$82B59440,$403F262E
Data.l $4D9B363E,$FB76ECCB,$B9B366F7,$002C7FF4,$C1F07C1E,$FF7FDF2E,$DFBF38FD,$063147AF,$FEF0180C,$5E3F8FE3,$DE3FDADE,$5DBDEF7B
Data.l $3C3E1F0E,$1FD5144E,$8F8F8CC2,$43A1D0C7,$9EE7BFDF,$FF1D5A7B,$269FA7E9,$67D9F67D,$545E2E93,$EBF42BD7,$3E24AFD7,$5D2C9E3E
Data.l $30D134BA,$4141616C,$E5AFF141,$F83E0F9C,$F9FCDC60,$7618BBF3,$A0A0B3FD,$E27FF0E0,$AF5EBCBD,$C194514B,$398D8D8D,$24966E00
Data.l $44924E39,$CAD6C00A,$E2108970,$821E38E3,$C63057C0,$3870E1FE,$B8A28BF6,$D572E5D1,$189E4FFD,$00AF0092,$49B21100,$57544144
Data.l $E9F40530,$A2FDA7D3,$AA9E8B45,$E20AAAAA,$2391C8CD,$FFDC0163,$9BD5A523,$1D6EB75B,$450E786A,$6801B651,$FCBE0035,$0D9CCBF2
Data.l $69CC361B,$21006868,$F6FB7D04,$54545D5D,$50505514,$FEA8DBD0,$02D5F802,$78B8B8A0,$C1414142,$13AEC338,$0123FE00,$96EA75A0
Data.l $9AD3DB6B,$8C6764B8,$FBF7E2DD,$20B45282,$E179E008,$FE62C58C,$386F7E55,$DD370018,$AEFAD374,$5696BB5D,$EB255555,$5EAF56FB
Data.l $A6A6AEDD,$6EDDBA86,$39AC05A5,$EAFABEAE,$C6BEE348,$CD9846C6,$6C003BE6,$788DF56D,$86868EFE,$D8BA2086,$7E85B66C,$DFE1FFBF
Data.l $E4D07A72,$9BFFB9DB,$0CACD0E7,$3ACECECC,$F4FE5CD2,$D3F4F98D,$2DA92F4F,$DD5EAF57,$E4081021,$575FDCB6,$C0FA3757,$FC970381
Data.l $61615DF6,$9ECF63A1,$0FA1493D,$CFCB296E,$6610DFCF,$D6FBFF08,$7272002C,$DE35AC7A,$CF67BE63,$6666641E,$4FF96AF6,$2AFABEAF
Data.l $E9F4FA7F,$F0760E4B,$37C8C1E0,$DCD37CDF,$FE3FFF72,$40988FF1,$7F43D020,$7F7FBFDE,$7E7E7E6F,$F272725D,$79797947,$E2B6192F
Data.l $5D7E4BB0,$4C03A66B,$CB753A9D,$A2BCAF2B,$53979794,$CFE7D61D,$5A157F9F,$5E40D17C,$C2CCDE5E,$D27F4BC2,$04A4A4AE,$39915C57
Data.l $CD53C013,$C1D28CA2,$0C9E4F27,$A28A3096,$460015FC,$2ABD1E8F,$62D73737,$3F317A18,$45451F3F,$8A8AB9A7,$C6C694CA,$2AAB8360
Data.l $06BF3F3F,$9DCEE600,$53D4F49B,$5E2E994F,$834188BC,$17C5E106,$D7EFA85F,$1FF2AAEF,$3ECF80FB,$2C846CFB,$EDF6A3CB,$695577DB
Data.l $93922969,$E8743193,$4723BD90,$C2E7FC8E,$E4FD1F85,$E170B50B,$9E67D4C2,$3D9E8679,$9326167B,$8FC7E309,$53A9D4C7,$F3F3F3CB
Data.l $BDC0DF83,$0166F379,$E901B240,$FA7D3EC4,$AC796D9C,$B7F7FBFD,$D6AEAEAB,$3F2FB73F,$E5A4BF3F,$F87E1F98,$ACACB921,$C6DF474C
Data.l $32FCFCFC,$BBCC7F6D,$5CEBBEEF,$6A1168B4,$36606A6A,$C864319B,$399CCC10,$F0F87EB3,$0F87E5E1,$9FCE17EF,$104B38BF,$369B5F04
Data.l $C9CDDE6D,$2B2F91C9,$1D0E8622,$77C3045A,$351A8D10,$F5F1A76A,$F3379BCD,$00CE2D5A,$61C38730,$D61AC9FC,$85EF77BB,$E5798F2D
Data.l $A5BE5795,$99326EBF,$BE3B1D94,$AF000719,$B7FAFEBF,$63F5FAFD,$002AED86,$0FC3F0F8,$FDBF6F63,$C7FEE336,$EFDE1F0F,$1785E178
Data.l $CECECADE,$66CD98F6,$47458006,$BCBCB347,$7B5F675E,$ADD9D5ED,$3F8F967D,$6E4478FE,$AB5EEE6E,$1CECDAD5,$BB274E9D,$05E9DEF7
Data.l $9FD3FA7F,$03F71B36,$63CB5DF8,$273399CC,$41A0D06B,$6767651F,$8D9B364B,$52946001,$3B5DAED6,$5B9B9B96,$779DE778,$2C2C2A4E
Data.l $B4C003B4,$8632D369,$3C1E1F0F,$46A351EF,$16161495,$E63CB546,$7D370984,$EEB98FA7,$3FAAEBBA,$4BB3ECFB,$E1EFD47E,$A53E1F87
Data.l $6532998F,$78004ACA,$1FF7FDFF,$E8743A1D,$54D4D4B9,$F0420826,$6363625C,$F6767659,$BC6F1BD9,$8B45B1F1,$EF741A3E,$87B2F7BD
Data.l $CD887A1E,$FA273399,$CC6121B2,$1B2F3198,$72724A2F,$D2EEB372,$E23C8F23,$0CCCCCCE,$23C8FEBE,$B8BB348F,$8DB9B9B9,$A12D4A2D
Data.l $E5BEDF6F,$7ABDEBFA,$5CB60AF5,$F198CC67,$5C070B6D,$58DACDA5,$78007BE3,$9E6799FC,$2A2A3979,$CF18B58A,$A8A8B000,$2789F928
Data.l $F8DC789E,$F6BDAFBE,$FDFEFB5A,$6A25AAAF,$CD92E5E7,$1BB0B162,$FD81B86E,$371800AB,$B4D8DC6E,$1FFAB4B4,$E600063B,$2DD8B972
Data.l $D9F2DCB7,$4C0B0582,$6EFBBEEF,$5A5A5A7C,$9B5AFE89,$83D86D36,$DA383E0F,$2B95CC78,$A4A76657,$63E834A4,$7B1B366C,$EF27C9F2
Data.l $DA99C16C,$5EC6C6C5,$8E38C004,$F03C0F63,$67B3CBC0,$3A327ECF,$B1FE5A3A,$1726D0F3,$9BE6F9BB,$3399CC2F,$4F93E8E7,$D97AB93E
Data.l $971165B2,$E7F3001D,$9F5E387F,$970CDA61,$3F9FCFE7,$8DFD7F5E,$4618DE37,$C45E0D29,$4C964B25,$0C8C8C89,$AD5AB78E,$7BBDDECA
Data.l $8FE3E927,$CFDA3D1E,$26131288,$B979D84C,$C4623001,$3A1D2D88,$23D26874,$D638E39E,$E9E929D2,$77BBE5E9,$80054EEF,$7E0A8A8A
Data.l $1BA9D4EA,$2108638D,$8EC763AC,$5ED7B5D2,$D76BB62B,$3084264E,$347EE38E,$97F2FE00,$1B1B5CBF,$716DEB1B,$84849581,$B56AD104
Data.l $9B63C64A,$D2F6264C,$052D2F4B,$87C3E180,$E7BE32AF,$D43D0F43,$DFECB94C,$9680FFBF,$EA7539A8,$5D0B66D4,$CEF3BCEE,$F131F41B
Data.l $FCCAF1F1,$4C5FF3F9,$0C934B4B,$EEF4A608,$801F7BDD,$3A1D0F3F,$52525F74,$973C6292,$BE271389,$E6F379B4,$B937D49F,$28A419A4
Data.l $76767B6C,$5379F076,$2C2D1353,$7F46BC2C,$BADD6EBE,$56A28AFE,$F67B3D85,$ABE42104,$797ABD5E,$7EFDD7F4,$6733993F,$0081AC4E
Data.l $3FCBD7F6,$74BA0842,$3AD972E9,$8743A1FE,$773B9E06,$6FB7DACE,$BDAF0BDF,$CBB3DAF6,$399F2F97,$F5B8DC6E,$3E884B16,$B6969694
Data.l $4E67339D,$A32A0D67,$7D5EAF56,$535B5EB5,$EA75314A,$9B4DA2D4,$5EAC6536,$BFD85ABD,$1ECF7F7F,$F97C7A3D,$E73BD42F,$969B4DA6
Data.l $D178BC5F,$D95C7062,$6E0B0582,$152D2D29,$B20A0A0A,$FD1E8F46,$7EA4C9B9,$10204B65,$BDAF6BC0,$7FEFFA36,$3EDF7BFF,$B66CFA7D
Data.l $D400AD5A,$96CB6665,$BE5C8B2D,$BBF0797C,$E2B8AE5D,$F5FA598A,$E1F0EDD0,$4EA7D9C3,$341B729D,$31F40795,$FBF5AB56,$59D6EB75
Data.l $CD3E9F4E,$64644001,$F17C5E24,$EE7747C5,$C003D9DC,$6C361BA3,$DE6F31E8,$696959BC,$DBB70169,$8888888D,$D2D2D2AA,$F9F9F90E
Data.l $800ACFD2,$B1BC6F1B,$6D72E5D6,$8284050F,$E60F0783,$BAE20218,$BCC23350,$AFABEAF1,$FE79E0AE,$4278E333,$79FD54C8,$70515151
Data.l $3C7C7C7C,$F5DAED76,$8006E5E1,$A4CF2E46,$F15FA7A7,$3C0F03C0,$E8F47A37,$9C4E26B7,$33333E38,$4C7D7BF3,$AA034343,$0013ABAB
Data.l $1389C4E0,$CACACB53,$E92BCD8C,$1C9F27C9,$7C9C9C9A,$A2A2000A,$F03DF6A2,$72D303C0,$5B2B7373,$8BC5BF7B,$7EBEDF17,$F960FAFD
Data.l $8191919B,$0D66B359,$5B96E5BF,$52D5AB16,$9C9CE1CE,$72735B9C,$59053672,$B095556A,$C7FAC361,$BFE80C06,$B62E2E25,$F23D70D1
Data.l $91D8EC76,$F327F1A9,$2E1B0D86,$2F1704E1,$F2F8EC5E,$E8472FCB,$359AF325,$84FA9C6B,$70783C19,$CBE7CFA9,$6AD983D1,$8743A2B5
Data.l $EF48CD0E,$DFC3E1F0,$BBCBCBCA,$D9ECF676,$B8DC6E37,$2D96E7B1,$ACFE265B,$DC001032,$73AFB76E,$891BCEE7,$495CF161,$9EFA4949
Data.l $D4AE7B3D,$7D476E2E,$83C1E0FF,$6EDDB8CF,$AE6B9AF1,$06CFA639,$28282800,$BCDE6C70,$0E000139,$49D0381C,$94949FDF,$0781EE74
Data.l $6E5EF01E,$66CD9800,$EC3A1D0C,$170B85DD,$F5C8F906,$3F5F5FD7,$F290C864,$413AF016,$366E2FD3,$8F8F8FEE,$BE7758FF,$76DDB76E
Data.l $4646795B,$DED696C6,$9DCEE76F,$44396513,$5353539E,$F6E6E597,$BAA2DC38,$E9BA6F10,$CF3CF5A6,$FAFB6707,$0D3A1BF5,$DEF57C1E
Data.l $E08CF4F4,$3F9C338F,$B3661E7F,$3D0D66F9,$040C01E3,$3A9D4E80,$6766BF41,$66459ECF,$0D44E666,$FDFB3B31,$B0002CFE,$D8E86CD9
Data.l $46A7E3B1,$9595945F,$FA7F4FE1,$06039BD3,$68BE980C,$F41BA2D1,$F27C9FFD,$1FC7C6C9,$399FFC7F,$B5973939,$3BD5B438,$6B631883
Data.l $82121212,$2A2A2BCF,$FF3FCF6C,$82C173BC,$5656B705,$59B4DA56,$CFE7F384,$9DCAD3CF,$191919D5,$7E3BDD46,$B9B9DCEE,$7D7F379B
Data.l $49494963,$3B11C194,$561B0D86,$0562D97B,$6FDBDEA5,$AF92EDBF,$B3ECFF3C,$68A99ACF,$33E92492,$7FB8CE2A,$1761B0D8,$6A6E3B5A
Data.l $EFAB6A6A,$91C8E477,$B06416B8,$5525253C,$5E4A4569,$6A18989D,$971C7065,$E6F379B6,$F366CDAB,$8210415C,$CF67B888,$9A9AFC9E
Data.l $5C801B1A,$C8CE1CBD,$959BDF48,$90000595,$E6F31965,$2C2B8BCD,$6464442C,$CFE75DE4,$B800079F,$E1AAAE5C,$33FF87C3,$2F723232
Data.l $E3C171C7,$C3B1D8ED,$F0505055,$3399CCCE,$EEDDBA97,$87C3E192,$E4E4E497,$7BDEF4BC,$E57CCDEF,$2FC85795,$1E87800E,$EDD8B07A
Data.l $28329F76,$4D4D487C,$77DDF07D,$45138DDF,$EC116891,$6A753A9B,$994C000D,$DFA8E532,$1F4AFFEF,$1078F1EF,$E0FB1B1B,$11BFAFEB
Data.l $48D8D8D3,$E57C59F5,$FD6E5795,$DB856239,$CCCC6EED,$1F92E2BC,$FA7D3C3D,$E36B4374,$5A8A8A8B,$B2E98820,$AAAAB7DE,$29F3D9AA
Data.l $D6BCA653,$2311B8DA,$3A3A2046,$02056954,$CEE77E01,$93C9969D,$D9B16F27,$04068D6C,$2BCAF1ED,$DAEC44AF,$CEA06BB5,$7A72729F
Data.l $8D8D8D6C,$1C986ADD,$2A2A2AB3,$178BC584,$3F70E8C7,$BA88C462,$A69C9C9C,$BFFBFDFE,$A753A9DB,$5EC1968A,$6A4B5B5B,$D7126A6A
Data.l $58975BAD,$D8F85858,$DFD3E9F4,$6D76BB5C,$3FCFF3D5,$028BF79F,$F5252520,$DE5E5E62,$55BEE379,$93B956AB,$E8669292,$D9084727
Data.l $73939392,$D47D7F42,$466551A8,$FAFD7115,$DDBB4EF5,$2DDE80FE,$F189898C,$6DAE5CB8,$F400273F,$293974D9,$4E2768C3,$9655F89C
Data.l $20C6318F,$BFAE1249,$5723FAFE,$D795755D,$E5C10950,$7AF18D72,$99B423BD,$9494948D,$F6FB7D55,$F98FA7DD,$516FDBF6,$CD9C5C5C
Data.l $7D18DC71,$EDF6FB5F,$E4C001E7,$DF4F93C9,$93BDEF7B,$7DEEF77A,$3F982756,$369BFEF6,$58AF726D,$B7CBE2B1,$C3BB7EDF,$00000ECF
Data.l $F8888888,$750B66D4,$EE59652A,$DF77DDF7,$3AACE925,$84EF2F2F,$8A28BC71,$B76EDD8B,$DDC87AB1,$BA576BB5,$70E1DCFE,$FDFF7F7C
Data.l $35FD1FF7,$5DAED11C,$BBCF66BB,$F37EEB75,$D3BFFCE5,$319DBCD9,$DFBCDE6F,$C76E36B5,$ADA81D8E,$773435AD,$ABD5E82C,$3E77CE97
Data.l $EDE31235,$775FB7DB,$4E99CCE6,$95959000,$B8B8B885,$E58B16E3,$C8C8C8D3,$D4D6CA20,$7438ACD4,$877DFD48,$0C58D8D8,$7830381C
Data.l $6733998C,$3BCEF57E,$32180F6F,$1198C864,$4D2C4623,$9BDD4D4D,$EAD19191,$7FBFD8E4,$3399CC7F,$45F9EE67,$F47A3001,$378C6FE8
Data.l $1515161B,$9558B8A1,$232323EA,$4AC20821,$B3D9F8E3,$9D3B1767,$3EAB20CE,$F42CF67B,$0421017E,$FBD9D9D9,$5B7D2D7E,$3A66E596
Data.l $CBE5F2F5,$E0771D5B,$F75681C0,$A3D1E8F7,$5BADF3D9,$36B426B7,$E5B366CE,$E35AF9E8,$6263A73E,$8006BE62,$AEC763B1,$C1D12236
Data.l $E9470783,$8A288995,$E9F4FB2B,$CF67A173,$0F3AA59E,$DEB78000,$27412B7A,$B5DAED9F,$52525FDB,$BCFCD252,$5CADCF72,$B5CBF2B9
Data.l $FF8ED76B,$070FC3F0,$363B1D8D,$D1E8F479,$EBBAEE3D,$E2E337AE,$E98CAAE2,$6DB6DB61,$0028BF09,$7C1E0F06,$AB2B2B30,$062F08D2
Data.l $7D30B874,$10CD3DFA,$E9292920,$CE4E4E58,$FD78E349,$172E5C7F,$B0E8743A,$800AD7E5,$66B4B4B4,$FBF7E5EF,$3A2A2C1F,$EA516F6D
Data.l $2E2E2E75,$1C47F1BE,$BA4E86FB,$CF7F2634,$A2EB75BA,$96EED45B,$3D0E8743,$EE85F3E2,$6A3519DA,$4E4E6D54,$11E3578E,$EABAAF9B
Data.l $84E326AA,$98C327D0,$DC2A6331,$BDDCB76E,$4092F77B,$E5B4B020,$9B33B518,$DBF6FDBD,$6A6A976F,$6BB5846A,$1E8FC6D7,$85FE3A3D
Data.l $F7185E17,$0EAFABEA,$FCFC8004,$FF3F86FC,$96E7CFF9,$38565B2D,$07DCEE77,$9AE6B9AE,$98958C47,$567EBCF1,$24C4A800,$97210D6E
Data.l $ECECCA92,$D4D4CAEC,$F72D33B4,$BE363637,$39241ADF,$BBF2CE9D,$E7B69AEE,$B1800AD7,$69AEC763,$F06DB6DB,$1B0D86F9,$FBFF7F4C
Data.l $B05CBE3F,$001B8160,$9359ACD6,$8AC562BD,$ECF67B15,$BF319569,$6B0BC2F0,$65737373,$2C83FF43,$F56CB65B,$BB1B8DC6,$DB7AB569
Data.l $FE7F9FE7,$FCBF2FBE,$19F0D332,$ACACAC95,$13E7F417,$5BF44E27,$FA4BD6AD,$31313122,$E4F27938,$45B91AFB,$56ED76BB,$4F4D831B
Data.l $76BB5D41,$22F5A359,$C6F1BFBA,$F77BA51B,$EA7D2DEE,$7C96A7A9,$2B17C5F1,$3ADD6EB6,$EC7485A4,$37EDDBB4,$7ED74B18,$F2FEFAFD
Data.l $D56AB90B,$A6F4FBAA,$1C71BE83,$984C26C7,$E36B64F0,$36DF6FB7,$F972E5D8,$13D46A5B,$D5384C26,$2A9FF8DA,$47ECB705,$E3103518
Data.l $F7FEFFFF,$C1A0DFBF,$3BCEE9AD,$7C6D3CEF,$B2B56ACD,$C3848484,$DBE9E9E9,$E6EB75BA,$9292C007,$468B5892,$3FD73051,$CF73DCF7
Data.l $E0F6EDDA,$B3CF3C6B,$37BBDDEE,$6FA7A7A4,$3F4F4F4B,$528D7C6E,$9ACD66CA,$93CB7DF5,$F2793C9B,$0038E340,$AB2B2B2C,$63B1D8F2
Data.l $D6C10C9D,$A929293B,$CCCC98D9,$2B95D2CC,$C002C657,$A55FB5DA,$95E5795E,$EAF7C615,$D56BB5DA,$B69349A4,$DDF77DDD,$F0FC3FAF
Data.l $F6FADBC3,$22207BED,$FFF82222,$EC292929,$B83E0F83,$400717F6,$338D4D4D,$99A32323,$070E1D43,$2FCBF2FB,$FFD8FF26,$B7DBEDF4
Data.l $529E38CA,$984C26CA,$19AFC4F0,$F2F00000,$66E72FCB,$CBFD6565,$B76DCE26,$D381F6DD,$00356CE9,$1FDFEFF6,$FC3F87F1,$5F6307E1
Data.l $528DB5A4,$FEBFAECA,$562B23FA,$796B88AC,$AED76B72,$4FA7D8ED,$C7E3669F,$BDBF1F8F,$1CD57745,$D7B31313,$EBBAE638,$A2DE5BAE
Data.l $874B7701,$E5FE1D0E,$D73F1879,$F63D8F63,$8D4D4D4E,$00A717E9,$DF5DDBB7,$ED8743A1,$FA1DBB76,$5C9C9C96,$F999999B,$8EF48DA3
Data.l $637E3B1D,$3870EF1C,$C7E3F1E4,$971B7AB7,$718264C9,$0F6EDDAC,$AB567D96,$C7EFB835,$FF969F4A,$D381CC6B,$F7DB4DA6,$DC4F13C4
Data.l $7B9B9B94,$07B76ED2,$E397737F,$EEDDB838,$7E9FA7A6,$6D6D7E6A,$CD9B02ED,$6BFBC976,$7833DD4C,$77EEE0F0,$33C771DC,$1E191919
Data.l $1081DF63,$8AD5AB02,$7A3B1D8E,$F198CC66,$BC6F1BFE,$EC763F91,$A6C44BD8,$53BCBCBC,$AB717171,$5CBB63F4,$793C9C2E,$9C8DD9B2
Data.l $FEF9F9F9,$D6472391,$232263E8,$4FA7D123,$638C6F9F,$B1EC7B1E,$CF67B3C5,$ADEB75EE,$DDBA96B7,$64C99F6E,$0B353182,$CB970082
Data.l $06030185,$F4FD3D94,$1B0CF753,$B77EEC36,$29F81DDB,$556FF001,$E773B9A3,$969694E6,$BD903376,$DE779DC0,$45DFA3F9,$FAFD7EBB
Data.l $828282CC,$7C6E632C,$3E87A1E8,$9AEC6D69,$EC466B35,$48CBB5DA,$FB3FD6AE,$9BE5B3EC,$1CB66F37,$5C747A3D,$4EB97979,$3E0FFD22
Data.l $5692E0F8,$00247B16,$9F421C18,$0D86173E,$05B1BE1B,$F9BCA58A,$16FD9BE6,$1AE45A2D,$88F0783C,$7F379BCD,$8FE3F8F6,$65329D1F
Data.l $0B05DECA,$70BDB416,$7D70C2E1,$6F803425,$D9F67D9E,$4B0A9733,$7A5FD3A7,$76BD8FE9,$76DDDEEF,$B71188C4,$6AB55AAD,$030180E1
Data.l $FECF67AA,$9494CEFD,$EAFF93D4,$B4DA6DFA,$EDF6D071,$CBD3B4DF,$BCBCBCC4,$F9F9F96D,$8E7C5AE7,$34030024,$3D1E8D82,$CFCFAC7A
Data.l $91756FCF,$6BB5DACB,$D6F5BEFB,$371BA95B,$C9E4C46E,$EF7AEF93,$E6E6F7BD,$89E1E5E5,$FF409E27,$FF3FFDFE,$5B0F8EA9,$B616C2D8
Data.l $6C2D85B0,$D85B0B61,$B0B616C2,$616C2D85,$C2D85B0B,$85B0B616,$0B616C2D,$16C2D85B,$2D85B0B6,$5B0B616C,$B616C2D8,$6C2D85B0
Data.l $D85B0B61,$B0B616C2,$FF617FFD,$5D9FE30F,$3F9D7E96,$0000002C,$4E454900,$6042AE44
Data.b $82
WindowsLogo_End:
EndDataSection

DataSection
StandByXP:
Data.l $474E5089,$0A1A0A0D,$0D000000,$52444849,$2A000000,$2A000000,$00000208,$5EA14A00,$0000000C,$4E527406
Data.l $00000053,$6E000000,$009107A6,$70090000,$00735948,$00C40E00,$01C40E00,$1B0E2B95,$E1140000,$54414449
Data.l $D601DA78,$00EB2914,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00010000,$00000000,$00000000,$ED000000,$0000241C,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$DCE41300,$00000000,$00000000,$00000100,$00000000,$ED000000,$4D10241C,$000000F1
Data.l $FE000102,$010200FF,$00FFFE00,$00000000,$01020000,$00FFFE00,$02000000,$FFFE0001,$00000000,$FE000102
Data.l $000000FF,$00010200,$0000FFFE,$01020000,$00FFFE00,$02000000,$FFFE0001,$00010200,$0000FFFE,$01020000
Data.l $00FFFE00,$02000000,$FFFE0001,$00000000,$130FB3F0,$0000DCE4,$00000000,$00000001,$ED000000,$4E12241C
Data.l $00FFFEF1,$02000000,$FFFE0001,$00010200,$0000FFFE,$00000000,$00010200,$0000FFFE,$01020000,$00FFFE00
Data.l $02F3F800,$FFFEF8F7,$00000002,$FEFE0102,$000002FF,$12120200,$000100FE,$01020000,$00FFFE00,$FE000102
Data.l $000000FF,$00010200,$0000FFFE,$01020000,$00FFFE00,$02000000,$B2EE0001,$DCE4130F,$01000000,$ED000000
Data.l $4E12241C,$000000F1,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00F3F800,$4F005E3B,$F0F6007D,$00000000,$01000000,$180F0001,$00146A00,$0100140D,$00000001
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$130FB2EE
Data.l $0004DCE4,$00000000,$00FFFE00,$FE000102,$000000FF,$00010200,$0200FFFE,$FFFE0001,$00000000,$02000000
Data.l $FFFE0001,$00000000,$FE000102,$1700FAFB,$1C130224,$001C13FE,$00020000,$0000FE00,$02000000,$FFFE00FE
Data.l $00000000,$FE000102,$010200FF,$00FFFE00,$02000000,$FFFE0001,$00000000,$FE000102,$000000FF,$00010200
Data.l $0000FFFE,$00000000,$00000200,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$F7FB0001,$00000000,$FE00FEFE,$000000FE,$00FEFE00
Data.l $FC000000,$00010000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000002,$02000000,$00000001,$00010200,$00000102,$01020000
Data.l $00000000,$02000102,$01020001,$00000000,$02FE0002,$0000F2F8,$00010200,$00FFFF02,$02020000,$02020202
Data.l $02000000,$00020202,$00000000,$02000002,$F200FF01,$FCFE02EB,$02000000,$01020001,$00000000,$02000102
Data.l $00000001,$00010200,$00000102,$01020000,$00000000,$02000000,$00000000,$FFFE0000,$00000000,$FE00FFFE
Data.l $000000FF,$00FFFE00,$FE000000,$FFFE00FF,$00FFFE00,$FEEFF500,$4BFEEFEE,$F2F70077,$FE00FFFE,$00000101
Data.l $FEFEFE00,$00FEFEFE,$FEFE0000,$0000FEFE,$FE000000,$F5FEFFFF,$BB7800F2,$00F2F6FE,$FFFEEBF2,$00FFFEFF
Data.l $FE000000,$FFFE00FF,$00000000,$FE00FFFE,$000000FF,$00FFFE00,$00000000,$00020000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$FEFF0000,$00EDE800,$A8005939,$815300FD,$00F9F300
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$FCF70000,$00442B00,$5000FCA2
Data.l $EEE6007E,$00FAFD00,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000200
Data.l $00000000,$00000102,$01020000,$00010200,$02000000,$00000001,$F9FD0200,$02EDEC02,$6700CA8C,$000002A2
Data.l $00FCFC02,$01020000,$FFFF0200,$02000000,$02020202,$00000002,$02020202,$00000000,$00010200,$00FEFF02
Data.l $00020000,$81530000,$02F0A902,$F800F6F9,$000102F3,$00000102,$01020000,$00010200,$02000000,$00000001
Data.l $00000000,$00000002,$FE000000,$000000FF,$00FFFE00,$0000FFFE,$FFFE0000,$F9FC0000,$FEF4F5FE,$22FEFDAA
Data.l $00000033,$FE0000FE,$0100FDFF,$00FFFE00,$000101FE,$FEFE0000,$FEFEFEFE,$FE000000,$00FEFEFE,$00000000
Data.l $FE00FFFE,$00000201,$FEFEFE00,$FE000000,$A0FE0D07,$120B00FA,$FEF2F6FE,$000000FF,$00FFFE00,$0000FFFE
Data.l $FFFE0000,$00000000,$02000000,$00000000,$00000000,$00000000,$00000000,$00000000,$FDFE0000,$00F2ED00
Data.l $0100FDA4,$FEFE0002,$00000000,$00000000,$00000001,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$FE000000,$000000FE,$00E59200,$FB000705,$000000F8
Data.l $00000000,$00000000,$00000000,$00000000,$00020000,$00000000,$00010200,$02000000,$01020001,$FFFF0000
Data.l $00EEEA02,$0002D28F,$00000200,$00020202,$00020000,$04030200,$02000000,$FF020001,$000000FF,$02020202
Data.l $00000202,$02020200,$00000002,$01020000,$FEFF0200,$02000000,$00000202,$02020200,$00000002,$9A020000
Data.l $F3F002F1,$02FDFE00,$01020001,$00000000,$00000102,$00000000,$00000200,$00000000,$0000FFFE,$FFFE0000
Data.l $00FFFE00,$FEF0F600,$1D006149,$FEFEFE2D,$FEFEFEFE,$0000FEFE,$0000FE00,$00DAE8FE,$FFFE0004,$0101FE00
Data.l $FE000000,$FEFEFEFE,$000000FE,$FEFEFEFE,$00000000,$01FFFE00,$000206FE,$00FEBBD2,$00000000,$FEFEFEFE
Data.l $0000FEFE,$0000FE00,$00A973FE,$FFFEEEEF,$00FFFE00,$FE000000,$000000FF,$00000000,$00000002,$02000000
Data.l $00000001,$00010200,$00FE0002,$6502FCF6,$0000009E,$02020202,$02020202,$00000002,$02CBDE02,$1000296D
Data.l $00010213,$00FFFF02,$02020000,$02020202,$02000000,$00020202,$00000000,$02000102,$7E00130F,$96BD0246
Data.l $02000000,$02020202,$00000002,$02000002,$13005638,$FAFD0216,$00000102,$01020000,$00000000,$02000000
Data.l $00000000,$FFFE0000,$00000000,$FE00FFFE,$5500F0F5,$0000FE7B,$FE000000,$FEFEFEFE,$0000FEFE,$FEF1F600
Data.l $15FE3871,$02010012,$FE00FFFE,$00000101,$FEFEFE00,$00FEFEFE,$FEFE0000,$0000FEFE,$FE000000,$FFFE0000
Data.l $151B0000,$006D91FE,$00FECADE,$FEFEFE00,$FE000000,$00FEFEFE,$9E650000,$FEF3F3FE,$000000FF,$00FFFE00
Data.l $00000000,$00020000,$00000000,$00000000,$00000000,$F3000000,$845500FF,$00000000,$00000000,$01010000
Data.l $00000000,$16002173,$0302000B,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$7A000F1A,$00000037,$00020200,$00000000,$00FF0000,$004B3000,$FF0000FE
Data.l $000000FE,$00000000,$00000000,$00000200,$00000000,$00000102,$FD020000,$1F2102F9,$02000000,$00000000
Data.l $02020200,$02010102,$EE00B3D0,$080602EF,$00000102,$01020000,$FFFF0200,$02000000,$02020202,$00000002
Data.l $02020202,$00000000,$00000200,$00000102,$03020000,$00030004,$0297BC02,$00000000,$02020200,$00000102
Data.l $3B020000,$F5FA0252,$02000000,$00000001,$00000000,$00000002,$FE000000,$000000FF,$F7F9FE00,$005536FE
Data.l $FEFE0000,$000000FE,$FEFEFEFE,$B3FE0000,$0A0D008B,$FE00FFFE,$000000FF,$00FFFE00,$000101FE,$FEFE0000
Data.l $FEFEFEFE,$FE000000,$00FEFEFE,$00000000,$FE0000FE,$000000FF,$00FFFE00,$FE0E0C00,$00FE87B3,$00000000
Data.l $FEFEFEFE,$0000FEFE,$4E31FE00,$00FAF9FE,$FFFE0000,$00000000,$02000000,$00000000,$00000000,$00000000
Data.l $00FDFB00,$00003520,$00000000,$00000000,$00000201,$C5D80000,$00090500,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$E6000603
Data.l $000000E5,$00000000,$00000000,$00000000,$001E1400,$000000FD,$00000000,$00000000,$00020000,$00000000
Data.l $00010200,$02000000,$1202FEFF,$0000001C,$00020202,$01020000,$FAFC0200,$00FEF902,$01020202,$00010200
Data.l $02000000,$FF020001,$000000FF,$02020202,$00000202,$02020200,$00000002,$00020000,$00010200,$02000000
Data.l $01000001,$FE040201,$00C6DB02,$02020000,$02020202,$02000000,$FF021D12,$000000FE,$00000102,$00000000
Data.l $00000200,$00000000,$0000FFFE,$FEFE0000,$0706FE02,$FE000000,$0000FEFE,$0000FE00,$FEFAFBFE,$00000202
Data.l $00FFFE00,$0000FFFE,$FFFE0000,$0A07FE00,$FE000000,$00FE0000,$00000000,$FE0000FE,$01000000,$0000FE00
Data.l $0000FFFE,$FFFE0000,$00000000,$FE0201FE,$0000EAF2,$FEFEFE00,$00FEFEFE,$13FE0000,$02FDFE1F,$FE000000
Data.l $000000FF,$00000000,$00000004,$00000000,$00000000,$00020000,$00F0F400,$00000000,$00000000,$00000000
Data.l $01000C09,$FFFF0000,$00010000,$00000000,$09060000,$00C1D700,$F3002A1A,$000000ED,$00FF0000,$0D000200
Data.l $00040012,$00010000,$00000000,$00000000,$00000000,$120000FE,$0000001E,$00000000,$00000000,$F3F90000
Data.l $00000100,$00000000,$00000000,$04000000,$00000000,$01020000,$00000000,$00FE0402,$2B00D7E7,$02020241
Data.l $02000000,$00000000,$1E1B0000,$02EEF400,$00000705,$00000000,$00090702,$CF00C0D8,$000102B5,$00000000
Data.l $010200FF,$00000000,$02140F00,$00000000,$00000000,$00000102,$FA02FFFF,$322100FE,$02000000,$00000202
Data.l $00000000,$00D2E202,$0000FE04,$00010200,$00000000,$00020000,$00000000,$00FFFE00,$FE000000,$D5FE0904
Data.l $000000BD,$00FEFEFE,$FEFE0000,$0000FEFE,$00643FFE,$FFFEF3F8,$00FFFE00,$FE000000,$05FE00FF,$150F000A
Data.l $FE150DFE,$0F00150D,$150DFE15,$00150DFE,$FFFE0100,$00FFFE00,$FE000000,$FA0000FF,$3D32FEF6,$000000FE
Data.l $FEFE0000,$FEFEFEFE,$FE000000,$05FEB8D3,$00000004,$0000FFFE,$00000000,$00000200,$00000000,$00000000
Data.l $07000000,$B0C8000A,$00000000,$00000101,$00000000,$00000000,$F1007B4F,$FF0000FF,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$F6EF0000
Data.l $008F5C00,$00000000,$00000000,$00000000,$C4000000,$0B0700A4,$00000000,$00000000,$00000000,$00000002
Data.l $02000000,$00000001,$02020200,$00FE0002,$0102C6DA,$00000001,$02020202,$00020000,$75580000,$02ECF002
Data.l $00000001,$00010200,$00000102,$01020000,$00010200,$02000000,$01020001,$00000000,$02000102,$00000001
Data.l $F0F70200,$02372D00,$00023320,$00000000,$02020202,$FB000202,$E3E402F8,$00060502,$01020000,$00000000
Data.l $02000000,$00000000,$FFFE0000,$00000000,$FE00FFFE,$A5000C0B,$0000FE6F,$FE000000,$FEFEFEFE,$00FFFEFE
Data.l $FE8A5900,$F3FE251A,$000000ED,$FE00FFFE,$000000FF,$00FFFE00,$0000FFFE,$FFFE0000,$00FFFE00,$FE000000
Data.l $FFFE00FF,$F4F80000,$000200FE,$00FEC880,$FEFEFE00,$FE000000,$00FEFEFE,$71A40000,$FE060DFE,$000000FF
Data.l $00FFFE00,$00000000,$00020000,$00000000,$00000000,$00000000,$06000000,$CCD30009,$00DEEB00,$00000000
Data.l $00000000,$00FEFF00,$8C000000,$2B1C00DA,$00EBED00,$0000FF00,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$EDF20000,$00050300,$0000F89F,$FEFE0000,$00000000,$02000000,$00000002,$0098B500
Data.l $00000E09,$00000000,$00000000,$00000000,$00000200,$00000000,$00000102,$01020000,$00010200,$020E1400
Data.l $0000387F,$02020200,$02020202,$00000202,$00000200,$00D28602,$E502855B,$EBF402EC,$02F8FB00,$0102FE00
Data.l $00000000,$02FF0002,$F500FBFE,$EBE402EF,$00654302,$0002F19A,$00000000,$02020202,$00000202,$00000200
Data.l $004A8B02,$0202070E,$00010201,$02000000,$00000001,$00000000,$00000002,$FE000000,$000000FF,$00FFFE00
Data.l $0000FFFE,$F2FE0705,$6BA000ED,$FE0000FE,$FEFEFEFE,$000000FE,$FEFEFEFE,$4D00FFFF,$FFB1FE7A,$008957FE
Data.l $EEFE180F,$EDEAFEEF,$FEEBEB00,$FDFEEEEC,$694300FC,$FEFDB1FE,$00009861,$FEFEFE00,$FE000000,$FEFEFEFE
Data.l $000000FE,$FEB1CDFE,$0900B9CA,$00FFFE0E,$0000FFFE,$FFFE0000,$00000000,$01000000,$ED000000,$4D10241C
Data.l $000102F1,$0000FFFE,$01020000,$00FFFE00,$FEEBE902,$3E019F6F,$FFFEFF60,$FE010202,$0000FEFE,$02020200
Data.l $000000FE,$00020000,$0000FE00,$02F8FB00,$0BFEF7FA,$00000011,$FE000002,$FE000000,$020202FE,$02FEFEFE
Data.l $FEFE0202,$020200FE,$FEDAE802,$1A002968,$01010212,$0000FFFE,$01020000,$00FFFE00,$130FB3F0,$0002DCE4
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$91001418,$92BAFF63,$00010200,$00000000
Data.l $00000000,$00000000,$FE00FEFE,$000000FE,$0000FF00,$0B000805,$00000011,$00FEFE00,$FE000000,$000000FE
Data.l $00000000,$00000000,$02020000,$00C7DC00,$19002769,$01000011,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000200,$00000000,$00000102,$01020000,$00010200,$02000000,$00000001,$12180201,$026F9C02
Data.l $00004488,$02020200,$00020202,$02020000,$02020202,$02000000,$00020001,$00000000,$02000002,$00000202
Data.l $02020200,$00020202,$02020000,$00000002,$0270A302,$19003A74,$02020213,$00000102,$01020000,$00010200
Data.l $02000000,$00000001,$00000000,$00000002,$FE000000,$000000FF,$00FFFE00,$0000FFFE,$FFFE0000,$00000000
Data.l $FE01FFFE,$D9FE1514,$015900C3,$FE9ABFFE,$00000000,$0000FE00,$00FFFFFE,$FEFE0000,$FEFEFEFE,$FE000000
Data.l $FEFEFEFE,$000000FE,$FE0000FE,$00000000,$B4CEFE00,$FE076200,$1AFE93BA,$02010015,$FE00FFFE,$000000FF
Data.l $00FFFE00,$0000FFFE,$FFFE0000,$00000000,$02000000,$00000000,$01020000,$00000000,$02000102,$00000001
Data.l $00010200,$02000000,$01020001,$0F0A0200,$02121000,$5902679D,$69A00001,$02D7E602,$00000101,$02020200
Data.l $00020202,$02020000,$02020202,$02000000,$AE02E8F0,$0660007F,$004D8B02,$0E020A06,$00010213,$02000000
Data.l $01020001,$00000000,$02000102,$00000001,$00010200,$00000000,$00040000,$00000000,$00FFFE00,$FE000102
Data.l $000000FF,$00010200,$0200FFFE,$FFFE0001,$00000000,$02000000,$0EFE0302,$FEFF0015,$FE9EC102,$FB009AB8
Data.l $25220200,$002B1DFE,$03021810,$F6F9FE06,$02DDEB00,$FAFEBDD2,$010A0002,$FE0E0902,$0102040A,$00FFFE00
Data.l $02000000,$FFFE0001,$00000000,$FE000102,$000000FF,$00010200,$0000FFFE,$00000000,$00000100,$00000000
Data.l $12241CED,$FFFEF14E,$00000000,$FE000102,$010200FF,$00FFFE00,$00000000,$01020000,$00FFFE00,$02000000
Data.l $FFFE0001,$FF000000,$FEFAFD02,$FE00FBFB,$FF0102FD,$000200FE,$05020403,$0301FE07,$02000000,$FFFE0001
Data.l $00010200,$0000FFFE,$01020000,$00FFFE00,$02000000,$FFFE0001,$00000000,$EE000102,$E4130FB2,$000000DC
Data.l $00000001,$00000000,$1CED0000,$F14E1224,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$EE000000,$E4130FB2
Data.l $000000DC,$01000000,$00000000,$00000000,$00000000,$00241CED,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $E4130000,$000000DC,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$07F5E200,$EB6A7644,$000000F3,$4E454900,$6042AE44
Data.b $82
EndDataSection

DataSection
ShutdownXP:
Data.l $474E5089,$0A1A0A0D,$0D000000,$52444849,$2A000000,$2A000000,$00000208,$5EA14A00,$0000000C,$4E527406
Data.l $00000053,$6E000000,$009107A6,$49E11400,$78544144,$14D601DA,$0000EB29,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000100,$00000000
Data.l $00000000,$2DC70000,$1A230927,$03F2F613,$FFFF0001,$00FFFFFF,$0000FFFE,$FFFFFFFE,$FF00FF00,$0000FFFF
Data.l $FFFF00FE,$FF00FF00,$FF00FFFF,$FFFF00FF,$00FF0000,$00FFFFFF,$FFFF00FF,$FFFFFF00,$FF00FFFF,$FFFFFFFF
Data.l $0000FF00,$FF00FF00,$FEFFFF00,$00FFFFFF,$F800FF00,$1FEFFFFD,$DEDE0620,$00D9D943,$00000000,$00000000
Data.l $00000001,$00000000,$53D40000,$171A2742,$FE3F37FD,$03FF1A16,$FEFF0004,$FFFFFF00,$FE000000,$000000FE
Data.l $00FFFFFF,$000000FF,$00FF00FF,$00FFFF00,$00FF00FF,$FFFF00FF,$00000000,$00FF00FF,$000000FF,$00FFFF00
Data.l $FF00FFFF,$000000FF,$00FFFFFF,$0000FFFF,$FEFE0000,$FF000000,$F3FE00FF,$DFDEFEF2,$DABCBAED,$AD4E211E
Data.l $000000AE,$01000000,$00000000,$53D80000,$3F3B213F,$004037F9,$02010604,$04030102,$00FF0000,$0000FFFF
Data.l $FFFF0000,$00FF0000,$FF000000,$000000FF,$00FFFFFF,$00000000,$FFFF0000,$0000FF00,$0000FF00,$FFFFFF00
Data.l $00000000,$0000FFFF,$FF000100,$FF00FF00,$000000FF,$00FF00FF,$00FF0000,$FEFFFF00,$F9FA00FF,$FEFBFDFE
Data.l $AAF5EBEA,$0B07CDAD,$00AEAD51,$00010000,$45DA0000,$312E212B,$025A49F4,$0301FF00,$FFFFFF04,$FFFDFD00
Data.l $0000FEFF,$FFFF0000,$00FFFF00,$000000FF,$FFFF00FF,$FF000000,$FF00FF00,$000000FF,$00FFFF00,$0000FFFF
Data.l $FF000000,$0000FFFF,$FF000000,$00FF00FF,$00FF0000,$0000FFFF,$FFFF0000,$0000FF00,$FF00FF00,$010200FF
Data.l $00040300,$FBFEFFFE,$EBECFFF9,$E99993E5,$DB4700FC,$000004DB,$0A070600,$FD3228F8,$FFFFF4F5,$FCFCFFFE
Data.l $00FCFCFF,$0000FF00,$000000FF,$00FEFEFF,$000000FF,$FFFE00FF,$00FF0000,$000000FF,$FFFF00FF,$00000000
Data.l $FF00FFFE,$0000FFFF,$00FFFF00,$0000FF00,$FFFF0000,$00FFFFFF,$FF000000,$FFFF00FF,$FF000000,$0000FFFE
Data.l $00FF00FE,$00FFFF00,$06020101,$02010006,$140607FF,$ECD82D31,$DBDB00F3,$00000004,$FA040612,$F1FE0805
Data.l $FEFFFFEF,$00FFFEFF,$00000000,$FFFF00FF,$FF000000,$0000FEFE,$FFFF0000,$00FFFF00,$FF010000,$FDFDFFFF
Data.l $FFFDFEFE,$000100FF,$00000000,$FFFF00FF,$FF00FEFE,$000102FF,$00010101,$00FF0100,$FFFF0000,$00FFFF00
Data.l $FF000000,$000000FE,$00FFFFFF,$0000FFFF,$F4F5FE00,$01030200,$19030203,$D7D11117,$04000000,$00000000
Data.l $F8FC0404,$00FFFFF7,$00FFFF00,$FF00FF00,$FFFF0000,$00FFFF00,$FEFF0000,$000000FE,$00FF0000,$FCFFFF00
Data.l $FFFFFFFD,$00050500,$0C020B09,$0908020D,$000302FF,$FB00FEFF,$F4F5FDFB,$FFF0F3FD,$FC01F7F7,$020102FA
Data.l $00020201,$0000FFFF,$FEFE0000,$FF000000,$FF00FFFF,$000000FF,$00FFFF00,$0301FFFF,$FBFC0003,$00FEFF05
Data.l $00040000,$FAFC0000,$F4F5FDFC,$010100FF,$01000101,$00000002,$00FFFF00,$0000FFFF,$FEFEFF00,$FE000101
Data.l $FBFEFCFC,$0B0800FA,$051F1C05,$14041F1D,$12110316,$FF080601,$FFFF0001,$FCFCFEFF,$FBF3F3FC,$EAFCE9EC
Data.l $DEE1FAE8,$03E8EAFF,$0504FAFB,$01010105,$FFFEFFFF,$FF0000FF,$FFFF00FF,$00FF0000,$FE00FFFF,$0000FFFE
Data.l $00F5F601,$0000FF00,$00000400,$FDFCFB00,$00F7F6FC,$FBFF0303,$F4F4FDFB,$00F9F9FE,$FF00FE00,$00000000
Data.l $FDFFFF00,$06FFFAFA,$2D290807,$07333009,$0E032623,$0100FE0E,$FEFCFBFB,$FDFFFCFD,$FFFFFEFE,$FF00FFFE
Data.l $0CFF0D0B,$1E1A000D,$FB1D1A00,$D1F6D8DA,$DDDDFECC,$02020307,$FE000103,$FFFF0000,$00FF0000,$0100FFFF
Data.l $08070201,$020A0A01,$00FFF9F9,$00000000,$00000004,$FBFDFDFC,$E9F9F6F5,$E2E3F9E8,$FEEAE9FA,$0100F9F8
Data.l $000000FF,$FC000000,$0DFFFEFA,$5654120C,$01454106,$FDF71B18,$EFEEFDFD,$FEFDFDFD,$FEFDFDFD,$FDFDFDFE
Data.l $FEFEFEFE,$FEFEFEFE,$FDFDFEFE,$FEFFFFFD,$24FF0603,$FFFEFB29,$FEDEDCF3,$010AC6CA,$00030500,$00FFFF00
Data.l $00000000,$02020100,$04090A02,$070A1615,$FF000209,$04000000,$FA000000,$D2F1FAF9,$D5D5F3D1,$FFEDEEFB
Data.l $0000FFFD,$00000000,$FD000000,$0EFE00FA,$5451140F,$FC58520C,$F1F81512,$FDFDFEF1,$FEFDFDFD,$0200FFFF
Data.l $0101FE02,$FD0101FF,$FDFB0000,$F9F9FCFD,$FDF9F9FC,$FDFDFDFD,$0000FEFD,$001E19FF,$ECF54F49,$C4C4F4F0
Data.l $05FF030C,$00FF0003,$00000000,$01000000,$E4000000,$0F0EFDE5,$000D06FF,$00040000,$EDF60000,$DEE7EDEE
Data.l $01F5F3FB,$03000003,$00000001,$FE000001,$0CFDFFFC,$5859120B,$FD666312,$F1F9110F,$FDFDFDF1,$03FDFDFD
Data.l $F8FB0707,$E3E4F2F8,$FAEBEBF7,$0301EFF0,$0E0E0404,$05131204,$FAF91313,$F8F8FDFA,$FDFEFEFD,$1901FFFE
Data.l $5A57061B,$F1F7F8F4,$040DCCCD,$01010200,$00000000,$FF000000,$FBF9FF00,$FFECEBF6,$00000919,$00000400
Data.l $F6F5F900,$00F5F2F7,$FE000102,$00000000,$00000000,$FBFCFF00,$383E0C00,$FB5A5710,$F0FC0D0B,$FDFDFEF0
Data.l $020000FD,$D3EB0303,$B3B4DED3,$02D4D4F0,$F601F1F1,$030303F6,$020A0A02,$3B131313,$36360D3B,$FA0B0AFC
Data.l $FF00F9F9,$F9FAFFFF,$061D1C04,$E7F34D4A,$E3E4FFE9,$0100060A,$00000000,$00000000,$FC0100FF,$01010101
Data.l $00000001,$00000004,$FC01FFFC,$FEFF0100,$00000000,$00000000,$FBFD0000,$1A1A0100,$FE4C4A0C,$EFF81918
Data.l $FCFCFDEF,$01FFFFFE,$BBE10000,$AEAEDDBA,$08D7D7FD,$0006F8F7,$00000300,$FE000001,$00FD0000,$D8D8EA00
Data.l $14CDCEF3,$1C035353,$F8F7FB1D,$FC000102,$2C05FAFB,$3938032D,$01EAB1F3,$0205F9FC,$00000001,$FF000000
Data.l $02FC0000,$00000600,$04000000,$FC000000,$FEFB00FE,$0000FF00,$00000000,$FEFF0000,$0200FDFF,$06353410
Data.l $F2F53432,$F9F9FDF2,$03FDFDFD,$B4DE0606,$A2A2DBB4,$13E2E408,$381500FF,$2D2E0737,$0000FFFF,$F8000001
Data.l $BABBEDF9,$F8E9E7F9,$F3E9C1C0,$606017F4,$FE1C1B04,$FE01F8F8,$090900FE,$F2363509,$DCF3CECD,$00050CDC
Data.l $00000001,$00FF0000,$0000FC00,$00000105,$00040000,$FDFB0000,$00FDFB00,$000000FF,$00000000,$00FEFD00
Data.l $06131501,$0BFA3231,$F0F0F90B,$02FEFEFD,$D0EB0707,$AEAFDCD0,$12E3E304,$00040000,$3D3D0301,$FF3A39FD
Data.l $0101FEFF,$FEFD0201,$FAE6E5FD,$FB0AEAE8,$CDCCF8FC,$151010ED,$05FB6564,$FDFD0004,$05FAFAFD,$20001F1E
Data.l $DCDCF521,$04FFFC04,$00000101,$0000FF00,$0100FFFD,$00000000,$00000200,$0000FC00,$FE01FFFE,$FFFE01FF
Data.l $01FFFE01,$0200FFFE,$1C001514,$F4F4F51D,$F8F8F8F7,$F0F8FAFA,$B7B7E0F0,$13DBDAFF,$00070000,$0000FE01
Data.l $FC0606FC,$02FD0202,$0201FD03,$F80303FB,$00F60909,$02020200,$F9FCFC08,$CCF6CECE,$080804CC,$00000000
Data.l $0E04FDFC,$2F2F100D,$FA1312FE,$FFFE00FE,$01FFFE01,$FE01FEFE,$01010100,$00000001,$00000002,$0400FFFE
Data.l $02040202,$02020402,$04010104,$19090101,$14140119,$F8F2F2F5,$FFFCF8F8,$DADAEDFF,$0ED5D5F2,$030DFBFB
Data.l $02020503,$00020203,$FE00FFFE,$FEFE00FE,$01FEFF00,$FFFEFFFF,$000002FF,$08020204,$EE070303,$D7D7FEEF
Data.l $02FDFD05,$04040304,$04050403,$0320210A,$00001212,$02020400,$04020204,$02030202,$01010102,$04000000
Data.l $FE000000,$010400FF,$00000001,$FF000000,$0502FFFF,$11110205,$FA0202F8,$FE00F8F8,$090907FE,$09EEEEFD
Data.l $020EF3F3,$01010702,$FE000000,$01020000,$00010000,$01000000,$01010000,$01010200,$05010104,$01030101
Data.l $FBFB0001,$02E2E2FF,$1A08EEEF,$FBFB0219,$FD050706,$08000C0D,$00000107,$01010104,$00FF0000,$00010500
Data.l $00000101,$00040000,$00FE0000,$02020400,$00000000,$00FF0000,$0303FE00,$FD040500,$0001FFFF,$010100FF
Data.l $FE000001,$F807F1F1,$01010AF8,$00020205,$FFFDFFFF,$010002FF,$FF0000FF,$00000100,$00010100,$04000103
Data.l $02040000,$00000302,$FD020200,$F101F2F2,$242609F1,$06F8F800,$0CFD0708,$0404030A,$04010101,$00010202
Data.l $0000FF00,$01000204,$00000001,$00000400,$01FFFF00,$FF020206,$00000000,$0000FF00,$010101FD,$01010201
Data.l $01000001,$01FF0000,$02040000,$01010602,$05020205,$FFFF0202,$FEFE04FF,$00000101,$01010101,$02020200
Data.l $03000003,$00FF0202,$02020400,$01000004,$01030101,$05060701,$00070808,$0806FF00,$0607FC07,$04020203
Data.l $02050101,$00000102,$040000FF,$01010002,$00000000,$00000004,$0500FFFD,$00FF0101,$00000000,$01010100
Data.l $FD010202,$0101FEFD,$00000101,$02FF0000,$0F0F0501,$03080905,$0104F5F5,$00000001,$030202FC,$06010202
Data.l $01010205,$02030403,$02040000,$0101FF02,$03010105,$01000000,$10100201,$031A1B0C,$01020506,$090A07FF
Data.l $020202F7,$0104FEFE,$01010401,$FF000001,$01040000,$01010200,$04000000,$FF000000,$02040000,$00000002
Data.l $00000000,$FD010101,$EFEFFFFD,$FFF9F901,$FE020302,$FDFCFEFE,$01121304,$ED000E0E,$020204EE,$04FFFF00
Data.l $0606FFFF,$08080306,$03010202,$00020203,$02020300,$040000FF,$FF040202,$060601FF,$0C27280A,$04FE2022
Data.l $08040302,$030B0B08,$F903FAFA,$020207F9,$00020206,$00FF0000,$FF020400,$000001FF,$00040000,$FFFE0000
Data.l $02020500,$00000000,$00000000,$FDFD0100,$FEE6E5F9,$1E03E9E9,$FAFA011D,$0CFBFCFF,$2FFC2525,$E6E5FD2F
Data.l $05000000,$FEFC0202,$070807FE,$020B0D05,$04040102,$FFFE0203,$01040405,$02050000,$FBFA0102,$0D121303
Data.l $12073538,$F8F70011,$08030403,$DFF50908,$EEED00E2,$0504040A,$00000202,$0000FF00,$FCFF0204,$00000001
Data.l $00000200,$00FFFE00,$04010104,$01040101,$01010401,$05020206,$E605F0F0,$070807E5,$08050606,$0E060507
Data.l $4647140C,$FA222202,$0103FCFC,$01010501,$05F6F705,$F904F9F9,$F8F802F9,$02F5F501,$0307F4F4,$FFFF0303
Data.l $0D030302,$47143C3D,$04010746,$0C0A0909,$F2FE100C,$CBCAEBF6,$0AF0F004,$01040505,$01010401,$04010104
Data.l $01010101,$00000000,$00000004,$050100FE,$00000404,$00000000,$FF000000,$F5FE0404,$D7D6FCF4,$FE393B07
Data.l $FF030B0D,$FF0101FE,$022E3107,$9CF4575A,$E7E7F99F,$F9030305,$CFEFB4B1,$0000F9D2,$020001FE,$D0FFFBFB
Data.l $05050FD1,$07000001,$6A1A3639,$1B1B0B68,$04FBF900,$0C070303,$CECCEA0E,$0FD7D6F6,$05090302,$00000305
Data.l $FF000000,$03050000,$0101FBFF,$04000000,$FE000000,$09040202,$00000006,$00000000,$01000000,$F9F90001
Data.l $03D7D7F5,$3E08DAD9,$F9FB003C,$02020204,$4D160203,$0808094B,$FDAFACF5,$DBFEDFDF,$D5D5FEDB,$01010101
Data.l $FF0100FF,$0A0A12FE,$0D161709,$6A183938,$36370D69,$03FAFA01,$03030A09,$F5F4FB04,$02BCBBE1,$0F12E6E6
Data.l $0404070E,$00000000,$00FF0000,$FD010301,$00010201,$00040000,$01FE0000,$09090403,$00010100,$00000000
Data.l $00000000,$FE080803,$C3FAF5F5,$2A2D05C4,$01191C05,$0203FCFB,$04050202,$F9505517,$BDF52C2E,$D8D6FDC0
Data.l $00E5E50A,$0301F8F8,$0E0E0303,$0C232308,$4C143536,$1C1B094C,$02FBFC00,$01010908,$FFFFFF02,$E9BFBFDD
Data.l $0414BCBC,$0C0C0F04,$00000003,$00000000,$0100FF00,$01FB0004,$00000001,$00000400,$03030300,$010A0A04
Data.l $00000101,$00000000,$00000000,$06010000,$DAD8FD06,$0CBDBBFA,$0F04585B,$FEFC010D,$02020303,$310A0200
Data.l $31311430,$F9EBE9FD,$EEFEE0DE,$060504EE,$0B1A1A09,$13072929,$00000113,$00FFFF01,$00000504,$00000000
Data.l $D6D1D1E5,$EB09A3A3,$131318EB,$01030307,$00000000,$00000000,$040100FF,$0201F9FE,$000000FB,$00000004
Data.l $05030609,$00000A0A,$00000000,$00000000,$00000000,$09090300,$F1FAFA01,$0EF3C4C1,$5155150F,$01141409
Data.l $0101FDFC,$02010301,$04050304,$27042424,$0000022A,$01000002,$00000000,$00000000,$00000000,$00000101
Data.l $FFFFFF00,$CCD3D3E6,$D3FF9595,$14141ED3,$0206060C,$00000000,$00000000,$FF000000,$FD040201,$FC000102
Data.l $04000000,$0B000000,$0A050306,$FFFF000A,$00000000,$00000000,$00000000,$05000000,$F7020A0A,$BAB9EFF7
Data.l $18FDFDEB,$23125051,$03030324,$02FFFE00,$01020202,$FEFE0202,$00020101,$00000001,$00000000,$00000000
Data.l $00000000,$FAFAFB00,$D7C4C4DE,$CDFCA5A5,$121222CD,$04090912,$FF000101,$000000FF,$00000000,$01000000
Data.l $00FB0403,$00F4FB00,$00040000,$070C0000,$090A0404,$00010000,$00000000,$00000000,$00000000,$00000000
Data.l $09090E00,$EFF9F904,$E7E4C1BF,$4243F7EA,$0E363616,$00011B1B,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$FAFB0000,$D9D9EAFA,$E8C2C2E1,$E607BEBE,$141421E6,$0408080F,$01010101,$00000001,$00000000
Data.l $00000000,$02000000,$02FDFA04,$000002FD,$00000400,$04070A00,$00090904,$00000100,$00000000,$00000000
Data.l $00000000,$00000000,$05000001,$FA090A0A,$DCDDF0FB,$EDE8E9EC,$2A0BC6C6,$2B2B122A,$0519190B,$05020A0A
Data.l $FFFFFF05,$F8FBFBFD,$DDEDF1F1,$D1D1EADD,$FFD7D7F2,$0118E2E2,$18181601,$0305050A,$01000000,$00000001
Data.l $00000000,$00000000,$00000000,$04020100,$F502FB03,$00000001,$00000004,$0504060B,$00000909,$00000001
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$0A0A0500,$0E0DFE07,$DBF2F9F9,$DEDEF6DB,$FFC6C6F5
Data.l $07FE0F0F,$0303FF07,$FEFFFFFF,$F5FEFBFB,$ECECFBF5,$15F2F202,$13110101,$07070D13,$01010105,$00010101
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$01040202,$010202FB,$04000000,$06000000,$0904FE01
Data.l $03010009,$00FF0000,$00000000,$00000000,$00000000,$00000000,$00000000,$04000000,$0B070000,$FFFF0E0B
Data.l $F8FBFBFA,$F5F8F8F8,$FEFEFBF5,$FF0000FC,$0002FFFF,$02020400,$0A030307,$05071818,$02020305,$00000002
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$02000000,$F8FE0503,$000101FB,$00040000
Data.l $03F40000,$FD021100,$000F0AFE,$0000FDFF,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$07000001,$FF0C0000,$0000FFFF,$00FEFEFE,$00FF0000,$00000100,$02010101,$00010101,$01010000
Data.l $FF000001,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$05030100,$E5DEEE03
Data.l $0000140D,$00000400,$F5E7F000,$FEE01422,$FE001D2A,$FEFE00FD,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$01000000,$00000001,$00000000,$0000FFFF
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$05030000
Data.l $F1F4FA03,$ED0ADDE4,$000000FD,$00000001,$D6000000,$24273347,$2C1E012B,$00FF0000,$0000FDFD,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$01000000
Data.l $05020001,$FFF5F900,$FAB7C1D4,$BCB04C02,$01000000,$00000000,$00000000,$374BD400,$010D0C29,$0E002B1E
Data.l $01000011,$FF00FF00,$FFFE0000,$0000FFFF,$0000FFFF,$01000000,$00000100,$00000000,$00000000,$00000100
Data.l $00000000,$00000000,$00000100,$01000000,$00000101,$00000100,$00000000,$01000000,$00000000,$00000000
Data.l $00000000,$FBFE0001,$F8E6EDFF,$07C3CFDA,$BEB14810,$00000000,$00010000,$00000000,$00000000,$C6000000
Data.l $0D071E21,$07141309,$F6FFFDF9,$FDF7FFFC,$FFFBF6FF,$F6FFFEF6,$FEF9FFFC,$00FF0000,$03000104,$01030002
Data.l $00010401,$04000102,$02020101,$00000400,$05000102,$01030002,$00020301,$03000002,$02040101,$00010300
Data.l $03010104,$02020001,$00010401,$E0FCFDFC,$E3030C06,$DED840EC,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $EA43A881,$9BE3814A,$00000000,$444E4549,$826042AE
EndDataSection

DataSection
RestartXP:
Data.l $474E5089,$0A1A0A0D,$0D000000,$52444849,$2A000000,$2A000000,$00000208,$5EA14A00,$0000000C,$4E527406
Data.l $00000053,$6E000000,$009107A6,$70090000,$00735948,$00C40E00,$01C40E00,$1B0E2B95,$E1140000,$54414449
Data.l $D601DA78,$00EB2914,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00010000,$00000000,$00000000,$06000000,$00003790,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$C970FA00,$00000000,$00000000,$00000100,$00000000,$06000000,$01FA3790,$00000002
Data.l $00FBF306,$00000000,$00000000,$00000000,$03000000,$00030001,$00010200,$02000002,$00030001,$00010200
Data.l $03000002,$01030000,$00000200,$FD000000,$FFFD0000,$0000FD00,$FD00FFFD,$FFFC0000,$00FFFE00,$FC0000FD
Data.l $00FD00FF,$FBFFFDFF,$00000614,$00000000,$FAFEFF06,$0000C970,$00000000,$00000001,$06000000,$01FA3790
Data.l $00000002,$00F01137,$0B070000,$000301FF,$FF0000FF,$01000000,$0102FF00,$FF000100,$00FF0000,$00020001
Data.l $FE000100,$01000100,$00000001,$000102FE,$00000001,$00FE0000,$0000FFFE,$FE00FFFE,$00FFFF00,$0001FEFF
Data.l $FE00FFFF,$00FEFF00,$FE01FFFF,$09FC00FC,$09E1D603,$00000000,$FF060000,$C970FAFE,$01000000,$06000000
Data.l $01FA3790,$00000002,$24F01137,$0300F727,$01FEFC01,$FE01FEFD,$FFFD01FF,$01FFFD00,$FE01FFFD,$FFFD01FF
Data.l $01FFFD01,$FE00FFFE,$FEFD01FF,$01FFFE01,$FC01FFFD,$FEFE00FF,$01FEFD02,$FE01FFFD,$FFFD01FF,$01FEFD00
Data.l $FD01FFFE,$FFFD01FF,$01FFFD00,$FD01FEFE,$FFFE01FF,$FE030600,$F2FA0415,$FFE4FFE2,$0000000A,$FAFEFF06
Data.l $0004C970,$00000000,$00000000,$20ED143D,$01FEFA26,$01FFFE01,$FE01FFFE,$00FE0100,$0000FE01,$FE01FFFE
Data.l $FFFD01FF,$01FFFE01,$FD01FFFE,$FFFE00FE,$01FFFD01,$FD01FEFD,$FFFD01FE,$01FFFD00,$FE01FFFD,$FEFD01FF
Data.l $00FFFD01,$FE01FFFD,$FEFD01FF,$01FFFD01,$FD01FFFD,$FEFE00FF,$01FFFD01,$F003FDF8,$170D06F9,$F6E51AFB
Data.l $000A03E6,$00000000,$00000400,$00000000,$1F000000,$01FFFA24,$01FFFE01,$FD01FEFD,$FFFD01FF,$00FFFD01
Data.l $FC01FFFE,$FFFD01FF,$01FFFE01,$FD01FEFD,$FFFE00FF,$01FFFD01,$FD01FFFD,$FFFE01FF,$02FFFC00,$FE01FFFD
Data.l $FEFD01FF,$00FFFD01,$FE01FFFD,$FFFD01FF,$01FFFE01,$FD00FFFD,$FEFD00FF,$01FFFD01,$FD01FFFD,$FFFE01FF
Data.l $06F9EF00,$00FF1611,$000000ED,$00000000,$00000004,$41000000,$01FDE50B,$01FFFF03,$FD01FEFD,$FFFF01FF
Data.l $FF000000,$01010001,$01030000,$00000000,$01FFFF01,$0102FF01,$00FFFD01,$FD00FF03,$00FEFFFF,$0101FD01
Data.l $FDFEFF04,$FFFE01FF,$0102FE00,$FF01FFFD,$FFFD01FF,$00FFFE00,$FE01FFFE,$FFFD01FF,$01FEFE01,$F501FFFB
Data.l $FEFB04FB,$01FEFF00,$EF00FE00,$000005FB,$000000FE,$04000000,$00000000,$0E0B0000,$0400FEFE,$FD01FEFE
Data.l $FFFE01FF,$FF020401,$01FE0207,$00FF0000,$00000000,$00000000,$00000000,$00000000,$00000000,$000000FF
Data.l $FF00FE00,$0100FFFF,$00000001,$00000002,$00000000,$000000FF,$00000000,$00000000,$00FF0000,$00000000
Data.l $F8000000,$F0DB02FC,$0AF0DF0C,$0001FEF9,$FFFFFFFE,$00000000,$00000000,$00040000,$00000000,$0001FE00
Data.l $FE01FEFD,$FFFE0100,$00000001,$FCFFFF00,$000001FD,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$0000FF00,$120B0308,$FEFA1607,$EBFAF0F9,$00FCFFFD,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$03070000,$F3132AFE,$E402FAF6,$FFFE09F1,$00FE0000,$00000000,$00000000,$00000400
Data.l $00000000,$FE01FFFD,$00FE01FF,$00FFFD00,$FE000000,$000002FF,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$01000000,$2DFD00FD,$1B54360E,$E5F9EA66,$E19AE5AC,$0103DAF6,$00000003,$00000000
Data.l $00000000,$FF000001,$00000000,$00000000,$00000000,$15000000,$F1E8FA09,$02FDFA07,$0000FF00,$00000000
Data.l $00000000,$00000004,$FD000000,$FFFD01FF,$0000FE01,$FE01FEFD,$00FF02FF,$00000000,$00000000,$00000000
Data.l $FE00FEFF,$01010001,$00000200,$00000000,$01FF0000,$0B230500,$360E2B2F,$CDF2FC1F,$F2D8C9EF,$030205D9
Data.l $00000000,$00000000,$FEFFFEFF,$02000100,$00000200,$00000001,$00000000,$FFFF0000,$00FF0101,$00FFFF00
Data.l $0000FFFD,$00000000,$04000000,$00000000,$FFFE0000,$00FFFD01,$FC0100FE,$FDFC01FF,$0100FF01,$00000000
Data.l $00000000,$090207FF,$F7160717,$F9ECF5FD,$030102EB,$00000000,$0001FF00,$01FEFC02,$01000000,$FFFE0200
Data.l $03FDFA04,$0002FFFF,$00FF0000,$060206FF,$FB1E091C,$F9EAFBFE,$FAFEFBE8,$00010000,$00000000,$01FDFC00
Data.l $00FFFEFF,$FE0001FE,$00000000,$00000000,$00040000,$00000000,$00FFFE00,$FE01FEFD,$FEFE0100,$02FEFA01
Data.l $0000FFFF,$00000000,$02000100,$5B2B0C27,$F5E26020,$ACE5B1E0,$02E1F6E3,$00FF0201,$01000200,$0001FEFD
Data.l $00010000,$01FEFD01,$FF01FDF9,$FFFF01FF,$080307FF,$543C1033,$FBF15A1C,$93DE99F0,$02E0F6E2,$00000100
Data.l $00000000,$0001FEFC,$FE0001FE,$00FF0000,$00000000,$00000000,$00000400,$00000000,$FD01FFFD,$00FE01FF
Data.l $01FFFC01,$FE01FDFA,$000001FF,$FF000000,$0D030002,$0A3115FF,$3D123639,$9F160510,$F4DD9BDF,$020102DD
Data.l $FB010001,$0000FFFE,$00000000,$F901FEFC,$FEFD02FD,$0A030900,$64401339,$0B216922,$CFE4CF22,$F807FBFF
Data.l $010300FC,$00000002,$FB000000,$FEFF01FE,$FFFF0000,$00FFFE00,$00000000,$00000000,$00000002,$FE000000
Data.l $FFFE01FF,$01FFFE01,$FB01FFFD,$FDFA02FD,$02FDFA02,$F603FDFA,$E7CAFEFC,$A8D1A6D0,$46F6F5F5,$23654818
Data.l $290B226C,$F800FCF8,$FEFB01FC,$00000000,$FD010100,$FDF902FF,$0D010501,$65461540,$0B216B22,$D4E4D422
Data.l $D997CB93,$FEFCE1EE,$02FDFA04,$FA02FDFA,$FDFC02FD,$FFFE0001,$0000FE00,$000000FE,$00000000,$04000000
Data.l $00000000,$FFFE0000,$01FFFD00,$FD0000FE,$FEFA01FE,$01FFFD02,$00000000,$01000000,$EBFDE402,$F89EDE98
Data.l $2D59FAFD,$44174454,$92050003,$F1D397DA,$F8FAF3D6,$F8FFFEFF,$F7F1F8FA,$05FEFDF7,$6641153D,$0A1E6824
Data.l $CFE2CD1D,$CD92C98D,$0B00D000,$03FE0200,$00000000,$00000000,$02FEFB00,$0000FEFF,$FF0000FE,$00000000
Data.l $00000000,$00030000,$48030000,$F609181C,$FE050D02,$FFFC01FF,$04FBF402,$FD02FEFC,$FFFD01FF,$01FEFD01
Data.l $F3040200,$EDD6F802,$FBF4FCD8,$24221025,$F3E12410,$D0EDC8E6,$F2FEF4FC,$E3C6F1EA,$CAEFC3CA,$58F7FEF1
Data.l $133B531C,$CCE0C837,$CB91C988,$0AFED2FE,$02FFFF02,$FD01FFFD,$FFFD01FF,$01FFFD01,$F602FBF8,$FEFF02F4
Data.l $FFFE0000,$03010300,$B8FDFF00,$000004E5,$00000000,$FE01FEFE,$00FE00FF,$01FEFC01,$FD02FDF9,$000001FE
Data.l $00000000,$00000000,$02000000,$F606EA06,$E7AEE59E,$0C1EEBF6,$D1F3C81C,$CB0800FF,$DEC9D6EF,$010401D1
Data.l $03051102,$D9B10405,$E6E2E4BB,$D3C7E8BF,$0A01DBFF,$01FD0104,$00000000,$00000000,$00000000,$FC000000
Data.l $FF0001FD,$00FE0000,$0000FE00,$00000000,$00000000,$00000004,$FD000000,$FFFD00FF,$0100FE01,$FA01FEFD
Data.l $FEFC01FD,$FEFFFE02,$00FDFFFC,$00000000,$00000000,$F5010000,$E59BF304,$00F903B0,$04071003,$0900070A
Data.l $080A0104,$FD00FF00,$00FD00FF,$CAEBBA00,$02C1F4B4,$0903060D,$FEFB0107,$00000000,$00000000,$00000100
Data.l $01040204,$FEFB0100,$00FEFF00,$0000FE00,$000000FF,$00000000,$04000000,$00000000,$FFFE0000,$01FFFD01
Data.l $FD0200FE,$FEFB01FE,$03FEFD01,$42190A1B,$03073517,$00000006,$FCFFFFFF,$0102FDFF,$ECF7E601,$EED3EDC8
Data.l $FDFEF1F9,$00000000,$00000000,$00000000,$00000000,$1F0A0AFF,$11332014,$0F061228,$00FFFFFF,$00000000
Data.l $00000000,$C3F4FBF1,$FAEFCEEA,$00FDFCF2,$0000FE00,$FE0000FF,$00000000,$00000000,$00040000,$00000000
Data.l $02FEFE00,$FE02FEFD,$00FC0000,$01FCF900,$560C040C,$286F4A1E,$05020659,$FF000000,$FFFDFF00,$010001FE
Data.l $89E7F5E2,$DEA6A2D6,$040204B7,$00000000,$00000000,$00000000,$FC000000,$194BFDFF,$54276C42,$FF0E0511
Data.l $0000FF00,$00000000,$F1010000,$CF79F4FB,$C5E6B694,$FEFBFDFB,$FE00FEFE,$FFFE0000,$00010000,$00000000
Data.l $00000400,$00000000,$0201FFFD,$00FE01FE,$02FEFD00,$FA03FEFB,$F5FD01FB,$01FD05FA,$00000003,$00000000
Data.l $03000401,$06010101,$F6FF00FB,$02FEFCFC,$0002FFFE,$00000000,$00000000,$00000000,$FEFE0000,$05FB0AFE
Data.l $0E0C0113,$FF000D06,$00000000,$00000000,$000A0000,$03FB0604,$FC02FCFC,$FF0001FD,$00FE0000,$0000FE00
Data.l $00000000,$00000000,$00000004,$FE000000,$FFFE00FF,$0100FD00,$FE01FEFD,$FCF001FD,$B6D9A2F6,$04E1E9E3
Data.l $00000300,$00000000,$01000000,$F9E80101,$DDF4C6EE,$FE040200,$00000100,$00000000,$00000000,$00000000
Data.l $03FF0000,$E2BADBA8,$0511DDE5,$FFFFFF0C,$00000000,$00000000,$F9FFF500,$F7D3F1BD,$FDFFFBFE,$00FD0000
Data.l $00FFFE00,$000000FF,$00000000,$04000000,$00000000,$FFFD0000,$01FF0201,$FE0100FD,$FC0001FF,$FEFDFEFF
Data.l $9FEDFDE0,$FE00B8DF,$000000FF,$00000000,$FF000000,$0B0803FF,$000F0C0B,$000000FC,$FF0000FF,$0000FF00
Data.l $01000000,$01000000,$E1000000,$EDDCEEFC,$FBFB00E1,$00010000,$00000000,$00000000,$00010300,$03000B0B
Data.l $FFFC0003,$00FFFE00,$FE0000FF,$00000000,$00000000,$00040000,$00000000,$00FFFE00,$FE01FFFD,$FEFE0100
Data.l $00FCFF01,$0000FD00,$0A000400,$0000000F,$00000000,$FE000000,$1D1023FD,$194F2A68,$DBA6140B,$C5DFB6BA
Data.l $02010200,$00FF0401,$FDFEFFFF,$4D000000,$22543D21,$DEEED441,$E9B8DBA2,$0100ECF5,$00000003,$00000000
Data.l $FF000000,$00FC00FF,$0000FE00,$FE0000FF,$FFFE0000,$00000000,$00000000,$00000400,$00000000,$FD01FFFE
Data.l $00FE01FE,$00FFFD01,$00FFFD00,$000000FD,$FF000000,$00000000,$FE000000,$1E1125FE,$5461327D,$FCFB4122
Data.l $D0E2C9FA,$38FBFB00,$285F321B,$F3FAF04A,$D7B8D8A2,$0D2FDAEA,$43225921,$14391DF1,$D1910F06,$EBF4E6A9
Data.l $00020200,$00000000,$00000000,$00000000,$FE00FFFD,$FFFE0000,$0000FE00,$00000000,$00000000,$00000003
Data.l $0B1C4803,$0D01FA03,$0000FD05,$F502FDFC,$FCFE02F2,$00FE0001,$0000FE00,$FE0000FE,$1F1027FF,$52663882
Data.l $FDFE4023,$AFD0A4FB,$F0B3D39F,$2353F9FB,$5E347942,$D122112D,$E9D2DBEA,$E9EFEBDA,$310D0619,$132C2A19
Data.l $0B050E22,$F2DEEBD3,$FE00F4F7,$00FE0001,$0000FE00,$FD0000FE,$FFFA0000,$0000FD00,$0B0000FF,$FF000302
Data.l $04E5B8FD,$00000000,$FFFE0000,$00FFFD01,$FE0100FD,$FDFF00FF,$00FC00FF,$00000000,$00000000,$20132900
Data.l $4A683A86,$FAF73921,$ABCCA1F6,$E1A9CE8E,$0300F0F8,$06010903,$09020103,$020C0703,$00FC0008,$7DE6F0D7
Data.l $FCFA98C2,$4C2E54FA,$094A295F,$C8850703,$E6F1E0A1,$00010000,$00000000,$FFFD0000,$00FFFE00,$FE0000FF
Data.l $00000000,$00000000,$00020000,$00000000,$00FFFE00,$FE01FFFD,$FEFD01FF,$00FC0001,$00FFFC00,$FC00FFFC
Data.l $00FD03FF,$4F20102C,$F9F63E24,$A5C79AF5,$E1A5C98A,$0000EFF5,$FFFC0005,$00FFFEFF,$01010000,$01FF0101
Data.l $00FFFC00,$F2D90500,$99C27EEA,$05ADCDA4,$295C0100,$23122E49,$0001FD01,$FC00FFFC,$FFFC00FF,$00FFFC00
Data.l $FE0000FE,$FFFF0000,$00000000,$00000000,$00000400,$00000000,$0001FFFD,$00FD01FF,$01FEFE01,$00FFFD00
Data.l $000000FD,$00000000,$D4FFFFFE,$B585D6E3,$F0F7E888,$E8C8DDAD,$0300F4FA,$FEFD0004,$00FFFE00,$000000FF
Data.l $01010100,$0001FF01,$0000FFFD,$040100FE,$82EEF4DE,$EEE29EC3,$120A18E2,$00DDE8DE,$0100FEFB,$00000000
Data.l $00000000,$FE0000FD,$FFFF0000,$0000FE00,$00000000,$00000000,$00000004,$FD000000,$FE0001FF,$0100FD01
Data.l $0001FFFD,$FC00FFFD,$00000000,$FF000000,$EFDB0000,$B4CF8EE8,$F3FFFFFC,$0200FAFD,$00FC0004,$00000000
Data.l $FEFFFFFE,$000000FF,$00000000,$FC0000FD,$00FF0000,$00000000,$F4E20500,$B6CF94F1,$ED030206,$00FFF9FB
Data.l $00000000,$00000000,$FE000000,$FFFF0000,$0000FD00,$000000FE,$00000000,$04000000,$00000000,$FFFE0000
Data.l $01FF0001,$FD0000FD,$FCFF00FE,$FFFC0000,$00000000,$00000000,$0000FC00,$00FAFFEF,$01000100,$FFFE0002
Data.l $00000000,$FD000000,$FCFBFDFE,$00000000,$FDFF0000,$FFFC00FF,$00FFFF00,$00000000,$03000000,$00F9F8EE
Data.l $0100FF00,$00000002,$00000000,$00000000,$00FE0000,$0000FD00,$FE0000FF,$000000FF,$00000000,$00040000
Data.l $00000000,$0000FE00,$FE01FFFF,$FEFE0000,$FEFD0001,$00FFFC00,$00000000,$00000000,$00000000,$00000000
Data.l $000000FF,$00000000,$00000000,$01FE0000,$BFCFDECC,$FCF7C0D7,$D0DFCEF9,$0002FD00,$0000FFFF,$00000000
Data.l $00000000,$00000000,$FF000001,$00000000,$00000000,$00000000,$0000FF00,$FE0000FE,$00FE00FF,$00000000
Data.l $00000000,$00000400,$00000000,$0101FEFD,$00FE01FE,$0101FE00,$00020601,$0100FDF5,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$C902FF00,$A962DAE3,$FFFFFE81,$00F8F9E9,$FF0002FE
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$FE0000FF,$00FE00FF
Data.l $0000FF00,$00000000,$00000000,$00000004,$FD000000,$1701FDF2,$0100FD00,$000103FE,$F6000214,$FEF600FE
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$FCF80000,$F1F8E0FC,$00000000
Data.l $01000301,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000001
Data.l $00FE0000,$0000FF00,$0000FFFE,$00000000,$04000000,$00000000,$00000000,$00FDFD00,$FD0102FE,$09FE01FF
Data.l $061F0001,$00FEF600,$FF00FFFC,$00FF0000,$00FF0000,$FF0000FE,$00FF0000,$0000FE00,$FF000000,$00FF00FF
Data.l $0004FE00,$FF00FFFF,$00FF0000,$00FFFE00,$FF0000FF,$00FF0000,$00FF0000,$FF0000FE,$00FE0000,$00000000
Data.l $FF000000,$00FE00FF,$0000FF00,$FC0000FE,$000000FF,$00000000,$00040000,$00000000,$00000000,$FFF8E7FC
Data.l $FFFD0B19,$00FFFF01,$00000500,$FF00020C,$00FD0000,$00FFFF00,$FE0000FE,$FFFF0000,$0000FE00,$FF0000FE
Data.l $01FE00FF,$0000FE00,$FE0000FF,$00FE0000,$00FFFF00,$FF0001FE,$FFFE0000,$0000FE00,$010001FF,$FFFF0000
Data.l $00000000,$FE0000FF,$00FE00FF,$0000FF00,$FE0000FE,$F10010FF,$001600F0,$00000000,$00000200,$C970FA00
Data.l $060B0EFB,$E8FDFBF7,$FFFCFFF8,$0000FE00,$0000FFFF,$00FF0000,$00FF0100,$FF0000FF,$FF000000,$0000FF00
Data.l $000000FF,$00FF0000,$0000FF00,$FF000000,$00FF00FF,$00FFFF00,$FF0000FF,$FFFE0000,$0000FE00,$FE0000FF
Data.l $FFFF0000,$0000FE00,$FE0000FF,$00FE00FF,$0000FF00,$FD0000FE,$F0FD10FE,$061628F0,$70FAFEFF,$000000C9
Data.l $00000001,$00000000,$90060000,$F5F20537,$F5000000,$0A000807,$01000004,$00FFFE00,$FE0000FE,$FFFF0000
Data.l $0000FE00,$FF0000FE,$00FF00FF,$0000FF00,$FE0000FE,$00FF00FF,$00FFFE00,$FE0000FE,$FFFF0000,$0000FE00
Data.l $FF0000FE,$FFFE0000,$0000FF00,$FD0000FE,$00FF00FF,$0000FF00,$0110FFFE,$000000F3,$061628F0,$70FAFEFF
Data.l $000000C9,$01000000,$00000000,$00000000,$00000000,$00379006,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $70FA0000,$000000C9,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$9E4F0100,$737DE91A,$0000001C,$4E454900,$6042AE44
Data.b $82
EndDataSection

DataSection
WinLogoXP:
Data.l $474E5089,$0A1A0A0D,$0D000000,$52444849,$32000000,$2D000000,$00000608,$38BFEC00,$000000FF,$58457419
Data.l $666F5374,$72617774,$64410065,$2065626F,$67616D49,$61655265,$C9717964,$00003C65,$54692203,$4D587458
Data.l $6F633A4C,$64612E6D,$2E65626F,$00706D78,$00000000,$70783F3C,$656B6361,$65622074,$3D6E6967,$BFBBEF22
Data.l $64692022,$3557223D,$704D304D,$69686543,$65727A48,$544E7A53,$636B7A63,$3F226439,$783C203E,$706D783A
Data.l $6174656D,$6C6D7820,$783A736E,$6461223D,$3A65626F,$6D3A736E,$2F617465,$3A782022,$74706D78,$41223D6B
Data.l $65626F64,$504D5820,$726F4320,$2E352065,$30632D30,$36203036,$33312E31,$37373734,$3032202C,$302F3031
Data.l $32312F32,$3A37312D,$303A3233,$20202030,$20202020,$203E2220,$6664723C,$4644523A,$6C6D7820,$723A736E
Data.l $223D6664,$70747468,$772F2F3A,$772E7777,$726F2E33,$39312F67,$302F3939,$32322F32,$6664722D,$6E79732D
Data.l $2D786174,$2223736E,$723C203E,$443A6664,$72637365,$69747069,$72206E6F,$613A6664,$74756F62,$2022223D
Data.l $6E6C6D78,$6D783A73,$68223D70,$3A707474,$736E2F2F,$6F64612E,$632E6562,$782F6D6F,$312F7061,$222F302E
Data.l $6C6D7820,$783A736E,$4D4D706D,$7468223D,$2F3A7074,$2E736E2F,$626F6461,$6F632E65,$61782F6D,$2E312F70
Data.l $6D6D2F30,$7820222F,$736E6C6D,$5274733A,$223D6665,$70747468,$6E2F2F3A,$64612E73,$2E65626F,$2F6D6F63
Data.l $2F706178,$2F302E31,$70795473,$65522F65,$72756F73,$65526563,$20222366,$3A706D78,$61657243,$54726F74
Data.l $3D6C6F6F,$6F644122,$50206562,$6F746F68,$706F6873,$35534320,$63614D20,$6F746E69,$20226873,$4D706D78
Data.l $6E493A4D,$6E617473,$44496563,$6D78223D,$69692E70,$46453A64,$43453132,$34333134,$31313838,$45383145
Data.l $38443834,$31353044,$39303642,$20223133,$4D706D78,$6F443A4D,$656D7563,$4449746E,$6D78223D,$69642E70
Data.l $46453A64,$43453132,$34333234,$31313838,$45383145,$38443834,$31353044,$39303642,$3E223133,$6D783C20
Data.l $3A4D4D70,$69726544,$46646576,$206D6F72,$65527473,$6E693A66,$6E617473,$44496563,$6D78223D,$69692E70
Data.l $46453A64,$43453132,$34334633,$31313838,$45383145,$38443834,$31353044,$39303642,$20223133,$65527473
Data.l $6F643A66,$656D7563,$4449746E,$6D78223D,$69642E70,$46453A64,$43453132,$34333034,$31313838,$45383145
Data.l $38443834,$31353044,$39303642,$2F223133,$2F3C203E,$3A666472,$63736544,$74706972,$3E6E6F69,$722F3C20
Data.l $523A6664,$203E4644,$3A782F3C,$6D706D78,$3E617465,$783F3C20,$6B636170,$65207465,$223D646E,$3E3F2272
Data.l $56D57475,$E7110000,$54414449,$5ADCDA78,$D754706B,$FB9FFF7D,$2D2FBBDA,$9090AC7A,$08042484,$08402464
Data.l $940C0628,$DB5DB187,$DA49C675,$4933A4F1,$FC64933B,$3A7693A1,$687C99D3,$74CC9992,$A699A5FA,$D4926776
Data.l $426E34F1,$0C99C69D,$3CD76D76,$C020D3CD,$4092C902,$DEAC4246,$DDF7DABB,$FFD3CFBD,$48577739,$AFE02EF2
Data.l $DCE8E65D,$B9EF7BBD,$FDF9DFFF,$2E738FFE,$94080004,$BF32D0FE,$2081E2D1,$1142B009,$BC9F3AE5,$05543A82
Data.l $89110807,$C4EC371D,$1D66668C,$2F7E59DB,$E2F63659,$EE721E1E,$88F21F91,$50005FEF,$7B644AA1,$39B5DA95
Data.l $576DEF28,$40953D95,$12040636,$65EA6DB6,$B1120BF7,$CD8922F2,$69F830D8,$6CFF78D6,$38777B54,$063C4DA6
Data.l $E0E77298,$CE3C8171,$E42BB48D,$C2B23C6F,$5E6DB5F7,$0275EBF1,$2829116C,$645BC116,$D9724402,$420E2221
Data.l $E020A358,$C9FE224D,$9B3D9902,$3B7CDF36,$C197F992,$8944ECB9,$ECF52B09,$92840B2F,$29423465,$9089158A
Data.l $79689E37,$7F9535BF,$69E0273A,$25410045,$04042A20,$802C8204,$2F6040C8,$70168C08,$71CEB111,$D214A140
Data.l $76FFEE40,$7FA3F736,$55FF981F,$0FEB6F2A,$25FA5899,$65F0A048,$541AD7F4,$A1B67F9B,$29E21079,$6343E0AF
Data.l $2107023D,$58651361,$CC882300,$A40E0471,$127DC380,$0B2D11FE,$B9D515BC,$BCFBDEE7,$352E786B,$2FA0C652
Data.l $CE4B37E3,$5858E549,$3857640C,$38203BB0,$0687CD5E,$3D9005F9,$46451005,$8205C164,$211972F2,$486C102E
Data.l $00206006,$33E05455,$1DBBED5D,$B6364CCD,$BADE68AD,$D4E7B5AB,$977F07EF,$3B97E6CD,$DC847935,$23C0A968
Data.l $9691FA2D,$754761BB,$162069E0,$14117E48,$879200AF,$0880C2B1,$3319936E,$E615F702,$25922027,$5E514BEE
Data.l $CE0F9F41,$A29C4E5D,$7E8ED1D4,$3BABEB65,$BBFDAA5F,$1FDF2EA6,$FE3DBECE,$C8DE81C3,$E972170D,$1CE258E8
Data.l $58411455,$BF7AB1B5,$036AF15F,$913FC757,$C2DF38CA,$AE4FA567,$BBC2B4D8,$A032D6C7,$F306C8A8,$0F45EC0D
Data.l $02F6E403,$64288BCA,$A8C29029,$70010384,$617DAA3C,$59067234,$EABBDB13,$A7A74A9F,$7ECEBC21,$B5EF85F1
Data.l $AD74D91E,$A5E0D8F6,$37B8FFB9,$8A90BB14,$812D266B,$E1C8C241,$B7AA290B,$D6F4E94A,$9A7A0EFB,$EF695F83
Data.l $99EEDC6E,$408E7E30,$A2254B2E,$B63612C4,$AABBFB54,$2BCD6865,$8C6082E0,$231E22A8,$184EFC08,$911BF83B
Data.l $76F0408B,$B08F81F1,$82412491,$DEE179A9,$95FCC8F5,$B5AA96FA,$5BBDAB75,$FC0779A2,$C07204B2,$EDDFAEF4
Data.l $EEEAE6F9,$CE4CDFD5,$468ADD34,$A3D3BD72,$524C81A9,$B50E398F,$DEBD4A2D,$58A34F2A,$015A7721,$C554C3A9
Data.l $09228EB5,$CFA23A16,$AEB7682B,$DCBCBFDC,$B9D24A47,$69E2AEB7,$2A44D889,$08232130,$20222BC9,$2BAF6BF4
Data.l $44605231,$05C8DC90,$0D9D9C8B,$B85457E9,$D45DA7D6,$BBB92B6C,$EAA8E1B3,$2BAC8F07,$E484BD78,$0B036E99
Data.l $F4E82AC8,$D59D28D4,$1BC8611D,$21419A00,$99A03867,$164F21AC,$0EB1CB00,$7CC3D0AA,$22267352,$8BABF1C3
Data.l $09529081,$D8328FCB,$6FDBE352,$90839D51,$44464358,$CA84015F,$23070080,$23611914,$87304316,$8BC64141
Data.l $9E4E0D4E,$F67BDF62,$0F641EB4,$4B107150,$888410B0,$093CA2D7,$C14E0E5A,$5BA028A9,$6C14D1A1,$0E3610CC
Data.l $79C2D0E8,$429B396C,$2A4327C8,$67250DA2,$408B7733,$9AD93ACA,$E8DADA90,$9C1DBB13,$7123D115,$2D393149
Data.l $03815080,$2B386064,$2C840BB2,$D4A02202,$C4C467E6,$F3B9A1D9,$AABFB0A1,$3CFC23AD,$E48A628B,$1031C107
Data.l $8D804E00,$D051FF0D,$1C0756D1,$BCCD9434,$062DE78D,$ED0406C6,$788C0C36,$4FA5400F,$91032231,$B66E680B
Data.l $600B231C,$7BFD85B6,$CBE3A27D,$32DC2CC8,$A9C7C6C7,$08389CAE,$846050AF,$A75C0B49,$85D08CE7,$09C3EBF0
Data.l $EF597AB8,$E7DA688B,$3DAE763B,$BAAABF54,$A052B74E,$9BFB3078,$7C510722,$A6D9C53C,$302C8E8A,$8005C026
Data.l $39F42C80,$631C2C59,$3C111553,$DF4C4916,$1E5D5C4D,$9154A17E,$F07D64F6,$74C28DB0,$D4EBACC3,$20A570DC
Data.l $060802A7,$EA7875CA,$2C58BA3A,$98CB507E,$4CDF4E3F,$4F395932,$267A696C,$9582F010,$4C8283CC,$BA1B4809
Data.l $B80303C7,$20741C74,$62442C03,$158C2031,$A03311EC,$A16080AB,$F20954AC,$3A246351,$DA28189E,$7270952C
Data.l $6D158C7E,$756AE6E5,$DDE4E1AF,$118A5799,$CD8EB88A,$81611C7B,$568EEA11,$C158C204,$95132C82,$E6FA8FAD
Data.l $5D0C12CE,$EEB4775B,$8B206E63,$E05E341E,$4F040272,$4477DA0B,$28CABF1B,$C92C0B2B,$33C71306,$45486C0A
Data.l $2AAEA159,$BD138ABC,$0CB5E895,$7368AE6B,$73B23CD9,$52BBBFA5,$2D164686,$764DC944,$449222C0,$9BC5A417
Data.l $A9081177,$CC71A3D0,$E1945447,$F775AF60,$5AE24CC6,$7B757B53,$9B55FADB,$4C345AD0,$58E1E941,$1C0C1BB6
Data.l $81BEBA89,$8C0CDBEC,$392C8323,$0A061D78,$08B24F1C,$A13F8307,$6223616F,$FE687276,$403A2172,$F0BBF0A9
Data.l $3C1F5DD9,$3DC75E84,$83DF698B,$C3E7D721,$179A8ECC,$E1CA5858,$325AE479,$05009AF1,$960D8563,$7C30729F
Data.l $4144647C,$69F49FA4,$4CCCD0E7,$8396CEF7,$642B95D5,$567130C3,$EB9C4665,$42400813,$967C1D0B,$286ECB68
Data.l $892E38C6,$5DB08226,$92B74436,$973E0B16,$E891D84B,$92FAFC68,$AEAA5984,$A50590A9,$8877C6A7,$86D43608
Data.l $E9847C3C,$FF7EF329,$F18199A7,$2A6F71B8,$664F8E6D,$244FA4CD,$A7854B72,$5E52B9A1,$DD4DA3B3,$3725D6D6
Data.l $F4013A7B,$46AEAC95,$9C0A1323,$86753EBC,$ABBDD98D,$C657A0ED,$EC3217B5,$A5286E08,$41016302,$AC4430A0
Data.l $D006453E,$16487891,$006502B1,$09B04017,$042531C5,$DB2CF912,$EF644B9F,$52194E2D,$436AFAA9,$B3B5B7B5
Data.l $EDC4FBD1,$89F0D4D9,$7C1F73AB,$C1F13778,$2375B8AD,$8E53300D,$A819C0C1,$D81B503F,$D0AE8DF7,$DE799E37
Data.l $8FF06CFF,$10999805,$C70DCFE6,$BEC305CE,$5A9B13F0,$A8E5A176,$72F91173,$C8A81099,$E346DF67,$8229CC05
Data.l $301002E0,$4DA888AF,$A088BC66,$332E205D,$353EB268,$4788BB18,$20EEC5F9,$6F76AA95,$5F9373C7,$C1C0DDFB
Data.l $107319DE,$65404F8D,$A7A84D43,$5D63736B,$EB0DCBF3,$ACAEAD36,$AAF5ADAE,$6CB0E632,$7FD63634,$A0747E77
Data.l $85EAE46F,$E767C7AB,$913F1D8F,$86F47639,$DC1FC5FF,$5441FDA8,$EB4D4DCD,$DBDDBDFA,$AAB0BFD6,$96CC36AE
Data.l $34CD843F,$E444AF0B,$47041386,$381131D8,$E17D3400,$7D6C2458,$6C6102E3,$68B3A828,$A312C68A,$A85F2B89
Data.l $D0954AC5,$4FA69D09,$7C261B4B,$79FFF747,$17EEBAED,$B66B0D03,$57EB84D4,$D42AFD86,$F2AC5260,$4AF21088
Data.l $102BF410,$6019FD0C,$6CDA01A5,$4FF3E864,$BDE6FE4E,$F37B5E37,$7FEBBE83,$E8E6F938,$1C8F0AB9,$6F7C61E4
Data.l $A1D573FB,$3CB4D04A,$A4667277,$B91E10E0,$2C84D1B8,$3243CF18,$D3971A14,$42477283,$E8CF4FCF,$A973B3B7
Data.l $EA41E5C1,$E896B50B,$2F42F90B,$B0EBC3FD,$429FF366,$A0E432A8,$B50C6526,$3F04C17E,$C60F2866,$A33B8944
Data.l $82643384,$1F83AB37,$595CAD81,$95F3A1BB,$85F0FD6F,$EAFEBF97,$F1BCDFC9,$E3FFAF4F,$458B5E8F,$1C18F3A3
Data.l $D7B55A48,$C0CFCF8F,$AF308AEA,$6C740C9F,$3D41E806,$C2B41E46,$CD964279,$1EA81E30,$C44FAD8F,$49DB50AF
Data.l $E2B28F2C,$CD828A72,$9F2ADB9D,$F34FEEFB,$61495502,$0D4E815D,$E43E6C41,$E6DC9558,$930D0B91,$25E78CA5
Data.l $EA60BE54,$FE89CC58,$1CF78703,$67A9B759,$FAFFF1D3,$A65B7FF5,$1A5EF4E5,$267572BD,$295FE2D2,$5B5D5FAF
Data.l $C6495E05,$0E518D0C,$767705F3,$D789663C,$E6CC4C76,$10961CD8,$2F26A7B1,$000EF851,$49340306,$633FF9B8
Data.l $4E9C9CFF,$495CB67F,$D091F05F,$59075D86,$ACD94089,$710485B1,$B45D3D63,$A10BA2FA,$A21CB0B3,$A1181DC0
Data.l $38698D80,$7D70A49E,$B6388A64,$7D2B6B4D,$06B34E6A,$F073FF07,$327FEFF9,$3FCECAF1,$8BF6F8E9,$D9EEB647
Data.l $F280DAD4,$8AC14054,$B3E06736,$36ADD16C,$E320CF99,$A6A69314,$C191A401,$EE7AFBB1,$DEF9ADF6,$63C1DE89
Data.l $53F991E9,$168BB6A5,$A02A5F87,$5BAD7C5C,$DD0DC7F6,$59BA95FD,$853DD797,$BA9EF0E6,$78E82B3D,$1380CA85
Data.l $15319D9E,$7E1F1242,$DF77C3F1,$5FAA4B67,$BFD778FD,$BB3FB5D5,$FFBFAFEA,$B99EDFE6,$8FADEB7C,$D8F9727F
Data.l $3E6FB7F9,$E9A7B6BD,$2DADCE99,$8534B64F,$C0E1C31B,$65B2410A,$2243CCDD,$B3D319A5,$6CECE4A9,$246C6676
Data.l $C4C11431,$9E4D1B97,$A37E9C81,$D64B0090,$AD716485,$6B6FA815,$9FDDFD5E,$4E9B4DF5,$05226788,$03C78873
Data.l $56D22C01,$6584AFA1,$F02BD1D7,$42AD8438,$3D8F0E65,$CA2F4B26,$EFCCC14D,$CC881557,$7EDFD3C6,$351DA9F6
Data.l $C0D8DDE6,$0E1CBF89,$6952BC74,$DFA7EEC7,$CFE2EF79,$D9D6F17F,$773A9C5F,$9372D07B,$EA003E32,$E1D57131
Data.l $546E01CD,$ACCA2B0E,$51C78539,$BCDF2D34,$DFDC1BC2,$ADB9DC11,$FD7DEC8D,$872FFCF4,$A958C622,$6525B0FD
Data.l $8EFB657C,$86A4865D,$A28D3E68,$546B0A13,$C0539D07,$D4A4C146,$031A91ED,$74D66CEB,$AB3AEECC,$0386D98E
Data.l $825C7926,$5BCDC0C1,$BBD9B537,$961FF677,$7556068E,$1CD91A54,$E0FE3196,$F7BABF57,$767E5E6F,$5DAE77E3
Data.l $E271391F,$9EFFF0EC,$757632BB,$1339327C,$D846E78B,$E5B598E0,$A840FAEA,$B1D7C9BD,$DDDBD5B9,$D9EC46BD
Data.l $613D0F50,$C679BE5F,$A3E39982,$C8A189EA,$248958D8,$0247D4BE,$250F5B6D,$037D0375,$C5B0E205,$E67BC38D
Data.l $796C3970,$60600187,$005B78D0,$196A6B1D,$4AF1ADF5,$39A70DD6,$5C6E8BAC,$6C74C338,$78D3D91F,$E055D414
Data.l $213873E4,$CB069816,$9EBE5511,$F42F1DED,$F0BD34F4,$B4125AF7,$499D3264,$35B035A7,$8F3908AA,$B27CD15F
Data.l $CD00F292,$582225B1,$8CB09C39,$F98CAF4E,$CDF62F7A,$59DB950D,$DEBF0859,$AE404D50,$AB2A7F6F,$1B66F8E5
Data.l $C6F1A25F,$59088AA2,$26CD7D9C,$1079823C,$72208284,$70B2F33C,$C51ABB69,$A789903C,$A7F3BEEC,$EEB106CF
Data.l $63A3BDDB,$40A9639F,$2ECB9CED,$118A2146,$2F3D8F29,$A62570C7,$B860D484,$EBBA0AC2,$AEFE1CD8,$383CE623
Data.l $5B2E7C59,$B4049A34,$BCDDADBC,$4D9A7C27,$36E56267,$848016EB,$C89E3B9A,$CD6B427B,$AA33124C,$ED9ABDC4
Data.l $85E8F212,$C68723F9,$2F0D9067,$8B158536,$9FEA1484,$2418C922,$3F260525,$7D3A3DBF,$AEEAEFA7,$A9B1B0F5
Data.l $C346C375,$66C24AC0,$C9AE04D5,$D6610011,$6080D2E1,$24E1AA03,$EC19F1E5,$B1CF7758,$FC522B86,$06D0D88A
Data.l $2594B09C,$F3877B25,$FD99DDD7,$92D0D6E2,$CB456EA5,$C369C3A6,$9E370E21,$10018A49,$05593670,$C31E718C
Data.l $A3651263,$030AE5A2,$4E4BB961,$34599C1E,$056CE043,$D3EB7239,$D4F47001,$47951D81,$64BD50C4,$000E71E8
Data.l $EB3E0207,$C16E930E,$410F9468,$3477BC30,$A5018C0E,$7068DB3A,$A26A1038,$C8956473,$CDECBDD0,$73B66D87
Data.l $22514446,$DC0F7618,$30DC6ACF,$87055216,$A0D9C75B,$5C11D058,$4010E66F,$7897AD1C,$CE0BA49E,$98B52EC5
Data.l $FBA6A15F,$88FE9D2F,$7778798D,$5CA641EB,$B5F92562,$3793102E,$97181942,$2E004011,$29EF2C98,$8C651CFA
Data.l $54506C98,$77DB6596,$B1A181A3,$0F1313FB,$7D76E8D9,$DCD75424,$F756AB44,$B8D3A6E4,$C6A4C504,$499B532A
Data.l $C7BAE6C7,$D3DF25F5,$CDA41465,$6C891B07,$585B9624,$F0B0B030,$C78C4DCB,$F47D2E86,$D415536E,$EDB57775
Data.l $63F45870,$D359E232,$1041802E,$F471BA80,$EC591302,$186C3AF1,$75A6B00D,$9F72B041,$BCC92320,$A03F389D
Data.l $3D4CB65D,$1DD7B0F7,$6378481C,$476993CF,$638B60AE,$3A30399B,$390ACDB6,$68C8E0AB,$1E0B83B5,$91311F56
Data.l $705817C6,$88E4C99B,$9DEC8D6B,$5CCC375B,$01F0FC7C,$DA8AA5F5,$8CD32AEA,$402B3F71,$E62D6346,$C6182EBD
Data.l $02645388,$29285841,$C76C508C,$4A84C1C6,$5B45C359,$7D634F34,$3D9FB277,$CDDDE364,$8FE784EC,$670F4FED
Data.l $507399DC,$0221569B,$911CADB1,$BC08EBEF,$1ADB66DC,$25D150A4,$BD784999,$3099F6CE,$EF6888CF,$4EE7A7F8
Data.l $FD0FAB32,$3E11FD51,$5EEE3E72,$7B1622CF,$C400B59D,$04FB8365,$1AAE1593,$8D9F1E69,$017A386C,$23140608
Data.l $3D51586F,$1D3E3138,$C1B12B1B,$2E7964BD,$826B2A05,$3DFAED62,$AB0D49A9,$2C04055C,$8322A9D5,$72360F81
Data.l $9F9D34D9,$8A32B0CB,$04249288,$BF82432A,$19545542,$A590A4A9,$48509F2C,$4CDEAF23,$79BF18D2,$17A54CE5
Data.l $1BDBBDD4,$DE7E41F7,$26C2E875,$B382811D,$F5531653,$EBBA2302,$684E4C13,$AE53A3BC,$A0860638,$CEC774B4
Data.l $2E07727D,$23A6CE4D,$164936E5,$A3BEBD9C,$DD53BB67,$9F9036B0,$66C6C803,$EBFEB1F5,$4BFEBDE6,$20E8ECCE
Data.l $2147A624,$53E71F3B,$84BB304A,$AAA16AEA,$CD7E4369,$BAD2FDF6,$86D447ED,$25809596,$7A571A4B,$DBE18999
Data.l $7DC3FBB1,$8EC53AFB,$7ADF0686,$D85C98C7,$5905701A,$AE859694,$F1ED8D82,$7C390970,$E65479F6,$987F3060
Data.l $09C692AC,$F9D485B2,$CA35ECFE,$D6F87E2F,$3AE164AE,$C9FAEA73,$EFF399E3,$FA4767BE,$3F3682CF,$92B5E78E
Data.l $3237356E,$0C22ED82,$75A5FE9F,$D32DB6AE,$A42FE871,$277F2F5D,$B615D1DC,$8C7FAE47,$7476E5D6,$AA26ECAE
Data.l $39E93825,$DC549594,$2B1B72B0,$607459C9,$2F7CB8FB,$B1CC6DD7,$3FCC2339,$DAEC374C,$93C74596,$779BBDC2
Data.l $E71F3732,$6B71271D,$C7ACDE67,$E4B5CD7D,$A9BF5153,$BEB7D0F2,$F87C0D27,$DEEDD8EB,$75FE2753,$EC0FEFFD
Data.l $6568BD0C,$AE0D8513,$281CB882,$13BE0100,$505801CD,$6FAE15C8,$A031C116,$DF8C3526,$7ADF55DE,$AF5327F5
Data.l $3FCCC752,$549AADEA,$479D8D28,$0F2E46BC,$1FD5352A,$7FC7E77F,$AFB5CEC5,$DAECD716,$CCEF3EA0,$53CCF9A7
Data.l $291817B0,$79F85BAE,$022FD8BB,$88603F61,$DA232AC9,$E731BEA9,$0F1022CA,$2E2A817D,$3293AF5B,$6F12900C
Data.l $0E479780,$CC705634,$C25B780C,$87D0776A,$99B4A074,$3166DB03,$E232BA17,$96F629F2,$46E517DB,$2821566C
Data.l $E306F290,$FC9BBDAF,$2E5CE4E9,$063790F2,$3394804B,$965FB1FC,$9D393F16,$33FB67EA,$CFE85E1F,$A505965F
Data.l $D2B56566,$D7B1F41A,$09CF3626,$CC5D8CC5,$62226E11,$77C042DB,$029F0533,$9F0BD959,$B1C8E5C5,$C75BDAF3
Data.l $B1DF452F,$1EE61E6C,$940C3FFB,$EE5A117B,$BADEA3FB,$E6D345F2,$C3EEFF16,$0E97C1DD,$D707AB76,$35AD0835
Data.l $08555415,$15F3175F,$5CB585A5,$CD1020DE,$E63C6E40,$D6195E4C,$903C7F2F,$4EED7539,$D644E3F6,$FB212B1A
Data.l $C9D2AFB2,$FDC77897,$A5F1F7B0,$ED01EB7C,$D4B70844,$A9AED67A,$0287D657,$72060D62,$0B7AE799,$9ECA588C
Data.l $7FAB37BD,$E31A891E,$BACCEDA6,$3BECB319,$63FFB2FF,$E14A5082,$FFE7C3FF,$B1001804,$943063F7,$00653796
Data.l $49000000,$AE444E45
Data.b $42,$60,$82
EndDataSection

DataSection
AbmeldenXP:
Data.l $E0FFD8FF,$464A1000,$01004649,$01000001,$00000100,$4300DBFF,$02020300,$03020203,$04030303,$05040303
Data.l $04050508,$070A0504,$0C080607,$0B0C0C0A,$0D0B0B0A,$0D10120E,$0B0E110E,$1016100B,$15141311,$0F0C1515
Data.l $14161817,$15141218,$00DBFF14,$04030143,$05040504,$09050509,$0D0B0D14,$14141414,$14141414,$14141414
Data.l $14141414,$14141414,$14141414,$14141414,$14141414,$14141414,$14141414,$14141414,$14141414,$C0FF1414
Data.l $00081100,$0386001F,$02002201,$11030111,$00C4FF01,$0100001F,$01010105,$00010101,$00000000,$01000000
Data.l $05040302,$09080706,$C4FF0B0A,$0010B500,$03030102,$05030402,$00040405,$017D0100,$04000302,$21120511
Data.l $13064131,$22076151,$81321471,$2308A191,$15C1B142,$24F0D152,$82726233,$17160A09,$251A1918,$29282726
Data.l $3635342A,$3A393837,$46454443,$4A494847,$56555453,$5A595857,$66656463,$6A696867,$76757473,$7A797877
Data.l $86858483,$8A898887,$95949392,$99989796,$A4A3A29A,$A8A7A6A5,$B3B2AAA9,$B7B6B5B4,$C2BAB9B8,$C6C5C4C3
Data.l $CAC9C8C7,$D5D4D3D2,$D9D8D7D6,$E3E2E1DA,$E7E6E5E4,$F1EAE9E8,$F5F4F3F2,$F9F8F7F6,$00C4FFFA,$0300011F
Data.l $01010101,$01010101,$00000001,$01000000,$05040302,$09080706,$C4FF0B0A,$0011B500,$04020102,$07040304
Data.l $00040405,$00770201,$11030201,$31210504,$51411206,$13716107,$08813222,$A1914214,$2309C1B1,$15F05233
Data.l $0AD17262,$E1342416,$1817F125,$27261A19,$352A2928,$39383736,$4544433A,$49484746,$5554534A,$59585756
Data.l $6564635A,$69686766,$7574736A,$79787776,$8483827A,$88878685,$93928A89,$97969594,$A29A9998,$A6A5A4A3
Data.l $AAA9A8A7,$B5B4B3B2,$B9B8B7B6,$C4C3C2BA,$C8C7C6C5,$D3D2CAC9,$D7D6D5D4,$E2DAD9D8,$E6E5E4E3,$EAE9E8E7
Data.l $F5F4F3F2,$F9F8F7F6,$00DAFFFA,$0001030C,$11031102,$FB003F00,$283EC56B,$AD356ED4,$BA571355,$864B4BB1
Data.l $98AD2882,$FC008022,$9A9672CD,$8DF589E7,$3F2D3B4E,$2E2ED55E,$AC423BA5,$ECC93DBD,$2F8C872A,$F819AF7C
Data.l $C5D93092,$801F83FC,$FB177EAB,$3C83974D,$4DC0AA5F,$8600ABB4,$64E0BC1B,$7BAACCB7,$F22B3D92,$5FA9D709
Data.l $3EF32811,$9BDDCC55,$BEED36D9,$FAFBD0F6,$0F432174,$BB318E1A,$FDAE2B49,$44476DCD,$DD71D4F1,$9F8BA735
Data.l $6680B951,$E03B4B5B,$7E1D28F3,$ABBDBD5D,$C58FE007,$F1CF140F,$FAC3C396,$A971AB86,$D3F6B7E9,$05D9A5B3
Data.l $41C678A2,$EB3D065E,$8D77C203,$6387E635,$3FA6E9A2,$247E4710,$898DD2FE,$55CE1963,$35D7B1BD,$6843E1B7
Data.l $73EB6B7F,$91DBB467,$4C67B77B,$EB7743F9,$62C1E79A,$0A455CD5,$27492AD4,$DA361B35,$27EDAE69,$BAE8B375
Data.l $A1A68813,$B12AAD4A,$9AB6A84D,$A7C33F49,$94D6A76E,$5DDE5051,$4FDAA7C3,$C3227175,$9234026F,$5401E748
Data.l $807D920C,$6A33FB15,$3EB2B729,$91DD260D,$6FF01535,$50FB61EC,$F841FC5C,$EADAAEDD,$C483385E,$B43F5E76
Data.l $7DB4D7BD,$718B6A20,$B7D68026,$CC2CC472,$CC838921,$0A2668B5,$0F49C940,$FB2FD73C,$1EDBFE2A,$C157F039
Data.l $78D386AF,$229EC0F3,$AA15FCD7,$776873EB,$1D35133F,$BE893B76,$C0E535D7,$CB997D88,$EEA7F04C,$28B332E3
Data.l $2528581B,$2EC23554,$93365B56,$6EE3B6F9,$CDCB4ED7,$95A296B4,$26FAA4A2,$CA45C9D7,$CE4F96FE,$A31FFBCA
Data.l $D2C35754,$49C100FF,$117FBB75,$8EE02734,$D3E179AB,$03BF1BE3,$6B58AC43,$3AD7CED6,$2388649C,$3316198E
Data.l $73B7C3FB,$27202A33,$AD6DE40C,$0500FFE3,$7ED2B312,$2D9E6A09,$64811FF1,$8C00FFF0,$3757BC6C,$2E85CF82
Data.l $8775CB35,$DE354AFB,$81849A44,$BC208E22,$5C6DA4B4,$4C30BC1F,$ADF37827,$6D79FCB4,$47A500FF,$356D4CEF
Data.l $F8E7572E,$FA00FF5E,$6EABF94B,$7E45877D,$FD5D7C7A,$327E6EB8,$18BFC77E,$372174EE,$78203E80,$B4CFB44D
Data.l $3BC200FF,$287558E2,$F2E28EE3,$DA961C21,$7D6C9B8D,$295C1DC8,$E6544E05,$37DADFBB,$5DF1BAF6,$8FC5BFB5
Data.l $F83F7C05,$82F8AD79,$6AF8091F,$190FE253,$36BCFAE9,$4FDCA24F,$BCB02465,$621EB631,$47B16B83,$14125C57
Data.l $6E536EE0,$6F6B7210,$F74A95CB,$AF6D2DD9,$771EA152,$BDDD7D15,$EFD54B35,$FB882E7B,$44F88A3A,$7CF2DEFE
Data.l $F053F81F,$6991C377,$F13ADE16,$ADE0A5D6,$A7D45C37,$2C8C2FF1,$528428F4,$35E6AB42,$FA7EEBDD,$60C77077
Data.l $269611CB,$FE5B5DBB,$A506070A,$DA83EFE1,$1E7E8097,$B8393E6A,$9CBA92F8,$EA625A36,$5B5CD950,$06285A5D
Data.l $650C2E27,$9386844C,$5C8A0A78,$D34EE107,$05E52C87,$F3E3A4AD,$17E797BC,$833256F3,$2EBD49E6,$FFB5F2AF
Data.l $0F7D2D00,$1CAF68AE,$00FF97FD,$00FF3968,$6B068F68,$E1A3969A,$78058F5B,$EED64083,$68AB3FBC,$DFADDD93
Data.l $DAA0AED9,$AACA2C58,$90D7611C,$90819CA3,$50C73E01,$3FF95BD3,$06BF26BD,$E5EF9D86,$5114DCA7,$279F2145
Data.l $E245A447,$F6FA8DAF,$14AD3495,$C8337F2D,$AA621963,$D40388BB,$768D1FE3,$3AD7E890,$369FCEFD,$8B066FA1
Data.l $5C3A4DE1,$315EA6C5,$FF34DE89,$A78C9600,$EBBD7D92,$F085F88B,$9F66E277,$D75433F1,$B51D23FC,$A6F4ADDD
Data.l $F5D629E2,$B084A66D,$E4082EC3,$3BAC7972,$3F8600FF,$C569F51A,$41A5A3C6,$431B307B,$10A3AB4D,$F5F1AB3D
Data.l $F6841543,$521696B1,$2C7D9B93,$7EF6EAD6,$D1B9DD87,$F6722AC4,$2D954BD1,$FE684D77,$AF0E7D7E,$798BF85E
Data.l $E9F0F724,$67696B0D,$3D453223,$2BC5AABD,$6E3E9E45,$1AFCC7B5,$0D00FF71,$EEA5E115,$E709AF6D,$53ECFE24
Data.l $8B1FC287,$F85F583E,$3FFEF446,$F81F27EA,$2FF05157,$F48D7FE0,$BEB68A7F,$1644F129,$8DAD657A,$04C3B0BC
Data.l $99672237,$68E718A4,$F90A00C0,$9D03BFCC,$58AA73E2,$C825648C,$926C7DA5,$AC95E857,$82ABD674,$4EAB83A3
Data.l $3E6DD394,$549F6DB7,$9FF11757,$00FF77C0,$F814BE14,$661AC2A7,$77357CBA,$A74958AE,$7D5B548D,$83A4DBA0
Data.l $7A8FB06B,$072C9464,$7B4E30CC,$2B4ABB62,$535106FA,$9FD9324E,$124EC69E,$F9E88E52,$73D87FBE,$A30EFAC0
Data.l $F056BFF0,$E08F960D,$37C17F3D,$AB2ECFF0,$7991E8A7,$81A8BDFA,$E1DE9EA1,$3266A391,$62CC67AB,$0E4E4EC5
Data.l $81A7794D,$BA9CE03F,$AFF486EF,$5C4FF805,$78A9D5F8,$8797E18F,$49AF71B5,$18EC1FE1,$F1E6962D,$DB549666
Data.l $23692472,$68A9738B,$72487089,$3E1B960A,$52B4A2DB,$6FFD5C6A,$E9EF9D7F,$1E4DABBE,$5C76C6AA,$6F2D9D9C
Data.l $D9F7ADC1,$B99BE6B5,$FB8FAEF2,$5A657F0C,$C27FB069,$8FFDE66D,$119F7CE2,$E3647FF7,$00FFFC7E,$E3AF7FA1
Data.l $5B00FF19,$558E00FF,$00FF181F,$AF343EC1,$C717F81A,$8AEF1D1A,$BFB5D4C1,$F7785C1E,$D164D44B,$362D9EE2
Data.l $20AA40E6,$6857DA96,$180AA3EE,$F7A16D30,$FD1CA372,$BD454571,$7E9A5EDE,$00FFB61C,$79F723D2,$7677E9BB
Data.l $9C00FFFB,$7D39E79F,$1DDF4AFE,$C100FF59,$03F8893D,$DA87CFE3,$47F48C87,$F654BCD6,$D120FEAA,$68A607BC
Data.l $130C6FC9,$F6C732C7,$9419317B,$F2928D92,$81363290,$E257BB83,$AE3DECCF,$9EC6D778,$21BCD53A,$F0547BF1
Data.l $CDE38D06,$4F7C2C35,$30E9DBA2,$91F4255E,$C811B4DB,$84063B92,$571D2A6D,$6FB871E6,$58BF8D5C,$F65E4E51
Data.l $DFD2FA8F,$BED39275,$C62D8ABB,$CEAFE9D6,$E56BFEE9,$DFC5C7B6,$9BE0BF11,$D32EDEF6,$68DC1EFE,$B4D334DE
Data.l $5FF8139F,$16DE36C3,$AF75D4B9,$B66BD907,$0AB4859A,$BBB33836,$B8C9902C,$8819DE31,$A49E2B56,$FF8747FA
Data.l $5FFB6300,$E08F780E,$AF6BAD96,$0EDF42DA,$9EE4B47F,$DA0F2F0B,$4DAB45D8,$478E007B,$A2885A11,$C0720AB7
Data.l $C0486E2C,$FAB19C24,$79BE8A26,$6D753973,$FFBD9BBF,$EDA6F400,$5636D9B5,$5BBE95B7,$DCD74A7E,$3F81CFF2
Data.l $4AE1BF03,$4F12F14F,$9FEDAFED,$59BC4BF8,$7D8CE27B,$27FBC893,$230F02DA,$BBFDB6EF,$CB00FF3E,$5ED1FD9C
Data.l $1D1545A7,$F992EC12,$12FC9224,$9EDCEA29,$C2E6DFED,$47A0288A
Data.b $FF,$D9
EndDataSection

DataSection
RunterfahrenXP:
Data.l $E0FFD8FF,$464A1000,$01004649,$01000001,$00000100,$4300DBFF,$02020300,$03020203,$04030303,$05040303
Data.l $04050508,$070A0504,$0C080607,$0B0C0C0A,$0D0B0B0A,$0D10120E,$0B0E110E,$1016100B,$15141311,$0F0C1515
Data.l $14161817,$15141218,$00DBFF14,$04030143,$05040504,$09050509,$0D0B0D14,$14141414,$14141414,$14141414
Data.l $14141414,$14141414,$14141414,$14141414,$14141414,$14141414,$14141414,$14141414,$14141414,$C0FF1414
Data.l $00081100,$0386001F,$02002201,$11030111,$00C4FF01,$0100001F,$01010105,$00010101,$00000000,$01000000
Data.l $05040302,$09080706,$C4FF0B0A,$0010B500,$03030102,$05030402,$00040405,$017D0100,$04000302,$21120511
Data.l $13064131,$22076151,$81321471,$2308A191,$15C1B142,$24F0D152,$82726233,$17160A09,$251A1918,$29282726
Data.l $3635342A,$3A393837,$46454443,$4A494847,$56555453,$5A595857,$66656463,$6A696867,$76757473,$7A797877
Data.l $86858483,$8A898887,$95949392,$99989796,$A4A3A29A,$A8A7A6A5,$B3B2AAA9,$B7B6B5B4,$C2BAB9B8,$C6C5C4C3
Data.l $CAC9C8C7,$D5D4D3D2,$D9D8D7D6,$E3E2E1DA,$E7E6E5E4,$F1EAE9E8,$F5F4F3F2,$F9F8F7F6,$00C4FFFA,$0300011F
Data.l $01010101,$01010101,$00000001,$01000000,$05040302,$09080706,$C4FF0B0A,$0011B500,$04020102,$07040304
Data.l $00040405,$00770201,$11030201,$31210504,$51411206,$13716107,$08813222,$A1914214,$2309C1B1,$15F05233
Data.l $0AD17262,$E1342416,$1817F125,$27261A19,$352A2928,$39383736,$4544433A,$49484746,$5554534A,$59585756
Data.l $6564635A,$69686766,$7574736A,$79787776,$8483827A,$88878685,$93928A89,$97969594,$A29A9998,$A6A5A4A3
Data.l $AAA9A8A7,$B5B4B3B2,$B9B8B7B6,$C4C3C2BA,$C8C7C6C5,$D3D2CAC9,$D7D6D5D4,$E2DAD9D8,$E6E5E4E3,$EAE9E8E7
Data.l $F5F4F3F2,$F9F8F7F6,$00DAFFFA,$0001030C,$11031102,$FA003F00,$19BFC773,$1BBFB52E,$C3ACD66B,$A166FAEC
Data.l $BC1D9F36,$9427329F,$D0DB09DB,$E2B62096,$3863F333,$35842F15,$6B159FEB,$A4557AB6,$B9B9705A,$DBD2AA6D
Data.l $24C0D526,$A0E7F293,$D8F0E235,$F6BB785C,$8577F198,$C930E56D,$B4CBE27F,$2D9F0132,$1EDBB933,$B57EACCA
Data.l $8D97BAEF,$1FE11B7C,$F013FE8D,$6767977E,$7368DBA5,$66D5BC94,$3CD2AC60,$3D67840D,$B1246579,$621CC7FB
Data.l $B65575BC,$ED959DDC,$4BA39FF8,$C229842F,$D37C2A9D,$D9F6F974,$BDEFDE72,$C46E89DE,$3CD975D5,$E9DDAD3D
Data.l $63FA7657,$4739DB5C,$07196B29,$385746BE,$0D5FADC1,$C4FE4F7C,$5474F4D6,$00FF9248,$31B0B750,$93C4AE5B
Data.l $A09C70CE,$BB3372F9,$71F91970,$F04C139C,$0FC400FF,$E2B3780C,$1B3C8A97,$DFD95AA8,$AEB76AD9,$04A47AD6
Data.l $D7083216,$DC3F0EE5,$A01E583B,$3B5F738E,$B58EBAEA,$F857FB61,$5ACEC14B,$F143332D,$3DF7A62D,$94B2D86E
Data.l $B836E873,$DA27F5C0,$D92B9EB3,$9CEEB4B8,$FF777EB9,$0DAB2300,$2B5C2C92,$924FA953,$6BEAA450,$BAB73CD6
Data.l $DBD2E6F3,$8A52F4A3,$FC70AF28,$CAAF28BC,$D97E167F,$F8B62EBE,$4A6BF1A9,$6A00FFD7,$5F55F8CF,$D4273ED8
Data.l $C31FED34,$A1AEF0DF,$58DB3CD6,$F62322A4,$E7E58784,$BE258729,$5F73925C,$F60FF855,$FD4987D7,$7816FE9B
Data.l $4E9AC6B7,$1D9FE2A1,$9ECDC2F8,$009EC3DB,$E59D1AB2,$369F88F1,$DA47E248,$C86B13BB,$59C286A5,$28B49171
Data.l $A26A3A35,$00FFF2D9,$7D6DDBE4,$EB74D574,$2A9CE6A0,$BFBE377B,$ADF9AF85,$D1569F7A,$00FF075E,$F3F0AD0D
Data.l $F11015FE,$675F83E0,$073AD4FE,$4A8322FC,$EDDFED7F,$FB4ED761,$8FF67326,$EF6D77F6,$FF9715BB,$E0E10D00
Data.l $9E847F2B,$A3D6F135,$43BBF8A0,$6CAFC19B,$3585E79A,$356D298D,$227131BB,$49D00EA4,$1CAE5D20,$E8FE3B38
Data.l $F4A6F83D,$B67EFABD,$97E400FF,$98ECD57D,$5DD2E424,$00FFE07F,$1FDBDE93,$3B5F5148,$B9FD3DFC,$F7F81EFE
Data.l $D12C7EC4,$14DF74EE,$0E4F3678,$29E2CFE8,$8E5EF127,$A67929F6,$2D6F102B,$452393D4,$A4C88DD0,$82041886
Data.l $FFE89607,$D73DB700,$1FDADFC5,$E18B76E0,$9EC5373D,$8897F00F,$5197575F,$0A3AC587,$DAAC475A,$B62564C7
Data.l $B799B6B8,$633888EE,$4D4FDD98,$A46504C3,$EB3B94DC,$FFB7F7F2,$9E5FC000,$951D4D8F,$45972BD7,$4DFE49FE
Data.l $D5B56A79,$2BAAED5F,$0A00FFE6,$0F7FDEFE,$9DE35BBC,$45834337,$838E85F1,$00FFDFAB,$38FEE865,$873734D4
Data.l $D9ADFAC3,$BD0DAB62,$33B36CD1,$14E5AA2B,$4CCF8D12,$FF28FEF3,$FC928200,$BB96F036,$BEF7E9AF,$96D4F118
Data.l $04F11E7E,$75D61D9E,$64116DAB,$96D9B4D3,$9A658D55,$63B54BE0,$06DA6676,$311B3B64,$2BE2AE8C,$BB2EC599
Data.l $6D7EE97D,$75D76D6F,$BF57D376,$1F00FF4D,$675F7BF2,$8AC2FAD8,$1591386A,$6458E594,$A44E511F,$05D5774A
Data.l $CF405114,$E36B6DCA,$DFC1B715,$D65F97DB,$D34696AF,$724F3CAD,$E45A5ED7,$6ECC6488,$312077C0,$7AC5776C
Data.l $F049EDB7,$975AC65B,$7F3C6E8B,$FF4DEFF0,$C3DB8400,$BD44213E,$9CBFA60F,$0940B9F0,$36BABC08,$C6B90203
Data.l $CEC03848,$FB73ED3F,$AFFAEA19,$C5574DC5,$F6EB4C5A,$7273663D,$643B94C4,$5910586E,$08CE3948,$081D23C8
Data.l $65F899E7,$7F8DCFE0,$A74D2D08,$7567BC85,$2F96D8A6,$CDB022F6,$11A92700,$9EA0ECC8,$F89A01E4,$F3EB94FA
Data.l $9C52A554,$386D5B9C,$1EFDBEEE,$1366F487,$1C7B951B,$C6826126,$53788552,$F32A9C50,$B424C972,$2D9AAB7C
Data.l $75353B49,$95FDB663,$EAF801FE,$7F56C7DF,$4524BE10,$353C852F,$91F7D0E1,$0191A8C3,$03844092,$17559EE5
Data.l $27378B25,$49F30C00,$3E78E265,$16D4FE22,$46B6281E,$12BF5B5B,$C37D1B59,$6359620C,$891D098D,$F51E0755
Data.l $2BBDE28B,$35C40FE3,$E25BBC58,$D166DD8B,$44B33858,$3A321882,$AA481A13,$BD06B94F,$F873F627,$F8DDAC11
Data.l $EFD44CD3,$377D6B22,$EE8EB94B,$C168A449,$11B94377,$2C8F5D15,$00709214,$8CE70C04,$9DB34261,$49A9543A
Data.l $B9494945,$92E4DF6E,$59E6215B,$B1540AAE,$325EEC58,$934EEB94,$BF5218A7,$B2AB632C,$9493E6BA,$B69DDC9D
Data.l $8AA2DD3E,$E78FED2B,$0C6FE223,$A8FD0AFC,$CB7810BE,$0FDF94E2,$5C11FE6E,$3EC673F8,$02F1BE28,$AAC9130F
Data.l $9D107749,$3144AAB0,$5C280CAA,$F29C9B8F,$3B3E7145,$608200FF,$C1AF9A6A,$1D5A851F,$BFE1A386,$C2AF7812
Data.l $7D4B5F12,$BD47E261,$CDAFD1B6,$2A93F9EB,$F124A3B5,$A6144EAC,$F3B1BBDD,$FD5A0900,$45A5A20F,$E5F6A828
Data.l $EC68EB57,$935BA4BF,$5B9F9C94,$1BBD2BBF,$75800FFC,$9426F87F,$BDECD7FA,$ECB8E069,$F8A017BC,$49C4DBBE
Data.l $E9A643E2,$A1EFEA73,$98B1485D,$9334CF7E,$157249DC,$91343FE2,$05E0C818,$D060DCC8,$3E9DE07F,$663FD323
Data.l $0F3E8A9F,$1E7ED2B6,$7EC65378,$C530362E,$E50800FF,$9F26B5F6,$C7DCDBE4,$F2926736,$C371DF59,$71892380
Data.l $CB779BDD,$68450BFA,$979CD4A4,$BF1C7E5B,$FFBE8AFC,$1F912B00,$B3AFC575,$EB0500FF,$4FE6B3F7,$66B2BF8A
Data.l $E353F1A7,$DCAEBD3E,$1E1676EA,$18FED514,$C41978DC,$1BF2DA45,$824C6E89,$43688F55,$60FBAF1A,$738C3192
Data.l $7F80075C,$D78E6F65,$0CBE129F,$7C129FEA,$FF5BE049,$3AFC0D00,$A1D2BFB4,$5DFAF0B7,$6D717545,$49B68835
Data.l $AD4DA49D,$51EEC229,$412E54B1,$6D1FD862,$F5BC5251,$F8CFE75F,$D14BF2FE,$25C906F9,$64E725D1,$00FFADA2
Data.l $ABFAC592,$07BF9B9F,$BA96E03F,$8A5FC39F,$A3C625DA,$D63AFCA4,$EAA329FC,$C4836E9F,$ABEBDD72,$245109E2
Data.l $2398C332,$64D18EBA,$02642A04,$AEE22EA0,$F8AA0F72,$F130F6AB,$0FF0B79E,$4DF082F6,$F4E1A5BE,$78217ED6
Data.l $E9117FD6,$304F1297,$B9671B86,$765295B6,$00599610,$7155F885,$496E3E92,$55D1661F,$BBA43819,$6594F05B
Data.l $2F3FC2F9,$65B99452,$F7A7BBCE,$F31E7E73,$AD88FCD3,$45DB3062,$20B2601B,$0A9C8E53,$37298A96,$C5387377
Data.l $A02B2A46,$8A144551
Data.b $3F,$FF,$D9
EndDataSection

DataSection
Arrow_Win7:
Data.l $00010000,$10100003,$00010010,$01280004,$00360000,$10100000,$00010000,$03680018,$015E0000,$10100000
Data.l $00010000,$04680020,$04C60000,$00280000,$00100000,$00200000,$00010000,$00000004,$00C00000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$80000080,$80000000,$00800080,$00800000,$80800080
Data.l $C0C00000,$808000C0,$00000080,$FF0000FF,$FF000000,$00FF00FF,$00FF0000,$FFFF00FF,$FFFF0000,$000000FF
Data.l $00000000,$00000000,$00000000,$03000000,$00000020,$03000000,$000020A2,$03000000,$0020A2AA,$03000000
Data.l $00A2AAAA,$03000000,$22AAAAAA,$03000000,$AAAAAAAA,$03000020,$AAAAAAAA,$030000A2,$AAAAAAAA,$03000020
Data.l $22AAAAAA,$03000000,$00A2AAAA,$03000000,$0020A2AA,$03000000,$000020A2,$03000000,$00000020,$00000000
Data.l $00000000,$FFFF0000,$FFFF0000,$FFE70000,$FFE10000,$7FE00000,$3FE00000,$0FE00000,$07E00000,$03E00000
Data.l $07E00000,$0FE00000,$3FE00000,$7FE00000,$FFE10000,$FFE70000,$FFFF0000,$00280000,$00100000,$00200000
Data.l $00010000,$00000018,$FF400000,$0000FFFF,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$26000000,$B22652B2,$00000052,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$26000000,$B82E52B2,$52B22658,$0052B226,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$26000000,$BD3552B2,$58B82E5F,$2652B226,$000052B2
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$26000000,$BD3552B2,$5FBD355F
Data.l $2658B82E,$B22652B2,$00000052,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$26000000
Data.l $C33D52B2,$5FBD3565,$2E5FBD35,$B82E58B8,$52B22658,$0052B226,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$26000000,$C94552B2,$65C33D6C,$3565C33D,$B82E5FBD,$58B82E58,$2652B226,$000052B2,$00000000
Data.l $00000000,$00000000,$00000000,$26000000,$CE4C52B2,$6CC94573,$3D65C33D,$BD3565C3,$58B82E5F,$2658B82E
Data.l $B22652B2,$52B22652,$00000000,$00000000,$00000000,$26000000,$CE4C52B2,$73CE4C73,$3D6CC945,$C33D65C3
Data.l $5FBD3565,$2E5FBD35,$B22658B8,$52B22652,$0052B226,$00000000,$00000000,$26000000,$D45452B2,$79D45479
Data.l $4573CE4C,$C9456CC9,$65C33D6C,$355FBD35,$B2265FBD,$52B22652,$00000000,$00000000,$00000000,$26000000
Data.l $DA5C52B2,$79D45480,$4C79D454,$C94573CE,$6CC9456C,$2665C33D,$000052B2,$00000000,$00000000,$00000000
Data.l $00000000,$26000000,$DF6352B2,$80DA5C86,$5479D454,$CE4C79D4,$52B22673,$0052B226,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$26000000,$DF6352B2,$86DF6386,$2680DA5C,$B22652B2,$00000052,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$26000000,$E56B52B2,$52B2268D,$0052B226,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$26000000,$B22652B2,$00000052
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$FFFF0000
Data.l $FFE70000,$FFE10000,$FFE00000,$7FE00000,$1FE00000,$0FE00000,$03E00000,$01E00000,$03E00000,$0FE00000
Data.l $1FE00000,$7FE00000,$FFE10000,$FFE70000,$FFFF0000,$00280000,$00100000,$00200000,$00010000,$00000020
Data.l $00400000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B2260000,$B82E4652,$B226C658
Data.l $B2265452,$00002752,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$B2260000,$B82E6052,$B226FF58,$B226FF52,$B2265452,$00003852,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B2260000
Data.l $B82E8652,$B82EFF58,$B226FF58,$B226FF52,$B2268C52,$00003C52,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$B2260000,$BD358652,$BD35FF5F,$B82EFF5F,$B226FF58
Data.l $B226FF52,$B2269952,$B2266052,$00001F52,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$B2260000,$C33D8652,$BD35FF65,$BD35FF5F,$B82EFF5F,$B226FF58,$B226FF52,$B226D552,$B2265452
Data.l $00003152,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B2260000,$C9458652,$C33DFF6C
Data.l $BD35FF65,$BD35FF5F,$B82EFF5F,$B82EFF58,$B226FF58,$B226FF52,$B2266752,$00004952,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$B2260000,$CE4C8652,$C945FF73,$C33DFF6C,$C33DFF65,$BD35FF65,$B82EFF5F
Data.l $B82EFF58,$B226FF58,$B226FF52,$B226C152,$B2264952,$00001F52,$00000000,$00000000,$00000000,$B2260000
Data.l $CE4C8652,$CE4CFF73,$C945FF73,$C33DFF6C,$C33DFF65,$BD35FF65,$B82EFF5F,$B82EFF58,$B226FF58,$B226FF52
Data.l $B226FF52,$B226C152,$00003952,$00000000,$00000000,$B2260000,$D4548652,$CE4CFF79,$CE4CFF73,$C945FF73
Data.l $C33DFF6C,$C33DFF65,$BD35FF65,$BD35FF5F,$B82EFF5F,$B226FF58,$B226FF52,$B226FF52,$B226C152,$00003952
Data.l $00000000,$B2260000,$DA5C8652,$D454FF80,$D454FF79,$CE4CFF79,$C945FF73,$C945FF6C,$C33DFF6C,$BD35FF65
Data.l $BD35FF5F,$B82EFF5F,$B226FF58,$0000C152,$00000000,$00000000,$00000000,$B2260000,$DF637552,$DA5CFF86
Data.l $D454FF80,$D454FF79,$CE4CFF79,$C945FF73,$C945FF6C,$C33DFF6C,$BD35FF65,$BD35925F,$00003F5F,$00000000
Data.l $00000000,$00000000,$00000000,$B2260000,$DF637552,$DF63FF86,$DA5CFF86,$D454FF80,$D454FF79,$CE4CFF79
Data.l $BD35FF73,$BD35AD5F,$BD356E5F,$00003F5F,$00000000,$00000000,$00000000,$00000000,$00000000,$B2260000
Data.l $E56B7552,$DF63FF8D,$DF63FF86,$DA5CFF86,$D454FF80,$D454AD79,$D4546E79,$00003F79,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$B2260000,$EB727552,$E56BFF93,$EB72FF8D,$EB72AD93
Data.l $EB726E93,$00003F93,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$B2260000,$EB724652,$EB72C193,$EB726E93,$00003F93,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$B2260000,$EB724652,$EB723F93
Data.l $00002D93,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$FFC30000,$FFC10000,$FFC00000,$3FC00000,$1FC00000,$0FC00000,$03C00000,$01C00000,$00C00000
Data.l $03C00000,$07C00000,$0FC00000,$3FC00000,$FFC00000,$FFC30000,$FFC70000
Data.b $00,$00
EndDataSection

DataSection
Restart16:
Data.l $00010000,$10100001,$00010000,$03680018,$00160000,$00280000,$00100000,$00200000,$00010000,$00000018
Data.l $00000000,$00600000,$00600000,$00000000,$00000000,$00000000,$2B4A3700,$1F015420,$521F0052,$004F1F00
Data.l $1E004C1E,$471D004A,$00441D00,$1C00411C,$3F1C003F,$013C1C00,$002B4034,$53430000,$04A1393D,$3800973A
Data.l $8D38008D,$00893700,$36008537,$7E350082,$007B3500,$33007734,$74330074,$00713300,$42006B31,$50243B4A
Data.l $0CA53716,$34007734,$75340075,$00753400,$52007534,$8C552B8A,$00753430,$34007534,$75340075,$00753400
Data.l $22007233,$51220F39,$12A83517,$3B008136,$843B0984,$32935509,$93008136,$BF9976BB,$0081367D,$40339456
Data.l $87400F87,$0081360F,$22007734,$51220E3A,$12A83517,$3B008136,$843B0984,$32935509,$93008136,$BF9976BB
Data.l $0081367D,$40339456,$87400F87,$0081360F,$22007734,$53210E3A,$1AAC331A,$43008C38,$93430E93,$C6E5D10E
Data.l $9350A96E,$C29675C1,$4DA86C78,$45C6E5D1,$94451194,$008C3811,$22007D35,$54200E3C,$21B0311E,$3800973A
Data.l $95380095,$109C4400,$4365C188,$9D430C9D,$5CBD810C,$37109B43,$94370094,$00973900,$23008236,$561F0E3E
Data.l $29B52E21,$D436B15F,$E4D4D2E4,$D2E4D5D2,$3A54BB75,$A23A03A2,$55BB7703,$DBD9E8DB,$E8DBD9E8,$36B15FD9
Data.l $23008837,$571E0E41,$32B92C25,$4515AB36,$B24527B2,$24AF4227,$3432A94C,$A83413A8,$29A64413,$3F20AE3F
Data.l $AF3F20AF,$14AB3520,$23018D37,$591D0E43,$3BBD2928,$2F26B32F,$B02F25B0,$93CB9A25,$80A2DEA5,$CB7D7ACB
Data.l $B1E3B378,$2F81C488,$B22F25B2,$26B32F25,$24029238,$5A1C0E45,$44C1262A,$3F39BC2A,$C13F4CC1,$9BDD914C
Data.l $923ABC2B,$DB8D9ADC,$3CBD2E95,$38A9E2A0,$BF3845BF,$39BC2A45,$24039738,$5B1B0E47,$4DC5242E,$244BC424
Data.l $C4244BC4,$4BC4244B,$694BC424,$D56285D7,$4BC4247F,$244BC424,$C4244BC4,$4AC4244B,$24039C39,$5B1B0E49
Data.l $4DC5242E,$244BC424,$C4244BC4,$4BC4244B,$694BC424,$D56285D7,$4BC4247F,$244BC424,$C4244BC4,$4AC4244B
Data.l $24039C39,$571C0E49,$55C9212C,$2351C722,$C6234EC6,$4AC4254E,$2745C226,$BD2940BF,$37BB2A3C,$2D33B92C
Data.l $B72D2EB7,$1CAE332E,$24009F3B,$4D41134A,$3FAC243D,$2355C821,$C5234FC5,$48C2254F,$2941BF27,$B92B3BBC
Data.l $2DB62D34,$3226B32F,$B0321FB0,$19AC331F,$42129832,$00003D4D,$2B413500,$1D01411C,$461D0046,$004B1E00
Data.l $1F004F1E,$57200053,$00541F00,$1D004F1E,$4A1D004A,$01441D00,$002B4135,$01800000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$01800000
Data.b $00,$00
EndDataSection

DataSection
Shutdown16:
Data.l $474E5089,$0A1A0A0D,$0D000000,$52444849,$10000000,$10000000,$00000608,$FFF31F00,$01000061,$414449AA
Data.l $63DA7854,$F2A0CFBC,$C002819F,$1600CB88,$36064575,$FB30654D,$0CBBF5D7,$27DE6E7F,$770E00CE,$CEA1065B
Data.l $29660632,$975F8631,$D8C5806E,$FE1834F4,$F0C57F3E,$E18BACAE,$B8C3CEC7,$4E2BE00D,$492FE062,$D8577865
Data.l $F575F0C2,$BF860676,$CC1220FF,$A1DC0C4C,$FD420C9E,$7B1F0CD5,$EA7C32E6,$00698B9D,$05D166C8,$ADCF0C5D
Data.l $DCFE18C3,$B9D58C7B,$0CB24A2C,$32574792,$672849BC,$09750EF8,$0BA900DC,$763E199B,$BAF860CC,$835C2B62
Data.l $0676BCF0,$197F3F86,$C0D5A6DE,$BDC2B8C5,$32AA0419,$FBE99E18,$05000C22,$15E1E498,$2D258F0C,$0206CE11
Data.l $C15375D1,$CB0EBC06,$E8033843,$C7E7D91D,$45D85E19,$71BEFC32,$5700620F,$6F030B80,$4BC32C4E,$27147897
Data.l $08003563,$642F77C4,$09753CF8,$BB0DB7C3,$8B0064A9,$0BD012BA,$02F389CB,$C70BC813,$47D85E18,$0E00BC21
Data.l $40C08BC4,$E206036C,$E881424A,$2CC40C05,$A0FA2060,$302702C6,$7416451A,$1C31A302,$022A3477,$3018F1A3
Data.l $182B131A,$8438EFBE,$24952125,$2717F033,$682DBC33,$7AB6F861,$BFC30307,$7367707F,$08307885,$F861AC4F
Data.l $E18F3BD8,$DC1CCF53,$C3D39949,$9410418E,$A0442594,$98119949,$FE19D594,$F0C37CBE,$6194981E,$0034E336
Data.l $94355806,$99415818,$FBFB2809,$80705DC6,$948C0361,$81006766,$2531D114,$00A896E1,$49000000,$AE444E45
Data.b $42,$60,$82
EndDataSection

DataSection
Abmelden16:
Data.l $00010000,$10100001,$00010000,$03680018,$00160000,$00280000,$00100000,$00200000,$00010000,$00000018
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$6B212121,$9A976B6D,$BCBFBB98
Data.l $EADADED9,$EFEAEBEF,$DADED9EB,$97BCBFBB,$706E989A,$292A296E,$00000000,$00000000,$00000000,$90C8CCC8
Data.l $6F6C9093,$4F514F6C,$29373837,$2B29292B,$37383729,$6C4F514F,$918D6C6F,$C7CBC68E,$00000000,$00000000
Data.l $00000000,$2A262726,$2C2B2A2B,$2B2C2B2B,$2B2B2C2B,$2C2B2B2C,$2B2C2B2B,$2B2B2C2B,$2B2A2B2C,$2324232A
Data.l $00000000,$00000000,$00000000,$2C303130,$2F2E2C2D,$2E2F2E2E,$2E2E2F2E,$2F2E2E2F,$2E2F2E2E,$2E2E2F2E
Data.l $2C2B2E2F,$2D2F2D2B,$00000000,$00000000,$00000000,$2B2C2C2C,$31302B2C,$30313030,$2B2D2E2D,$2C2B2B2C
Data.l $2D2E2D2B,$302F302F,$2B2A3031,$2929292A,$00000000,$00000000,$00000000,$25080808,$2D2D2525,$2B2C2B2D
Data.l $1E232423,$1F1F1E1F,$2324231F,$2C2A2B2A,$25242C2D,$06060624,$00000000,$00000000,$00000000,$13000000
Data.l $23231313,$24252423,$020A0A0A,$03030202,$0A0A0A03,$22242424,$10102223,$00000010,$00000000,$00000000
Data.l $00000000,$00000000,$10100000,$0D0D0D10,$CB797B79,$CDC8CCD0,$717370C9,$0D0B0B0B,$00000D0E,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$787A7700,$528D908D,$55545253,$94969354,$00777A77
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$82848100,$3F3D3E3D,$403F3F40
Data.l $3D3E3D3F,$007F827F,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$42444200
Data.l $42404140,$43424243,$40414042,$00444444,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$33343300,$433D3E3D,$44434344,$3D3E3D43,$00363736,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$16171600,$38313131,$39383839,$30313038,$00161716,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$21131313,$21212121,$12121221,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$03C00000,$03C00000,$03C00000
Data.l $03C00000,$03C00000,$03C00000,$07E00000,$0FF00000,$1FF80000,$1FF80000,$1FF80000,$1FF80000,$1FF80000
Data.l $3FFC0000,$FFFF0000,$FFFF0000
Data.b $00,$00
EndDataSection

DataSection
Energy16:
Data.l $00010000,$10100001,$00010000,$03680018,$00160000,$00280000,$00100000,$00200000,$00010000,$00000018
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$C3C3C3C3,$C3C3C3C3,$C3C3C3C3,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00C3C3C3,$00000000,$C3C3C300,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$C3C3C3C3,$C3C3C3C3,$C3C3C3C3,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00C3C3C3,$00000000
Data.l $C3C3C300,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $26F6F826,$F826F6F8,$F6F826F6,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$F6F82600,$26F6F826,$F826F6F8,$F6F826F6,$00F6F826,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$F6F82600,$8CF6F78C,$F78CF6F7,$F6F78CF6,$00F6F826,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$F8260000,$F6F826F6,$8CF6F78C,$F78CF6F7,$F6F78CF6,$26F6F78C
Data.l $0000F6F8,$00000000,$00000000,$00000000,$00000000,$00000000,$F8260000,$F6F826F6,$BAF7F8BA,$F78CF7F8
Data.l $F6F78CF6,$8CF6F78C,$0000F6F7,$00000000,$00000000,$00000000,$00000000,$26000000,$F826F6F8,$F6F826F6
Data.l $BAF7F8BA,$F8BAF7F8,$F6F78CF7,$8CF6F78C,$F826F6F7,$000000F6,$00000000,$00000000,$00000000,$26000000
Data.l $F826F6F8,$F6F826F6,$FBFEFEFB,$F8BAFEFE,$F6F78CF7,$8CF6F78C,$F826F6F7,$000000F6,$00000000,$00000000
Data.l $00000000,$26000000,$F826F6F8,$F6F826F6,$FBFEFEFB,$F8BAFEFE,$F6F78CF7,$8CF6F78C,$F826F6F7,$000000F6
Data.l $00000000,$00000000,$00000000,$00000000,$F8260000,$F6F826F6,$FBF6F826,$F8BAFEFE,$F6F78CF7,$26F6F826
Data.l $0000F6F8,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$F6F82600,$26F6F826,$F826F6F8
Data.l $F6F826F6,$00F6F826,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$3FFC0000,$1FF80000,$1FF80000
Data.l $1FF80000,$1FF80000,$1FF80000,$0FF00000,$0FF00000,$07E00000,$07E00000,$03C00000,$03C00000,$03C00000
Data.l $07E00000,$0FF00000,$1FF80000
Data.b $00,$00
EndDataSection

DataSection
Information16:
Data.l $00010000,$10100001,$00010000,$03680018,$00160000,$00280000,$00100000,$00200000,$00010000,$00000018
Data.l $00000000,$00600000,$00600000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$91DBFF00
Data.l $8A005E8A,$5E8A005E,$005E8A00,$0091DBFF,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $5E8A0000,$005E8A00,$C80189C8,$89C80189,$0189C801,$8A005E8A,$0000005E,$00000000,$00000000,$00000000
Data.l $00000000,$8A91DBFF,$8FCC005E,$028FCC02,$CC028FCC,$8FCC028F,$028FCC02,$CC028FCC,$5E8A028F,$91DBFF00
Data.l $00000000,$00000000,$00000000,$D1005E8A,$94D10494,$0494D104,$D10494D1,$94D10494,$0494D104,$D10494D1
Data.l $94D10494,$005E8A04,$00000000,$00000000,$005E8A00,$D50599D5,$99D50599,$0599D505,$FFFFFFFF,$FFFFFFFF
Data.l $FFFFFFFF,$D50599D5,$99D50599,$0599D505,$00005E8A,$DBFF0000,$005E8A91,$D9069FD9,$9FD9069F,$069FD906
Data.l $FF069FD9,$FFFFFFFF,$069FD9FF,$D9069FD9,$9FD9069F,$069FD906,$FF005E8A,$5E8A91DB,$07A4DD00,$DD07A4DD
Data.l $A4DD07A4,$07A4DD07,$FF07A4DD,$FFFFFFFF,$07A4DDFF,$DD07A4DD,$A4DD07A4,$07A4DD07,$8A07A4DD,$5E8A005E
Data.l $09AAE200,$E209AAE2,$AAE209AA,$09AAE209,$FF09AAE2,$FFFFFFFF,$09AAE2FF,$E209AAE2,$AAE209AA,$09AAE209
Data.l $8A09AAE2,$5E8A005E,$0AAFE600,$E60AAFE6,$AFE60AAF,$0AAFE60A,$FF0AAFE6,$FFFFFFFF,$0AAFE6FF,$E60AAFE6
Data.l $AFE60AAF,$0AAFE60A,$8A0AAFE6,$5E8A005E,$0BB4EA00,$EA0BB4EA,$B4EA0BB4,$0BB4EA0B,$FFFFFFFF,$FFFFFFFF
Data.l $FFFFFFFF,$EA0BB4EA,$B4EA0BB4,$0BB4EA0B,$8A0BB4EA,$DBFF005E,$005E8A91,$EE0CBAEE,$BAEE0CBA,$0CBAEE0C
Data.l $EE0CBAEE,$BAEE0CBA,$0CBAEE0C,$EE0CBAEE,$BAEE0CBA,$0CBAEE0C,$FF005E8A,$000091DB,$005E8A00,$F20DBFF2
Data.l $BFF20DBF,$0DBFF20D,$FF0DBFF2,$FFFFFFFF,$0DBFF2FF,$F20DBFF2,$BFF20DBF,$0DBFF20D,$00005E8A,$00000000
Data.l $00000000,$F7005E8A,$C4F70FC4,$0FC4F70F,$FF0FC4F7,$FFFFFFFF,$0FC4F7FF,$F70FC4F7,$C4F70FC4,$005E8A0F
Data.l $00000000,$00000000,$00000000,$8A91DBFF,$CAFB005E,$10CAFB10,$FB10CAFB,$CAFB10CA,$10CAFB10,$FB10CAFB
Data.l $5E8A10CA,$91DBFF00,$00000000,$00000000,$00000000,$00000000,$5E8A0000,$005E8A00,$FF11CFFF,$CFFF11CF
Data.l $11CFFF11,$8A005E8A,$0000005E,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$91DBFF00
Data.l $8A005E8A,$5E8A005E,$005E8A00,$0091DBFF,$00000000,$00000000,$00000000,$1FF80000,$0FF00000,$03C00000
Data.l $03C00000,$01800000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$01800000,$03C00000
Data.l $03C00000,$0FF00000,$1FF80000
Data.b $00,$00
EndDataSection

DataSection
Refresh_Start:
Data.q $0A1A0A0D474E5089,$524448490D000000,$2800000028000000,$B8FE8C0000000608,$414449260C00006D
Data.q $D4587998CDC35854,$747AA7DCE9C71E75,$A3DADA7DD9EB69F7,$440ACB4DACDB6DAD,$31510913CD375245
Data.q $8F15B95104D35011,$C39204CC153510BC,$866E62FB98145451,$06198E1983986663,$0450440644043866
Data.q $FF7679F019FBDE03,$F3CF8FEAD2A367D8,$FEF35E61E786FEFB,$7B64BF1E000F5FDC,$744F7BBDDEE4FF20
Data.q $D05F6B6B6CDEBA76,$E57C6CE9CF32DCDC,$2E80117F47EDDF76,$54A6454D1AEBD757,$2549EF2A952EB8AA
Data.q $B8B364E8572E41D2,$1A1A1A5F6A6A6A47,$6E6D1F8BE90079FA,$4B16665D44BF36BE,$0E558B205560C04A
Data.q $90A0B32BAA067D67,$8AA954A05797908B,$F602D3F3B9DCEEBD,$A5DEA962DE7EDDF5,$7E0C0E85125DAA54
Data.q $295E68E1305FF60D,$AD1E27B863246F7A,$F162C0735328C9F5,$D6D6D6E6EE6CD89B,$1BA9ED62901D0F89
Data.q $7572CC9A5616371D,$95428CD4BCB0D971,$1E82E2F8B5B86703,$E8193D75B8D4F247,$81EE76E8315C028E
Data.q $6160D15162017341,$7B7A7D1830698721,$C3C3C380A0789F7B,$60929E7DDEEF771E,$EAA96D5F99D3A369
Data.q $614074AF284CEAD3,$5AC21913A941476E,$023282F1C46CBA1C,$BC820E81A2E092FC,$9E54347896818D1E
Data.q $E2E4571E038A8944,$7BB3D555555984F1,$9FFCF89E3D7E7A7A,$DF6F13B7EDFB7E1F,$977056E7AB75E3BE
Data.q $686FAEDEDEDA95CB,$B7A251AB1BD01868,$8A177A861D7AC2A1,$C8BB2136D6C1DBAB,$D069654895F9A386
Data.q $78B824ED740A91DB,$D12DB046B8062DA0,$D41A7D5A85DFA9E8,$2F9F2F7102842E4A,$4B66CC938BCB962E
Data.q $F7D7D7D49CE9D3A0,$BBBA47B14900B8D8,$7356F37DD9BA1E6F,$6D2A03AD5548DB4B,$48469A781B6AF82D
Data.q $BD8540ED6651DB2B,$0099A03712803FF3,$0082FC14867804B5,$A058E6803BAD0177,$14671186DCE03B71
Data.q $93029958D0BB6D7A,$1A225485CAA922E6,$07FDFEC34AE974BA,$C520377FF7F7F4A6,$C5837CDD5D5D93D9
Data.q $640E643046F22B89,$B172E03691C81C49,$506D2CC8668ABC03,$406E2BC82D0C0990,$2C71192E0716BF1A
Data.q $00F009D23AB71CBF,$949009130097BED0,$64EC056C3777246C,$7163D90C36E7EE75,$F80809D34E13BEC7
Data.q $6E6F2E562B15A1FC,$9E0777BBC06EFE6E,$2D901AE852AB82A1,$1ABC291D9169C36D,$53E47664319C51A4
Data.q $615733F74948B1CC,$71BDC84716A0BA47,$7B4F46A8BBEC5AD9,$D7804BDC9079D006,$375723D48129B008
Data.q $500B76A036DD6410,$3A1373D337980E15,$82824671E0203B0D,$7803C63870E0DD3E,$ADA9172CE1D38277
Data.q $471AAB28E13710C8,$C864D1AA9C7DC80A,$BCD38AC88DF0DB14,$239280705A671C6A,$CD8894A7F5835B36
Data.q $FD904A34B5E6E194,$0E80FBBD8A1EDEA4,$04AD209DA2C52037,$50DA02362A008969,$1C1132E020A3CAB8
Data.q $77FDFD805C65B21C,$35451CB558D4D627,$7B12A57FD89C0B4E,$994A48C57491EA2F,$227BD05F098AF870
Data.q $A9A44472ACD88743,$361121FF87229211,$DEE457D37744257E,$6EF58314CD80637D,$0614C07AD41136D5
Data.q $007901AB6502D7E8,$3C8438756E865D20,$316D7F01B8E86037,$1C70A42AD2596957,$0483472E2035CC48
Data.q $2128CD6C72ECB8B2,$A52FD3EA09422510,$F802FDE2C62C9E58,$1B2E1B28E820E4EE,$42915698EA46D7B9
Data.q $821CC500BFF5008B,$A7C64C59D1140B99,$8ADD0B33804CE677,$1F5D0D0885788830,$59A32689FEC04E39
Data.q $E2035671C4A92853,$E99114B676D81519,$F81263EAC0A604C5,$EDE63E3EE162141D,$E015B7931B1811E5
Data.q $D703145EF0977585,$E662B97D25012B65,$3E48059D264E53D8,$0908047F14824024,$D7C97039BCEF4392
Data.q $371B090908858291,$4250B8B1BD0633E0,$C20D2CA88ED0ABAD,$C7C112B4E9B18AD3,$81C5D9CD6A4258A5
Data.q $6FC55C446F133C77,$F8F03981E3C05ED7,$88BDA167846F1B24,$9F2A5046419AA75C,$302326CE967490FB
Data.q $3459D3E324827CE9,$B1B3E220CFCA9D0F,$0C0E0171F0DACD66,$22CC789BD0693C0C,$8E5B3C88EDF3923D
Data.q $79581409292B5F8D,$F00BDB29B55468B4,$C80B06E63C05C85C,$0C7B223378396FBE,$3BED4A098B0098B0
Data.q $C09ABB74A704C566,$63E8BEB919000BE4,$CF90628ABB442E7A,$402E3C195C0C0E1D,$BB06260D1A8F22EA
Data.q $519110EB57C38748,$24B2C2277382308E,$1882A7805ADCDE31,$8CE796478D9605FF,$E5D2ED0725B5BE02
Data.q $A72C2E4A57290940,$0C4A3CF95810D358,$D04A5B7F4C5D2B02,$29687ECE84BC047E,$5BF3F41DC3970589
Data.q $CD7BDDD0755C78B6,$498706893CC39695,$89527A7C3AE94DC1,$4263618E4C32A380,$E697239F963C2E70
Data.q $49818DB8073A37DC,$D48A090328740C11,$529233827A6A92D3,$3E9FC19412330246,$04367434C82B8523
Data.q $3D9957F90FB651C0,$5F1E7F537A0797CB,$1EA65899F332A62F,$99D8458A919412C9,$BFEDF87C9486C6C3
Data.q $53D6DA60DFF1D980,$F324F351C9CB60F8,$13FC2A6467814C8A,$4BCBF2841B92438F,$E872C15D0FE2B9A1
Data.q $0FC2C0D7713041D9,$A19F85AA3D609545,$E7F15A80DBC64046,$535CF33320CFCAD0,$C7070706DFF07070
Data.q $E52952CFD7B76807,$688DEEE24E39AE77,$B70876DB70123BF4,$DD3E851CCFA20F6B,$1164B7A1F996F41A
Data.q $AA0164ACC60BD57A,$717883E09DE2170A,$0F7F0D26BCBC19E5,$843F4D94DCFF06FB,$0AE6373117ED9F01
Data.q $F885F1C7C02B8E3E,$63C8F9122B10B638,$3A3A34B9293871AB,$7601F1919191D9FA,$EB59532641FC7474
Data.q $A7ACEF51B56DA8AB,$1D443A8C9BB0D4F6,$4042C35A150B0375,$CE977DE1FB436547,$8C955B5E36733D42
Data.q $5E36557E78590189,$B78CB86EAF1E7B5C,$A3BC1636DEF1F3C2,$3E288CC7C31998B9,$8A195ED562176FA6
Data.q $AC99D9F0D86C1AE4,$BB516E3DC7C7ACAC,$CB28A9CD2CA55C7B,$ACDF501BBB9360C7,$3AD57BD3B403184F
Data.q $5A95944B1465A98A,$0E70097D21B82277,$83915D9E08FAB1FE,$A38BFAF2F030D617,$78E3D30B146A68A5
Data.q $D3009C66601049F0,$0AA9F108BA3209A2,$07E6F379C1CA65C8,$F5EAB037EFFAF5E9,$3D61D03C4C857F46
Data.q $4C8D1D7B9A94BD4C,$BD0D64A4ECBED4F5,$51D0B953D6415257,$47E606B519CCD5E1,$FF9651CF0C7C1498
Data.q $C982BE6DAF172C31,$214EDC1025784C51,$A980562D3088767C,$414E43209B98F9DB,$592C96DA66CF3209
Data.q $B5B00FDFDA4D0AF2,$E8B5A2408179EDB5,$21B9D52E3DD861CE,$9EA66B04AD00C613,$652D48245484F86A
Data.q $56F1F3D81A1E76AA,$BAFE2E6D7EFC71C8,$78BDE216B6930F31,$316ED66212EC662E,$D9DE0168D4E013A6
Data.q $744B8A3961C8422E,$F1389C4E524241D4,$907A1EA9F91EF7C4,$DDCBA860994A11FC,$7239E7B9B66EDD5F
Data.q $95B7EA2AD08695B1,$E88CA82A054B47AB,$2F12775E4E028FE6,$65A305116BC3CBAD,$33188F75B9276BC9
Data.q $DEA4C9885E33D009,$142668D34E1978CC,$56C33BE59ACC6E08,$F1C1A3893B61FB67,$0C0CB45830239702
Data.q $6C695A411B3A67B9,$8A4549239B91C5B2,$0B8F1DDAB9105345,$C29E37778059C0D1,$D4C5251263E6365F
Data.q $6F733088F7BC1E78,$5218DDE114EDA611,$B5CA0564D08C4A2F,$C7C7C56646464426,$5DD0083FBDAEED3F
Data.q $3844993AFE5CB897,$98DB6390CB435ED8,$E7CB5025AD82568A,$BF43DD43094C1904,$34F9BFBC42EE0E18
Data.q $DE2E18EDE2670D5E,$BD48D318A012144F,$9B9805DBDBDEA4A9,$FC6F6A52C2B9C4A8,$D4D4D778663319D6
Data.q $E6FDB566CEADB8FC,$FD0B19455E7CA5F2,$0C6A35B1936303CE,$520108654FCA9AB2,$A6116F23412FD0F7
Data.q $13BC6CADF5E1A645,$8453DB4D812787CF,$8FDEF629B7BD49F7,$32C9930E868E2195,$E262625250556ABC
Data.q $63BA0171BD4FFF93,$56DC59B37B62C591,$320892D7C31731AB,$A06F351486B00C61,$117F1360AA315C38
Data.q $A61E18CDE2CFA27C,$BB07C22EEE7AD652,$82091894C42B04C4,$4F48C82C6B505492,$A5A5B97DF5F5F32F
Data.q $8F6D6D6DEE2CC1E5,$0788952AD8C99DA6,$DC827CC4D1CF6B9A,$9348AA8E2C58C5FD,$A3E0568B9A2569B2
Data.q $4DCA45E189C10644,$2098292267812BDB,$D08D88146A7DE2C5,$3316BCBCBC37346A,$4542CDE81E47CC99
Data.q $129CCC8C8C84C545,$A23168171C3A1155,$635D9D9508E9ADED,$0204496B50CB4389,$49D985487BE1F392
Data.q $0EFCC08C90787C4A,$06A71A0B557E916A,$FCC4C4C477FDFDFC,$BEE1F57B07C7B68A,$3ECECE7F58B16005
Data.q $55D346E0912B2B2F,$8F769AFCD48326E0,$B17B8DD7087B0463,$9FF87AD3FF045D31,$2C53822349C040AA
Data.q $4438D9D381A8BD48,$CECED9F9454E9B59,$CAA5BEE3377387CE,$4D5CB9DCEB79CECE,$F48C4C8D6D0CA979
Data.q $D13385DA79E813E6,$92DE37687B0A7759,$D863889D176D8F57,$F0EB6AEA83557191,$FD3E9F4D2F3B1D8E
Data.q $BAB76F70F6CD9B45,$E539389E4E3CBABA,$EA1512D2E29CD9EC,$30EE07C9BFE8F86A,$4E1B4A191E72D3D1
Data.q $D62851DAE5485DC8,$85B11117B86742A1,$F0C18327FDEDEDE1,$948F2E5CB9BF5CD3,$5B32F91C8E57D494
Data.q $B7A8E4EBD1DC572E,$A232A05071B0E10A,$A14201B949426E40,$1F1F41DFA974B5C8,$81751FB810FDDF9F
Data.q $8427E7F3F9F776E9,$172D3D4D4EAC4787,$9290F1652A3DC408,$B1C6C6C67764C58C,$EC2C2C28B2994CA7
Data.q $D80AEF9FA6A6A6E9,$B9FBBDDEEC7B366C,$86160B05DF40C0C0,$73D3D3D4373399CE,$C70E1CB3C040407A
Data.q $87F7E897FCFD84BD,$4D1D3A751BB70F5C,$1F01C0F60D1FF6E4,$CF18330AE31BFD96,$490000000081A888
Data.b $45,$4E,$44,$AE,$42,$60,$82
EndDataSection

DataSection
File_Start3:
Data.l $00010000,$20200001,$00010000,$08A80008,$00160000,$00280000,$00200000,$00400000,$00010000,$00000008
Data.l $04800000,$00000000,$00000000,$01000000,$00000000,$00000000,$00004300,$80004F80,$80004F00,$00804C80
Data.l $00802D00,$80805780,$C0C04500,$DCC042C0,$CAF02EC0,$F0D444A6,$E2B145FF,$D48E00FF,$C66B00FF,$B84800FF
Data.l $AA2500FF,$AA0000FF,$920043FF,$7A004FDC,$62004FB9,$4A004C96,$32002D73,$E3D45750,$C7B145FF,$AB8E42FF
Data.l $8F6B2EFF,$734844FF,$572545FF,$550000FF,$490000FF,$3D0000DC,$310000B9,$25000096,$19004373,$D4D44F50
Data.l $B1B14FFF,$8E8E4CFF,$6B6B2DFF,$484857FF,$252545FF,$000042FF,$00002EFE,$000044DC,$000045B9,$00000096
Data.l $00000073,$D4E30050,$B1C700FF,$8EAB00FF,$6B8F43FF,$48734FFF,$25574FFF,$00554CFF,$00492DFF,$003D57DC
Data.l $003145B9,$00254296,$00192E73,$D4F04450,$B1E245FF,$8ED400FF,$6BC600FF,$48B800FF,$25AA00FF,$00AA00FF
Data.l $009243FF,$007A4FDC,$00624FB9,$004A4C96,$00322D73,$D4FF5750,$B1FF45FF,$8EFF42FF,$6BFF2EFF,$48FF44FF
Data.l $25FF45FF,$00FE00FF,$00DC00FE,$00B900DC,$009600B9,$00730096,$00504373,$D4FF4F50,$B1FF4FF0,$8EFF4CE2
Data.l $6BFF2DD4,$48FF57C6,$25FF45B8,$00FF42AA,$00DC2EAA,$00B94492,$0096457A,$00730062,$0050004A,$D4FF0032
Data.l $B1FF00E3,$8EFF00C7,$6BFF43AB,$48FF4F8F,$25FF4F73,$00FF4C57,$00DC2D55,$00B95749,$0096453D,$00734231
Data.l $00502E25,$D4FF4419,$B1FF45D4,$8EFF00B1,$6BFF008E,$48FF006B,$25FF0048,$00FE0025,$00DC4300,$00B94F00
Data.l $00964F00,$00734C00,$00502D00,$E3FF5700,$C7FF45D4,$ABFF42B1,$8FFF2E8E,$73FF446B,$57FF4548,$55FF0025
Data.l $49DC0000,$3DB90000,$31960000,$25730000,$19504300,$F0FF4F00,$E2FF4FD4,$D4FF4CB1,$C6FF2D8E,$B8FF576B
Data.l $AAFF4548,$AAFF4225,$92DC2E00,$7AB94400,$62964500,$4A730000,$32500000,$FFFF0000,$FFFF00D4,$FFFF00B1
Data.l $FFFF438E,$FFFF4F6B,$FFFF4F48,$FEFE4C25,$DCDC2D00,$B9B95700,$96964500,$73734200,$50502E00,$FFF04400
Data.l $FFE245D4,$FFD400B1,$FFC6008E,$FFB8006B,$FFAA0048,$FFAA0025,$DC924300,$B97A4F00,$96624F00,$734A4C00
Data.l $50322D00,$FFE35700,$FFC745D4,$FFAB42B1,$FF8F2E8E,$FF73446B,$FF574548,$FF550025,$DC490000,$B93D0000
Data.l $96310000,$73250000,$50194300,$FFD44F00,$FFB14FD4,$FF8E4CB1,$FF6B2D8E,$FF48576B,$FF254548,$FE004225
Data.l $DC002E00,$B9004400,$96004500,$73000000,$50000000,$FFD40000,$FFB100E3,$FF8E00C7,$FF6B43AB,$FF484F8F
Data.l $FF254F73,$FF004C57,$DC002D55,$B9005749,$9600453D,$73004231,$50002E25,$FFD44419,$FFB145F0,$FF8E00E2
Data.l $FF6B00D4,$FF4800C6,$FF2500B8,$FF0000AA,$DC0043AA,$B9004F92,$96004F7A,$73004C62,$50002D4A,$FFD45732
Data.l $FFB145FF,$FF8E42FF,$FF6B2EFF,$FF4844FF,$FF2545FF,$FE0000FF,$DC0000FE,$B90000DC,$960000B9,$73000096
Data.l $50004373,$F2F24F50,$E6E64FF2,$DADA4CE6,$CECE2DDA,$C2C257CE,$B6B645C2,$AAAA42B6,$9E9E2EAA,$9292449E
Data.l $86864592,$7A7A0086,$6E6E007A,$6262006E,$56560062,$4A4A0056,$3E3E434A,$32324F3E,$26264F32,$1A1A4C26
Data.l $0E0E2D1A,$FBF0570E,$A0A445FF,$808042A0,$00002E80,$FF0044FF,$FF004500,$00FF00FF,$00FF0000,$FFFF00FF
Data.l $FFFF0000,$000000FF,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$F8000000,$F8F8F8F8
Data.l $F8F8F8F8,$F8F8F8F8,$F8F8F8F8,$F8F8F8F8,$000000F8,$00000000,$07F60000,$07070707,$07070707,$07070707
Data.l $07070707,$07070707,$0000F807,$00000000,$07F60000,$07070707,$07070707,$07070707,$07070707,$07070707
Data.l $0000F807,$00000000,$07F60000,$07070707,$07070707,$07070707,$07070707,$07070707,$0000F807,$00000000
Data.l $07F60000,$07070707,$07070707,$07070707,$07070707,$07070707,$0000F807,$00000000,$07F60000,$07070707
Data.l $07070707,$07070707,$07070707,$07070707,$0000F807,$00000000,$07F60000,$07070707,$07070707,$07070707
Data.l $07070707,$07070707,$0000F807,$00000000,$07F60000,$07070707,$07070707,$07070707,$07070707,$07070707
Data.l $0000F807,$00000000,$07F60000,$07070707,$07070707,$07070707,$07070707,$07070707,$0000F807,$00000000
Data.l $07F60000,$07070707,$07070707,$07070707,$07070707,$07070707,$0000F807,$00000000,$07F60000,$07070707
Data.l $07070707,$07070707,$07070707,$07070707,$0000F807,$00000000,$07F60000,$07070707,$07070707,$07070707
Data.l $07070707,$07070707,$0000F807,$00000000,$07F60000,$07070707,$07070707,$07070707,$07070707,$07070707
Data.l $0000F807,$00000000,$07F60000,$07070707,$07070707,$07070707,$07070707,$07070707,$0000F807,$00000000
Data.l $07F60000,$07070707,$07070707,$07070707,$07070707,$07070707,$0000F807,$00000000,$07F60000,$07070707
Data.l $07070707,$07070707,$07070707,$07070707,$0000F807,$00000000,$07F60000,$07070707,$07070707,$07070707
Data.l $07070707,$07070707,$0000F807,$00000000,$07F60000,$07070707,$07070707,$07070707,$07070707,$07070707
Data.l $0000F807,$00000000,$07F60000,$07070707,$07070707,$07070707,$07070707,$07070707,$0000F807,$00000000
Data.l $07F60000,$07070707,$07070707,$07070707,$07070707,$07070707,$0000F807,$00000000,$07F60000,$07070707
Data.l $07070707,$07070707,$07070707,$F8F8F8F8,$0000F8F8,$00000000,$07F60000,$07070707,$07070707,$07070707
Data.l $00070707,$00000000,$00000000,$00000000,$07F60000,$07070707,$07070707,$07070707,$00000707,$00000000
Data.l $00000000,$00000000,$07F60000,$07070707,$07070707,$07070707,$00000707,$F8F8F800,$000000F8,$00000000
Data.l $07F60000,$07070707,$07070707,$07070707,$00000707,$E4E4E4F6,$00000000,$00000000,$07F60000,$07070707
Data.l $07070707,$07070707,$00000707,$00E4E4F6,$00000000,$00000000,$07F60000,$07070707,$07070707,$07070707
Data.l $00000707,$0000E4F6,$00000000,$00000000,$F6000000,$F6F6F6F6,$F6F6F6F6,$F6F6F6F6,$0000F6F6,$000000F6
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00E00000,$00C00700,$00C00300
Data.l $00C00300,$00C00300,$00C00300,$00C00300,$00C00300,$00C00300,$00C00300,$00C00300,$00C00300,$00C00300
Data.l $00C00300,$00C00300,$00C00300,$00C00300,$00C00300,$00C00300,$00C00300,$00C00300,$00C00300,$00C00300
Data.l $00C00300,$00C00300,$00C00300,$00C00300,$00C00700,$00C00F00,$00C01F00,$00C03F00,$00E07F00
Data.b $00,$FF
EndDataSection

DataSection
Folder_Start2:
Data.l $00010000,$20200001,$00010000,$08A80008,$00160000,$00280000,$00200000,$00400000,$00010000,$00000008
Data.l $04000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00004300,$80004F80,$80004F00,$00804C80
Data.l $00802D00,$80805780,$C0C04500,$DCC042C0,$CAF02EC0,$040444A6,$08084504,$0C0C0008,$1111000C,$16160011
Data.l $1C1C0016,$2222001C,$29294322,$55554F29,$4D4D4F55,$42424C4D,$39392D42,$7C805739,$505045FF,$009342FF
Data.l $ECFF2ED6,$D6C644CC,$E7D645EF,$A99000E7,$000000AD,$00000033,$00000066,$00000099,$330043CC,$33004F00
Data.l $33004F33,$33004C66,$33002D99,$330057CC,$660045FF,$66004200,$66002E33,$66004466,$66004599,$660000CC
Data.l $990000FF,$99000000,$99000033,$99000066,$99004399,$99004FCC,$CC004FFF,$CC004C00,$CC002D33,$CC005766
Data.l $CC004599,$CC0042CC,$FF002EFF,$FF004466,$FF004599,$003300CC,$00330000,$00330033,$00330066,$00330099
Data.l $003343CC,$33334FFF,$33334F00,$33334C33,$33332D66,$33335799,$333345CC,$663342FF,$66332E00,$66334433
Data.l $66334566,$66330099,$663300CC,$993300FF,$99330000,$99330033,$99334366,$99334F99,$99334FCC,$CC334CFF
Data.l $CC332D00,$CC335733,$CC334566,$CC334299,$CC332ECC,$FF3344FF,$FF334533,$FF330066,$FF330099,$FF3300CC
Data.l $006600FF,$00660000,$00664333,$00664F66,$00664F99,$00664CCC,$33662DFF,$33665700,$33664533,$33664266
Data.l $33662E99,$336644CC,$666645FF,$66660000,$66660033,$66660066,$66660099,$996600CC,$99664300,$99664F33
Data.l $99664F66,$99664C99,$99662DCC,$CC6657FF,$CC664500,$CC664233,$CC662E99,$CC6644CC,$FF6645FF,$FF660000
Data.l $FF660033,$FF660099,$00CC00CC,$00FF00FF,$999943CC,$33994F00,$00994F99,$00994C99,$00992DCC,$33995700
Data.l $00994533,$33994266,$00992ECC,$669944FF,$66994500,$33990033,$66990066,$66990099,$339900CC,$999900FF
Data.l $99994333,$99994F66,$99994F99,$99994CCC,$CC992DFF,$CC995700,$CC664533,$CC994266,$CC992E99,$CC9944CC
Data.l $FF9945FF,$FF990000,$CC990033,$FF990066,$FF990099,$FF9900CC,$00CC43FF,$00994F00,$00CC4F33,$00CC4C66
Data.l $00CC2D99,$339957CC,$33CC4500,$33CC4233,$33CC2E66,$33CC4499,$33CC45CC,$66CC00FF,$66CC0000,$66990033
Data.l $66CC0066,$66CC0099,$669943CC,$99CC4FFF,$99CC4F00,$99CC4C33,$99CC2D66,$99CC5799,$99CC45CC,$CCCC42FF
Data.l $CCCC2E00,$CCCC4433,$CCCC4566,$CCCC0099,$CCCC00CC,$FFCC00FF,$FFCC0000,$FF990033,$FFCC4366,$FFCC4F99
Data.l $FFCC4FCC,$00CC4CFF,$00FF2D33,$00FF5766,$33CC4599,$33FF4200,$33FF2E33,$33FF4466,$33FF4599,$33FF00CC
Data.l $66FF00FF,$66FF0000,$66CC0033,$66FF0066,$66FF4399,$66CC4FCC,$99FF4FFF,$99FF4C00,$99FF2D33,$99FF5766
Data.l $99FF4599,$99FF42CC,$CCFF2EFF,$CCFF4400,$CCFF4533,$CCFF0066,$CCFF0099,$CCFF00CC,$FFFF00FF,$FFCC0033
Data.l $FFFF4366,$FFFF4F99,$66664FCC,$FF664CFF,$FF662D66,$66FF57FF,$66FF4566,$FFFF42FF,$00212E66,$5F5F44A5
Data.l $7777455F,$86860077,$96960086,$CBCB0096,$B2B200CB,$D7D700B2,$DDDD43D7,$E3E34FDD,$EAEA4FE3,$F1F14CEA
Data.l $F8F82DF1,$FBF057F8,$A0A445FF,$808042A0,$00002E80,$FF0044FF,$FF004500,$00FF00FF,$00FF0000,$FFFF00FF
Data.l $FFFF0000,$000000FF,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$22000000,$22222222,$22222222,$22222222,$22222222,$22222222,$22222222
Data.l $22222222,$79300022,$79797979,$79797979,$79797979,$79797979,$79797979,$79797979,$79797979,$F5302279
Data.l $A09AA09A,$9AA0A09A,$A0A09AA0,$9AA09AA0,$9A9AA0A0,$9AA09AA0,$9AA09A9A,$F5302279,$9AA0A0A0,$A0A09AA0
Data.l $9AA0A09A,$A09AA09A,$A0A09A9A,$A09A9A9A,$9A9A9A9A,$F5302279,$A0A0A09A,$A09AA0A0,$A09A9AA0,$9AA09AA0
Data.l $9A9AA0A0,$9A9AA09A,$9A9A9A9A,$F5302279,$A09AA0A0,$9AA0A09A,$9AA0A0A0,$A0A09AA0,$9AA0A09A,$9AA09A9A
Data.l $9A9AA0A0,$F5302279,$A0A0A0A0,$A0A0A0A0,$A0A09AA0,$9A9AA09A,$A09A9AA0,$9A9AA0A0,$9AA09A9A,$F5302279
Data.l $9AA09AA0,$A09AA0A0,$9AA0A09A,$A0A09AA0,$9AA0A0A0,$A09A9A9A,$9A9A9A9A,$F5302279,$A0A0A0A0,$A0A0A0A0
Data.l $A0A09AA0,$9AA0A0A0,$A09A9AA0,$9AA09A9A,$A09AA09A,$F5302279,$A0A0A0A0,$A09AA0A0,$A09AA0A0,$A09AA09A
Data.l $9AA0A09A,$A09AA0A0,$9A9A9AA0,$F5302279,$A0A0A0A0,$A0A0A09A,$A0A0A0A0,$A0A0A0A0,$A09AA0A0,$9AA09A9A
Data.l $9AA09A9A,$F5302279,$A0A0A0A0,$A0A0A0A0,$A09AA09A,$9A9AA09A,$A0A09AA0,$A09AA0A0,$A09A9AA0,$F5302279
Data.l $A0A0A0A0,$A09AA0A0,$A0A0A0A0,$A0A0A0A0,$A09AA0A0,$9AA0A09A,$9AA0A09A,$F5302279,$A0A0A0A0,$A0A0A0A0
Data.l $9AA0A0A0,$A09AA0A0,$9AA0A09A,$A09AA0A0,$A09AA0A0,$F5302279,$A0A0A0A0,$A0A0A0A0,$A0A0A09A,$A0A09AA0
Data.l $A0A0A0A0,$A0A09AA0,$9AA09A9A,$F5302279,$A0A0A0A0,$A0A0A0A0,$A0A0A0A0,$A0A0A0A0,$A09AA09A,$A09AA09A
Data.l $A09AA0A0,$F5302279,$A0A0A0A0,$A0A0A0A0,$A09AA0A0,$A09AA09A,$A0A0A0A0,$9AA0A0A0,$9AA09AA0,$F5302279
Data.l $A0A0A0A0,$A0A0A0A0,$A0A0A0A0,$A0A0A0A0,$A09AA09A,$A09AA0A0,$9AA0A0A0,$F5302279,$A0A0A0A0,$A0A0A0A0
Data.l $A0A0A0A0,$A0A0A0A0,$A0A0A0A0,$9AA0A09A,$A0A0A09A,$F5302279,$A0A0A0A0,$A0A0A0A0,$A0A0A0A0,$9AA09AA0
Data.l $A0A09AA0,$A0A09AA0,$9AA09AA0,$F5302279,$A0A0A0A0,$A0A0A0A0,$A0A0A0A0,$A0A0A0A0,$9AA0A0A0,$A09AA0A0
Data.l $A09AA0A0,$F5300B79,$F5F5F5F5,$F5F5F5F5,$F5F5F5F5,$F5F5F5F5,$F5F5F5F5,$F5F5F5F5,$F5F5F5F5,$79300000
Data.l $79797979,$79797979,$79797979,$30307979,$30303030,$30303030,$30303030,$30000000,$A0A0A0F6,$A0A0A0A0
Data.l $A0A0A0A0,$000B30A0,$00000000,$00000000,$00000000,$00000000,$A0A0F530,$A0A0A0A0,$A0A0A0A0,$00000B30
Data.l $00000000,$00000000,$00000000,$00000000,$A0F53000,$A0A0A0A0,$30A0A0A0,$0000000B,$00000000,$00000000
Data.l $00000000,$00000000,$30300000,$30303030,$0B303030,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$FFFF0000,$FFFFFFFF,$FFFFFFFF
Data.l $FFFFFFFF,$0080FFFF,$00000100,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
Data.l $00000000,$00000000,$00000000,$00000100,$00800300,$00C0FF7F,$01E0FFFF,$03F0FFFF,$FFFFFFFF
Data.b $FF,$FF
EndDataSection

DataSection
File_Start4:
Data.l $00010000,$30300001,$00010000,$06680004,$00160000,$00280000,$00300000,$00600000,$00010000,$00000004
Data.l $04800000,$00000000,$00000000,$00000000,$00000000,$00000000,$00004300,$80004F80,$80004F00,$00804C80
Data.l $00802D00,$80805780,$C0C04500,$808042C0,$00002E80,$FF0044FF,$FF004500,$00FF00FF,$00FF0000,$FFFF00FF
Data.l $FFFF0000,$000000FF,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$77777708,$77777777
Data.l $77777777,$77777777,$70777777,$00000000,$FFFFFF08,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF,$70FFFFFF,$00000000
Data.l $FFFFFF08,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF,$70FFFFFF,$00000000,$FFFFFF08,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF
Data.l $70FFFFFF,$00000000,$FFFFFF08,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF,$70FFFFFF,$00000000,$FFFFFF08,$FFFFFFFF
Data.l $FFFFFFFF,$FFFFFFFF,$70FFFFFF,$00000000,$FFFFFF08,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF,$70FFFFFF,$00000000
Data.l $FFFFFF08,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF,$70FFFFFF,$00000000,$FFFFFF08,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF
Data.l $70FFFFFF,$00000000,$FFFFFF08,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF,$70FFFFFF,$00000000,$FFFFFF08,$FF0FFFF0
Data.l $FFFFFFFF,$FFFFFFFF,$70FFFFFF,$00000000,$FFFFFF08,$F0000FF0,$FFFFFFFF,$FFFFFFFF,$70FFFFFF,$00000000
Data.l $F0FFFF08,$F0000FFF,$FF0FF000,$F0FFFFFF,$70FFFF0F,$00000000,$F0FFFF08,$F0F0FFFF,$0F00F000,$00F0FFFF
Data.l $70FFFF0F,$00000000,$FFFFFF08,$FFCFFFFC,$0000F0F0,$00000000,$70FFFF0F,$00000000,$FFFFFF08,$FCCCCFFC
Data.l $0000F0FF,$00000000,$70FFFF0F,$00000000,$FCFFFF08,$FCCCCFFF,$400CF0CC,$B0030000,$70FFFF0F,$00000000
Data.l $FCFFFF08,$FCFCFFFF,$CC0CF0CC,$B0BB0BC0,$70FFFF0F,$00000000,$FFFFFF08,$FF0FFFF0,$CC0CF0FC,$B0BB0BC0
Data.l $70FFFF0F,$00000000,$FFFFFF08,$F0000FF0,$CC0CF0FF,$B0BB0BC0,$70FFFF0F,$00000000,$F0FFFF08,$F0000FFF
Data.l $CC0CF000,$B0BB0BC0,$70FFFF0F,$00000000,$F0FFFF08,$F0F0FFFF,$4C00F000,$00B30BC0,$70FFFF0F,$00000000
Data.l $FFFFFF08,$FF9FFFF9,$0000F0F0,$00000000,$70FFFF0F,$00000000,$FFFFFF08,$F9999FF9,$0000F0FF,$00000000
Data.l $70FFFF0F,$00000000,$F9FFFF08,$F9999FFF,$1009F099,$A0020000,$70FFFF0F,$00000000,$F9FFFF08,$F9F9FFFF
Data.l $9909F099,$A0AA0A90,$70FFFF0F,$00000000,$FFFFFF08,$FF0FFFF0,$9909F0F9,$A0AA0A90,$70FFFF0F,$00000000
Data.l $FFFFFF08,$F0000FF0,$9909F0FF,$A0AA0A90,$70FFFF0F,$00000000,$F0FFFF08,$F0000FFF,$9909F000,$A0AA0A90
Data.l $70FFFF0F,$00000000,$F0FFFF08,$F0F0FFFF,$1900F000,$00A20A90,$70FFFF0F,$00000000,$FFFFFF08,$FFFFFFFF
Data.l $0000F0F0,$00000000,$70FFFF0F,$00000000,$FFFFFF08,$FFFFFFFF,$0000FFFF,$00000000,$70FFFFFF,$00000000
Data.l $FFFFFF08,$FFFFFFFF,$00FFFFFF,$FF000000,$70FFFFFF,$00000000,$FFFFFF08,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF
Data.l $70FFFFFF,$00000000,$FFFFFF08,$FFFFFFFF,$FFFFFFFF,$FFFFFFFF,$70FFFFFF,$00000000,$FFFFFF08,$FFFFFFFF
Data.l $FFFFFFFF,$FFFFFFFF,$70FFFFFF,$00000000,$FFFFFF08,$FFFFFFFF,$FFFFFFFF,$80FFFFFF,$00000000,$00000000
Data.l $FFFFFF08,$FFFFFFFF,$FFFFFFFF,$8FFFFFFF,$80F7FFFF,$00000000,$FFFFFF08,$FFFFFFFF,$FFFFFFFF,$8FFFFFFF
Data.l $0078FFFF,$00000000,$FFFFFF08,$FFFFFFFF,$FFFFFFFF,$8FFFFFFF,$0080F7FF,$00000000,$FFFFFF08,$FFFFFFFF
Data.l $FFFFFFFF,$8FFFFFFF,$000078FF,$00000000,$FFFFFF08,$FFFFFFFF,$FFFFFFFF,$8FFFFFFF,$000080F7,$00000000
Data.l $FFFFFF08,$FFFFFFFF,$FFFFFFFF,$8FFFFFFF,$00000078,$00000000,$FFFFFF08,$FFFFFFFF,$FFFFFFFF,$87FFFFFF
Data.l $00000080,$00000000,$FFFFFF08,$FFFFFFFF,$FFFFFFFF,$88FFFFFF,$00000000,$00000000,$FFFFFF08,$FFFFFFFF
Data.l $FFFFFFFF,$80FFFFFF,$00000000,$00000000,$88888808,$88888888,$88888888,$80888888,$00000000,$00F80000
Data.l $0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000
Data.l $0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000
Data.l $0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000
Data.l $0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000
Data.l $0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000
Data.l $0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000
Data.l $0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000
Data.l $0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$0F000000,$00F80000,$1F000000,$00F80000
Data.l $3F000000,$00F80000,$7F000000,$00F80000,$FF000000,$00F80000,$FF010000,$00F80000,$FF030000,$00F80000
Data.l $FF070000,$00F80000,$FF0F0000,$00F80000,$FF1F0000
Data.b $00,$00
EndDataSection

DataSection
Tool:
IncludeBinary "Icon\Zahnrad2.ico"
EndDataSection

DataSection
Tool2:
IncludeBinary "Icon\Configure.ico"
EndDataSection

DataSection
Info:
IncludeBinary "Icon\Info.ico"
EndDataSection

DataSection
VistaFolder:
IncludeBinary "Icon\VistaFolder.ico"
EndDataSection

DataSection
WinUpdate:
IncludeBinary "Icon\WinUpdate.png"
EndDataSection

DataSection
Computer:
IncludeBinary "Icon\Computer.png"
EndDataSection

DataSection
HardDisk:
IncludeBinary "Icon\Harddisk.ico"
EndDataSection

DataSection
Network:
IncludeBinary "Icon\Network.ico"
EndDataSection

DataSection
Printer:
IncludeBinary "Icon\Printer.ico"
EndDataSection

DataSection
MenuSettings:
IncludeBinary "Icon\MenuSettings.ico"
EndDataSection

DataSection
DeviceManager:
IncludeBinary "Icon\DeviceManager.ico"
EndDataSection

DataSection
Deinstall:
IncludeBinary "Icon\Deinstall.ico"
EndDataSection

DataSection
Plus:
IncludeBinary "Icon\Plus.ico"
EndDataSection

DataSection
Minus:
IncludeBinary "Icon\Minus.ico"
EndDataSection

; IDE Options = PureBasic 6.00 LTS (Windows - x64)
; Folding = AAAAAAAAAAAAAAAg
; EnableXP
; DPIAware
; UseIcon = Icon\PStarter.ico
; Executable = ..\Temp\PureStarter.exe