
#PureRequester_Version$ ="1.1a"
#PureRequester_Yes = #IDYES
#PureRequester_No = #IDNO
#PureRequester_Cancel = #IDCANCEL
#PureRequester_YesAll = -6
#PureRequester_NoAll = -7
#PureRequester_YesWithCheckBox = -6
#PureRequester_NoWithCheckBox = -7
#PureRequester_CancelRGB = -1
#PureRequester_CancelDate = 0

Procedure.i PR_MultiButtonRequester(Title$, Text$)

If GetUserDefaultLangID_() & $FF = #LANG_GERMAN
  Ja$="Ja"
  Nein$="Nein"
  JaAlle$="Ja Alle"
  NeinAlle$="Nein Alle"
  Abbrechen$="Abbrechen"
Else
  Ja$="Yes"
  Nein$="No"
  JaAlle$="Yes to All"
  NeinAlle$="No to All"
  Abbrechen$="Cancel"
EndIf

If ExamineDesktops()
  DeskWidth=DesktopWidth(0)
  DeskHeight=DesktopHeight(0)
EndIf

txt$=ReplaceString(Text$,#CRLF$,"|")
Text$=ReplaceString(txt$,#LFCR$,"|")
txt$=ReplaceString(Text$,#CR$,"|")
Text$=ReplaceString(txt$,#LF$,"|")
txt$=ReplaceString(Text$,"|",Chr(10))
Text$=txt$
If Right(Text$,1)<>Chr(10):Text$+Chr(10):EndIf

oldwin=GetActiveWindow_()
win=OpenWindow(#PB_Any,50,50,400,200,Title$,#PB_Window_SystemMenu|#PB_Window_TitleBar|#PB_Window_ScreenCentered,oldwin)
EnableWindow_(oldwin,#False)

fnt=LoadFont(#PB_Any,"Arial",9)
SetGadgetFont(#PB_Default,FontID(fnt))
sum=CountString(Text$,Chr(10))
If StartDrawing(WindowOutput(win))
  DrawingFont(FontID(fnt))
  For i=1 To sum
    c$=StringField(Text$,i,Chr(10))
    height+TextHeight(c$)
    If TextWidth(c$)>width
      width=TextWidth(c$)+95
    EndIf
  Next
  If width<590:width=590:EndIf
  If width>DeskWidth:width=DeskWidth-20:EndIf
  height+10
  StopDrawing()
EndIf

x=(DeskWidth/2)-((width)/2)
y=(DeskHeight/2)-((height+111)/2)

ResizeWindow(win,x,y,width,height+111)
icon=LoadIcon_(0,#IDI_QUESTION)
ImageGadget=ImageGadget(#PB_Any,25,25,10,10,icon)
TextGadget=TextGadget(#PB_Any,80,33,width-85,height,Text$)
x=width-120
Yes=ButtonGadget(#PB_Any,x-450,height+70,100,27,Ja$)
No=ButtonGadget(#PB_Any,x-345,height+70,100,27,Nein$)
YesAll=ButtonGadget(#PB_Any,x-225,height+70,100,27,JaAlle$)
NoAll=ButtonGadget(#PB_Any,x-120,height+70,100,27,NeinAlle$)
Cancel=ButtonGadget(#PB_Any,x,height+70,100,27,Abbrechen$)
MessageBeep_(#MB_ICONQUESTION)

Repeat
  Event=WaitWindowEvent()
  If Event=#PB_Event_Gadget
    st=EventGadget()
    If st=Yes : state=#IDYES : EndIf
    If st=No : state=#IDNO : EndIf
    If st=Cancel : state=#IDCANCEL : EndIf
    If st=YesAll : state=-6 : EndIf
    If st=NoAll : state=-7 : EndIf
    Break
  EndIf
Until Event=#PB_Event_CloseWindow

SetGadgetFont(#PB_Default, #PB_Default)
FreeFont(fnt)
DestroyIcon_(icon)
EnableWindow_(oldwin,#True)
CloseWindow(win)

If Event=#PB_Event_CloseWindow
  state=#IDCANCEL
EndIf

ProcedureReturn state

EndProcedure

Procedure.i PR_TimeRequester(Title$, Text$, Seconds.l, DefaultButton.l)

If GetUserDefaultLangID_() & $FF = #LANG_GERMAN
  Ja$="Ja"
  Nein$="Nein"
  Sekunden$=" Sekunden"
Else
  Ja$="Yes"
  Nein$="No"
  Sekunden$=" Seconds"
EndIf

If ExamineDesktops()
  DeskWidth=DesktopWidth(0)
  DeskHeight=DesktopHeight(0)
EndIf

txt$=ReplaceString(Text$,#CRLF$,"|")
Text$=ReplaceString(txt$,#LFCR$,"|")
txt$=ReplaceString(Text$,#CR$,"|")
Text$=ReplaceString(txt$,#LF$,"|")
txt$=ReplaceString(Text$,"|",Chr(10))
Text$=txt$
If Right(Text$,1)<>Chr(10):Text$+Chr(10):EndIf

oldwin=GetActiveWindow_()
win=OpenWindow(#PB_Any,50,50,400,200,Title$,#PB_Window_SystemMenu|#PB_Window_TitleBar|#PB_Window_ScreenCentered,oldwin)
EnableWindow_(oldwin,#False)
state=DefaultButton
If state<>#IDYES And state<>#IDNO
  state=#IDNO
EndIf
fnt=LoadFont(#PB_Any,"Arial",9)
SetGadgetFont(#PB_Default,FontID(fnt))
sum=CountString(Text$,Chr(10))
If StartDrawing(WindowOutput(win))
  DrawingFont(FontID(fnt))
  For i=1 To sum
    c$=StringField(Text$,i,Chr(10))
    height+TextHeight(c$)
    If TextWidth(c$)>width
      width=TextWidth(c$)+95
    EndIf
  Next
  If width<350:width=350:EndIf
  If width>DeskWidth:width=DeskWidth-20:EndIf
  height+10
  StopDrawing()
EndIf

x=(DeskWidth/2)-((width)/2)
y=(DeskHeight/2)-((height+111)/2)

ResizeWindow(win,x,y,width,height+111)
icon=LoadIcon_(0,#IDI_QUESTION)
ImageGadget=ImageGadget(#PB_Any,25,25,10,10,icon)
TextGadget=TextGadget(#PB_Any,80,33,width-85,height,Text$)
TimeGadget=TextGadget(#PB_Any,15,height+80,90,25,Str(Seconds)+Sekunden$)
x=width-120
Yes=ButtonGadget(#PB_Any,x-105,height+70,100,27,Ja$)
No=ButtonGadget(#PB_Any,x,height+70,100,27,Nein$)
MessageBeep_(#MB_ICONQUESTION)
StartTime=ElapsedMilliseconds()

Repeat
  If ElapsedMilliseconds()-StartTime>1000
    StartTime=ElapsedMilliseconds()
    Seconds-1
    If Seconds<0:Break:EndIf
    SetGadgetText(TimeGadget,Str(Seconds)+Sekunden$)
  EndIf
  Event=WaitWindowEvent(10)
  If Event=#PB_Event_Gadget
    st=EventGadget()
    If st=Yes : state=#IDYES : EndIf
    If st=No : state=#IDNO : EndIf
    Break
  EndIf
Until Event=#PB_Event_CloseWindow

If Event=#PB_Event_CloseWindow
  state=#IDNO
EndIf

SetGadgetFont(#PB_Default, #PB_Default)
FreeFont(fnt)
DestroyIcon_(icon)
EnableWindow_(oldwin,#True)
CloseWindow(win)

ProcedureReturn state

EndProcedure

Procedure.s PR_InputRequester(Title$, Text$, DefaultText$, StoredText$)

If GetUserDefaultLangID_() & $FF = #LANG_GERMAN
  Ok$="OK"
  Abbrechen$="Abbrechen"
Else
  Ok$="OK"
  Abbrechen$="Cancel"
EndIf

oldwin=GetActiveWindow_()
Window_0 = OpenWindow(#PB_Any, 195, 302, 341, 150, Title$, #PB_Window_SystemMenu|#PB_Window_TitleBar|#PB_Window_ScreenCentered|#PB_Window_WindowCentered,oldwin)
If Window_0
  EnableWindow_(oldwin,#False)
  menu=CreateMenu(#PB_Any,WindowID(Window_0))
  If menu<>0
    MenuTitle("Options")
    MenuItem(1, Ok$+Chr(9)+"[ENTER]")
    MenuItem(2, Abbrechen$+Chr(9)+"[ESC]")
  EndIf
  Text_0 = TextGadget(#PB_Any, 16, 17, 319, 20, Text$)
  ComboBox_1 = ComboBoxGadget(#PB_Any, 15, 50, 309, 22, #PB_ComboBox_Editable)
  Button_1 = ButtonGadget(#PB_Any, 54, 90, 111, 25, Ok$)
  Button_2 = ButtonGadget(#PB_Any, 176, 90, 111, 25, Abbrechen$)
  AddKeyboardShortcut(Window_0,#PB_Shortcut_Return, 1) ; OK Button
  AddKeyboardShortcut(Window_0,#PB_Shortcut_Escape, 2) ; Cancel Button
  SetGadgetText(ComboBox_1,DefaultText$)
  SetActiveGadget(ComboBox_1)
  txt$=ReplaceString(StoredText$,"|",Chr(10))
  If Right(txt$,1)<>Chr(10):txt$+Chr(10):EndIf
  For i=1 To CountString(txt$,Chr(10))
    a$=StringField(txt$,i,Chr(10))
    AddGadgetItem(ComboBox_1,-1,a$)
  Next
  Repeat
    Event=WaitWindowEvent()
    If Event=#PB_Event_Gadget
      pb=EventGadget()
    ElseIf Event=#PB_Event_Menu
      em=EventMenu()
    Else
      pb=0
      em=0
    EndIf
    If pb=Button_1 Or em=1
      b$=GetGadgetText(ComboBox_1)
    EndIf
  Until Event=#PB_Event_CloseWindow Or pb=Button_1 Or pb=Button_2 Or em=1 Or em=2
  EnableWindow_(oldwin,#True)
  CloseWindow(Window_0)
  ProcedureReturn b$
EndIf

EndProcedure

Procedure.i PR_CheckBoxRequester(Title$, Text$)

If GetUserDefaultLangID_() & $FF = #LANG_GERMAN
  Ja$="Ja"
  Nein$="Nein"
  Msg$="Diese Meldung nicht mehr anzeigen"
Else
  Ja$="Yes"
  Nein$="No"
  Msg$="Don't show again this message"
EndIf

If ExamineDesktops()
  DeskWidth=DesktopWidth(0)
  DeskHeight=DesktopHeight(0)
EndIf

txt$=ReplaceString(Text$,#CRLF$,"|")
Text$=ReplaceString(txt$,#LFCR$,"|")
txt$=ReplaceString(Text$,#CR$,"|")
Text$=ReplaceString(txt$,#LF$,"|")
txt$=ReplaceString(Text$,"|",Chr(10))
Text$=txt$
If Right(Text$,1)<>Chr(10):Text$+Chr(10):EndIf

oldwin=GetActiveWindow_()
win=OpenWindow(#PB_Any,50,50,400,200,Title$,#PB_Window_SystemMenu|#PB_Window_TitleBar|#PB_Window_ScreenCentered,oldwin)
EnableWindow_(oldwin,#False)

fnt=LoadFont(#PB_Any,"Arial",9)
SetGadgetFont(#PB_Default,FontID(fnt))
sum=CountString(Text$,Chr(10))
If StartDrawing(WindowOutput(win))
  DrawingFont(FontID(fnt))
  For i=1 To sum
    c$=StringField(Text$,i,Chr(10))
    height+TextHeight(c$)
    If TextWidth(c$)>width
      width=TextWidth(c$)+95
    EndIf
  Next
  If width<480:width=480:EndIf
  If width>DeskWidth:width=DeskWidth-20:EndIf
  height+10
  StopDrawing()
EndIf

x=(DeskWidth/2)-((width)/2)
y=(DeskHeight/2)-((height+111)/2)

ResizeWindow(win,x,y,width,height+111)
icon=LoadIcon_(0,#IDI_QUESTION)
ImageGadget=ImageGadget(#PB_Any,25,25,10,10,icon)
TextGadget=TextGadget(#PB_Any,80,33,width-85,height,Text$)
CheckBox=CheckBoxGadget(#PB_Any,15,height+72,220,25,Msg$)
x=width-120
Yes=ButtonGadget(#PB_Any,x-105,height+70,100,27,Ja$)
No=ButtonGadget(#PB_Any,x,height+70,100,27,Nein$)
MessageBeep_(#MB_ICONQUESTION)

Repeat
  Event=WaitWindowEvent(10)
  If Event=#PB_Event_Gadget
    st=EventGadget()
    If st=Yes : state=#IDYES : EndIf
    If st=No : state=#IDNO : EndIf
    If st<>CheckBox : Break : EndIf
  EndIf
Until Event=#PB_Event_CloseWindow

If Event=#PB_Event_CloseWindow
  state=#IDNO
EndIf
If GetGadgetState(CheckBox)=#True
  If state=#IDYES : state=-6 : EndIf
  If state=#IDNO : state=-7 : EndIf
EndIf

SetGadgetFont(#PB_Default, #PB_Default)
FreeFont(fnt)
DestroyIcon_(icon)
EnableWindow_(oldwin,#True)
CloseWindow(win)

ProcedureReturn state

EndProcedure

Procedure.i PR_DateRequester()

  Protected win.l, date.l, btn.l, result.l, Date$
  If GetUserDefaultLangID_() & $FF = #LANG_GERMAN
    Date$="Datum"
    Format$="%dd.%mm.%yyyy"
  Else
    Date$="Date"
    Format$="%mm.%dd.%yyyy"
  EndIf
  oldwin=GetActiveWindow_()
  win = OpenWindow(#PB_Any, 100, 100, 200, 40, Date$, #PB_Window_SystemMenu | #PB_Window_TitleBar | #PB_Window_ScreenCentered , oldwin)
  date = DateGadget(#PB_Any, 10, 10, 90, 22, Format$, Date())
  btn = ButtonGadget(#PB_Any, 110, 9, 80, 24, "OK")
  EnableWindow_(oldwin, #False)
  Repeat
    Select WaitWindowEvent()
      Case #PB_Event_CloseWindow
        If EventWindow() = win
          Break
        EndIf
      Case #PB_Event_Gadget
        If EventGadget() = btn
          result = GetGadgetState(date)
          Break
        EndIf
    EndSelect
  ForEver
  EnableWindow_(oldwin, #True)
  CloseWindow(win)
  ProcedureReturn result

EndProcedure

Procedure.i PR_RgbRequester(Color.l)

If GetUserDefaultLangID_() & $FF = #LANG_GERMAN
  Ok$="OK"
  Abbrechen$="Abbrechen"
Else
  Ok$="OK"
  Abbrechen$="Cancel"
EndIf

r=Red(Color):g=Green(Color):b=Blue(Color)
oldwin=GetActiveWindow_()
Window = OpenWindow(#PB_Any, 544, 428, 410, 190, "RGB", #PB_Window_SystemMenu|#PB_Window_TitleBar|#PB_Window_ScreenCentered,oldwin)

If Window
  EnableWindow_(oldwin,#False)
  TrackBar_1 = TrackBarGadget(#PB_Any, 16, 14, 376, 22, 0, 255, #PB_TrackBar_Ticks)
  TrackBar_2 = TrackBarGadget(#PB_Any, 16, 44, 376, 22, 0, 255, #PB_TrackBar_Ticks)
  TrackBar_3 = TrackBarGadget(#PB_Any, 16, 74, 376, 22, 0, 255, #PB_TrackBar_Ticks)
  Text_1 = TextGadget(#PB_Any, 15, 120, 380, 26, "$"+RSet(Hex(RGB(r,g,b)),6,"0"), #PB_Text_Border|#PB_Text_Center|#SS_CENTERIMAGE)
  Button_1 = ButtonGadget(#PB_Any, 180, 156, 103, 24, Ok$)
  Button_2 = ButtonGadget(#PB_Any, 290, 156, 103, 24, Abbrechen$)
  SetGadgetState(TrackBar_1,r)
  SetGadgetState(TrackBar_2,g)
  SetGadgetState(TrackBar_3,b)
  SetGadgetColor(Text_1, #PB_Gadget_FrontColor, RGB(r!255,g!255,b!255))
  SetGadgetColor(Text_1, #PB_Gadget_BackColor, Color)
EndIf

Repeat

  Event=WaitWindowEvent()
  If Event=#PB_Event_Gadget
    pb=EventGadget()
  Else
    pb=0
  EndIf

  If pb=TrackBar_1 Or pb=TrackBar_2 Or pb=TrackBar_3
    r=GetGadgetState(TrackBar_1)
    g=GetGadgetState(TrackBar_2)
    b=GetGadgetState(TrackBar_3)
    Color=RGB(r,g,b) : x=r!255 : y=g!255 : z=b!255
    SetGadgetColor(Text_1, #PB_Gadget_FrontColor, RGB(x,y,z))
    SetGadgetColor(Text_1, #PB_Gadget_BackColor, Color)
    SetGadgetText(Text_1,"$"+RSet(Hex(RGB(r,g,b)),6,"0"))
  EndIf

  If pb=Button_1 Or pb=Button_2
    Break
  EndIf

Until Event=#PB_Event_CloseWindow

If pb=Button_1
  Color=RGB(r,g,b)
ElseIf pb=Button_2 Or Event=#PB_Event_CloseWindow
  Color=-1
EndIf

EnableWindow_(oldwin,#True)
CloseWindow(Window)
ProcedureReturn Color

EndProcedure

; IDE Options = PureBasic 6.00 LTS (Windows - x64)
; Folding = A-
; EnableXP