
; PureRequester Example code.

IncludeFile "..\PureRequester.pb"

If OpenWindow(0, 10, 10, 650, 400, "PureRequester Version " + #PureRequester_Version$ + " Example Code", #PB_Window_SystemMenu | #PB_Window_MinimizeGadget | #PB_Window_ScreenCentered)

  ; TimeRequester()

  st = PR_TimeRequester("Frage", "Was mchten Sie tun ?", 60, #IDNO)
  Select st
    Case #PureRequester_Yes
      Debug "[Ja] wurde gewhlt!"
    Case #PureRequester_No
      Debug "[Nein] wurde gewhlt!"
  EndSelect

  ; MultiButtonRequester()

  st = PR_MultiButtonRequester("Frage", "Was mchten Sie tun ?")
  Select st
    Case #PureRequester_Yes
      Debug "[Ja] wurde gewhlt!"
    Case #PureRequester_No
      Debug "[Nein] wurde gewhlt!"
    Case #PureRequester_YesAll
      Debug "[Ja Alle] wurde gewhlt!"
    Case #PureRequester_NoAll
      Debug "[Nein Alle] wurde gewhlt!"
    Case #PureRequester_Cancel
      Debug "[Abbrechen] wurde gewhlt!"
  EndSelect

  ; CheckBoxRequester()

  st = PR_CheckBoxRequester("Frage", "Was mchten Sie tun ?")
  Select st
    Case #PureRequester_Yes
      Debug "[Ja] ohne Hckchen wurde gewhlt!"
    Case #PureRequester_No
      Debug "[Nein] ohne Hckchen wurde gewhlt!"
    Case #PureRequester_YesWithCheckBox
      Debug "[Ja] mit Hckchen wurde gewhlt!"
    Case #PureRequester_NoWithCheckBox
      Debug "[Nein] mit Hckchen wurde gewhlt!"
  EndSelect

  ; DateRequester()

  st = PR_DateRequester()
  Select st
    Case #PureRequester_CancelDate
      Debug "Datums-Requester wurde Abgebrochen!"
    Default
      Debug FormatDate("%dd.%mm.%yyyy", st)
  EndSelect

  ; RgbRequester()

  st = PR_RgbRequester(RGB(0, 0, 255))
  Select st
    Case #PureRequester_CancelRGB
      Debug "RGB-Requester wurde Abgebrochen!"
    Default
      Debug "RGB-Werte = " + Str(Red(st)) + "," + Str(Green(st)) + "," + Str(Blue(st))
  EndSelect

  ; InputRequester()

  txt$ = PR_InputRequester("Frage", "Bitte geben Sie etwas ein", "Standardtext", "Vorname|Nachname|Wohnort")
  Select txt$
    Case ""
      Debug "Input-Requester wurde Abgebrochen!"
    Default
      Debug "Es wurde " + #DQUOTE$ + txt$ + #DQUOTE$ + " eingegeben."
  EndSelect

  Repeat
    Event = WaitWindowEvent()
    If Event = #PB_Event_CloseWindow
      Break
    EndIf
  ForEver

  CloseWindow(0)
  End

EndIf

; jaPBe Version=3.9.6.796
; Build=0
; Language=0x0000 Language Neutral
; FirstLine=0
; CursorPosition=0
; EnableXP
; ExecutableFormat=Windows
; DontSaveDeclare
; EOF
; IDE Options = PureBasic 6.00 LTS (Windows - x64)
; EnableXP