
#PI_Vertical=0
#PI_Horizontal=1
#PI_Vertical_Horizontal=2
#PI_Version$="1.0a"

Procedure.i PI_ResizeImage(Image.l, Percent.f)

If IsImage(Image)<>0
  x.f=(ImageWidth(Image)/100) * Percent
  y.f=(ImageHeight(Image)/100) * Percent
  ResizeImage(Image, Int(x), Int(y))
  ProcedureReturn #True
EndIf

EndProcedure

Procedure.i PI_SetImageGrey(Image.l)

If IsImage(Image)<>0
  Width=ImageWidth(Image)
  Height=ImageHeight(Image)
  If StartDrawing(ImageOutput(Image))
    For y=0 To Height-1
      For x=0 To Width-1
        p=Point(x,y)
        rgb.f=(Red(p)+Green(p)+Blue(p))/3
        Plot(x,y,RGB(rgb,rgb,rgb))
      Next
    Next
    StopDrawing()
    ProcedureReturn #True
  EndIf
EndIf

EndProcedure

Procedure.i PI_SetImageBrightness(Image.l, Percent.f)

If IsImage(Image)<>0
  wert=2.54999995231628 * Percent
  Width=ImageWidth(Image)
  Height=ImageHeight(Image)
  If StartDrawing(ImageOutput(Image))
    For y=0 To Height-1
      For x=0 To Width-1
        p=Point(x,y)
        Red=Red(p) + wert
        Green=Green(p) + wert
        Blue=Blue(p) + wert
        If Red>255:Red=255:EndIf
        If Red<0:Red=0:EndIf
        If Green>255:Green=255:EndIf
        If Green<0:Green=0:EndIf
        If Blue>255:Blue=255:EndIf
        If Blue<0:Blue=0:EndIf
        Plot(x,y,RGB(Red,Green,Blue))
      Next
    Next
    StopDrawing()
    ProcedureReturn #True
  EndIf
EndIf

EndProcedure

Procedure.i PI_SetImageRaster(Image.l, Modus.l)

If IsImage(Image)<>0
  If Modus=#PI_Vertical
    Horizontal=1
  ElseIf Modus=#PI_Horizontal
    Vertical=1
  ElseIf Modus=#PI_Vertical_Horizontal
    Vertical=1
    Horizontal=1
  EndIf
  Width=ImageWidth(Image)
  Height=ImageHeight(Image)
  If StartDrawing(ImageOutput(Image))
    For y=0 To Height-1
      y+Vertical
      For x=0 To Width-1
        x+Horizontal
        Plot(x,y,0)
      Next
    Next
    StopDrawing()
    ProcedureReturn #True
  EndIf
EndIf

EndProcedure

Procedure.i PI_FlipImageVertical(Image.l)

If IsImage(Image)<>0
  Width=ImageWidth(Image)
  Height=ImageHeight(Image)
  Dim Pixel.l(Width,Height)
  If StartDrawing(ImageOutput(Image))
    For y=0 To Height-1
      For x=0 To Width-1
        Pixel(x,y)=Point(x,Height-y-1)
      Next
    Next
    For y=0 To Height-1
      For x=0 To Width-1
        Plot(x,y,Pixel(x,y))
      Next
    Next
    StopDrawing()
    ProcedureReturn #True
  EndIf
EndIf

EndProcedure

Procedure.i PI_FlipImageHorizontal(Image.l)

If IsImage(Image)<>0
  Width=ImageWidth(Image)
  Height=ImageHeight(Image)
  Dim Pixel.l(Width,Height)
  If StartDrawing(ImageOutput(Image))
    For x=0 To Width-1
      For y=0 To Height-1
        Pixel(x,y)=Point(Width-x-1,y)
      Next
    Next
    For x=0 To Width-1
      For y=0 To Height-1
        Plot(x,y,Pixel(x,y))
      Next
    Next
    StopDrawing()
    ProcedureReturn #True
  EndIf
EndIf

EndProcedure

Procedure.i PI_SetImageNegative(Image.l)

If IsImage(Image)<>0
  Width=ImageWidth(Image)
  Height=ImageHeight(Image)
  If StartDrawing(ImageOutput(Image))
    For y=0 To Height-1
      For x=0 To Width-1
        p=Point(x,y)
        Red=255-Red(p)
        Green=255-Green(p)
        Blue=255-Blue(p)
        Plot(x,y,RGB(Red,Green,Blue))
      Next
    Next
    StopDrawing()
    ProcedureReturn #True
  EndIf
EndIf

EndProcedure

Procedure.i PI_SetImageMonochrome(Image.l)

If IsImage(Image)<>0
  Width=ImageWidth(Image)
  Height=ImageHeight(Image)
  If StartDrawing(ImageOutput(Image))
    For y=0 To Height-1
      For x=0 To Width-1
        p=Point(x,y)
        rgb.f=(Red(p)+Green(p)+Blue(p)+60)/3
        If rgb>127
          rgb=255
        Else
          rgb=0
        EndIf
        Plot(x,y,RGB(rgb,rgb,rgb))
      Next
    Next
    StopDrawing()
    ProcedureReturn #True
  EndIf
EndIf

EndProcedure

Procedure.i PI_RotateImageLeft(Image.l)

If IsImage(Image)<>0
  Width=ImageWidth(Image)
  Height=ImageHeight(Image)
  Dim Pixel.l(Width,Height)
  If StartDrawing(ImageOutput(Image))
    For y=0 To Height-1
      For x=0 To Width-1
        Pixel(x,y)=Point(x,y)
      Next
    Next
    StopDrawing()
  EndIf
  ResizeImage(Image, Height, Width)
  If StartDrawing(ImageOutput(Image))
    For y=0 To Height-1
      For x=0 To Width-1
        Plot(y,x,Pixel(Width-x-1,y))
      Next
    Next
    StopDrawing()
    ProcedureReturn #True
  EndIf
EndIf

EndProcedure

Procedure.i PI_RotateImageRight(Image.l)

If IsImage(Image)<>0
  Width=ImageWidth(Image)
  Height=ImageHeight(Image)
  Dim Pixel.l(Width,Height)
  If StartDrawing(ImageOutput(Image))
    For y=0 To Height-1
      For x=0 To Width-1
        Pixel(x,y)=Point(x,y)
      Next
    Next
    StopDrawing()
  EndIf
  ResizeImage(Image, Height, Width)
  If StartDrawing(ImageOutput(Image))
    For y=0 To Height-1
      For x=0 To Width-1
        Plot(y,x,Pixel(x,Height-y-1))
      Next
    Next
    StopDrawing()
    ProcedureReturn #True
  EndIf
EndIf

EndProcedure

Procedure.i PI_CreateMirrorImage(Image.l, Width, Height, Depth, Color1, Color2)

img=CreateImage(Image, Width, Height, Depth)
If Image=#PB_Any : Image=img : EndIf

If IsImage(Image)
  If StartDrawing(ImageOutput(Image))
    If Red(Color2)>Red(Color1)
      Pixels=Red(Color2)-Red(Color1)
      add1.f=Pixels/Height
    Else
      Pixels=Red(Color1)-Red(Color2)
      add1.f=-(Pixels/Height)
    EndIf
    If Green(Color2)>Green(Color1)
      Pixels=Green(Color2)-Green(Color1)
      add2.f=Pixels/Height
    Else
      Pixels=Green(Color1)-Green(Color2)
      add2.f=-(Pixels/Height)
    EndIf
    If Blue(Color2)>Blue(Color1)
      Pixels=Blue(Color2)-Blue(Color1)
      add3.f=Pixels/Height
    Else
      Pixels=Blue(Color1)-Blue(Color2)
      add3.f=-(Pixels/Height)
    EndIf
    r.f=Red(Color1):g.f=Green(Color1):b.f=Blue(Color1)
    For y=0 To Height-1
      Box(0,y,Width,1,RGB(r,g,b))
      r+add1 : g+add2 : b+add3
    Next
    StopDrawing()
    ProcedureReturn img
  EndIf
EndIf

EndProcedure

; IDE Options = PureBasic 6.00 LTS (Windows - x64)
; Folding = Ag
; EnableXP