
; PureCrunch Example Code

; Init variables & Memory

BlockSize=6000 : Level=9
Buffer1=AllocateMemory(BlockSize+2)
Buffer2=AllocateMemory(BlockSize+2)

; Init GUI

OpenWindow(0, 450, 200, 403, 193, "PureCrunch Example (PureCrunch version "+#PC_Version$+")", #PB_Window_SystemMenu|#PB_Window_MinimizeGadget|#PB_Window_TitleBar|#PB_Window_ScreenCentered)
StringGadget(0, 113, 24, 244, 20, "")
StringGadget(1, 113, 48, 245, 20, "")
ProgressBarGadget(2, 20, 115, 365, 20, 0, 100, #PB_ProgressBar_Smooth)
TextGadget(3, 20, 90, 365, 20, "De/Crunch Process", #PB_Text_Center|#PB_Text_Border)
TextGadget(4, 8, 26, 90, 20, "Source File", #PB_Text_Right)
TextGadget(5, 8, 50, 90, 20, "Destination File", #PB_Text_Right)
ButtonGadget(6, 362, 24, 25, 20, "...")
ButtonGadget(7, 362, 48, 25, 20, "...")
ButtonGadget(8, 228, 155, 79, 25, "Crunch")
ButtonGadget(9, 310, 155, 79, 25, "DeCrunch")

; Wait for Events

Repeat

  Gadget.l=0
  Event=WaitWindowEvent()
  If Event=#PB_Event_Gadget
    Gadget.l=EventGadget()
  EndIf

  ; File(s) selection

  If Gadget=6
    File$=OpenFileRequester("Please choose a file","","",0)
    If File$<>""
      SetGadgetText(0,File$)
    EndIf
  EndIf
  If Gadget=7
    File$=SaveFileRequester("Please choose a file","","",0)
    If File$<>""
      SetGadgetText(1,File$)
    EndIf
  EndIf

  ; Start Crunch

  If Gadget=8
    Source$=GetGadgetText(0)
    Dest$=GetGadgetText(1)
    Size.l=FileSize(Source$)
    Blocks.l=Size/BlockSize : Rest.l=Size-(Blocks*BlockSize)
    SetGadgetAttribute(2,#PB_ProgressBar_Maximum,Blocks)
    If ReadFile(0,Source$)
      If CreateFile(1,Dest$)
        WriteLong(1,Blocks)
        WriteLong(1,Rest)
        If Blocks>0
          For i=1 To Blocks
            SetGadgetState(2,i)
            While WindowEvent():Wend
            ReadData(0,Buffer1,BlockSize)
            Bytes=PC_CrunchMemory(Buffer1,Buffer2,BlockSize,Level)
            WriteLong(1,Bytes)
            If Bytes>0
              WriteData(1,Buffer2,Bytes)
            Else
              WriteData(1,Buffer1,BlockSize)
            EndIf
          Next
        EndIf
        If Rest>0
          ReadData(0,Buffer1,Rest)
          Bytes=PC_CrunchMemory(Buffer1,Buffer2,Rest,Level)
          WriteLong(1,Bytes)
          If Bytes>0
            WriteData(1,Buffer2,Bytes)
          Else
            WriteData(1,Buffer1,Rest)
          EndIf
        EndIf
        CloseFile(1)
        MessageRequester("Info", "Crunch process complete!", #MB_OK|#MB_ICONINFORMATION)
        SetGadgetState(2,0)
      EndIf
      CloseFile(0)
    EndIf
  EndIf

  ; Start DeCrunch

  If Gadget=9
    Source$=GetGadgetText(0)
    Dest$=GetGadgetText(1)
    If ReadFile(0,Source$)
      If CreateFile(1,Dest$)
        Blocks=ReadLong(0)
        Rest=ReadLong(0)
        SetGadgetAttribute(2,#PB_ProgressBar_Maximum,Blocks)
        If Blocks>0
          For i=1 To Blocks
            SetGadgetState(2,i)
            While WindowEvent():Wend
            Bytes=ReadLong(0)
            If Bytes>0
              ReadData(0,Buffer1,Bytes)
              UnPackLen.l=PC_DeCrunchMemory(Buffer1,Buffer2,Bytes)
            Else
              ReadData(0,Buffer2,BlockSize)
              UnPackLen.l=BlockSize
            EndIf
            WriteData(1,Buffer2,UnPackLen)
          Next
        EndIf
        If Rest>0
          Bytes=ReadLong(0)
          If Bytes>0
            ReadData(0,Buffer1,Bytes)
            UnPackLen.l=PC_DeCrunchMemory(Buffer1,Buffer2,Bytes)
          Else
            ReadData(0,Buffer2,Rest)
            UnPackLen.l=Rest
          EndIf
          WriteData(1,Buffer2,UnPackLen)
        EndIf
        CloseFile(1)
        MessageRequester("Info", "DeCrunch process complete!", #MB_OK|#MB_ICONINFORMATION)
        SetGadgetState(2,0)
      EndIf
      CloseFile(0)
    EndIf
  EndIf

Until Event=#PB_Event_CloseWindow

FreeMemory(Buffer1)
FreeMemory(Buffer2)
CloseWindow(0)
