
; PureCrunch Example Code with a CallBack

Procedure.l MyProgressCallBack(state.l)

SetGadgetState(2, state) ; Set current process state in ProgressBarGadget

Event=WindowEvent()

If Event=#PB_Event_Gadget
  Gadget.l=EventGadget()
  If Gadget=10 ; Process breaked by the 'Stop' ButtonGadget ?
    ProcedureReturn #PC_ProcessBreak
  EndIf
EndIf

EndProcedure

; Init variables (Compression Level)

Level=9

; Init GUI

OpenWindow(0, 450, 200, 403, 193, "CallBack-Example (PureCrunch version "+#PC_Version$+")", #PB_Window_SystemMenu|#PB_Window_MinimizeGadget|#PB_Window_TitleBar|#PB_Window_ScreenCentered)
StringGadget(0, 113, 24, 244, 20, "")
StringGadget(1, 113, 48, 245, 20, "")
ProgressBarGadget(2, 20, 115, 365, 20, 0, 100, #PB_ProgressBar_Smooth)
TextGadget(3, 20, 90, 365, 20, "De/Crunch Process", #PB_Text_Center|#PB_Text_Border)
TextGadget(4, 8, 26, 90, 20, "Source File", #PB_Text_Right)
TextGadget(5, 8, 50, 90, 20, "Destination File", #PB_Text_Right)
ButtonGadget(6, 362, 24, 25, 20, "...")
ButtonGadget(7, 362, 48, 25, 20, "...")
ButtonGadget(8, 228, 155, 79, 25, "Crunch")
ButtonGadget(9, 310, 155, 79, 25, "DeCrunch")
ButtonGadget(10, 146, 155, 79, 25, "Stop")

; Wait for Events

Repeat

  Gadget.l=0
  Event=WaitWindowEvent()
  If Event=#PB_Event_Gadget
    Gadget.l=EventGadget()
  EndIf

  ; File(s) selection

  If Gadget=6
    File$=OpenFileRequester("Please choose a file","","",0)
    If File$<>""
      SetGadgetText(0,File$)
    EndIf
  EndIf
  If Gadget=7
    File$=SaveFileRequester("Please choose a file","","",0)
    If File$<>""
      SetGadgetText(1,File$)
    EndIf
  EndIf

  ; Start Crunch

  If Gadget=8
    Source$=GetGadgetText(0)
    Dest$=GetGadgetText(1)
    If ReadFile(0,Source$)
      FileSize.l=Lof(0)
      Buffer1=AllocateMemory(FileSize)
      If Buffer1>0
        ReadData(0,Buffer1,FileSize) ; <--- Load Original File into Memory!
        Buffer2=AllocateMemory(FileSize)
        If Buffer2>0
          SetGadgetAttribute(2,#PB_ProgressBar_Maximum,FileSize)
          Bytes=PC_CrunchLargeMemory(Buffer1, Buffer2, FileSize, Level, @MyProgressCallBack())
          If Bytes=#PC_ProcessBreak ; Process canceled ?
            MessageRequester("Break", "Process canceled!", #MB_OK|#MB_ICONWARNING)
          ElseIf Bytes=#PC_ProcessFail ; File already packed ? if yes then process will failed!
            MessageRequester("Info", "Process failed - cannot crunch file!", #MB_OK|#MB_ICONERROR)
          ElseIf Bytes>0 ; Process successful. Packed data will now save.
            If CreateFile(1,Dest$)
              WriteData(1,Buffer2,Bytes)
              CloseFile(1)
            EndIf
            MessageRequester("Info", "Crunch process successfully complete!", #MB_OK|#MB_ICONINFORMATION)
          EndIf
          FreeMemory(Buffer2)
        EndIf
        FreeMemory(Buffer1)
      EndIf
      CloseFile(0)
    EndIf
    SetGadgetState(2,0)
  EndIf

  ; Start DeCrunch

  If Gadget=9
    Source$=GetGadgetText(0)
    Dest$=GetGadgetText(1)
    If ReadFile(0,Source$)
      FileSize.l=Lof(0)
      Buffer1=AllocateMemory(FileSize)
      If Buffer1>0
        ReadData(0,Buffer1,FileSize) ; <--- Load PackedFile into Memory!
        If PC_CheckCrunchedMemory(Buffer1,FileSize) ; <--- Check if file is valid!
          Maximum.l=PC_GetDeCrunchedSize(Buffer1) ; <--- Get the original unpacked filesize!
          Buffer2=AllocateMemory(Maximum) ; <--- Allocate Memory in original (unpacked) filesize!
          If Buffer2>0
            SetGadgetAttribute(2,#PB_ProgressBar_Maximum,Maximum)
            Bytes=PC_DeCrunchLargeMemory(Buffer1, Buffer2, FileSize, @MyProgressCallBack())
            If Bytes=#PC_ProcessBreak ; Process canceled ?
              MessageRequester("Break", "Process canceled!", #MB_OK|#MB_ICONWARNING)
            ElseIf Bytes=#PC_ProcessFail ; Process failed because an error has occurred ?
              MessageRequester("Info", "Process failed - cannot decrunch file!", #MB_OK|#MB_ICONERROR)
            ElseIf Bytes>0 ; Process successful. UnPacked data will now save.
              If CreateFile(1,Dest$)
                WriteData(1,Buffer2,Bytes)
                CloseFile(1)
              EndIf
              MessageRequester("Info", "DeCrunch process successfully complete!", #MB_OK|#MB_ICONINFORMATION)
            EndIf
            FreeMemory(Buffer2)
          EndIf
        Else
          MessageRequester("Error", "Not a valid crunched file", #MB_OK|#MB_ICONERROR)
        EndIf
        FreeMemory(Buffer1)
      EndIf
      CloseFile(0)
    EndIf
    SetGadgetState(2,0)
  EndIf

Until Event=#PB_Event_CloseWindow

CloseWindow(0)
End
